/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.model.bullet;

import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.renderer.GlStateManager;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.ModelIIBase;
import pl.pabilo8.immersiveintelligence.client.util.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIUtils;

public class ModelBullet2bCal
extends ModelIIBase
implements IBulletModel {
    private static final String TEXTURE = "immersiveintelligence:textures/entity/bullets/2bcal_machinegun.png";
    int textureX = 32;
    int textureY = 16;
    ModelRendererTurbo[] casingModel = new ModelRendererTurbo[2];
    ModelRendererTurbo[] paintModel;
    ModelRendererTurbo[] coreSoftpointModel;
    ModelRendererTurbo[] corePiercingModel;

    public ModelBullet2bCal() {
        this.casingModel[0] = new ModelRendererTurbo(this, 0, 9, this.textureX, this.textureY);
        this.casingModel[1] = new ModelRendererTurbo(this, 0, 0, this.textureX, this.textureY);
        this.casingModel[0].func_78790_a(-1.0f, -3.0f, -1.0f, 2, 3, 2, 0.0f);
        this.casingModel[0].func_78793_a(0.0f, 0.0f, 0.0f);
        this.casingModel[1].addShapeBox(-1.0f, -5.0f, -1.0f, 2, 2, 2, 0.0f, -0.25f, -0.75f, -0.25f, -0.25f, -0.75f, -0.25f, -0.25f, -0.75f, -0.25f, -0.25f, -0.75f, -0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.casingModel[1].func_78793_a(0.0f, 0.0f, 0.0f);
        this.paintModel = new ModelRendererTurbo[1];
        this.paintModel[0] = new ModelRendererTurbo(this, 8, 0, this.textureX, this.textureY);
        this.paintModel[0].addShapeBox(-1.0f, -3.0f, -1.0f, 2, 2, 2, 0.0f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f, 0.01f, 0.0f, 0.01f);
        this.paintModel[0].func_78793_a(0.0f, 0.0f, 0.0f);
        this.coreSoftpointModel = new ModelRendererTurbo[2];
        this.coreSoftpointModel[0] = new ModelRendererTurbo(this, 0, 4, this.textureX, this.textureY);
        this.coreSoftpointModel[1] = new ModelRendererTurbo(this, 8, 4, this.textureX, this.textureY);
        this.coreSoftpointModel[0].addShapeBox(-1.0f, -5.0f, -1.0f, 2, 2, 2, 0.0f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f);
        this.coreSoftpointModel[0].func_78793_a(0.0f, 0.0f, 0.0f);
        this.coreSoftpointModel[1].addShapeBox(-1.0f, -3.0f, -1.0f, 2, 3, 2, 0.0f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f);
        this.coreSoftpointModel[1].func_78793_a(0.0f, 0.0f, 0.0f);
        this.corePiercingModel = new ModelRendererTurbo[2];
        this.corePiercingModel[0] = new ModelRendererTurbo(this, 0, 4, this.textureX, this.textureY);
        this.corePiercingModel[1] = new ModelRendererTurbo(this, 8, 4, this.textureX, this.textureY);
        this.corePiercingModel[0].addShapeBox(-1.0f, -6.0f, -1.0f, 2, 3, 2, 0.0f, -0.625f, 0.0f, -0.625f, -0.625f, 0.0f, -0.625f, -0.625f, 0.0f, -0.625f, -0.625f, 0.0f, -0.625f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f);
        this.corePiercingModel[0].func_78793_a(0.0f, 0.0f, 0.0f);
        this.corePiercingModel[1].addShapeBox(-1.0f, -3.0f, -1.0f, 2, 3, 2, 0.0f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f);
        this.corePiercingModel[1].func_78793_a(0.0f, 0.0f, 0.0f);
        this.parts.put("casing", this.casingModel);
        this.parts.put("paint", this.paintModel);
        this.parts.put("core_softpoint", this.coreSoftpointModel);
        this.parts.put("core_piercing", this.corePiercingModel);
        this.flipAll();
    }

    @Override
    public void renderCasing(float gunpowderPercentage, int paintColour) {
        ClientUtils.bindTexture((String)TEXTURE);
        for (ModelRendererTurbo model : this.casingModel) {
            model.func_78785_a(0.0625f);
        }
        if (paintColour != -1) {
            float[] c = IIUtils.rgbIntToRGB(paintColour);
            GlStateManager.func_179124_c((float)c[0], (float)c[1], (float)c[2]);
            for (ModelRendererTurbo model : this.paintModel) {
                model.func_78785_a(0.0625f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void renderCore(int coreColour, AmmoRegistry.EnumCoreTypes coreType) {
        ClientUtils.bindTexture((String)TEXTURE);
        float[] c = IIUtils.rgbIntToRGB(coreColour);
        GlStateManager.func_179124_c((float)c[0], (float)c[1], (float)c[2]);
        switch (coreType) {
            case SOFTPOINT: {
                for (ModelRendererTurbo model : this.coreSoftpointModel) {
                    model.func_78785_a(0.0625f);
                }
                break;
            }
            case PIERCING: {
                for (ModelRendererTurbo model : this.corePiercingModel) {
                    model.func_78785_a(0.0625f);
                }
                break;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void reloadModels() {
        ModelBullet2bCal newModel = new ModelBullet2bCal();
        this.baseModel = newModel.baseModel;
        this.casingModel = newModel.casingModel;
        this.corePiercingModel = newModel.corePiercingModel;
        this.coreSoftpointModel = newModel.coreSoftpointModel;
        this.paintModel = newModel.paintModel;
    }
}

