/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.model.misc;

import java.util.Arrays;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;

public class ModelHansBiped
extends ModelPlayer {
    public ModelRenderer bipedLeftHand;
    public ModelRenderer bipedRightHand;
    public ModelRenderer bipedLeftFoot;
    public ModelRenderer bipedRightFoot;
    public ModelRenderer bipedLeftHandWear;
    public ModelRenderer bipedRightHandWear;
    public ModelRenderer bipedLeftFootWear;
    public ModelRenderer bipedRightFootWear;
    private final ModelHansBiped bipedHelper;

    public ModelHansBiped(float expand) {
        this(expand, false);
    }

    public ModelHansBiped(float expand, boolean slimArms) {
        this(expand, slimArms, new BipedTextureUVs(40, 16, 40, 16, 48, 48, 40, 32, 0, 16, 0, 16, 0, 48, 0, 32, 16, 16), false);
    }

    private ModelHansBiped(float expand, boolean slimArms, BipedTextureUVs uvs, boolean slave) {
        super(expand, slimArms);
        this.bipedLeftHand = this.addLimb(this.field_178724_i, true, uvs.armLeftU, uvs.armLeftV, -1.0f, -2.0f, -2.0f, expand);
        this.bipedRightHand = this.addLimb(this.field_178723_h, false, uvs.armRightU, uvs.armRightV, -3.0f, -2.0f, -2.0f, expand);
        this.bipedLeftHandWear = this.addLimb(this.field_178734_a, true, uvs.armWearLeftU, uvs.armWearLeftV, -1.0f, -2.0f, -2.0f, expand + 0.25f);
        this.bipedRightHandWear = this.addLimb(this.field_178732_b, false, uvs.armWearRightU, uvs.armWearRightV, -3.0f, -2.0f, -2.0f, expand + 0.25f);
        this.bipedLeftFoot = this.addLimb(this.field_178722_k, true, uvs.legLeftU, uvs.legLeftV, -2.0f, 0.0f, -2.0f, expand);
        this.bipedLeftFoot.field_78797_d += 2.0f;
        this.bipedRightFoot = this.addLimb(this.field_178721_j, false, uvs.legRightU, uvs.legRightV, -2.0f, 0.0f, -2.0f, expand);
        this.bipedRightFoot.field_78797_d += 2.0f;
        this.bipedLeftFootWear = this.addLimb(this.field_178733_c, true, uvs.legWearLeftU, uvs.legWearLeftV, -2.0f, 0.0f, -2.0f, expand + 0.25f);
        this.bipedLeftFootWear.field_78797_d += 2.0f;
        this.bipedRightFootWear = this.addLimb(this.field_178731_d, false, uvs.legWearRightU, uvs.legWearRightV, -2.0f, 0.0f, -2.0f, expand + 0.25f);
        this.bipedRightFootWear.field_78797_d += 2.0f;
        this.bipedHelper = slave ? null : new ModelHansBiped(expand, slimArms, uvs, true);
    }

    private ModelRenderer addLimb(ModelRenderer bipedLeftArm, boolean l, int u, int v, float x, float y, float z, float expand) {
        bipedLeftArm.field_78804_l.clear();
        bipedLeftArm.field_78804_l.add(new ModelBoxCustomizable(bipedLeftArm, u, v, x, y, z, 4, 5, 4, expand, 0, -4));
        ModelRenderer mod = new ModelRenderer((ModelBase)this);
        mod.field_78797_d = 4.0f;
        mod.field_78804_l.add(new ModelBoxCustomizable(mod, u, v + 5, x, -1.0f, z, 4, 7, 4, expand, -5, 0));
        bipedLeftArm.func_78792_a(mod);
        return mod;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        this.bipedRightFoot.field_78800_c = 0.0f;
        this.bipedLeftFoot.field_78800_c = 0.0f;
        this.bipedRightFoot.field_78797_d = 6.0f;
        this.bipedLeftFoot.field_78797_d = 6.0f;
        this.bipedRightFoot.field_78798_e = 0.0f;
        this.bipedLeftFoot.field_78798_e = 0.0f;
        this.bipedRightFoot.field_78795_f = 0.0f;
        this.bipedLeftFoot.field_78795_f = 0.0f;
        this.bipedRightFoot.field_78796_g = 0.0f;
        this.bipedLeftFoot.field_78796_g = 0.0f;
        this.bipedRightFoot.field_78808_h = 0.0f;
        this.bipedLeftFoot.field_78808_h = 0.0f;
        this.bipedRightHand.field_78795_f = 0.0f;
        this.bipedLeftHand.field_78795_f = 0.0f;
        this.bipedRightHand.field_78796_g = 0.0f;
        this.bipedLeftHand.field_78796_g = 0.0f;
        this.bipedRightHand.field_78808_h = 0.0f;
        this.bipedLeftHand.field_78808_h = 0.0f;
        this.field_178723_h.field_78797_d = 2.0f;
        this.field_178724_i.field_78797_d = 2.0f;
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        if (entityIn instanceof EntityHans) {
            float progress;
            EntityHans hans = (EntityHans)entityIn;
            if (hans.getLegAnimation() == hans.prevLegAnimation) {
                this.handleLegAnimation(hans, hans.getLegAnimation(), ageInTicks);
            } else {
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.bipedHelper.field_178722_k);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.bipedHelper.field_178721_j);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.bipedHelper.field_178724_i);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.bipedHelper.field_178723_h);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.bipedHelper.field_78115_e);
                ModelHansBiped.func_178685_a((ModelRenderer)this.bipedLeftHand, (ModelRenderer)this.bipedHelper.bipedLeftHand);
                ModelHansBiped.func_178685_a((ModelRenderer)this.bipedRightHand, (ModelRenderer)this.bipedHelper.bipedRightHand);
                ModelHansBiped.func_178685_a((ModelRenderer)this.bipedLeftFoot, (ModelRenderer)this.bipedHelper.bipedLeftFoot);
                ModelHansBiped.func_178685_a((ModelRenderer)this.bipedRightFoot, (ModelRenderer)this.bipedHelper.bipedRightFoot);
                this.handleLegAnimation(hans, hans.prevLegAnimation, ageInTicks);
                this.handleArmAnimation(hans, hans.prevArmAnimation, ageInTicks);
                this.bipedHelper.handleLegAnimation(hans, hans.getLegAnimation(), ageInTicks);
                progress = 1.0f - MathHelper.func_76131_a((float)(((float)hans.legAnimationTimer - ageInTicks % 1.0f) / 8.0f), (float)0.0f, (float)1.0f);
                this.lerpModelAngles(this.field_178722_k, this.bipedHelper.field_178722_k, progress);
                this.lerpModelAngles(this.field_178721_j, this.bipedHelper.field_178721_j, progress);
                this.lerpModelAngles(this.field_178724_i, this.bipedHelper.field_178724_i, progress);
                this.lerpModelAngles(this.field_178723_h, this.bipedHelper.field_178723_h, progress);
                this.lerpModelAngles(this.field_78115_e, this.bipedHelper.field_78115_e, progress);
                this.lerpModelAngles(this.bipedLeftFoot, this.bipedHelper.bipedLeftFoot, progress);
                this.lerpModelAngles(this.bipedRightFoot, this.bipedHelper.bipedRightFoot, progress);
                this.lerpModelAngles(this.bipedLeftHand, this.bipedHelper.bipedLeftHand, progress);
                this.lerpModelAngles(this.bipedRightHand, this.bipedHelper.bipedRightHand, progress);
            }
            if (hans.armAnimation == hans.prevArmAnimation) {
                this.handleArmAnimation(hans, hans.armAnimation, ageInTicks);
            } else {
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.bipedHelper.field_178722_k);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.bipedHelper.field_178721_j);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.bipedHelper.field_178724_i);
                ModelHansBiped.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.bipedHelper.field_178723_h);
                ModelHansBiped.func_178685_a((ModelRenderer)this.bipedLeftHand, (ModelRenderer)this.bipedHelper.bipedLeftHand);
                ModelHansBiped.func_178685_a((ModelRenderer)this.bipedRightHand, (ModelRenderer)this.bipedHelper.bipedRightHand);
                this.handleArmAnimation(hans, hans.prevArmAnimation, ageInTicks);
                this.bipedHelper.handleArmAnimation(hans, hans.armAnimation, ageInTicks);
                progress = 1.0f - MathHelper.func_76131_a((float)(((float)hans.armAnimationTimer - ageInTicks % 1.0f) / 8.0f), (float)0.0f, (float)1.0f);
                this.lerpModelAngles(this.field_178724_i, this.bipedHelper.field_178724_i, progress);
                this.lerpModelAngles(this.field_178723_h, this.bipedHelper.field_178723_h, progress);
                this.lerpModelAngles(this.bipedLeftHand, this.bipedHelper.bipedLeftHand, progress);
                this.lerpModelAngles(this.bipedRightHand, this.bipedHelper.bipedRightHand, progress);
            }
        }
        ModelHansBiped.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.field_178733_c);
        ModelHansBiped.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.field_178731_d);
        ModelHansBiped.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.field_178734_a);
        ModelHansBiped.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178732_b);
        ModelHansBiped.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.field_178730_v);
        ModelHansBiped.func_178685_a((ModelRenderer)this.bipedLeftFoot, (ModelRenderer)this.bipedLeftFootWear);
        ModelHansBiped.func_178685_a((ModelRenderer)this.bipedRightFoot, (ModelRenderer)this.bipedRightFootWear);
        ModelHansBiped.func_178685_a((ModelRenderer)this.bipedLeftHand, (ModelRenderer)this.bipedLeftHandWear);
        ModelHansBiped.func_178685_a((ModelRenderer)this.bipedRightHand, (ModelRenderer)this.bipedRightHandWear);
    }

    private void lerpModelAngles(ModelRenderer main, ModelRenderer second, float progress) {
        main.field_78795_f = (float)MathHelper.func_151238_b((double)main.field_78795_f, (double)second.field_78795_f, (double)progress);
        main.field_78796_g = (float)MathHelper.func_151238_b((double)main.field_78796_g, (double)second.field_78796_g, (double)progress);
        main.field_78808_h = (float)MathHelper.func_151238_b((double)main.field_78808_h, (double)second.field_78808_h, (double)progress);
        main.field_78800_c = (float)MathHelper.func_151238_b((double)main.field_78800_c, (double)second.field_78800_c, (double)progress);
        main.field_78797_d = (float)MathHelper.func_151238_b((double)main.field_78797_d, (double)second.field_78797_d, (double)progress);
        main.field_78798_e = (float)MathHelper.func_151238_b((double)main.field_78798_e, (double)second.field_78798_e, (double)progress);
    }

    private void handleArmAnimation(EntityHans hans, HansAnimations.HansArmAnimation animation, float ageInTicks) {
        switch (animation) {
            default: {
                break;
            }
            case SALUTE: {
                this.field_178723_h.field_78795_f -= 2.5f;
                this.field_178723_h.field_78808_h -= 0.5f;
                this.bipedRightHand.field_78808_h -= 0.75f;
                break;
            }
            case SURRENDER: {
                this.field_178723_h.field_78808_h = 2.89f;
                this.field_178724_i.field_78808_h -= 2.89f;
                break;
            }
            case SQUAD_ORDER_ONWARDS: {
                float v = Math.min(ageInTicks % 40.0f / 22.0f, 1.0f);
                float v1 = v % 0.5f / 0.5f;
                float v2 = v > 0.5f ? (v - 0.5f) / 0.25f : 0.0f;
                float kickLeg = 0.25f;
                float landLeg = -0.55f;
                this.bipedLeftHand.field_78795_f = IIUtils.clampedLerp3Par(0.25f, -0.55f - v2 * 0.125f, 0.25f, v1);
            }
        }
    }

    private void handleLegAnimation(EntityHans hans, HansAnimations.HansLegAnimation animation, float ageInTicks) {
        switch (animation) {
            default: {
                break;
            }
            case LYING: {
                this.field_78115_e.field_78795_f += 1.5f;
                float a1 = 1.0f - (this.field_178722_k.field_78795_f + 0.3f) / 0.6f;
                float a2 = 1.0f - (this.field_178721_j.field_78795_f + 0.3f) / 0.6f;
                this.field_178721_j.field_78796_g = -Math.abs(a1);
                this.field_178722_k.field_78796_g = Math.abs(a2);
                if (hans.func_70638_az() == null) {
                    this.field_178723_h.field_78796_g += Math.abs(a1 * 0.75f);
                    this.field_178724_i.field_78796_g += Math.abs(a2 * 0.75f);
                }
                this.bipedLeftFoot.field_78808_h = this.field_178722_k.field_78796_g;
                this.bipedRightFoot.field_78808_h = this.field_178721_j.field_78796_g;
                this.field_178721_j.field_78795_f = 1.5f;
                this.field_178722_k.field_78795_f = 1.5f;
                this.field_178721_j.field_78808_h = 0.0f;
                this.field_178722_k.field_78808_h = 0.0f;
                this.field_178723_h.field_78795_f = -1.57f;
                this.field_178724_i.field_78795_f = -1.57f;
                this.field_178721_j.field_78797_d = 1.0f;
                this.field_178722_k.field_78797_d = 1.0f;
                this.field_178723_h.field_78797_d = 1.0f;
                this.field_178724_i.field_78797_d = 1.0f;
                this.field_178721_j.field_78798_e = 12.0f;
                this.field_178722_k.field_78798_e = 12.0f;
                break;
            }
            case KNEELING: {
                this.field_178722_k.field_78795_f = -1.57f;
                this.field_178733_c.field_78795_f = -1.57f;
                this.bipedLeftFoot.field_78795_f = 1.65f;
                this.field_178721_j.field_78795_f = 0.25f;
                this.bipedRightFoot.field_78795_f = 1.4f;
                break;
            }
            case SQUATTING: {
                this.field_178722_k.field_78795_f = -1.82f;
                this.field_178721_j.field_78795_f = -1.82f;
                this.field_178721_j.field_78796_g = 0.625f;
                this.field_178722_k.field_78796_g = -0.625f;
                this.field_178721_j.field_78798_e = 2.0f;
                this.field_178722_k.field_78798_e = 2.0f;
                this.bipedLeftFoot.field_78795_f = 1.9950001f;
                this.bipedRightFoot.field_78795_f = 1.9950001f;
                this.field_78115_e.field_78795_f = 0.3f;
                this.field_178723_h.field_78795_f = -0.45f;
                this.field_178723_h.field_78796_g = 0.45f;
                this.field_178724_i.field_78795_f = -0.45f;
                this.field_178724_i.field_78796_g = -0.45f;
                this.bipedRightHand.field_78795_f = -0.75f;
                this.bipedLeftHand.field_78795_f = -0.75f;
                break;
            }
            case KAZACHOK: {
                float v = ageInTicks % 22.0f / 22.0f;
                float v1 = v < 0.5f ? v * 2.0f : 1.0f;
                float v2 = v > 0.5f ? (v - 0.5f) / 0.5f : 0.0f;
                this.field_178721_j.field_78796_g = 0.25f;
                this.field_178722_k.field_78796_g = -0.25f;
                float kickLeg = -1.32f;
                float landLeg = -1.82f;
                float kickFoot = 1.9200001f;
                this.field_178722_k.field_78795_f = IIUtils.clampedLerp3Par(-1.32f, -1.82f - v2 * 0.125f, -1.32f, v1);
                this.field_178721_j.field_78795_f = IIUtils.clampedLerp3Par(-1.32f, -1.82f - v1 * 0.125f, -1.32f, v2);
                this.bipedLeftFoot.field_78795_f = IIUtils.clampedLerp3Par(1.9200001f, -0.25f, 1.9200001f, v1);
                this.bipedRightFoot.field_78795_f = IIUtils.clampedLerp3Par(1.9200001f, -0.25f, 1.9200001f, v2);
                this.field_78115_e.field_78795_f = -0.1f;
                this.field_178723_h.field_78795_f = -1.57f;
                this.field_178723_h.field_78796_g = -0.95f;
                this.bipedRightHand.field_78795_f = -0.125f;
                this.bipedRightHand.field_78808_h = -0.35f;
                this.field_178724_i.field_78795_f = -1.57f;
                this.field_178724_i.field_78796_g = 0.95f;
                this.bipedLeftHand.field_78795_f = -0.125f;
                this.bipedLeftHand.field_78808_h = 0.35f;
            }
            case SWIMMING: 
        }
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179094_E();
        super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179121_F();
    }

    public void func_187073_a(float scale, EnumHandSide side) {
        ModelRenderer hand = side == EnumHandSide.LEFT ? this.bipedLeftHand : this.bipedRightHand;
        ModelRenderer arm = this.func_187074_a(side);
        float f = 0.5f * (float)(side == EnumHandSide.RIGHT ? 1 : -1);
        arm.field_78800_c += f;
        hand.field_78797_d -= 3.0f;
        hand.field_78798_e += 1.0f;
        arm.func_78794_c(scale);
        hand.func_78794_c(scale);
        hand.field_78797_d += 3.0f;
        hand.field_78798_e -= 1.0f;
        arm.field_78800_c -= f;
    }

    private static class ModelBoxCustomizable
    extends ModelBox {
        public static final int SIDE_LEFT = 1;
        public static final int SIDE_RIGHT = 2;
        public static final int SIDE_TOP = 4;
        public static final int SIDE_BOTTOM = 8;
        public static final int SIDE_FRONT = 16;
        public static final int SIDE_BACK = 32;
        public static final int SIDE_ALL = 63;
        private final PositionTextureVertex[] vertexPositions;
        private final TexturedQuad[] quadList;
        private final float posX1;
        private final float posY1;
        private final float posZ1;
        private final float posX2;
        private final float posY2;
        private final float posZ2;
        private int visibleSides;

        public ModelBoxCustomizable(ModelRenderer model, int u, int v, float x1, float y1, float z1, int width, int height, int depth, float expand, int topVOffset, int bottomUOffset) {
            super(model, u, v, x1, y1, z1, width, height, depth, expand);
            this.posX1 = x1;
            this.posY1 = y1;
            this.posZ1 = z1;
            this.posX2 = x1 + (float)width;
            this.posY2 = y1 + (float)height;
            this.posZ2 = z1 + (float)depth;
            this.vertexPositions = new PositionTextureVertex[8];
            this.quadList = new TexturedQuad[6];
            float x2 = x1 + (float)width;
            float y2 = y1 + (float)height;
            float z2 = z1 + (float)depth;
            x1 -= expand;
            y1 -= expand;
            z1 -= expand;
            x2 += expand;
            y2 += expand;
            z2 += expand;
            if (model.field_78809_i) {
                float x = x2;
                x2 = x1;
                x1 = x;
            }
            PositionTextureVertex v000 = new PositionTextureVertex(x1, y1, z1, 1.3563156E-19f, 1.3563156E-19f);
            PositionTextureVertex v100 = new PositionTextureVertex(x2, y1, z1, 1.3563264E-19f, 4.966073E28f);
            PositionTextureVertex v110 = new PositionTextureVertex(x2, y2, z1, 1.9364292E31f, 1.7032407E25f);
            PositionTextureVertex v010 = new PositionTextureVertex(x1, y2, z1, 1.9441665E31f, 1.9264504E-19f);
            PositionTextureVertex v001 = new PositionTextureVertex(x1, y1, z2, 4.076745E22f, 1.3563156E-19f);
            PositionTextureVertex v101 = new PositionTextureVertex(x2, y1, z2, 2.0113521E-19f, 3.0309808E24f);
            PositionTextureVertex v111 = new PositionTextureVertex(x2, y2, z2, 6.977187E22f, 1.88877E31f);
            PositionTextureVertex v011 = new PositionTextureVertex(x1, y2, z2, 1.0943429E31f, 2.0958594E-19f);
            this.vertexPositions[0] = v000;
            this.vertexPositions[1] = v100;
            this.vertexPositions[2] = v110;
            this.vertexPositions[3] = v010;
            this.vertexPositions[4] = v001;
            this.vertexPositions[5] = v101;
            this.vertexPositions[6] = v111;
            this.vertexPositions[7] = v011;
            this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{v101, v100, v110, v111}, u + depth + width, v + depth, u + depth + width + depth, v + depth + height, model.field_78801_a, model.field_78799_b);
            this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{v000, v001, v011, v010}, u, v + depth, u + depth, v + depth + height, model.field_78801_a, model.field_78799_b);
            this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{v101, v001, v000, v100}, u + depth, v + topVOffset, u + depth + width, v + depth + topVOffset, model.field_78801_a, model.field_78799_b);
            this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{v110, v010, v011, v111}, u + depth + width + bottomUOffset, v + depth + topVOffset, u + depth + width + width + bottomUOffset, v + topVOffset, model.field_78801_a, model.field_78799_b);
            this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{v100, v000, v010, v110}, u + depth, v + depth, u + depth + width, v + depth + height, model.field_78801_a, model.field_78799_b);
            this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{v001, v101, v111, v011}, u + depth + width + depth, v + depth, u + depth + width + depth + width, v + depth + height, model.field_78801_a, model.field_78799_b);
            if (model.field_78809_i) {
                Arrays.stream(this.quadList).forEach(TexturedQuad::func_78235_a);
            }
            this.setVisibleSides(63);
        }

        public void setVisibleSides(int visibleSides) {
            this.visibleSides = visibleSides & 0x3F;
        }

        public void func_178780_a(BufferBuilder vb, float scale) {
            for (int i = 0; i < this.quadList.length; ++i) {
                if ((this.visibleSides & 1 << i) == 0) continue;
                this.quadList[i].func_178765_a(vb, scale);
            }
        }
    }

    public static class BipedTextureUVs {
        int armLeftU;
        int armLeftV;
        int armRightU;
        int armRightV;
        int armWearLeftU;
        int armWearLeftV;
        int armWearRightU;
        int armWearRightV;
        int legLeftU;
        int legLeftV;
        int legRightU;
        int legRightV;
        int legWearLeftU;
        int legWearLeftV;
        int legWearRightU;
        int legWearRightV;
        int bodyU;
        int bodyV;

        public BipedTextureUVs(int armLeftU, int armLeftV, int armRightU, int armRightV, int armWearLeftU, int armWearLeftV, int armWearRightU, int armWearRightV, int legLeftU, int legLeftV, int legRightU, int legRightV, int legWearLeftU, int legWearLeftV, int legWearRightU, int legWearRightV, int bodyU, int bodyV) {
            this.armLeftU = armLeftU;
            this.armLeftV = armLeftV;
            this.armRightU = armRightU;
            this.armRightV = armRightV;
            this.armWearLeftU = armWearLeftU;
            this.armWearLeftV = armWearLeftV;
            this.armWearRightU = armWearRightU;
            this.armWearRightV = armWearRightV;
            this.legLeftU = legLeftU;
            this.legLeftV = legLeftV;
            this.legRightU = legRightU;
            this.legRightV = legRightV;
            this.legWearLeftU = legWearLeftU;
            this.legWearLeftV = legWearLeftV;
            this.legWearRightU = legWearRightU;
            this.legWearRightV = legWearRightV;
            this.bodyU = bodyU;
            this.bodyV = bodyV;
        }
    }
}

