/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.world.IBlockAccess;
import pl.pabilo8.immersiveintelligence.client.render.IReloadableModelContainer;

public abstract class IITileRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer<T>
implements IReloadableModelContainer<IITileRenderer<T>> {
    private boolean unCompiled = true;

    public final void func_192841_a(@Nullable T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (this.shouldNotRender(te)) {
            return;
        }
        if (te != null && this.unCompiled) {
            Tuple<IBlockState, IBakedModel> model = this.getModelFromBlockState(te);
            if (model.func_76340_b() instanceof IESmartObjModel) {
                this.nullifyModels();
                this.compileModels(model);
                this.unCompiled = false;
            } else {
                return;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        ClientUtils.bindAtlas();
        this.draw(te, Tessellator.func_178181_a().func_178180_c(), partialTicks, Tessellator.func_178181_a());
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
    }

    public final void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
    }

    protected Tuple<IBlockState, IBakedModel> getModelFromBlockState(T te) {
        if (!te.func_145830_o()) {
            return null;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)te.func_145831_w(), te.func_174877_v());
        state = state.func_177226_a((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        return new Tuple((Object)state, (Object)blockRenderer.func_175023_a().func_178125_b(state));
    }

    protected void applyStandardRotation(EnumFacing facing) {
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)facing.func_185119_l(), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
    }

    protected final void mirrorRender() {
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
    }

    protected final void unMirrorRender() {
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
    }

    @Override
    public final void reloadModels() {
        this.unCompiled = true;
    }

    public abstract void draw(T var1, BufferBuilder var2, float var3, Tessellator var4);

    public abstract void compileModels(Tuple<IBlockState, IBakedModel> var1);

    protected abstract void nullifyModels();

    protected boolean shouldNotRender(T te) {
        return te == null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RegisteredTileRenderer {
        public String name();

        public Class<? extends TileEntity> clazz();
    }
}

