/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.hans;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pl.pabilo8.immersiveintelligence.client.model.misc.ModelHansBiped;
import pl.pabilo8.immersiveintelligence.client.render.IReloadableModelContainer;
import pl.pabilo8.immersiveintelligence.client.render.hans.LayerHansEmotions;
import pl.pabilo8.immersiveintelligence.client.render.hans.LayerHansHeldItem;
import pl.pabilo8.immersiveintelligence.client.render.hans.LayerHansTeamOverlay;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;

public class HansRenderer
extends RenderLivingBase<EntityHans>
implements IReloadableModelContainer<HansRenderer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("immersiveintelligence", "textures/entity/hans.png");

    public HansRenderer(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelPlayer(0.0f, false), 0.5f);
        this.func_177094_a(new LayerHansEmotions(this));
        this.func_177094_a(new LayerHansTeamOverlay(this));
        this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.subscribeToList("hans");
    }

    protected void preRenderCallback(EntityHans entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    public void doRender(EntityHans entity, double x, double y, double z, float entityYaw, float partialTicks) {
        double d0 = y;
        d0 = entity.prevLegAnimation == entity.legAnimation ? (d0 += this.getOffsetForPose(entity, entity.getLegAnimation())) : (d0 += MathHelper.func_151238_b((double)this.getOffsetForPose(entity, entity.prevLegAnimation), (double)this.getOffsetForPose(entity, entity.getLegAnimation()), (double)(1.0f - MathHelper.func_76131_a((float)(((float)entity.legAnimationTimer - partialTicks) / 8.0f), (float)0.0f, (float)1.0f))));
        this.setModelVisibilities(entity);
        super.func_76986_a((EntityLivingBase)entity, x, d0, z, entityYaw, partialTicks);
    }

    private void setModelVisibilities(EntityHans hans) {
        ModelPlayer model = this.getMainModel();
        ItemStack mainHand = hans.func_184614_ca();
        ItemStack offHand = hans.func_184592_cb();
        model.func_178719_a(true);
        model.field_78117_n = hans.func_70093_af();
        ModelBiped.ArmPose poseMainHand = ModelBiped.ArmPose.EMPTY;
        ModelBiped.ArmPose poseOffHand = ModelBiped.ArmPose.EMPTY;
        if (!mainHand.func_190926_b()) {
            poseMainHand = ModelBiped.ArmPose.ITEM;
            if (hans.func_184605_cv() > 0) {
                EnumAction enumaction = mainHand.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    poseMainHand = ModelBiped.ArmPose.BLOCK;
                } else if (enumaction == EnumAction.BOW) {
                    poseMainHand = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        if (!offHand.func_190926_b()) {
            poseOffHand = ModelBiped.ArmPose.ITEM;
            if (hans.func_184605_cv() > 0) {
                EnumAction enumaction1 = offHand.func_77975_n();
                if (enumaction1 == EnumAction.BLOCK) {
                    poseOffHand = ModelBiped.ArmPose.BLOCK;
                } else if (enumaction1 == EnumAction.BOW) {
                    poseOffHand = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        if (hans.func_184591_cq() == EnumHandSide.RIGHT) {
            model.field_187076_m = poseMainHand;
            model.field_187075_l = poseOffHand;
        } else {
            model.field_187076_m = poseOffHand;
            model.field_187075_l = poseMainHand;
        }
    }

    public ModelPlayer getMainModel() {
        return (ModelPlayer)super.func_177087_b();
    }

    protected ResourceLocation getEntityTexture(EntityHans entity) {
        return TEXTURE;
    }

    protected void renderEntityName(EntityHans entityIn, double x, double y, double z, String name, double distanceSq) {
        super.func_188296_a((Entity)entityIn, x, y, z, entityIn.func_145748_c_().func_150260_c(), distanceSq);
    }

    @Override
    public void reloadModels() {
        this.field_77045_g = new ModelHansBiped(0.0f, false);
        this.field_177097_h.clear();
        this.func_177094_a(new LayerHansEmotions(this));
        this.func_177094_a(new LayerHansTeamOverlay(this));
        this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
        this.func_177094_a(new LayerHansHeldItem(this));
    }

    public double getOffsetForPose(EntityHans entity, HansAnimations.HansLegAnimation animation) {
        switch (animation) {
            case LYING: {
                return -1.25;
            }
            case SQUATTING: {
                return -0.385;
            }
            case SNEAKING: {
                return -0.125;
            }
            case KNEELING: {
                return -0.25;
            }
            case KAZACHOK: {
                float v = (float)(entity.field_70173_aa % 22) / 22.0f;
                float v1 = v < 0.5f ? v * 2.0f : 1.0f;
                float v2 = v > 0.5f ? (v - 0.5f) / 0.5f : 0.0f;
                return -0.325f + IIUtils.clampedLerp3Par(0.0f, 0.0725f, 0.0f, v1) + IIUtils.clampedLerp3Par(0.0f, 0.0725f, 0.0f, v2);
            }
            case SWIMMING: {
                return 1.0;
            }
        }
        return 0.0;
    }
}

