/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.hans;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import pl.pabilo8.immersiveintelligence.client.render.hans.HansRenderer;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;

public class LayerHansEmotions
implements LayerRenderer<EntityHans> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("immersiveengineering", "textures/items/white.png");
    private final HansRenderer hansRenderer;
    private final ModelBiped modelHans;
    private final float[] EYEBROW_COLOUR = IIUtils.rgbIntToRGB(3024419);
    private final float[] EYE_BACK_COLOUR = IIUtils.rgbIntToRGB(0xF1F1F1);
    private final float[] EYELID_COLOUR = IIUtils.rgbIntToRGB(14592147);
    private final float[] LIP_COLOUR = IIUtils.rgbIntToRGB(12949894);
    private final float[] MOUTH_COLOUR = IIUtils.rgbIntToRGB(4668986);
    private final float[] TEETH_COLOUR = IIUtils.rgbIntToRGB(0xC1C1C1);
    private final float[] TONGUE_COLOUR = IIUtils.rgbIntToRGB(12945030);

    public LayerHansEmotions(HansRenderer renderer) {
        this.hansRenderer = renderer;
        this.modelHans = (ModelBiped)this.hansRenderer.field_77045_g;
    }

    public void doRenderLayer(EntityHans hans, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        boolean upperTeethVisible;
        double tongueHeight;
        double lipTopWidth;
        double lipTopOffset;
        double lipBottomWidth;
        double lipBottomOffset;
        GlStateManager.func_179094_E();
        if (hans.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.25, (double)0.0);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)0.0625);
        ModelRenderer biped = this.modelHans.field_78116_c;
        GlStateManager.func_179109_b((float)(biped.field_78800_c * scale), (float)(biped.field_78797_d * scale), (float)(biped.field_78798_e * scale));
        if (biped.field_78796_g != 0.0f) {
            GlStateManager.func_179114_b((float)(biped.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (biped.field_78795_f != 0.0f) {
            GlStateManager.func_179114_b((float)(biped.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (biped.field_78808_h != 0.0f) {
            GlStateManager.func_179114_b((float)(biped.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        HansAnimations.EyeEmotions emotionE = hans.eyeEmotion;
        HansAnimations.MouthEmotions emotionM = hans.mouthEmotion;
        HansAnimations.MouthShapes mouthShape = hans.mouthShape;
        double lookOffset = 0.0;
        double eyebrowThickness = emotionE.eyebrowThickness;
        double eyebrowHeightDiffRight = emotionE.eyebrowHeightDiffRight;
        double eyebrowHeightDiffLeft = emotionE.eyebrowHeightDiffLeft;
        double eyeBlink = Math.min(((float)(hans.field_70173_aa % 140) + partialTicks) / 5.0f, 1.0f);
        double eyeBlinkHalf = 1.0 - Math.abs((eyeBlink - 0.5) / 0.5);
        if (hans.mouthShapeQueue.size() > 0) {
            double mouthProgress = ((float)hans.speechProgress + partialTicks) / (float)((Integer)hans.mouthShapeQueue.get(0).func_76341_a()).intValue();
            double[] mouthShapeVals = HansAnimations.getMouthShapeInBetween(hans.mouthShape, (HansAnimations.MouthShapes)((Object)hans.mouthShapeQueue.get(0).func_76340_b()), emotionM, mouthProgress);
            lipBottomOffset = mouthShapeVals[0];
            lipBottomWidth = mouthShapeVals[1];
            lipTopOffset = mouthShapeVals[2];
            lipTopWidth = mouthShapeVals[3];
            tongueHeight = mouthShapeVals[4];
            upperTeethVisible = ((HansAnimations.MouthShapes)((Object)hans.mouthShapeQueue.get((int)0).func_76340_b())).upperTeethVisible;
        } else {
            lipBottomOffset = mouthShape.lipBottomOffset;
            lipBottomWidth = mouthShape.lipBottomWidth;
            lipTopOffset = mouthShape.lipTopOffset;
            lipTopWidth = mouthShape.lipTopWidth;
            tongueHeight = mouthShape.tongueHeight;
            upperTeethVisible = mouthShape.upperTeethVisible;
        }
        this.hansRenderer.func_110776_a(TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        this.drawHansEyes(buffer, lookOffset, eyebrowThickness, eyebrowHeightDiffRight, eyebrowHeightDiffLeft, eyeBlinkHalf, IIUtils.rgbIntToRGB(hans.eyeColour));
        this.drawHansMouth(buffer, lipBottomOffset, lipBottomWidth, lipTopOffset, lipTopWidth, tongueHeight, upperTeethVisible);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return true;
    }

    public static void drawTexturedModalRect(BufferBuilder buff, double x, double y, double z, double width, double height, double depth, double hdiff, float[] rgb) {
        float us = 0.0f;
        float vs = 0.0f;
        float ue = 1.0f;
        float ve = 1.0f;
        buff.func_181662_b(x, y, z).func_187315_a((double)us, (double)vs).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buff.func_181662_b(x, y + height, z + depth).func_187315_a((double)us, (double)ve).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buff.func_181662_b(x + width, y + height + hdiff, z + depth).func_187315_a((double)ue, (double)ve).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buff.func_181662_b(x + width, y + hdiff, z).func_187315_a((double)ue, (double)ve).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
    }

    private void drawHansEyes(BufferBuilder buffer, double lookOffset, double eyebrowThickness, double eyebrowHeightDiffRight, double eyebrowHeightDiffLeft, double eyeBlinkProgress, float[] eyeColour) {
        LayerHansEmotions.drawTexturedModalRect(buffer, 1.0, -5.0 - eyebrowThickness + 0.125 * eyeBlinkProgress, -4.014f, 2.0, eyebrowThickness, 0.0, eyebrowHeightDiffRight, this.EYEBROW_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, 1.0, -5.0, -4.011f, 2.0, 1.0, 0.0, 0.0, this.EYE_BACK_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, 1.0 + Math.max(lookOffset, 0.0), -5.0, -4.012f, 1.0, 1.0, 0.0, 0.0, eyeColour);
        LayerHansEmotions.drawTexturedModalRect(buffer, -3.0, -5.0 - eyebrowThickness + 0.125 * eyeBlinkProgress + eyebrowHeightDiffLeft, -4.014f, 2.0, eyebrowThickness, 0.0, -eyebrowHeightDiffLeft, this.EYEBROW_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -3.0, -5.0, -4.011f, 2.0, 1.0, 0.0, 0.0, this.EYE_BACK_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -2.0 + Math.min(lookOffset, 0.0), -5.0, -4.012f, 1.0, 1.0, 0.0, 0.0, eyeColour);
        LayerHansEmotions.drawTexturedModalRect(buffer, 1.0, -5.0, -4.013f, 2.0, eyeBlinkProgress, 0.0, 0.0, this.EYELID_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -3.0, -5.0, -4.013f, 2.0, eyeBlinkProgress, 0.0, 0.0, this.EYELID_COLOUR);
    }

    private void drawHansMouth(BufferBuilder buffer, double lipBottomOffset, double lipBottomWidth, double lipTopOffset, double lipTopWidth, double tongueHeight, boolean upperTeethVisible) {
        LayerHansEmotions.drawTexturedModalRect(buffer, -1.0 - (Math.min(lipTopWidth, lipBottomWidth) - 1.0), -2.0, -4.011f, 2.0 * Math.min(lipTopWidth, lipBottomWidth), 1.0, 0.0, 0.0, this.MOUTH_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -0.5, -1.0 - tongueHeight, -4.012f, 1.0, tongueHeight, 0.0, 0.0, this.TONGUE_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -1.0 - (lipTopWidth - 1.0), -2.0 - lipTopOffset * 0.55, -4.016f, 2.0 * lipTopWidth, 1.0 - lipTopOffset * 0.55, 0.0, 0.0, this.LIP_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -1.0 - (lipTopWidth - 1.0) + 0.125, -2.0 - lipTopOffset * 0.4, upperTeethVisible ? (double)-4.015f : (double)-4.013f, 1.75 * lipTopWidth, 1.0 - lipTopOffset * 0.4, 0.0, 0.0, this.TEETH_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -1.0 - (lipBottomWidth - 1.0), -2.0 + 2.0 * lipBottomOffset * 0.55, -4.014f, 2.0 * lipBottomWidth, 1.0 - lipBottomOffset * 0.55, 0.0, 0.0, this.LIP_COLOUR);
        LayerHansEmotions.drawTexturedModalRect(buffer, -1.0 - (lipBottomWidth - 1.0) + 0.125, -2.0 + 2.0 * lipBottomOffset * 0.4, -4.013f, 1.75 * lipBottomWidth, 1.0 - lipBottomOffset * 0.4, 0.0, 0.0, this.TEETH_COLOUR);
    }
}

