/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.item;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleGunfire;
import pl.pabilo8.immersiveintelligence.client.render.item.ISpecificHandRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTBullet;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTCrossVariantReference;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTHand;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCacheBuilder;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTParticle;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTText;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCachedMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIUpgradableItemRendererAMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.MTLTextureRemapper;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIAssaultRifle;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.IISkinHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;

public class AssaultRifleRenderer
extends IIUpgradableItemRendererAMT<ItemIIAssaultRifle>
implements ISpecificHandRenderer {
    IIAnimationCachedMap load;
    IIAnimationCachedMap unload;
    IIAnimationCachedMap modeSwitch;
    IIAnimationCachedMap fire;
    IIAnimationCachedMap handAngle;
    IIAnimationCachedMap offHandAngle;
    IIAnimationCachedMap loadGrenade;
    IIAnimationCachedMap fireGrenade;
    IIAnimationCachedMap stabilizer;
    private MTLTextureRemapper skinRemapper;
    private AMTCrossVariantReference<AMT> magazine;
    private AMTCrossVariantReference<AMT> hand;
    private AMTCrossVariantReference<AMTParticle> muzzleFlash;
    private AMTCrossVariantReference<AMTText> nixie1;
    private AMTCrossVariantReference<AMTText> nixie2;
    private AMTCrossVariantReference<AMTBullet> grenade;
    private AMTCrossVariantReference<AMTBullet> casingFired;

    public AssaultRifleRenderer() {
        super(IIContent.itemAssaultRifle, ResLoc.of(RES_MODEL_WEAPON, "assault_rifle"));
    }

    @Override
    protected ImmersiveModelRegistry.ItemModelReplacement setTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ model) {
        Matrix4 tpp = new Matrix4().scale(0.385, 0.385, 0.385).rotate(Math.toRadians(-20.5), 0.0, 1.0, 0.0).translate(0.625, -1.25, -0.25);
        Matrix4 tppOffhand = new Matrix4().scale(0.385, 0.385, 0.385).rotate(Math.toRadians(75.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(20.5), 0.0, 0.0, 1.0).rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).translate(-0.5, -0.25, 0.125);
        Matrix4 fpp = new Matrix4().scale(0.625, 0.625, 0.625).translate(0.75, -1.0, 0.0).rotate(Math.toRadians(7.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(5.0), 1.0, 0.0, 0.0).translate(0.0, 0.0, -0.5);
        Matrix4 fppOffhand = new Matrix4().scale(0.55, 0.55, 0.55).translate(0.75, -1.0, 0.0).rotate(Math.toRadians(82.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(2.5), 1.0, 0.0, 0.0).translate(0.0, 0.0, -0.5);
        return model.setTransformations(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(0.325, 0.325, 0.325).translate(0.5, -0.75, 0.5)).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, tpp).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, tppOffhand).setTransformations(ItemCameraTransforms.TransformType.FIXED, new Matrix4().rotate(Math.toRadians(-3.5), 1.0, 0.0, 0.0).rotate(Math.toRadians(-75.0), 0.0, 1.0, 0.0).translate(0.125, -0.25, -0.125).scale(0.425, 0.425, 0.425)).setTransformations(ItemCameraTransforms.TransformType.GUI, new Matrix4().translate(0.0, -0.25, 0.0).scale(0.325, 0.325, 0.325).rotate(Math.toRadians(35.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(135.0), 0.0, 1.0, 0.0)).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, fpp).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, fppOffhand);
    }

    @Override
    public void registerSprites(TextureMap map) {
        super.registerSprites(map);
        IISkinHandler.registerSprites(map, IIContent.itemAssaultRifle.getSkinnableName());
    }

    @Override
    public void draw(ItemStack stack, ItemCameraTransforms.TransformType transform, BufferBuilder buf, Tessellator tes, float partialTicks) {
        if (this.isScopeZooming(transform, stack)) {
            return;
        }
        EasyNBT nbt = EasyNBT.wrapNBT(stack);
        this.model.getVariant(nbt.getString("contributorSkin"), stack);
        this.model.forEach(AMT::defaultize);
        this.showUpgrades(stack, nbt);
        ItemStack magazine = nbt.getItemStack("magazine");
        ItemStack grenade = nbt.getItemStack("grenade");
        IIAnimationUtils.setModelVisibility(this.magazine.get(), !magazine.func_190926_b());
        int firing = nbt.getInt("fireDelay");
        int firingDelay = ((ItemIIAssaultRifle)this.item).getFireDelay(stack, nbt);
        int reloading = nbt.getInt("reloading");
        int lastMode = nbt.getInt("last_mode");
        int fireMode = nbt.getInt("fire_mode");
        int modeTimer = nbt.getInt("mode_switch");
        boolean handRender = this.is1stPerson(transform);
        IIAnimationUtils.setModelVisibility(this.hand.get(), handRender);
        if (handRender) {
            int aiming = nbt.getInt("aiming");
            boolean scoped = ((ItemIIAssaultRifle)this.item).isScoped(stack);
            float preciseAim = IIAnimationUtils.getAnimationProgress(aiming, ((ItemIIAssaultRifle)this.item).getAimingTime(stack, nbt), true, !Minecraft.func_71410_x().field_71439_g.func_70093_af(), 1.0f, 3.0f, partialTicks);
            if (preciseAim > 0.0f) {
                float recoil = Math.min((nbt.getFloat("recoilV") + nbt.getFloat("recoilH")) / (IIConfigHandler.IIConfig.Weapons.AssaultRifle.maxRecoilHorizontal + IIConfigHandler.IIConfig.Weapons.AssaultRifle.maxRecoilVertical), 1.0f);
                GlStateManager.func_179137_b((double)((double)(-preciseAim) * 1.03125), (double)(0.225 * (double)preciseAim), (double)0.0);
                GlStateManager.func_179114_b((float)(preciseAim * -8.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(preciseAim * -5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                if (scoped) {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)preciseAim * -0.1), (double)((double)preciseAim * 0.85));
                    GlStateManager.func_179114_b((float)(5.0f * preciseAim), (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)preciseAim * 0.25));
                }
                if (recoil > 0.0f) {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)(-recoil) * (0.155 - 0.1 * (double)preciseAim)), (double)((double)recoil * 0.25));
                }
            }
            (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND ? this.handAngle : this.offHandAngle).apply(preciseAim);
        }
        this.fireGrenade.apply(0.0f);
        (fireMode == 2 ? this.fireGrenade : this.fire).apply(1.0f - ((float)firing - partialTicks) / (float)firingDelay);
        if (transform == ItemCameraTransforms.TransformType.GUI) {
            IIAnimationUtils.setModelVisibility(this.muzzleFlash.get(), false);
            IIAnimationUtils.setModelVisibility(this.casingFired.get(), false);
        }
        this.grenade.get().withStack(grenade, AMTBullet.BulletState.BULLET_USED);
        IIAnimationUtils.setModelVisibility(this.magazine.get(), !magazine.func_190926_b());
        if (reloading > 0) {
            float v = IIAnimationUtils.getAnimationProgress(reloading, ((ItemIIAssaultRifle)this.item).getReloadTime(stack, ItemStack.field_190927_a, EasyNBT.wrapNBT(((ItemIIAssaultRifle)this.item).getUpgrades(stack))), false, partialTicks);
            float rpart = (double)v <= 0.33 ? v / 0.33f : ((double)v <= 0.66 ? 1.0f : 1.0f - (v - 0.66f) / 0.33f);
            switch (fireMode) {
                case 0: 
                case 1: {
                    (magazine.func_190926_b() ? this.load : this.unload).apply(v);
                    if (!handRender) break;
                    GlStateManager.func_179114_b((float)(rpart * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)0.0, (double)((double)(-rpart) * 0.75), (double)((double)(-rpart) * 1.5));
                    break;
                }
                case 2: {
                    this.loadGrenade.apply(v);
                    this.grenade.get().withStack(nbt.getItemStack("found"), AMTBullet.BulletState.BULLET_UNUSED);
                    if (!handRender) break;
                    GlStateManager.func_179114_b((float)(rpart * 35.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)0.0, (double)((double)(-rpart) * 0.35), (double)0.0);
                    break;
                }
            }
        }
        this.modeSwitch.apply((float)fireMode * 0.5f);
        if (modeTimer > 0) {
            float modeProgress = 1.0f - MathHelper.func_76131_a((float)(((float)nbt.getInt("mode_switch") - partialTicks) / 6.0f), (float)0.0f, (float)1.0f);
            this.modeSwitch.apply((float)MathHelper.func_151238_b((double)lastMode, (double)fireMode, (double)modeProgress) * 0.5f);
        }
        if (handRender) {
            int value = 0;
            if (((ItemIIAssaultRifle)this.item).hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.STEREOSCOPIC_RANGEFINDER)) {
                RayTraceResult mop = ClientUtils.mc().field_71439_g.func_174822_a(60.0, partialTicks);
                if (mop != null) {
                    value = (int)ClientUtils.mc().field_71439_g.func_174791_d().func_72438_d(mop.field_72307_f);
                }
            } else if (fireMode == 2) {
                value = (int)MathHelper.func_76131_a((float)((1.0f - ((float)firing - partialTicks) / (float)firingDelay) * 99.0f), (float)0.0f, (float)99.0f);
            }
            if (((ItemIIAssaultRifle)this.item).hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.GYROSCOPIC_STABILIZER)) {
                this.stabilizer.apply(IIAnimationUtils.getDebugProgress((World)Minecraft.func_71410_x().field_71441_e, 30.0f, partialTicks));
            }
            this.nixie1.get().setText(String.valueOf(value / 10));
            this.nixie2.get().setText(String.valueOf(value % 10));
        }
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }

    @Override
    public void compileModels(OBJModel model, IIModelHeader header) {
        this.model = AMTModelCacheBuilder.startItemModel().withModel(model).withModel(ResLoc.of(this.directoryRes, "upgrades/common.obj")).withModels(this.listUpgradeModels()).withHeader(header).withHeader(ResLoc.of(this.directoryRes, "assault_rifle_upgrades.obj.amt")).withModelProvider((stack, combinedHeader) -> new AMT[]{new AMTParticle("muzzle_flash", (IIModelHeader)combinedHeader).setParticle(new ParticleGunfire(null, Vec3d.field_186680_a, new Vec3d(1.0, 0.0, 0.0), 16.0f)), new AMTHand("hand", (IIModelHeader)combinedHeader, EnumHand.OFF_HAND), new AMTBullet("casing_fired", (IIModelHeader)combinedHeader, AmmoRegistry.INSTANCE.getModel(IIContent.itemAmmoAssaultRifle)).withState(AMTBullet.BulletState.CASING), new AMTBullet("grenade", (IIModelHeader)combinedHeader, AmmoRegistry.INSTANCE.getModel(IIContent.itemRailgunGrenade)).withState(AMTBullet.BulletState.CASING), new AMTText("nixie_text1", (IIModelHeader)combinedHeader).setText("0").setFontSize(0.015625f).setColor(0xFF9900), new AMTText("nixie_text2", (IIModelHeader)combinedHeader).setText("0").setFontSize(0.015625f).setColor(0xFF9900)}).withTextureProvider((res, stack) -> {
            String skin = IIContent.itemAssaultRifle.getSkinnableCurrentSkin((ItemStack)stack);
            if (IISkinHandler.isValidSkin(skin)) {
                this.skinRemapper = new MTLTextureRemapper(model, (ResourceLocation)ResLoc.of(IIReference.RES_TEXTURES_SKIN, skin, "/assault_rifle").withExtension(".mtl"));
                return ClientUtils.getSprite((ResourceLocation)this.skinRemapper.apply((ResourceLocation)res));
            }
            return ClientUtils.getSprite((ResourceLocation)res);
        }).build();
        this.magazine = new AMTCrossVariantReference("magazine", this.model);
        this.hand = new AMTCrossVariantReference("hand", this.model);
        this.muzzleFlash = new AMTCrossVariantReference("muzzle_flash", this.model);
        this.nixie1 = new AMTCrossVariantReference("nixie_text1", this.model);
        this.nixie2 = new AMTCrossVariantReference("nixie_text2", this.model);
        this.grenade = new AMTCrossVariantReference("grenade", this.model);
        this.casingFired = new AMTCrossVariantReference("casing_fired", this.model);
        this.loadUpgrades(model, ResLoc.of(this.animationRes, "upgrades/"));
        this.load = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load"));
        this.unload = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "unload"));
        this.modeSwitch = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "mode_manual"));
        this.fire = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "fire"));
        this.handAngle = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "hand"));
        this.offHandAngle = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "offhand"));
        this.loadGrenade = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load_grenade"));
        this.fireGrenade = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "fire_grenade"));
        this.stabilizer = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "stabilizer"));
    }

    @Override
    protected void nullifyModels() {
        IIAnimationUtils.disposeOf(this.model);
    }

    @Override
    public boolean doHandRender(ItemStack stack, EnumHand hand, ItemStack otherHand, float swingProgress, float partialTicks) {
        return hand == EnumHand.OFF_HAND && otherHand.func_77973_b() instanceof ItemIIGunBase;
    }

    @Override
    public boolean renderCrosshair(ItemStack stack, EnumHand hand) {
        if (((ItemIIAssaultRifle)this.item).isScoped(stack)) {
            return false;
        }
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming") > (double)IIConfigHandler.IIConfig.Weapons.AssaultRifle.aimTime * 0.85;
    }
}

