/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.item;

import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTHand;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIItemRendererAMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.item.tools.ItemIIRadioTuner;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class RadioTunerRenderer
extends IIItemRendererAMT<ItemIIRadioTuner> {
    private static final ResLoc RES_ADVANCED_TUNER = ResLoc.of(IIReference.RES_ITEM_MODEL, "tools/advanced_radio_tuner").withExtension(".obj");
    AMT[] amtBasic;
    AMT[] amtAdvanced;
    IIAnimationCompiledMap handBasic;
    IIAnimationCompiledMap handAdvanced;
    IIAnimationCompiledMap gaugeBasic1;
    IIAnimationCompiledMap gaugeBasic2;
    IIAnimationCompiledMap gaugeAdvanced1;
    IIAnimationCompiledMap gaugeAdvanced2;
    IIAnimationCompiledMap gaugeAdvanced3;

    public RadioTunerRenderer() {
        super(IIContent.itemRadioTuner, ResLoc.of(IIReference.RES_ITEM_MODEL, "tools/radio_tuner").withExtension(".obj"));
    }

    @Override
    protected ImmersiveModelRegistry.ItemModelReplacement setTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ model) {
        Matrix4 tpp = new Matrix4().scale(0.5, 0.5, 0.5).rotate(Math.toRadians(-20.5), 0.0, 1.0, 0.0).translate(0.0, 0.125, (double)0.385f);
        Matrix4 fpp = new Matrix4().scale(1.0, 1.0, 1.0).rotate(Math.toRadians(-25.0), 0.0, 1.0, 0.0).translate(0.25, 0.0, 0.125).translate(0.0, 0.0, -0.5);
        return model.setTransformations(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(0.45, 0.45, 0.45).translate(0.5, 0.0, 0.5)).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, tpp).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, fpp).setTransformations(ItemCameraTransforms.TransformType.GUI, new Matrix4().translate(0.2, 0.0, 0.0).scale(0.7, 0.7, 0.7).rotate(Math.toRadians(-22.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(-7.5), 1.0, 0.0, 0.0));
    }

    @Override
    public void draw(ItemStack stack, ItemCameraTransforms.TransformType transform, BufferBuilder buf, Tessellator tes, float partialTicks) {
        EasyNBT nbt = EasyNBT.wrapNBT(stack);
        float prevFrequency = nbt.getInt("prev_frequency");
        float frequency = nbt.getInt("frequency");
        float progress = prevFrequency + (frequency - prevFrequency) * partialTicks;
        switch (ItemIIRadioTuner.RadioTuners.values()[stack.func_77960_j()]) {
            case BASIC: {
                this.handBasic.apply(this.is1stPerson(transform) ? 1.0f : 0.0f);
                this.renderBasic(progress, buf, tes);
                break;
            }
            case ADVANCED: {
                this.handAdvanced.apply(this.is1stPerson(transform) ? 1.0f : 0.0f);
                this.renderAdvanced(progress, buf, tes);
            }
        }
    }

    private void renderBasic(float frequency, BufferBuilder buf, Tessellator tes) {
        this.gaugeBasic1.apply(frequency % 6.0f / 6.0f);
        this.gaugeBasic2.apply((float)Math.floor(frequency / ((float)IIConfigHandler.IIConfig.radioBasicMaxFrequency / 6.0f)) / 6.0f);
        for (AMT amt : this.amtBasic) {
            amt.render(tes, buf);
        }
    }

    private void renderAdvanced(float frequency, BufferBuilder buf, Tessellator tes) {
        this.gaugeAdvanced3.apply(frequency % 8.0f / 8.0f);
        this.gaugeAdvanced2.apply(frequency % 64.0f / 64.0f);
        this.gaugeAdvanced1.apply((float)Math.floor(frequency / ((float)IIConfigHandler.IIConfig.radioAdvancedMaxFrequency / 64.0f)) / 64.0f);
        for (AMT amt : this.amtAdvanced) {
            amt.render(tes, buf);
        }
    }

    @Override
    public void compileModels(OBJModel model, IIModelHeader header) {
        this.amtBasic = IIAnimationUtils.getAMTItemModel(model, header, header1 -> new AMT[]{new AMTHand("hand", header, EnumHand.MAIN_HAND)});
        this.gaugeBasic1 = IIAnimationCompiledMap.create(this.amtBasic, ResLoc.of(IIReference.RES_II, "tools/basic_tuner/gauge1"));
        this.gaugeBasic2 = IIAnimationCompiledMap.create(this.amtBasic, ResLoc.of(IIReference.RES_II, "tools/basic_tuner/gauge2"));
        this.amtAdvanced = IIAnimationUtils.getAMTItemModel(IIAnimationUtils.modelFromRes(RES_ADVANCED_TUNER), IIAnimationLoader.loadHeader(RES_ADVANCED_TUNER.withExtension(".obj.amt")), header1 -> new AMT[]{new AMTHand("hand", header, EnumHand.MAIN_HAND)});
        this.gaugeAdvanced1 = IIAnimationCompiledMap.create(this.amtAdvanced, ResLoc.of(IIReference.RES_II, "tools/advanced_tuner/gauge1"));
        this.gaugeAdvanced2 = IIAnimationCompiledMap.create(this.amtAdvanced, ResLoc.of(IIReference.RES_II, "tools/advanced_tuner/gauge2"));
        this.gaugeAdvanced3 = IIAnimationCompiledMap.create(this.amtAdvanced, ResLoc.of(IIReference.RES_II, "tools/advanced_tuner/gauge3"));
        this.handBasic = IIAnimationCompiledMap.create(this.amtBasic, ResLoc.of(IIReference.RES_II, "tools/hand"));
        this.handAdvanced = IIAnimationCompiledMap.create(this.amtAdvanced, ResLoc.of(IIReference.RES_II, "tools/hand"));
    }

    @Override
    protected void nullifyModels() {
        IIAnimationUtils.disposeOf(this.amtBasic);
        IIAnimationUtils.disposeOf(this.amtAdvanced);
    }

    @Override
    public void registerSprites(TextureMap map) {
        super.registerSprites(map);
        IIAnimationLoader.preloadTexturesFromMTL(RES_ADVANCED_TUNER.withExtension(".mtl"), map);
    }
}

