/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.item;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleGunfire;
import pl.pabilo8.immersiveintelligence.client.render.item.ISpecificHandRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTBullet;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTCrossVariantReference;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTHand;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCacheBuilder;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTParticle;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCachedMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIUpgradableItemRendererAMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.MTLTextureRemapper;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIRifle;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ammohandler.AmmoHandler;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.IISkinHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;

public class RifleRenderer
extends IIUpgradableItemRendererAMT<ItemIIRifle>
implements ISpecificHandRenderer {
    private MTLTextureRemapper handmadeRemapper;
    private MTLTextureRemapper skinRemapper;
    private AMTCrossVariantReference<AMTBullet> bullet;
    private AMTCrossVariantReference<AMTBullet> casing;
    private IIAnimationCachedMap loadBullet;
    private IIAnimationCachedMap loadMag;
    private IIAnimationCachedMap unloadMag;
    private IIAnimationCachedMap fireBoltAction;
    private IIAnimationCachedMap fireSemiAutomatic;
    private IIAnimationCachedMap handAngle;
    private IIAnimationCachedMap handVisibility;
    private IIAnimationCachedMap offhandVisibility;
    private float swingProgress = 0.0f;

    public RifleRenderer() {
        super(IIContent.itemRifle, ResLoc.of(RES_MODEL_WEAPON, "rifle"));
    }

    @Override
    protected ImmersiveModelRegistry.ItemModelReplacement setTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ model) {
        Matrix4 tpp = new Matrix4().scale(0.385, 0.385, 0.385).translate(-0.25, 0.0, -0.5).rotate(Math.toRadians(-20.5), 0.0, 1.0, 0.0).translate((double)0.825f, -0.525, -0.225);
        Matrix4 tppOffhand = new Matrix4().scale(0.385, 0.385, 0.385).rotate(Math.toRadians(75.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-20.5), 0.0, 0.0, 1.0).rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).translate(-0.125, 0.0, -0.425);
        Matrix4 fpp = new Matrix4().scale(0.75, 0.75, 0.75).translate(0.75, (double)-0.65f, 0.0).rotate(Math.toRadians(7.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(5.0), 1.0, 0.0, 0.0).translate(0.0, 0.0, -1.0);
        Matrix4 fppOffhand = new Matrix4().scale(0.75, 0.75, 0.75).translate(0.75, (double)-0.65f, 0.0).rotate(Math.toRadians(82.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(5.0), 1.0, 0.0, 0.0).translate(0.0, 0.0, -1.0);
        return model.setTransformations(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(0.325, 0.325, 0.325).translate(0.5, -0.75, 0.5)).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, tpp).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, tppOffhand).setTransformations(ItemCameraTransforms.TransformType.FIXED, new Matrix4().rotate(Math.toRadians(-3.5), 1.0, 0.0, 0.0).rotate(Math.toRadians(-78.0), 0.0, 1.0, 0.0).translate(0.0625, 0.0, -0.125).scale(0.425, 0.425, 0.425)).setTransformations(ItemCameraTransforms.TransformType.GUI, new Matrix4().translate(0.0, -0.125, 0.0).scale(0.355, 0.355, 0.355).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(145.0), 0.0, 1.0, 0.0)).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, fpp).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, fppOffhand);
    }

    @Override
    public void draw(ItemStack stack, ItemCameraTransforms.TransformType transform, BufferBuilder buf, Tessellator tes, float partialTicks) {
        if (this.isScopeZooming(transform, stack)) {
            return;
        }
        EasyNBT nbt = EasyNBT.wrapNBT(stack);
        AmmoHandler ammoHandler = ((ItemIIRifle)this.item).getAmmoHandler(stack);
        this.model.getVariant(nbt.hasKey("handmade") ? "diy" : nbt.getString("contributorSkin"), stack);
        this.model.forEach(AMT::defaultize);
        int firing = nbt.getInt("fireDelay");
        int reloading = nbt.getInt("reloading");
        boolean handRender = this.is1stPerson(transform);
        boolean semiAuto = ((ItemIIRifle)this.item).hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SEMI_AUTOMATIC);
        boolean gui = transform == ItemCameraTransforms.TransformType.GUI;
        this.showUpgrades(stack, nbt);
        this.handVisibility.apply(handRender ? 1.0f : 0.0f);
        if (handRender) {
            int aiming = nbt.getInt("aiming");
            float preciseAim = IIAnimationUtils.getAnimationProgress(aiming, ((ItemIIRifle)this.item).getAimingTime(stack, nbt), true, !Minecraft.func_71410_x().field_71439_g.func_70093_af(), 1.0f, 3.0f, partialTicks);
            if (preciseAim > 0.0f) {
                float recoil = Math.min((nbt.getFloat("recoilV") + nbt.getFloat("recoilH")) / (IIConfigHandler.IIConfig.Weapons.AssaultRifle.maxRecoilHorizontal + IIConfigHandler.IIConfig.Weapons.AssaultRifle.maxRecoilVertical), 1.0f);
                GlStateManager.func_179137_b((double)((double)(-preciseAim) * 0.9140625), (double)(0.25 * (double)preciseAim), (double)0.0);
                GlStateManager.func_179114_b((float)(preciseAim * -7.75f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(preciseAim * -5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                if (((ItemIIRifle)this.item).hasIIUpgrades(stack, ItemIIWeaponUpgrade.WeaponUpgrades.SCOPE)) {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)preciseAim * -0.1), (double)((double)preciseAim * 1.5));
                    GlStateManager.func_179114_b((float)(5.0f * preciseAim), (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)preciseAim * 0.35));
                }
                if (recoil > 0.0f) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)recoil * 0.25));
                }
            } else if (this.swingProgress > 0.0f && ((ItemIIRifle)this.item).getUpgrades(stack).func_74764_b("melee")) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-0.5f * (1.0f - Math.abs((this.swingProgress - 0.5f) / 0.5f))));
            }
            this.handAngle.apply(preciseAim);
        }
        (semiAuto ? this.fireSemiAutomatic : this.fireBoltAction).apply(gui ? 0.0f : 1.0f - ((float)firing - partialTicks) / (float)((ItemIIRifle)this.item).getFireDelay(stack, nbt));
        float v = IIAnimationUtils.getAnimationProgress(reloading, ((ItemIIRifle)this.item).getReloadTime(stack, ItemStack.field_190927_a, EasyNBT.wrapNBT(((ItemIIRifle)this.item).getUpgrades(stack))), reloading > 0, false, 1.0f, 0.0f, partialTicks);
        if (semiAuto) {
            ItemStack magazine = nbt.getItemStack("magazine");
            (magazine.func_190926_b() ? this.loadMag : this.unloadMag).apply(v);
        }
        if (reloading > 0) {
            if (!semiAuto) {
                this.bullet.get().withStack(nbt.getItemStack("found"), AMTBullet.BulletState.BULLET_UNUSED);
                this.loadBullet.apply(v);
            }
        } else if (handRender) {
            ItemStack b = ammoHandler.getNextAmmo(stack, nbt, false);
            this.bullet.get().withStack(b, AMTBullet.BulletState.BULLET_UNUSED);
            this.casing.get().withStack(b, AMTBullet.BulletState.CASING);
        }
        if (gui) {
            IIAnimationUtils.setModelVisibility(this.casing.get(), false);
        }
        if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            this.offhandVisibility.apply(0.0f);
        }
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }

    @Override
    public void compileModels(OBJModel model, IIModelHeader header) {
        this.handmadeRemapper = new MTLTextureRemapper(model, (ResourceLocation)ResLoc.of(this.directoryRes, "rifle_handmade").withExtension(".mtl"));
        this.model = AMTModelCacheBuilder.startItemModel().withModel(model).withModels(this.listUpgradeModels()).withHeader(header).withHeader(IIAnimationLoader.loadHeader(new ResourceLocation("immersiveintelligence", "models/item/weapons/rifle/rifle_upgrades.obj.amt"))).withModelProvider((stack, combinedHeader) -> new AMT[]{new AMTBullet("bullet", (IIModelHeader)combinedHeader, AmmoRegistry.INSTANCE.getModel(IIContent.itemAmmoMachinegun)).withState(AMTBullet.BulletState.BULLET_UNUSED).withProperties(0xCFCFCF, AmmoRegistry.EnumCoreTypes.PIERCING, -1), new AMTBullet("casing_fired", (IIModelHeader)combinedHeader, AmmoRegistry.INSTANCE.getModel(IIContent.itemAmmoMachinegun)).withState(AMTBullet.BulletState.CASING), new AMTParticle("muzzle_flash", (IIModelHeader)combinedHeader).setParticle(new ParticleGunfire(null, Vec3d.field_186680_a, new Vec3d(1.0, 0.0, 0.0), 16.0f)), new AMTHand("hand", (IIModelHeader)combinedHeader, EnumHand.OFF_HAND), new AMTHand("hand_right", (IIModelHeader)combinedHeader, EnumHand.MAIN_HAND)}).withTextureProvider((res, stack) -> {
            String skin = IIContent.itemRifle.getSkinnableCurrentSkin((ItemStack)stack);
            if (IISkinHandler.isValidSkin(skin)) {
                this.skinRemapper = new MTLTextureRemapper(model, (ResourceLocation)ResLoc.of(IIReference.RES_TEXTURES_SKIN, skin, "/rifle").withExtension(".mtl"));
                return ClientUtils.getSprite((ResourceLocation)this.skinRemapper.apply((ResourceLocation)res));
            }
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"handmade")) {
                return ClientUtils.getSprite((ResourceLocation)this.handmadeRemapper.apply((ResourceLocation)res));
            }
            return ClientUtils.getSprite((ResourceLocation)res);
        }).build();
        this.bullet = new AMTCrossVariantReference("bullet", this.model);
        this.casing = new AMTCrossVariantReference("casing_fired", this.model);
        this.loadUpgrades(model, ResLoc.of(this.animationRes, "upgrades/"));
        this.loadBullet = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load_bullet"));
        this.loadMag = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load_magazine"));
        this.unloadMag = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "unload_magazine"));
        this.fireBoltAction = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "fire_bolt_action"));
        this.fireSemiAutomatic = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "fire_semiauto"));
        this.handAngle = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "hand"));
        this.handVisibility = IIAnimationCachedMap.create(this.model, new ResourceLocation("immersiveintelligence", "gun_hand_visibility"));
        this.offhandVisibility = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "offhand"));
    }

    @Override
    public void registerSprites(TextureMap map) {
        super.registerSprites(map);
        ApiUtils.getRegisterSprite((TextureMap)map, (ResourceLocation)new ResourceLocation("immersiveintelligence", "items/weapons/rifle_handmade"));
        IISkinHandler.registerSprites(map, IIContent.itemRifle.getSkinnableName());
    }

    @Override
    protected void nullifyModels() {
        IIAnimationUtils.disposeOf(this.model);
    }

    @Override
    public boolean doHandRender(ItemStack stack, EnumHand hand, ItemStack otherHand, float swingProgress, float partialTicks) {
        this.swingProgress = swingProgress;
        return hand == EnumHand.OFF_HAND && otherHand.func_77973_b() instanceof ItemIIGunBase;
    }

    @Override
    public boolean renderCrosshair(ItemStack stack, EnumHand hand) {
        if (((ItemIIRifle)this.item).hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.SCOPE)) {
            return false;
        }
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming") > (double)((ItemIIRifle)this.item).getAimingTime(stack, EasyNBT.wrapNBT(stack)) * 0.85;
    }
}

