/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.item;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleGunfire;
import pl.pabilo8.immersiveintelligence.client.render.item.ISpecificHandRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTBullet;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTCrossVariantReference;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTHand;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCacheBuilder;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTParticle;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCachedMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIUpgradableItemRendererAMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.MTLTextureRemapper;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIGunBase;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIISubmachinegun;
import pl.pabilo8.immersiveintelligence.common.item.weapons.ItemIIWeaponUpgrade;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.IISkinHandler;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.IIItemEnum;

public class SubmachinegunRenderer
extends IIUpgradableItemRendererAMT<ItemIISubmachinegun>
implements ISpecificHandRenderer {
    IIAnimationCachedMap fire;
    IIAnimationCachedMap load;
    IIAnimationCachedMap unload;
    IIAnimationCachedMap handAngle;
    IIAnimationCachedMap offHandAngle;
    IIAnimationCachedMap foldingStock;
    IIAnimationCachedMap loadBottom;
    IIAnimationCachedMap loadBottomDrum;
    IIAnimationCachedMap unloadBottom;
    IIAnimationCachedMap unloadBottomDrum;
    private MTLTextureRemapper skinRemapper;
    private AMTCrossVariantReference<AMT> hand;
    private AMTCrossVariantReference<AMT> offHand;
    private AMTCrossVariantReference<AMTParticle> muzzleFlash;
    private AMTCrossVariantReference<AMTBullet> casingFired;

    public SubmachinegunRenderer() {
        super(IIContent.itemSubmachinegun, ResLoc.of(RES_MODEL_WEAPON, "submachinegun"));
    }

    @Override
    protected ImmersiveModelRegistry.ItemModelReplacement setTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ model) {
        Matrix4 tpp = new Matrix4().scale(0.425, 0.425, 0.425).rotate(Math.toRadians(-20.5), 0.0, 1.0, 0.0).translate(0.625, -1.125, (double)0.65f);
        Matrix4 tppOffhand = new Matrix4().scale(0.385, 0.385, 0.385).rotate(Math.toRadians(75.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(20.5), 0.0, 0.0, 1.0).rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).translate(-0.5, -0.25, 0.125);
        Matrix4 fpp = new Matrix4().scale(0.75, 0.75, 0.75).translate(0.75, -1.0, 0.0).rotate(Math.toRadians(7.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(5.0), 1.0, 0.0, 0.0).translate(-0.125, 0.0, 0.125);
        Matrix4 fppOffhand = new Matrix4().scale(0.55, 0.55, 0.55).translate(0.75, -1.0, 0.0).rotate(Math.toRadians(82.5), 0.0, 1.0, 0.0).rotate(Math.toRadians(2.5), 1.0, 0.0, 0.0).translate(0.0, 0.0, -0.5);
        return model.setTransformations(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(0.325, 0.325, 0.325).translate(0.5, -0.75, 0.5)).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, tpp).setTransformations(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, tppOffhand).setTransformations(ItemCameraTransforms.TransformType.FIXED, new Matrix4().rotate(Math.toRadians(-3.5), 1.0, 0.0, 0.0).rotate(Math.toRadians(-75.0), 0.0, 1.0, 0.0).translate(0.125, -0.25, -0.125).scale(0.425, 0.425, 0.425)).setTransformations(ItemCameraTransforms.TransformType.GUI, new Matrix4().translate(0.0, -0.25, 0.0).scale(0.5, 0.5, 0.5).rotate(Math.toRadians(35.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(135.0), 0.0, 1.0, 0.0).translate(0.0, 0.0, 0.325)).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, fpp).setTransformations(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, fppOffhand);
    }

    @Override
    public void registerSprites(TextureMap map) {
        super.registerSprites(map);
        IISkinHandler.registerSprites(map, IIContent.itemSubmachinegun.getSkinnableName());
    }

    @Override
    public void draw(ItemStack stack, ItemCameraTransforms.TransformType transform, BufferBuilder buf, Tessellator tes, float partialTicks) {
        EasyNBT nbt = EasyNBT.wrapNBT(stack);
        this.model.getVariant(nbt.getString("contributorSkin"), stack);
        this.model.forEach(AMT::defaultize);
        this.showUpgrades(stack, nbt);
        ItemStack magazine = nbt.getItemStack("magazine");
        int firing = nbt.getInt("fireDelay");
        int firingDelay = ((ItemIISubmachinegun)this.item).getFireDelay(stack, nbt);
        int reloading = nbt.getInt("reloading");
        this.fire.apply(1.0f - Math.max(0.0f, (float)firing - partialTicks) / (float)firingDelay);
        boolean handRender = this.is1stPerson(transform);
        IIAnimationUtils.setModelVisibility(this.hand.get(), handRender);
        IIAnimationUtils.setModelVisibility(this.offHand.get(), handRender);
        if (handRender) {
            EasyNBT upgradeNBT;
            int aiming = nbt.getInt("aiming");
            float preciseAim = IIAnimationUtils.getAnimationProgress(aiming, ((ItemIISubmachinegun)this.item).getAimingTime(stack, upgradeNBT = EasyNBT.wrapNBT(((ItemIISubmachinegun)this.item).getUpgrades(stack))), true, !Minecraft.func_71410_x().field_71439_g.func_70093_af(), 1.0f, 3.0f, partialTicks);
            if (preciseAim > 0.0f) {
                float recoil = Math.min((nbt.getFloat("recoilV") + nbt.getFloat("recoilH")) / (IIConfigHandler.IIConfig.Weapons.AssaultRifle.maxRecoilHorizontal + IIConfigHandler.IIConfig.Weapons.AssaultRifle.maxRecoilVertical), 1.0f);
                GlStateManager.func_179137_b((double)((double)(-preciseAim) * 0.8541666666666666), (double)(0.15 * (double)preciseAim), (double)0.0);
                GlStateManager.func_179114_b((float)(preciseAim * -7.75f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(preciseAim * -5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)preciseAim * 0.25));
                if (recoil > 0.0f) {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)(-recoil) * (0.155 - 0.1 * (double)preciseAim)), (double)((double)recoil * 0.25));
                }
                if (((ItemIISubmachinegun)this.item).hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.FOLDING_STOCK)) {
                    this.foldingStock.apply(preciseAim);
                }
            }
            (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND ? this.handAngle : this.offHandAngle).apply(preciseAim);
        }
        if (transform == ItemCameraTransforms.TransformType.GUI) {
            IIAnimationUtils.setModelVisibility(this.muzzleFlash.get(), false);
            IIAnimationUtils.setModelVisibility(this.casingFired.get(), false);
        }
        float v = IIAnimationUtils.getAnimationProgress(reloading, ((ItemIISubmachinegun)this.item).getReloadTime(stack, ItemStack.field_190927_a, EasyNBT.wrapNBT(((ItemIISubmachinegun)this.item).getUpgrades(stack))), false, reloading > 0 ? partialTicks : 0.0f);
        if (((ItemIISubmachinegun)this.item).hasIIUpgrade(stack, (IIItemEnum)ItemIIWeaponUpgrade.WeaponUpgrades.BOTTOM_LOADING)) {
            if (nbt.hasKey("isDrum")) {
                (magazine.func_190926_b() ? this.loadBottomDrum : this.unloadBottomDrum).apply(v);
            } else {
                (magazine.func_190926_b() ? this.loadBottom : this.unloadBottom).apply(v);
            }
        } else {
            (magazine.func_190926_b() ? this.load : this.unload).apply(v);
        }
        if (reloading > 0) {
            float rpart;
            float f = (double)v <= 0.33 ? v / 0.33f : (rpart = (double)v <= 0.66 ? 1.0f : 1.0f - (v - 0.66f) / 0.33f);
            if (handRender) {
                GlStateManager.func_179114_b((float)(rpart * 80.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(rpart * 40.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)rpart, (double)((double)(-rpart) * 0.75), (double)((double)(-rpart) * 0.25));
            }
        }
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }

    @Override
    public void compileModels(OBJModel model, IIModelHeader header) {
        this.model = AMTModelCacheBuilder.startItemModel().withModel(model).withModels(this.listUpgradeModels()).withHeader(header).withHeader(ResLoc.of(this.directoryRes, "submachinegun_upgrades.obj.amt")).withModelProvider((stack, combinedHeader) -> new AMT[]{new AMTParticle("muzzle_flash", (IIModelHeader)combinedHeader).setParticle(new ParticleGunfire(null, Vec3d.field_186680_a, new Vec3d(1.0, 0.0, 0.0), 16.0f)), new AMTHand("hand_main", (IIModelHeader)combinedHeader, EnumHand.OFF_HAND), new AMTHand("hand_off", (IIModelHeader)combinedHeader, EnumHand.OFF_HAND), new AMTBullet("casing_fired", (IIModelHeader)combinedHeader, AmmoRegistry.INSTANCE.getModel(IIContent.itemAmmoSubmachinegun)).withState(AMTBullet.BulletState.CASING)}).withTextureProvider((res, stack) -> {
            String skin = IIContent.itemAssaultRifle.getSkinnableCurrentSkin((ItemStack)stack);
            if (IISkinHandler.isValidSkin(skin)) {
                this.skinRemapper = new MTLTextureRemapper(model, (ResourceLocation)ResLoc.of(IIReference.RES_TEXTURES_SKIN, skin, "/assault_rifle").withExtension(".mtl"));
                return ClientUtils.getSprite((ResourceLocation)this.skinRemapper.apply((ResourceLocation)res));
            }
            return ClientUtils.getSprite((ResourceLocation)res);
        }).build();
        this.muzzleFlash = new AMTCrossVariantReference("muzzle_flash", this.model);
        this.hand = new AMTCrossVariantReference("hand_main", this.model);
        this.offHand = new AMTCrossVariantReference("hand_off", this.model);
        this.casingFired = new AMTCrossVariantReference("casing_fired", this.model);
        this.loadUpgrades(model, ResLoc.of(this.animationRes, "upgrades/"));
        this.load = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load"));
        this.unload = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "unload"));
        this.fire = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "fire"));
        this.loadBottom = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load_bottom"));
        this.unloadBottom = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "unload_bottom"));
        this.loadBottomDrum = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "load_bottom_drum"));
        this.unloadBottomDrum = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "unload_bottom_drum"));
        this.handAngle = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "hand"));
        this.offHandAngle = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "offhand"));
        this.foldingStock = IIAnimationCachedMap.create(this.model, ResLoc.of(this.animationRes, "folding_stock"));
    }

    @Override
    protected void nullifyModels() {
        IIAnimationUtils.disposeOf(this.model);
    }

    @Override
    public boolean doHandRender(ItemStack stack, EnumHand hand, ItemStack otherHand, float swingProgress, float partialTicks) {
        return hand == EnumHand.OFF_HAND && otherHand.func_77973_b() instanceof ItemIIGunBase;
    }

    @Override
    public boolean renderCrosshair(ItemStack stack, EnumHand hand) {
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming") > (double)IIConfigHandler.IIConfig.Weapons.Submachinegun.aimTime * 0.85;
    }
}

