/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.mechanical_device;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.block.rotary_device.tileentity.TileEntityMechanicalPump;

@SideOnly(value=Side.CLIENT)
@IITileRenderer.RegisteredTileRenderer(name="mechanical_pump", clazz=TileEntityMechanicalPump.class)
public class MechanicalPumpRenderer
extends IITileRenderer<TileEntityMechanicalPump> {
    private static IIAnimation rotation;
    private static IIAnimation pumping;
    private static IIAnimationCompiledMap rotationMap;
    private static IIAnimationCompiledMap pumpingMap;
    private static AMT[] models;

    @Override
    public void draw(TileEntityMechanicalPump te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        if (te.dummy) {
            return;
        }
        double world_rpm = RotaryUtils.getWorldRPM(te.func_145831_w(), partialTicks);
        float rotation_progress = (float)(world_rpm * (double)te.rotation.getRotationSpeed());
        boolean b = te.func_145831_w().func_175687_A(te.func_174877_v()) > 0;
        int a = (int)(30.0f - 25.0f * (te.rotation.getRotationSpeed() / (float)IIConfigHandler.IIConfig.Machines.MechanicalPump.rpmBreakingMax));
        float pumping_progress = 0.0f;
        if (te.rotation.getRotationSpeed() > 0.0f) {
            pumping_progress = ((float)(te.func_145831_w().func_82737_E() % (long)a) + partialTicks) / (float)a * (b ? 1.0f : 0.0f);
        }
        rotationMap.apply(rotation_progress % 1.0f);
        pumpingMap.apply(pumping_progress);
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.applyStandardRotation(te.getFacing());
        for (AMT mod : models) {
            mod.render(tes, buf);
        }
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        rotation = IIAnimationLoader.loadAnimation(new ResourceLocation("immersiveintelligence", "mechanical_pump/rotation"));
        pumping = IIAnimationLoader.loadAnimation(new ResourceLocation("immersiveintelligence", "mechanical_pump/pumping"));
        models = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()));
        rotationMap = IIAnimationCompiledMap.create(models, rotation);
        pumpingMap = IIAnimationCompiledMap.create(models, pumping);
    }

    @Override
    protected void nullifyModels() {
        pumpingMap = null;
        rotationMap = null;
        pumping = null;
        rotation = null;
        models = IIAnimationUtils.disposeOf(models);
    }

    static {
        models = null;
    }
}

