/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.multiblock.metal;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleGunfire;
import pl.pabilo8.immersiveintelligence.client.render.IIMultiblockRenderer;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTBullet;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTParticle;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityArtilleryHowitzer;

@IITileRenderer.RegisteredTileRenderer(name="artillery_howitzer", clazz=TileEntityArtilleryHowitzer.class)
public class ArtilleryHowitzerRenderer
extends IIMultiblockRenderer<TileEntityArtilleryHowitzer> {
    private AMT[] model = null;
    private AMT[] allParts = null;
    private IIAnimationCompiledMap animationDefault;
    private IIAnimationCompiledMap animationOpen;
    private IIAnimationCompiledMap animationPlatform;
    private IIAnimationCompiledMap[] animationFire;
    private IIAnimationCompiledMap[] animationLoading;
    private IIAnimationCompiledMap[] animationUnloading;
    private IIAnimation.IIAnimationGroup animationQueueIn;
    private IIAnimation.IIAnimationGroup animationQueueOut;
    private AMTBullet[] shells;
    private AMTBullet[] shellsStorage;
    private AMTBullet shellHeld;
    private AMTBullet shellEjected;
    private AMTBullet shellLoaded;
    private AMT gunYaw;
    private AMT gunPitch;

    @Override
    public void drawAnimated(TileEntityArtilleryHowitzer te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        int i;
        this.applyStandardRotation(te.facing);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.5);
        for (AMT mod : this.allParts) {
            mod.defaultize();
        }
        this.animationDefault.apply(0.0f);
        boolean canOperatePassive = te.energyStorage.getEnergyStored() >= IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive;
        boolean canOperateActive = canOperatePassive && te.energyStorage.getEnergyStored() >= IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive + IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsageActive;
        float doorAnim = IIAnimationUtils.getAnimationProgress(te.doorTime, IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.doorTime, canOperatePassive, !te.isDoorOpened, 1.0f, 2.0f, partialTicks);
        float platformAnim = IIAnimationUtils.getAnimationProgress(te.platformTime, IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.platformTime, canOperatePassive, !te.platformPosition, 1.0f, 1.0f, partialTicks);
        this.animationOpen.apply(doorAnim);
        this.animationPlatform.apply(platformAnim);
        float pDiff = te.plannedPitch - te.turretPitch;
        float yDiff = MathHelper.func_76142_g((float)(360.0f + te.plannedYaw - te.turretYaw));
        float turretYaw = te.turretYaw + Math.signum(yDiff) * MathHelper.func_76131_a((float)(Math.abs(yDiff) * partialTicks), (float)0.0f, (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed);
        float turretPitch = te.turretPitch + Math.signum(pDiff) * MathHelper.func_76131_a((float)(Math.abs(yDiff) * partialTicks), (float)0.0f, (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed);
        float conveyorAnim = IIAnimationUtils.getAnimationProgress(te.shellConveyorTime, IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.conveyorTime, canOperatePassive, false, 1.0f, 0.0f, partialTicks);
        boolean next = false;
        for (i = 5; i >= 0; --i) {
            next = this.animateShellConveyor(te, 0, i, conveyorAnim, AMTBullet.BulletState.BULLET_UNUSED, this.animationQueueIn, next);
        }
        next = false;
        for (i = 11; i >= 6; --i) {
            next = this.animateShellConveyor(te, 6, i, conveyorAnim, AMTBullet.BulletState.CASING, this.animationQueueOut, next);
        }
        this.shellEjected.withStack(ItemStack.field_190927_a, AMTBullet.BulletState.CASING);
        for (i = 0; i < 4; ++i) {
            IIAnimationUtils.setModelVisibility(this.shellsStorage[i], true);
            this.shellsStorage[i].withStack((ItemStack)te.loadedShells.get(i), ((ItemStack)te.loadedShells.get(i)).func_77973_b() == IIContent.itemAmmoArtillery ? AMTBullet.BulletState.BULLET_UNUSED : AMTBullet.BulletState.CASING);
        }
        IIAnimationUtils.setModelVisibility(this.shellHeld, false);
        IIAnimationUtils.setModelVisibility(this.shellEjected, false);
        IIAnimationUtils.setModelVisibility(this.shellLoaded, false);
        float animationProgress = IIAnimationUtils.getAnimationProgress(te.animationTime, te.animationTimeMax, canOperateActive && te.animation != TileEntityArtilleryHowitzer.ArtilleryHowitzerAnimation.STOP, false, 1.0f, 0.0f, partialTicks);
        switch (te.animation) {
            case LOAD1: 
            case LOAD2: 
            case LOAD3: 
            case LOAD4: {
                int slot = te.animation.ordinal() - TileEntityArtilleryHowitzer.ArtilleryHowitzerAnimation.LOAD1.ordinal();
                this.setupShellDisplay(te, AMTBullet.BulletState.BULLET_UNUSED, slot);
                this.animationLoading[slot].apply(animationProgress);
                break;
            }
            case UNLOAD1: 
            case UNLOAD2: 
            case UNLOAD3: 
            case UNLOAD4: {
                int slot = te.animation.ordinal() - TileEntityArtilleryHowitzer.ArtilleryHowitzerAnimation.UNLOAD1.ordinal();
                this.setupShellDisplay(te, this.shellsStorage[slot].getState(), slot);
                this.animationUnloading[slot].apply(animationProgress);
                break;
            }
            case FIRE1: 
            case FIRE2: 
            case FIRE3: 
            case FIRE4: {
                int slot = te.animation.ordinal() - TileEntityArtilleryHowitzer.ArtilleryHowitzerAnimation.FIRE1.ordinal();
                AMTBullet.BulletState firingState = (double)animationProgress > IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment ? AMTBullet.BulletState.CASING : AMTBullet.BulletState.BULLET_UNUSED;
                this.setupShellDisplay(te, firingState, slot);
                this.animationFire[slot].apply(animationProgress);
                double firstMarker = IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment - (double)0.03f;
                double secondMarker = IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment - (double)0.07f;
                double dist = Math.abs(firstMarker - secondMarker);
                double firstMarker2 = IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment + (double)0.01f;
                double secondMarker2 = IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment + (double)0.04f;
                double dist2 = Math.abs(firstMarker2 - secondMarker2);
                if (animationProgress < 0.1f) {
                    turretPitch = this.lerp(turretPitch, 90.0f, Math.min(animationProgress / 0.1f, 1.0f));
                    break;
                }
                if (animationProgress > 0.9f) {
                    turretPitch = this.lerp(90.0f, turretPitch, (animationProgress - 0.9f) / 0.1f);
                    break;
                }
                if ((double)animationProgress > secondMarker && (double)animationProgress < firstMarker) {
                    turretPitch = this.lerp(90.0f, turretPitch, (float)(((double)animationProgress - secondMarker) / dist));
                    break;
                }
                if ((double)animationProgress > firstMarker2 && (double)animationProgress < secondMarker2) {
                    turretPitch = this.lerp(turretPitch, 90.0f, (float)(((double)animationProgress - firstMarker2) / dist2));
                    break;
                }
                if (!((double)animationProgress < secondMarker) && !((double)animationProgress > secondMarker2)) break;
                turretPitch = 90.0f;
                break;
            }
        }
        IIAnimationUtils.setModelRotation(this.gunYaw, 0.0, (float)(te.mirrored ? -1 : 1) * (te.facing.func_185119_l() - turretYaw), 0.0);
        IIAnimationUtils.setModelRotation(this.gunPitch, -turretPitch, 0.0, 0.0);
        if (te.mirrored) {
            this.mirrorRender();
        }
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        if (te.mirrored) {
            this.unMirrorRender();
        }
    }

    @Override
    public void drawSimple(BufferBuilder buf, float partialTicks, Tessellator tes) {
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.5);
        for (AMT mod : this.allParts) {
            mod.defaultize();
        }
        this.animationDefault.apply(0.0f);
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
    }

    private void setupShellDisplay(TileEntityArtilleryHowitzer te, AMTBullet.BulletState state, int slot) {
        this.shellLoaded.withStack((ItemStack)te.inventory.get(5), state);
        this.shellHeld.withStack((ItemStack)te.inventory.get(5), state);
        this.shellEjected.withStack((ItemStack)te.inventory.get(5), state);
        this.shellsStorage[slot].withStack((ItemStack)te.inventory.get(5), state);
    }

    private boolean animateShellConveyor(TileEntityArtilleryHowitzer te, int startFrom, int i, float conveyorAnim, AMTBullet.BulletState bulletUnused, IIAnimation.IIAnimationGroup animationQueueIn, boolean next) {
        boolean here = !((ItemStack)te.inventory.get(i)).func_190926_b();
        float shellTime = 0.16666667f * ((float)(i - startFrom) + (next ? conveyorAnim : 0.0f));
        IIAnimationUtils.setModelVisibility(this.shells[i], here);
        if (here) {
            this.shells[i].withStack((ItemStack)te.inventory.get(i), bulletUnused);
            IIAnimationUtils.setModelAnimations(this.shells[i], animationQueueIn, shellTime);
        } else {
            next = true;
        }
        return next;
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.shells = new AMTBullet[12];
        this.shellsStorage = new AMTBullet[4];
        this.model = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()), header -> {
            AMT[] aMTArray = new AMT[20];
            aMTArray[0] = this.createShellQueueAMT(true, 0, (IIModelHeader)header);
            aMTArray[1] = this.createShellQueueAMT(true, 1, (IIModelHeader)header);
            aMTArray[2] = this.createShellQueueAMT(true, 2, (IIModelHeader)header);
            aMTArray[3] = this.createShellQueueAMT(true, 3, (IIModelHeader)header);
            aMTArray[4] = this.createShellQueueAMT(true, 4, (IIModelHeader)header);
            aMTArray[5] = this.createShellQueueAMT(true, 5, (IIModelHeader)header);
            aMTArray[6] = this.createShellQueueAMT(false, 0, (IIModelHeader)header);
            aMTArray[7] = this.createShellQueueAMT(false, 1, (IIModelHeader)header);
            aMTArray[8] = this.createShellQueueAMT(false, 2, (IIModelHeader)header);
            aMTArray[9] = this.createShellQueueAMT(false, 3, (IIModelHeader)header);
            aMTArray[10] = this.createShellQueueAMT(false, 4, (IIModelHeader)header);
            aMTArray[11] = this.createShellQueueAMT(false, 5, (IIModelHeader)header);
            this.shellsStorage[0] = this.createDefaultShellAMT((IIModelHeader)header, "shell_storage1");
            aMTArray[12] = this.shellsStorage[0];
            this.shellsStorage[1] = this.createDefaultShellAMT((IIModelHeader)header, "shell_storage2");
            aMTArray[13] = this.shellsStorage[1];
            this.shellsStorage[2] = this.createDefaultShellAMT((IIModelHeader)header, "shell_storage3");
            aMTArray[14] = this.shellsStorage[2];
            this.shellsStorage[3] = this.createDefaultShellAMT((IIModelHeader)header, "shell_storage4");
            aMTArray[15] = this.shellsStorage[3];
            this.shellLoaded = this.createDefaultShellAMT((IIModelHeader)header, "shell_loaded");
            aMTArray[16] = this.shellLoaded;
            this.shellEjected = this.createDefaultShellAMT((IIModelHeader)header, "shell_hatch");
            aMTArray[17] = this.shellEjected;
            this.shellHeld = this.createDefaultShellAMT((IIModelHeader)header, "shell_held");
            aMTArray[18] = this.shellHeld;
            aMTArray[19] = new AMTParticle("muzzle_flash", (IIModelHeader)header).setParticle(new ParticleGunfire(null, Vec3d.field_186680_a, new Vec3d(0.0, 1.0, 0.0), 48.0f));
            return aMTArray;
        });
        this.allParts = IIAnimationUtils.getChildrenRecursive(this.model);
        this.animationDefault = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_default"));
        this.animationOpen = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_door"));
        this.animationPlatform = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_platform"));
        this.animationLoading = new IIAnimationCompiledMap[4];
        this.animationUnloading = new IIAnimationCompiledMap[4];
        this.animationFire = new IIAnimationCompiledMap[4];
        for (int i = 0; i < 4; ++i) {
            this.animationLoading[i] = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_loading" + (i + 1)));
            this.animationUnloading[i] = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_unloading" + (i + 1)));
            this.animationFire[i] = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_fire" + (i + 1)));
        }
        this.animationQueueIn = IIAnimationLoader.loadAnimation(new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_queue_in")).getLeadingGroup();
        this.animationQueueOut = IIAnimationLoader.loadAnimation(new ResourceLocation("immersiveintelligence", "artillery_howitzer/artillery_howitzer_queue_out")).getLeadingGroup();
        this.gunYaw = IIAnimationUtils.getPart(this.model, "turret");
        this.gunPitch = IIAnimationUtils.getPart(this.model, "gun");
    }

    @Override
    protected void nullifyModels() {
        super.nullifyModels();
        this.model = IIAnimationUtils.disposeOf(this.model);
        this.animationPlatform = null;
        this.animationOpen = null;
        this.animationLoading = null;
        this.animationFire = null;
        this.gunPitch = null;
        this.gunYaw = null;
    }

    private AMTBullet createDefaultShellAMT(IIModelHeader header, String name) {
        return this.createDefaultShellAMT(header, name, name);
    }

    private AMTBullet createDefaultShellAMT(IIModelHeader header, String name, String originName) {
        return new AMTBullet(name, header.getOffset(originName), AmmoRegistry.INSTANCE.getModel(IIContent.itemAmmoArtillery));
    }

    private AMTBullet createShellQueueAMT(boolean in, int id, IIModelHeader header) {
        String name = in ? "shell_in" : "shell_out";
        AMTBullet mod = this.createDefaultShellAMT(header, name + id, name).withState(AMTBullet.BulletState.BULLET_UNUSED);
        this.shells[(in ? 0 : 6) + id] = mod;
        return mod;
    }

    float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }
}

