/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.multiblock.metal;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.crafting.ElectrolyzerRecipe;
import pl.pabilo8.immersiveintelligence.client.render.IIMultiblockRenderer;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTFluid;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityElectrolyzer;

@IITileRenderer.RegisteredTileRenderer(name="electrolyzer", clazz=TileEntityElectrolyzer.class)
public class ElectrolyzerRenderer
extends IIMultiblockRenderer<TileEntityElectrolyzer> {
    AMTFluid fluid;

    @Override
    public void drawAnimated(TileEntityElectrolyzer te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        this.applyStandardRotation(te.facing);
        if (te.mirrored) {
            this.mirrorRender();
        }
        this.fluid.setFluid(te.tanks[0].getFluid());
        float tankAmount = te.tanks[0].getFluidAmount();
        if (te.currentProcess != null) {
            tankAmount -= te.getProductionProgress(te.currentProcess, partialTicks) * (float)((ElectrolyzerRecipe)te.currentProcess.recipe).fluidInput.amount;
        }
        this.fluid.setLevel(tankAmount / (float)te.tanks[0].getCapacity());
        this.fluid.setFlowing(false);
        this.fluid.render(tes, buf);
        if (te.mirrored) {
            this.unMirrorRender();
        }
    }

    @Override
    public void drawSimple(BufferBuilder buf, float partialTicks, Tessellator tes) {
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.fluid = new AMTFluid("fluid", new Vec3d(-3.0, -6.0, 19.9), new Vec3d(0.625, 0.875, 1.5625));
    }

    @Override
    protected void nullifyModels() {
        super.nullifyModels();
        if (this.fluid != null) {
            this.fluid.disposeOf();
        }
    }
}

