/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.multiblock.metal;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.client.render.IIMultiblockRenderer;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTItem;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTLocator;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIBooleanAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIMachineUpgradeModel;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityPacker;

@IITileRenderer.RegisteredTileRenderer(name="packer", clazz=TileEntityPacker.class)
public class PackerRenderer
extends IIMultiblockRenderer<TileEntityPacker> {
    AMT[] model;
    AMT[] upgradeParts;
    IIBooleanAnimation conveyor;
    IIMachineUpgradeModel fluidUpgrade;
    IIMachineUpgradeModel energyUpgrade;
    IIMachineUpgradeModel railwayUpgrade;
    IIMachineUpgradeModel namingUpgrade;
    private IIAnimationCompiledMap animationWork;
    private IIAnimationCompiledMap animationDefault;
    private AMTItem itemModel;

    @Override
    public void drawSimple(BufferBuilder buf, float partialTicks, Tessellator tes) {
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        IIAnimationUtils.setModelVisibility(this.upgradeParts, false);
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        this.animationDefault.apply(0.0f);
        for (AMT mod : this.upgradeParts) {
            mod.render(tes, buf);
        }
    }

    @Override
    public void drawAnimated(TileEntityPacker te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        IIAnimationUtils.setModelVisibility(this.upgradeParts, false);
        boolean active = !te.getRedstoneAtPos(0);
        float animationProgress = IIAnimationUtils.getAnimationProgress(te.processTime, IIConfigHandler.IIConfig.Machines.Packer.actionTime, te.processTime > 0 && active, false, 1.0f, 0.0f, partialTicks);
        this.itemModel.setStack((ItemStack)te.inventory.get(0));
        this.animationWork.apply(animationProgress);
        this.applyStandardRotation(te.facing);
        if (te.mirrored) {
            this.mirrorRender();
        }
        this.conveyor.apply(active);
        IIMachineUpgradeModel.UpgradeStage railway = this.railwayUpgrade.renderConstruction(te, tes, buf, partialTicks);
        if (railway != IIMachineUpgradeModel.UpgradeStage.NOT_INSTALLED) {
            this.conveyor.applyVisibility(false);
        }
        if (railway == IIMachineUpgradeModel.UpgradeStage.INSTALLED) {
            this.railwayUpgrade.defaultize();
            this.railwayUpgrade.render(tes, buf);
        }
        this.namingUpgrade.renderConstruction(te, tes, buf, partialTicks);
        if (this.fluidUpgrade.renderConstruction(te, tes, buf, partialTicks) == IIMachineUpgradeModel.UpgradeStage.INSTALLED) {
            this.fluidUpgrade.defaultize();
            this.fluidUpgrade.render(tes, buf);
        } else if (this.energyUpgrade.renderConstruction(te, tes, buf, partialTicks) == IIMachineUpgradeModel.UpgradeStage.INSTALLED) {
            this.energyUpgrade.defaultize();
            this.energyUpgrade.render(tes, buf);
        } else if (te.getCurrentlyInstalled() != IIContent.UPGRADE_PACKER_FLUID && te.getCurrentlyInstalled() != IIContent.UPGRADE_PACKER_ENERGY) {
            this.animationDefault.apply(0.0f);
            for (AMT mod : this.upgradeParts) {
                mod.render(tes, buf);
            }
        }
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        if (te.mirrored) {
            this.unMirrorRender();
        }
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.model = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()), header -> {
            AMT[] aMTArray = new AMT[1];
            this.itemModel = new AMTItem("conveyor_item", (IIModelHeader)header);
            aMTArray[0] = this.itemModel;
            return aMTArray;
        });
        this.conveyor = new IIBooleanAnimation(IIAnimationUtils.getPart(this.model, "conveyor_active"), IIAnimationUtils.getPart(this.model, "conveyor"));
        this.animationWork = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "packer/work"));
        this.upgradeParts = new AMT[4];
        AMT[] modelUpgrades = IIAnimationUtils.getAMTFromRes(new ResourceLocation("immersiveintelligence", "models/block/multiblock/packer_construction.obj.ie"), new ResourceLocation("immersiveintelligence", "models/block/multiblock/packer_construction.obj.amt"), header -> {
            this.upgradeParts[0] = new AMTLocator("item", (IIModelHeader)header);
            this.upgradeParts[1] = new AMTLocator("fluid", (IIModelHeader)header);
            this.upgradeParts[2] = new AMTLocator("energy", (IIModelHeader)header);
            this.upgradeParts[3] = new AMTLocator("railway", (IIModelHeader)header);
            return new AMT[]{this.upgradeParts[0], this.upgradeParts[1], this.upgradeParts[2], this.upgradeParts[3]};
        });
        this.animationDefault = IIAnimationCompiledMap.create(modelUpgrades, new ResourceLocation("immersiveintelligence", "packer/default"));
        this.railwayUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_PACKER_RAILWAY, modelUpgrades, new ResourceLocation("immersiveintelligence", "packer/upgrade_railway"));
        this.namingUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_PACKER_NAMING, modelUpgrades, new ResourceLocation("immersiveintelligence", "packer/upgrade_naming"));
        this.fluidUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_PACKER_FLUID, modelUpgrades, new ResourceLocation("immersiveintelligence", "packer/upgrade_fluid"));
        this.energyUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_PACKER_ENERGY, modelUpgrades, new ResourceLocation("immersiveintelligence", "packer/upgrade_energy"));
    }

    @Override
    protected void nullifyModels() {
        super.nullifyModels();
        IIAnimationUtils.disposeOf(this.model);
        IIAnimationUtils.disposeOf(this.railwayUpgrade);
        IIAnimationUtils.disposeOf(this.namingUpgrade);
        IIAnimationUtils.disposeOf(this.fluidUpgrade);
        IIAnimationUtils.disposeOf(this.energyUpgrade);
    }
}

