/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.multiblock.metal;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.client.render.IIMultiblockRenderer;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIBooleanAnimation;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityScanningConveyor;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

@IITileRenderer.RegisteredTileRenderer(name="scanning_conveyor", clazz=TileEntityScanningConveyor.class)
public class ScanningConveyorRenderer
extends IIMultiblockRenderer<TileEntityScanningConveyor> {
    AMT[] model;
    private IIBooleanAnimation active;
    private IIAnimationCompiledMap photo;

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.model = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()));
        this.active = new IIBooleanAnimation(IIAnimationUtils.getPart(this.model, "conveyor_on"), IIAnimationUtils.getPart(this.model, "conveyor_off"));
        this.photo = IIAnimationCompiledMap.create(this.model, ResLoc.of(IIReference.RES_II, "scanning_conveyor/photo"));
    }

    @Override
    protected void nullifyModels() {
        super.nullifyModels();
        this.model = IIAnimationUtils.disposeOf(this.model);
    }

    @Override
    public void drawAnimated(TileEntityScanningConveyor te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        this.applyStandardRotation(te.facing);
        this.active.apply(!te.getRedstoneAtPos(te.getPOI(MultiblockPOI.REDSTONE_INPUT)[0]));
        if (te.lastScanned.isEmpty()) {
            this.photo.apply(0.0f);
        } else {
            for (Integer value : te.lastScanned.values()) {
                if (value <= 2) continue;
                this.photo.apply(Math.max((float)(value - 2) - partialTicks, 0.0f) / 3.0f);
                break;
            }
        }
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }

    @Override
    public void drawSimple(BufferBuilder buf, float partialTicks, Tessellator tes) {
        this.active.apply(false);
        this.photo.apply(0.0f);
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }
}

