/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.multiblock.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.client.render.IIMultiblockRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIMachineUpgradeModel;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.gate_multiblock.tileentity.TileEntityGateBase;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;

public class FenceGateRenderer<T extends TileEntityGateBase<T>>
extends IIMultiblockRenderer<T> {
    private AMT[] model;
    IIMachineUpgradeModel redstoneUpgrade;
    IIMachineUpgradeModel razorUpgrade;
    private IIAnimationCompiledMap open;
    private IIAnimationCompiledMap redstone;
    private IIAnimationCompiledMap razor;

    public FenceGateRenderer(String name) {
        this.subscribeToList(name);
    }

    @Override
    public void drawAnimated(T te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        this.applyStandardRotation(((TileEntityGateBase)te).facing);
        if (!((TileEntityGateBase)te).mirrored) {
            this.mirrorRender();
        }
        this.open.apply(((TileEntityGateBase)te).gate.getProgress(partialTicks));
        this.redstone.apply(this.redstoneUpgrade.renderConstruction((IUpgradableMachine)te, tes, buf, partialTicks) == IIMachineUpgradeModel.UpgradeStage.INSTALLED ? 1.0f : 0.0f);
        this.razor.apply(this.razorUpgrade.renderConstruction((IUpgradableMachine)te, tes, buf, partialTicks) == IIMachineUpgradeModel.UpgradeStage.INSTALLED ? 1.0f : 0.0f);
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
        this.drawConnectedFences(te, buf, tes);
        if (!((TileEntityGateBase)te).mirrored) {
            this.unMirrorRender();
        }
    }

    private void drawConnectedFences(T te, BufferBuilder buf, Tessellator tes) {
        int i;
        boolean[] connections = new boolean[8];
        BlockPos blockPos = te.func_174877_v();
        IBlockState state = this.func_178459_a().func_180495_p(blockPos);
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)this.func_178459_a(), blockPos);
        state = state.func_177226_a((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        EnumFacing fR = ((TileEntityGateBase)te).mirrored ? ((TileEntityGateBase)te).facing.func_176735_f() : ((TileEntityGateBase)te).facing.func_176746_e();
        EnumFacing fL = ((TileEntityGateBase)te).mirrored ? ((TileEntityGateBase)te).facing.func_176746_e() : ((TileEntityGateBase)te).facing.func_176735_f();
        IBlockState fenceState = ((TileEntityGateBase)te).getFenceState(null);
        IBlockState fenceStateR = ((TileEntityGateBase)te).getFenceState(EnumFacing.WEST);
        IBlockState fenceStateL = ((TileEntityGateBase)te).getFenceState(EnumFacing.EAST);
        IBakedModel modelFence = IIAnimationUtils.getBRD().func_175023_a().func_178125_b(fenceState);
        for (i = 0; i < 4; ++i) {
            connections[i] = Utils.canFenceConnectTo((IBlockAccess)te.func_145831_w(), (BlockPos)blockPos.func_177977_b().func_177981_b(i), (EnumFacing)fL, (Material)state.func_185904_a());
            connections[i + 4] = Utils.canFenceConnectTo((IBlockAccess)te.func_145831_w(), (BlockPos)blockPos.func_177977_b().func_177981_b(i).func_177967_a(fR, 7), (EnumFacing)fR, (Material)state.func_185904_a());
        }
        buf.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buf.func_178969_c(0.01, -1.01, 0.01);
        buf.func_181669_b(255, 255, 255, 255);
        for (i = 0; i < 4; ++i) {
            IIAnimationUtils.getBRD().func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), modelFence, connections[((TileEntityGateBase)te).facing.func_176740_k() == EnumFacing.Axis.X ? i + 4 : i] ? fenceStateR : fenceState, new BlockPos(0, i, 0), buf, true);
            IIAnimationUtils.getBRD().func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), modelFence, connections[((TileEntityGateBase)te).facing.func_176740_k() == EnumFacing.Axis.X ? i : i + 4] ? fenceStateL : fenceState, new BlockPos(7, i, 0), buf, true);
        }
        buf.func_178969_c(0.0, 0.0, 0.0);
        tes.func_78381_a();
    }

    @Override
    public void drawSimple(BufferBuilder buf, float partialTicks, Tessellator tes) {
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.model = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()));
        this.open = IIAnimationCompiledMap.create(this.model, ResLoc.of(IIReference.RES_II, "gate/open"));
        AMT[] modelUpgrades = IIAnimationUtils.getAMTFromRes(new ResourceLocation("immersiveintelligence", "models/block/multiblock/gate_construction.obj.ie"), new ResourceLocation("immersiveintelligence", "models/block/multiblock/gate_construction.obj.amt"));
        this.redstone = IIAnimationCompiledMap.create(this.model, ResLoc.of(IIReference.RES_II, "gate/redstone"));
        this.razor = IIAnimationCompiledMap.create(this.model, ResLoc.of(IIReference.RES_II, "gate/razor"));
        this.redstoneUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_REDSTONE_ACTIVATION, modelUpgrades, new ResourceLocation("immersiveintelligence", "gate/upgrade_redstone"));
        this.razorUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_RAZOR_WIRE, modelUpgrades, new ResourceLocation("immersiveintelligence", "gate/upgrade_razor"));
    }

    @Override
    protected void nullifyModels() {
        super.nullifyModels();
        this.model = IIAnimationUtils.disposeOf(this.model);
    }
}

