/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.multiblock.wooden;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.api.utils.tools.ISawblade;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTCrossVariantReference;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTItem;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTLocator;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCache;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCacheBuilder;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTQuads;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCachedMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.wooden_multiblock.tileentity.TileEntitySawmill;
import pl.pabilo8.immersiveintelligence.common.item.crafting.ItemIISawBlade;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;

@SideOnly(value=Side.CLIENT)
@IITileRenderer.RegisteredTileRenderer(name="sawmill", clazz=TileEntitySawmill.class)
public class SawmillRenderer
extends IITileRenderer<TileEntitySawmill> {
    private AMTModelCache<TileEntity> model;
    private IIAnimationCachedMap animationRotate;
    private IIAnimationCachedMap animationDustPile;
    private IIAnimationCachedMap animationInteract;
    private IIAnimationCachedMap animationProductionStart;
    private IIAnimationCachedMap animationProductionLoop;
    private IIAnimationCachedMap animationProductionReach;
    private AMTCrossVariantReference<AMTQuads> partSawblade;
    private AMTCrossVariantReference<AMTItem> partItemInput;
    private AMTCrossVariantReference<AMTItem> partItemOutput;
    private AMTCrossVariantReference<AMTItem> partItemInserter;

    @Override
    protected boolean shouldNotRender(TileEntitySawmill te) {
        return te == null || te.isDummy();
    }

    @Override
    public void draw(TileEntitySawmill te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        ItemStack sawBlade = (ItemStack)te.inventory.get(1);
        ItemStack sawDust = (ItemStack)te.getInventory().get(3);
        float progress = te.getProductionProgress(te.currentProcess, partialTicks);
        this.applyStandardRotation(te.facing);
        this.model.getVariant(sawBlade.func_190926_b() ? "" : ((ISawblade)sawBlade.func_77973_b()).getMaterialName(sawBlade), (TileEntity)te);
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        this.partItemInput.get().setStack((ItemStack)te.inventory.get(0));
        this.partItemOutput.get().setStack((ItemStack)te.inventory.get(2));
        this.partItemInserter.get().setStack(ItemStack.field_190927_a);
        this.animationDustPile.apply(sawDust.func_190926_b() ? 0.0f : (float)sawDust.func_190916_E() / (float)sawDust.func_77976_d());
        IIAnimationUtils.setModelVisibility(this.partSawblade.get(), !((ItemStack)te.getInventory().get(1)).func_190926_b());
        this.animationRotate.apply(IIAnimationUtils.getDebugProgress(this.func_178459_a(), 20.0f, partialTicks));
        if (progress > 0.0f) {
            assert (te.currentProcess != null);
            SawmillRecipe recipe = (SawmillRecipe)te.currentProcess.recipe;
            if (progress < 0.1f) {
                this.animationProductionStart.apply(progress / 0.1f);
            } else {
                double individual = (double)((progress -= 0.1f) * (float)recipe.itemOutput.func_190916_E()) % 0.9 / (double)0.9f;
                this.animationProductionLoop.apply((float)individual);
                this.animationProductionReach.apply(progress);
            }
            this.partItemInserter.get().setStack(recipe.itemInput.getExampleStack());
            this.partItemOutput.get().setStack(recipe.itemOutput);
        } else {
            this.animationProductionReach.apply(0.0f);
        }
        this.animationInteract.apply(te.vice.getProgress(partialTicks));
        if (!te.mirrored) {
            this.mirrorRender();
        }
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        if (!te.mirrored) {
            this.unMirrorRender();
        }
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.model = AMTModelCacheBuilder.startTileEntityModel().withModel(((IESmartObjModel)sModel.func_76340_b()).getModel()).withModel(ResLoc.of(IIReference.RES_BLOCK_MODEL, "multiblock/sawmill/sawblade.obj")).withModel(ResLoc.of(IIReference.RES_BLOCK_MODEL, "multiblock/sawmill/sawdust.obj")).withHeader(IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b())).withModelProvider((tile, header) -> new AMT[]{new AMTItem("item_input", (IIModelHeader)header), new AMTItem("item_output", (IIModelHeader)header), new AMTItem("item_inserter", (IIModelHeader)header), new AMTLocator("cardan1", (IIModelHeader)header), new AMTLocator("cardan3", (IIModelHeader)header)}).withTextureProvider((res, tile) -> {
            if (!(tile instanceof TileEntitySawmill) || !tile.func_145830_o()) {
                return ClientUtils.getSprite((ResourceLocation)res);
            }
            TileEntitySawmill sawmill = (TileEntitySawmill)tile;
            ItemStack sawblade = (ItemStack)sawmill.inventory.get(1);
            if (res.func_110623_a().endsWith("iron") && sawblade.func_77973_b() instanceof ISawblade) {
                return ClientUtils.getSprite((ResourceLocation)((ISawblade)sawblade.func_77973_b()).getSawbladeTexture(sawblade));
            }
            return ClientUtils.getSprite((ResourceLocation)res);
        }).build();
        this.partSawblade = new AMTCrossVariantReference("sawblade", this.model);
        this.partItemInput = new AMTCrossVariantReference("item_input", this.model);
        this.partItemOutput = new AMTCrossVariantReference("item_output", this.model);
        this.partItemInserter = new AMTCrossVariantReference("item_inserter", this.model);
        this.animationInteract = IIAnimationCachedMap.create(this.model, ResLoc.of(IIReference.RES_II, "sawmill/interact"));
        this.animationRotate = IIAnimationCachedMap.create(this.model, ResLoc.of(IIReference.RES_II, "sawmill/rotate"));
        this.animationDustPile = IIAnimationCachedMap.create(this.model, ResLoc.of(IIReference.RES_II, "sawmill/sawdust"));
        this.animationProductionStart = IIAnimationCachedMap.create(this.model, ResLoc.of(IIReference.RES_II, "sawmill/production_start"));
        this.animationProductionLoop = IIAnimationCachedMap.create(this.model, ResLoc.of(IIReference.RES_II, "sawmill/production_loop"));
        this.animationProductionReach = IIAnimationCachedMap.create(this.model, ResLoc.of(IIReference.RES_II, "sawmill/production_reach"));
    }

    @Override
    public void registerSprites(TextureMap map) {
        super.registerSprites(map);
        for (ItemIISawBlade.SawBlades value : ItemIISawBlade.SawBlades.values()) {
            map.func_174942_a(IIContent.itemSawblade.getSawbladeTexture(IIContent.itemSawblade.getStack(value)));
        }
    }

    @Override
    protected void nullifyModels() {
        IIAnimationUtils.disposeOf(this.model);
    }
}

