/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util;

import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.utils.camera.IEntityZoomProvider;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.client.ClientEventHandler;
import pl.pabilo8.immersiveintelligence.common.entity.EntityCamera;

@SideOnly(value=Side.CLIENT)
public class CameraHandler {
    private static EntityCamera camera;
    private static boolean enabled;
    public static float fovZoom;
    public static ZoomType type;
    public static IAdvancedZoomTool zoom;
    public static ItemStack stack;

    public static void setCameraPos(BlockPos pos) {
        CameraHandler.setCameraPos((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public static void setCameraPos(double x, double y, double z) {
        CameraHandler.ensureExists();
        CameraHandler.camera.field_70165_t = x;
        CameraHandler.camera.field_70163_u = y;
        CameraHandler.camera.field_70161_v = z;
    }

    public static void setCameraAngle(float yaw, float pitch, float roll) {
        CameraHandler.ensureExists();
        CameraHandler.camera.field_70126_B = CameraHandler.camera.field_70177_z;
        CameraHandler.camera.field_70177_z = yaw;
        CameraHandler.camera.field_70127_C = CameraHandler.camera.field_70125_A;
        CameraHandler.camera.field_70125_A = pitch;
        CameraHandler.camera.rotationRoll = roll;
    }

    public static void setEnabled(boolean enabled) {
        CameraHandler.enabled = enabled;
        CameraHandler.ensureExists();
        ClientUtils.mc().func_175607_a((Entity)(enabled ? camera : ClientUtils.mc().field_71439_g));
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static float getYaw() {
        return CameraHandler.camera.field_70177_z;
    }

    public static float getPitch() {
        return CameraHandler.camera.field_70125_A;
    }

    public static float getRoll() {
        return CameraHandler.camera.rotationRoll;
    }

    public static boolean handleZoom() {
        if (CameraHandler.handleZoomLogic()) {
            return true;
        }
        type = null;
        zoom = null;
        return false;
    }

    private static boolean handleZoomLogic() {
        EntityPlayerSP player = ClientUtils.mc().field_71439_g;
        stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof IAdvancedZoomTool) {
            type = ZoomType.ITEM_MAINHAND;
            zoom = (IAdvancedZoomTool)stack.func_77973_b();
        } else {
            Entity lowestRidden;
            stack = player.func_184586_b(EnumHand.OFF_HAND);
            if (stack.func_77973_b() instanceof IAdvancedZoomTool) {
                type = ZoomType.ITEM_OFFHAND;
                zoom = (IAdvancedZoomTool)stack.func_77973_b();
            } else if (ClientEventHandler.mgAiming && (lowestRidden = player.func_184208_bv()) instanceof IEntityZoomProvider) {
                type = ZoomType.RIDING;
                zoom = ((IEntityZoomProvider)lowestRidden).getZoom();
            } else {
                return false;
            }
        }
        if (zoom == null || !zoom.shouldZoom(stack, (EntityPlayer)player)) {
            return false;
        }
        float[] steps = zoom.getZoomSteps(stack, (EntityPlayer)player);
        if (steps != null && steps.length > 0) {
            int curStep = -1;
            float dist = 0.0f;
            for (int i = 0; i < steps.length; ++i) {
                if (curStep != -1 && !(Math.abs(steps[i] - fovZoom) < dist)) continue;
                curStep = i;
                dist = Math.abs(steps[i] - fovZoom);
            }
            fovZoom = steps[curStep];
        }
        return true;
    }

    private static void ensureExists() {
        if (camera == null || camera.func_130014_f_() != ClientUtils.mc().field_71441_e) {
            camera = new EntityCamera((World)ClientUtils.mc().field_71441_e);
            ClientUtils.mc().field_71441_e.func_72838_d((Entity)camera);
        }
    }

    public static RayTraceResult rayTrace(double blockReachDistance, float partialTicks) {
        return camera.func_174822_a(blockReachDistance, partialTicks);
    }

    static {
        enabled = false;
        fovZoom = 1.0f;
        type = null;
    }

    public static enum ZoomType {
        ITEM_MAINHAND,
        ITEM_OFFHAND,
        RIDING;

    }
}

