/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util;

import java.util.function.BiConsumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IIDrawUtils {
    public static final float[] NO_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final IIDrawUtils INSTANCE = new IIDrawUtils();
    private VertexFormat format;
    private BufferBuilder buf;
    private Tessellator tes;
    private float offX;
    private float offY;

    private static IIDrawUtils start(BufferBuilder buf, VertexFormat format) {
        IIDrawUtils.INSTANCE.format = format;
        IIDrawUtils.INSTANCE.offX = 0.0f;
        IIDrawUtils.INSTANCE.offY = 0.0f;
        IIDrawUtils.INSTANCE.buf = buf;
        IIDrawUtils.INSTANCE.tes = Tessellator.func_178181_a();
        IIDrawUtils.INSTANCE.buf.func_181668_a(7, format);
        return INSTANCE;
    }

    public static IIDrawUtils startTextured(BufferBuilder buf) {
        return IIDrawUtils.start(buf, DefaultVertexFormats.field_181707_g);
    }

    public static IIDrawUtils startTextured() {
        return IIDrawUtils.startTextured(Tessellator.func_178181_a().func_178180_c());
    }

    public static IIDrawUtils startColored(BufferBuilder buf) {
        return IIDrawUtils.start(buf, DefaultVertexFormats.field_181706_f);
    }

    public static IIDrawUtils startColored() {
        return IIDrawUtils.startColored(Tessellator.func_178181_a().func_178180_c());
    }

    public static IIDrawUtils startTexturedColored(BufferBuilder buf) {
        return IIDrawUtils.start(buf, DefaultVertexFormats.field_181709_i);
    }

    public static IIDrawUtils startTexturedColored() {
        return IIDrawUtils.startTexturedColored(Tessellator.func_178181_a().func_178180_c());
    }

    public IIDrawUtils drawTexRect(float x, float y, float w, float h, float ... uv) {
        this.buf.func_181662_b((double)(this.offX + x), (double)(this.offY + y + h), 0.0).func_187315_a((double)uv[0], (double)uv[3]).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x + w), (double)(this.offY + y + h), 0.0).func_187315_a((double)uv[1], (double)uv[3]).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x + w), (double)(this.offY + y), 0.0).func_187315_a((double)uv[1], (double)uv[2]).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x), (double)(this.offY + y), 0.0).func_187315_a((double)uv[0], (double)uv[2]).func_181675_d();
        return this;
    }

    public IIDrawUtils drawColorRect(float x, float y, float w, float h, float r, float g, float b, float a) {
        this.buf.func_181662_b((double)(this.offX + x), (double)(this.offY + y + h), 0.0).func_181666_a(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x + w), (double)(this.offY + y + h), 0.0).func_181666_a(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x + w), (double)(this.offY + y), 0.0).func_181666_a(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x), (double)(this.offY + y), 0.0).func_181666_a(r, g, b, a).func_181675_d();
        return this;
    }

    public IIDrawUtils drawColorGradient(int x, float y, int w, int h, int colorBottom, int colorTop) {
        int r = colorBottom >> 16 & 0xFF;
        int g = colorBottom >> 8 & 0xFF;
        int b = colorBottom & 0xFF;
        int a = colorBottom << 8;
        int r2 = colorTop >> 16 & 0xFF;
        int g2 = colorTop >> 8 & 0xFF;
        int b2 = colorTop & 0xFF;
        int a2 = colorTop << 8;
        this.buf.func_181662_b((double)(this.offX + (float)x), (double)(this.offY + y + (float)h), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + (float)x + (float)w), (double)(this.offY + y + (float)h), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + (float)x + (float)w), (double)(this.offY + y), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r2, g2, b2, a2).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + (float)x), (double)(this.offY + y), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r2, g2, b2, a2).func_181675_d();
        return this;
    }

    public IIDrawUtils drawTexColorRect(int x, float y, int w, int h, float[] argb, float ... uv) {
        return this.drawTexColorRect((float)x, y, (float)w, (float)h, argb[0], argb[1], argb[2], 1.0f, uv);
    }

    public IIDrawUtils drawTexColorRect(float x, float y, float w, float h, float r, float g, float b, float a, float ... uv) {
        this.buf.func_181662_b((double)(this.offX + x), (double)(this.offY + y + h), 0.0).func_187315_a((double)uv[0], (double)uv[3]).func_181666_a(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x + w), (double)(this.offY + y + h), 0.0).func_187315_a((double)uv[1], (double)uv[3]).func_181666_a(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x + w), (double)(this.offY + y), 0.0).func_187315_a((double)uv[1], (double)uv[2]).func_181666_a(r, g, b, a).func_181675_d();
        this.buf.func_181662_b((double)(this.offX + x), (double)(this.offY + y), 0.0).func_187315_a((double)uv[0], (double)uv[2]).func_181666_a(r, g, b, a).func_181675_d();
        return this;
    }

    public IIDrawUtils setOffset(float x, float y) {
        this.offX = x;
        this.offY = y;
        return this;
    }

    public IIDrawUtils addOffset(float x, float y) {
        this.offX += x;
        this.offY += y;
        return this;
    }

    public IIDrawUtils inBetween(BiConsumer<Integer, Integer> draw) {
        this.finish();
        draw.accept((int)this.offX, (int)this.offY);
        this.buf.func_181668_a(7, this.format);
        return this;
    }

    public void finish() {
        this.tes.func_78381_a();
    }
}

