/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util;

import net.minecraft.util.ResourceLocation;

public class ResLoc
extends ResourceLocation {
    public static final String EXT_OBJ = ".obj";
    public static final String EXT_MTL = ".mtl";
    public static final String EXT_OBJAMT = ".obj.amt";
    public static final String EXT_JSON = ".json";
    public static final String EXT_PNG = ".png";
    private final String extension;
    private final int extensionIndex;

    private ResLoc(String domain, String path, String extension, int extensionIndex) {
        super(domain, path);
        this.extension = extension;
        this.extensionIndex = extensionIndex;
    }

    private ResLoc(String domain, String path) {
        super(domain, path);
        this.extensionIndex = path.lastIndexOf(46);
        this.extension = this.extensionIndex == -1 ? "" : path.substring(this.extensionIndex);
    }

    public String getExtension() {
        return this.extension;
    }

    public ResLoc withDomain(String domain) {
        return new ResLoc(domain, this.field_110625_b, this.extension, this.extensionIndex);
    }

    public ResLoc asDirectory() {
        int i = this.field_110625_b.lastIndexOf(47);
        if (i == -1) {
            return this;
        }
        return new ResLoc(this.field_110626_a, this.field_110625_b.substring(0, i) + "/");
    }

    public ResLoc withExtension(String extension) {
        if (this.extensionIndex == -1) {
            return new ResLoc(this.field_110626_a, this.field_110625_b + extension, extension, this.field_110625_b.length());
        }
        return new ResLoc(this.field_110626_a, this.field_110625_b.substring(0, this.extensionIndex) + extension, extension, this.extensionIndex);
    }

    public static ResLoc root(String domain) {
        return new ResLoc(domain, "");
    }

    public static ResLoc of(ResLoc blueprint, Object ... elements) {
        if (!blueprint.field_110625_b.contains("%")) {
            StringBuilder builder = new StringBuilder(blueprint.field_110625_b);
            for (Object e : elements) {
                builder.append(e);
            }
            return new ResLoc(blueprint.field_110626_a, builder.toString());
        }
        return new ResLoc(blueprint.field_110626_a, String.format(blueprint.field_110625_b, elements));
    }

    public static ResLoc of(ResourceLocation res) {
        return new ResLoc(res.func_110624_b(), res.func_110623_a());
    }

    public ResLoc replace(String replace, String with) {
        return new ResLoc(this.field_110626_a, this.field_110625_b.replace(replace, with));
    }
}

