/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;

public class ShaderUtil {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;

    public static void init() {
        ShaderUtil.createShader(Shaders.ALPHA, null, "alpha");
        ShaderUtil.createShader(Shaders.BLUEPRINT, null, "blueprint");
        ShaderUtil.createShader(Shaders.COLOR, null, "color");
    }

    @Deprecated
    public static boolean useBlueprint(float av, float ticks) {
        return ShaderUtil.useShader(Shaders.BLUEPRINT, av, ticks);
    }

    @Deprecated
    public static boolean useAlpha(float av) {
        return ShaderUtil.useShader(Shaders.ALPHA, av);
    }

    @Deprecated
    public static boolean useColor(float r, float g, float b) {
        return ShaderUtil.useShader(Shaders.COLOR, r, g, b);
    }

    public static boolean useShader(@Nullable Shaders shader, float ... parameters) {
        if (shader == null || !shader.use()) {
            return false;
        }
        switch (shader) {
            case BLUEPRINT: {
                shader.setFloat("alpha", parameters[0]);
                shader.setFloat("ticks", parameters[1]);
                break;
            }
            case ALPHA: {
                shader.setFloat("alpha", parameters[0]);
                break;
            }
            case COLOR: {
                Shaders.COLOR.setVec3("color", parameters[0], parameters[1], parameters[2]);
            }
        }
        return true;
    }

    public static boolean useShader(@Nullable Shaders shaders, @Nonnull Float[] parameters) {
        return ShaderUtil.useShader(shaders, ArrayUtils.toPrimitive((Float[])parameters));
    }

    public static void releaseShader() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    private static void createShader(Shaders shader, @Nullable String vert, @Nullable String frag) {
        if (frag != null) {
            shader.fragID = ShaderUtil.createShader(frag, 35632);
        }
        if (vert != null) {
            shader.vertID = ShaderUtil.createShader(vert, 35633);
        }
        shader.programID = ARBShaderObjects.glCreateProgramObjectARB();
        if (shader.programID == 0) {
            return;
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)shader.programID, (int)shader.fragID);
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)shader.programID, (int)shader.vertID);
        }
        ARBShaderObjects.glLinkProgramARB((int)shader.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)shader.programID, (int)35714) == 0) {
            IILogger.error("Shader Error: " + ShaderUtil.getLogInfo(shader.programID));
            return;
        }
        if (ARBShaderObjects.glGetObjectParameteriARB((int)shader.programID, (int)35715) == 0) {
            IILogger.error("Shader Error: " + ShaderUtil.getLogInfo(shader.programID));
        }
        IILogger.info(String.format("Succesfully loaded shader '%s'", shader.func_176610_l()));
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderUtil.readFileAsString(String.format("/assets/immersiveintelligence/shaders/%s.frag", filename)));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderUtil.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = ShaderUtil.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static enum Shaders implements ISerializableEnum
    {
        ALPHA,
        BLUEPRINT,
        COLOR;

        private int programID;
        private int fragID;
        private int vertID;

        boolean use() {
            if (this.programID <= 0) {
                return false;
            }
            ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
            return true;
        }

        int getRef(String name) {
            return ARBShaderObjects.glGetUniformLocationARB((int)this.programID, (CharSequence)name);
        }

        void setFloat(String name, float value) {
            ARBShaderObjects.glUniform1fARB((int)this.getRef(name), (float)value);
        }

        void setVec3(String name, float x, float y, float z) {
            ARBShaderObjects.glUniform3fARB((int)this.getRef(name), (float)x, (float)y, (float)z);
        }

        public static Shaders getByName(String name) {
            return Arrays.stream(Shaders.values()).filter(shaders -> shaders.func_176610_l().equals(name)).findFirst().orElse(ALPHA);
        }
    }
}

