/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTQuads;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;

public abstract class AMTModelCache<T>
extends HashMap<String, AMT[]>
implements Iterable<AMT> {
    @Nonnull
    private final OBJModel[] models;
    @Nonnull
    private final BiFunction<ResourceLocation, T, TextureAtlasSprite> textureProvider;
    @Nullable
    private final IIModelHeader header;
    @Nonnull
    private final BiFunction<T, IIModelHeader, AMT[]> modelProvider;
    private final boolean isBlock;
    private final AMT[] base;
    private AMT[] lastPicked = null;

    public AMTModelCache(@Nonnull OBJModel[] models, @Nonnull BiFunction<ResourceLocation, T, TextureAtlasSprite> textureProvider, @Nullable IIModelHeader[] headers, @Nonnull BiFunction<T, IIModelHeader, AMT[]> modelProvider, boolean isBlock) {
        this.models = models;
        this.textureProvider = textureProvider;
        this.header = new IIModelHeader(headers);
        this.modelProvider = modelProvider;
        this.base = this.getVariant("", this.getDefaultParameter());
        this.isBlock = isBlock;
    }

    @Override
    public void clear() {
        this.values().forEach(IIAnimationUtils::disposeOf);
        super.clear();
    }

    public AMT[] getVariant(@Nullable String name, T parameter) {
        if (this.containsKey(name)) {
            this.lastPicked = (AMT[])this.get(name);
            return this.lastPicked;
        }
        this.lastPicked = this.getAMTModel(parameter);
        this.put(name, this.lastPicked);
        return this.lastPicked;
    }

    @Nullable
    public AMT[] getBase() {
        return this.base;
    }

    @Nullable
    public AMT[] getLast() {
        return this.lastPicked;
    }

    @Override
    public Iterator<AMT> iterator() {
        if (this.lastPicked == null) {
            return Collections.emptyIterator();
        }
        return Iterators.forArray((Object[])this.lastPicked);
    }

    protected AMT[] getAMTModel(T parameter) {
        ArrayList<AMT> models = new ArrayList<AMT>();
        for (OBJModel objModel : this.models) {
            Map groups = objModel.getMatLib().getGroups();
            for (String group : groups.keySet()) {
                OBJModel.OBJState objState = new OBJModel.OBJState((List)ImmutableList.of((Object)group), true, (IModelState)ModelRotation.X0_Y0);
                Vec3d origin = IIAnimationUtils.getHeaderOffset(this.header, group);
                BakedQuad[] quads = objModel.bake((IModelState)objState, this.isBlock ? DefaultVertexFormats.field_176600_a : DefaultVertexFormats.field_176599_b, res -> this.textureProvider.apply((ResourceLocation)res, (ResourceLocation)parameter)).func_188616_a(null, null, 0L).toArray(new BakedQuad[0]);
                if (quads.length == 0) continue;
                models.add(new AMTQuads(group, origin, quads));
            }
        }
        models.addAll(Arrays.asList((Object[])this.modelProvider.apply(parameter, this.header)));
        if (this.header != null) {
            this.header.applyHierarchy((Collection<AMT>)models);
        }
        return IIAnimationUtils.organise(models.toArray(new AMT[0]));
    }

    protected abstract T getDefaultParameter();
}

