/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCache;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;

public final class AMTModelCacheBuilder<T> {
    private List<OBJModel> models = new ArrayList<OBJModel>();
    private List<IIModelHeader> headers = new ArrayList<IIModelHeader>();
    private BiFunction<ResourceLocation, T, TextureAtlasSprite> textureProvider = (res, t) -> ClientUtils.getSprite((ResourceLocation)res);
    private BiFunction<T, IIModelHeader, AMT[]> modelProvider = (t, h) -> new AMT[0];
    private final Supplier<T> defaultValue;
    private boolean isBlock = false;

    private AMTModelCacheBuilder(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static AMTModelCacheBuilder<ItemStack> startItemModel() {
        return new AMTModelCacheBuilder<ItemStack>(() -> ItemStack.field_190927_a);
    }

    public static AMTModelCacheBuilder<IBlockState> startBlockModel() {
        AMTModelCacheBuilder<IBlockState> builder = new AMTModelCacheBuilder<IBlockState>(() -> null);
        builder.isBlock = true;
        return builder;
    }

    public static AMTModelCacheBuilder<TileEntity> startTileEntityModel() {
        AMTModelCacheBuilder<TileEntity> builder = new AMTModelCacheBuilder<TileEntity>(() -> null);
        builder.isBlock = true;
        return builder;
    }

    public AMTModelCacheBuilder<T> withModel(OBJModel model) {
        this.models.add(model);
        return this;
    }

    public AMTModelCacheBuilder<T> withModel(ResourceLocation res) {
        return this.withModel(IIAnimationUtils.modelFromRes(res));
    }

    public AMTModelCacheBuilder<T> withModels(OBJModel ... model) {
        this.models.addAll(Arrays.asList(model));
        return this;
    }

    public AMTModelCacheBuilder<T> withHeader(IIModelHeader header) {
        this.headers.add(header);
        return this;
    }

    public AMTModelCacheBuilder<T> withHeader(ResourceLocation res) {
        return this.withHeader(IIAnimationLoader.loadHeader(res));
    }

    public AMTModelCacheBuilder<T> withTextureProvider(BiFunction<ResourceLocation, T, TextureAtlasSprite> textureProvider) {
        this.textureProvider = textureProvider;
        return this;
    }

    public AMTModelCacheBuilder<T> withModelProvider(BiFunction<T, IIModelHeader, AMT[]> modelProvider) {
        this.modelProvider = modelProvider;
        return this;
    }

    public AMTModelCache<T> build() {
        return new AMTModelCache<T>(this.models.toArray(new OBJModel[0]), this.textureProvider, this.headers.toArray(new IIModelHeader[0]), this.modelProvider, this.isBlock){

            @Override
            protected T getDefaultParameter() {
                return AMTModelCacheBuilder.this.defaultValue.get();
            }
        };
    }
}

