/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.client.util.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;

public class IIAnimation {
    public final ResourceLocation res;
    @Nonnull
    public final IIAnimationGroup[] groups;

    public IIAnimation(ResourceLocation res, @Nonnull IIAnimationGroup[] groups) {
        this.res = res;
        this.groups = groups;
    }

    public IIAnimation(ResourceLocation res, JsonObject json) {
        this.res = res;
        if (json.has("groups")) {
            JsonObject groups = json.getAsJsonObject("groups");
            this.groups = (IIAnimationGroup[])groups.entrySet().stream().map(e -> new IIAnimationGroup((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonObject())).toArray(IIAnimationGroup[]::new);
        } else {
            this.groups = new IIAnimationGroup[0];
        }
    }

    public IIAnimationGroup getLeadingGroup() {
        return this.groups.length > 0 ? this.groups[0] : new IIAnimationGroup("missingno", new JsonObject());
    }

    public static class IIShaderLine
    extends IIAnimationLine<Float[]> {
        private final ShaderUtil.Shaders shader;

        public IIShaderLine(ShaderUtil.Shaders shader, float[] timeframes, Float[][] values) {
            super(timeframes, (T[])values);
            this.shader = shader;
        }

        @Override
        public Float[] interpolate(Float[] t1, Float[] t2, float value) {
            if (value == 0.0f) {
                return t1;
            }
            if (value == 1.0f) {
                return t2;
            }
            Float[] interpolated = new Float[Math.min(t1.length, t2.length)];
            for (int i = 0; i < interpolated.length; ++i) {
                interpolated[i] = Float.valueOf((t1[i].floatValue() + t2[i].floatValue()) * 0.5f);
            }
            return interpolated;
        }

        public ShaderUtil.Shaders getShader() {
            return this.shader;
        }
    }

    public static class IIFloatLine
    extends IIAnimationLine<Float> {
        public IIFloatLine(float[] timeframes, Float[] values) {
            super(timeframes, values);
        }

        @Override
        public Float interpolate(Float t1, Float t2, float value) {
            return Float.valueOf((t1.floatValue() + t2.floatValue()) * 0.5f);
        }
    }

    public static class IIBooleanLine
    extends IIAnimationLine<Boolean> {
        public IIBooleanLine(float[] timeframes, Boolean[] values) {
            super(timeframes, values);
        }

        @Override
        public Boolean interpolate(Boolean t1, Boolean t2, float value) {
            return t1;
        }

        @Override
        public Boolean getForTime(float time) {
            for (int i = this.timeframes.length - 1; i >= 0; --i) {
                if (!(time >= this.timeframes[i])) continue;
                if (time == this.timeframes[i]) {
                    return ((Boolean[])this.values)[i];
                }
                if (i + 1 >= this.timeframes.length) continue;
                return ((Boolean[])this.values)[i];
            }
            return ((Boolean[])this.values)[0];
        }
    }

    public static class IIVectorLine
    extends IIAnimationLine<Vec3d> {
        public IIVectorLine(float[] timeframes, Vec3d[] values) {
            super(timeframes, values);
        }

        public IIVectorLine(float[] timeframes, Vec3d[] values, float scale) {
            this(timeframes, (Vec3d[])Arrays.stream(values).map(vec3d -> vec3d.func_186678_a((double)scale)).toArray(Vec3d[]::new));
        }

        @Override
        public Vec3d interpolate(Vec3d t1, Vec3d t2, float value) {
            return new Vec3d(MathHelper.func_151238_b((double)t1.field_72450_a, (double)t2.field_72450_a, (double)value), MathHelper.func_151238_b((double)t1.field_72448_b, (double)t2.field_72448_b, (double)value), MathHelper.func_151238_b((double)t1.field_72449_c, (double)t2.field_72449_c, (double)value));
        }
    }

    public static abstract class IIAnimationLine<T> {
        public final float[] timeframes;
        public final float[] durations;
        public final T[] values;

        public IIAnimationLine(float[] timeframes, T[] values) {
            this.timeframes = timeframes;
            if (timeframes.length == 1) {
                this.durations = new float[]{1.0f};
            } else {
                this.durations = new float[timeframes.length];
                for (int i = 0; i < timeframes.length - 1; ++i) {
                    this.durations[i] = timeframes[i + 1] - timeframes[i];
                }
                this.durations[this.durations.length - 1] = 1.0f;
            }
            this.values = values;
        }

        public abstract T interpolate(T var1, T var2, float var3);

        public T getForTime(float time) {
            for (int i = this.timeframes.length - 1; i >= 0; --i) {
                if (!(time >= this.timeframes[i])) continue;
                if (time == this.timeframes[i]) {
                    return this.values[i];
                }
                if (i + 1 >= this.timeframes.length) continue;
                return this.interpolate(this.values[i], this.values[i + 1], (time - this.timeframes[i]) / this.durations[i]);
            }
            return this.values[0];
        }
    }

    public static class IIAnimationGroup {
        final String groupName;
        @Nullable
        final IIVectorLine position;
        @Nullable
        final IIVectorLine scale;
        @Nullable
        final IIVectorLine rotation;
        @Nullable
        final IIBooleanLine visibility;
        @Nullable
        final IIShaderLine shader;
        @Nullable
        final IIFloatLine property;

        public IIAnimationGroup(String groupName, @Nullable IIVectorLine position, @Nullable IIVectorLine scale, @Nullable IIVectorLine rotation, @Nullable IIBooleanLine visibility, @Nullable IIShaderLine shader, @Nullable IIFloatLine property) {
            this.groupName = groupName;
            this.position = position;
            this.scale = scale;
            this.rotation = rotation;
            this.visibility = visibility;
            this.shader = shader;
            this.property = property;
        }

        public IIAnimationGroup(String groupName, JsonObject json) {
            this.groupName = groupName;
            this.position = json.has("position") ? this.loadPositionLine(this.loadLine(json, "position")) : null;
            this.scale = json.has("scale") ? this.loadVectorLine(this.loadLine(json, "scale")) : null;
            this.rotation = json.has("rotation") ? this.loadVectorLine(this.loadLine(json, "rotation")) : null;
            IIShaderLine shaderLine = null;
            for (ShaderUtil.Shaders value : ShaderUtil.Shaders.values()) {
                if (!json.has(value.func_176610_l())) continue;
                shaderLine = this.loadShaderLine(json, value);
                break;
            }
            this.shader = shaderLine;
            this.visibility = json.has("visibility") ? this.loadBooleanLine(json, "visibility") : null;
            this.property = json.has("property") ? this.loadFloatLine(json, "property") : null;
        }

        private Tuple<ArrayList<Float>, ArrayList<Vec3d>> loadLine(JsonObject json, String id) {
            JsonArray array = json.getAsJsonArray(id);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Vec3d> vectors = new ArrayList<Vec3d>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    vectors.add(IIAnimationUtils.jsonToVec3d(obj.get("transform").getAsJsonArray()));
                }
            }
            return new Tuple(timeframes, vectors);
        }

        private IIVectorLine loadPositionLine(Tuple<ArrayList<Float>, ArrayList<Vec3d>> tuple) {
            return new IIVectorLine(IIAnimationGroup.convertTimeframes((ArrayList)tuple.func_76341_a()), ((ArrayList)tuple.func_76340_b()).toArray(new Vec3d[0]), 0.0625f);
        }

        private IIVectorLine loadVectorLine(Tuple<ArrayList<Float>, ArrayList<Vec3d>> tuple) {
            return new IIVectorLine(IIAnimationGroup.convertTimeframes((ArrayList)tuple.func_76341_a()), ((ArrayList)tuple.func_76340_b()).toArray(new Vec3d[0]));
        }

        private IIFloatLine loadFloatLine(JsonObject json, String id) {
            JsonArray array = json.getAsJsonArray(id);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Float> values = new ArrayList<Float>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    values.add(Float.valueOf(obj.get(id).getAsFloat()));
                }
            }
            return new IIFloatLine(IIAnimationGroup.convertTimeframes(timeframes), values.toArray(new Float[0]));
        }

        private IIBooleanLine loadBooleanLine(JsonObject json, String id) {
            JsonArray array = json.getAsJsonArray(id);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    values.add(obj.get(id).getAsBoolean());
                }
            }
            return new IIBooleanLine(IIAnimationGroup.convertTimeframes(timeframes), values.toArray(new Boolean[0]));
        }

        private IIShaderLine loadShaderLine(JsonObject json, ShaderUtil.Shaders shader) {
            String shaderName = shader.func_176610_l();
            JsonArray array = json.getAsJsonArray(shaderName);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Float[]> values = new ArrayList<Float[]>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    JsonElement value = obj.get(shaderName);
                    if (value.isJsonArray()) {
                        JsonArray valueSet = obj.get(shaderName).getAsJsonArray();
                        Float[] parameters = new Float[valueSet.size()];
                        for (int i = 0; i < parameters.length; ++i) {
                            parameters[i] = Float.valueOf(valueSet.get(i).getAsFloat());
                        }
                        values.add(parameters);
                        continue;
                    }
                    values.add(new Float[]{Float.valueOf(value.getAsFloat())});
                }
            }
            return new IIShaderLine(shader, IIAnimationGroup.convertTimeframes(timeframes), (Float[][])values.toArray((T[])new Float[0][0]));
        }

        private static float[] convertTimeframes(ArrayList<Float> timeframes) {
            float[] arr = new float[timeframes.size()];
            for (int i = 0; i < timeframes.size(); ++i) {
                arr[i] = timeframes.get(i).floatValue();
            }
            return arr;
        }
    }
}

