/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCache;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTQuads;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;

public class IIAnimationCachedMap {
    @Nonnull
    AMTModelCache<?> model;
    @Nonnull
    IIAnimation animation;
    @Nonnull
    HashMap<AMT[], IIAnimationCompiledMap> map = new HashMap();

    private IIAnimationCachedMap(@Nonnull AMTModelCache<?> model, @Nonnull IIAnimation animation) {
        this.model = model;
        this.animation = animation;
    }

    public static IIAnimationCachedMap create(@Nonnull AMTModelCache<?> model, @Nonnull IIAnimation animation) {
        return new IIAnimationCachedMap(model, animation);
    }

    public static IIAnimationCachedMap create(@Nonnull AMTModelCache<?> model, @Nonnull ResourceLocation res) {
        return IIAnimationCachedMap.create(model, IIAnimationLoader.loadAnimation(res));
    }

    public static IIAnimationCachedMap createVisibilityAnimation(@Nonnull AMTModelCache<?> model, @Nonnull OBJModel mainModel) {
        Set present = mainModel.getMatLib().getGroups().keySet();
        IIAnimation.IIAnimationGroup[] groups = (IIAnimation.IIAnimationGroup[])Arrays.stream(IIAnimationUtils.getChildrenRecursive(model.getBase())).filter(amt -> amt instanceof AMTQuads).filter(amt -> !present.contains(amt.name)).map(amt -> new IIAnimation.IIAnimationGroup(amt.name, null, null, null, new IIAnimation.IIBooleanLine(new float[]{0.0f}, new Boolean[]{false}), null, null)).toArray(IIAnimation.IIAnimationGroup[]::new);
        return IIAnimationCachedMap.create(model, new IIAnimation(new ResourceLocation("immersiveintelligence", "visibility"), groups));
    }

    public void apply(float time) {
        AMT[] last = this.model.getLast();
        this.map.putIfAbsent(last, IIAnimationCompiledMap.create(last, this.animation));
        this.map.get(last).apply(time);
    }
}

