/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.EntityAMTTactile;

public class IIAnimationCollisionMap
extends HashMap<EntityAMTTactile, IIAnimation.IIAnimationGroup> {
    private Matrix4 mat;
    private EnumFacing facing;

    private IIAnimationCollisionMap() {
    }

    public static IIAnimationCollisionMap create(List<EntityAMTTactile> tactiles, IIAnimation animation, EnumFacing facing, boolean isMirrored) {
        IIAnimationCollisionMap map = new IIAnimationCollisionMap();
        map.mat = new Matrix4(facing);
        map.facing = facing;
        block0: for (IIAnimation.IIAnimationGroup group : animation.groups) {
            for (EntityAMTTactile tactile : tactiles) {
                if (!IIAnimationCollisionMap.isTactileGroup(group) || !group.groupName.equals(tactile.name)) continue;
                map.put(tactile, group);
                continue block0;
            }
        }
        return map;
    }

    private static boolean isTactileGroup(IIAnimation.IIAnimationGroup group) {
        return group.position != null || group.rotation != null || group.scale != null || group.visibility != null;
    }

    public void apply(float time) {
        this.forEach((key, value) -> this.setAnimationGroups((EntityAMTTactile)((Object)key), (IIAnimation.IIAnimationGroup)value, time));
    }

    private void setAnimationGroups(EntityAMTTactile tactile, IIAnimation.IIAnimationGroup group, float time) {
        if (group.position != null) {
            tactile.translation = (Vec3d)group.position.getForTime(time);
            if (this.facing == EnumFacing.EAST) {
                tactile.translation = new Vec3d(-tactile.translation.field_72449_c, tactile.translation.field_72448_b, tactile.translation.field_72450_a);
            } else if (this.facing == EnumFacing.WEST) {
                tactile.translation = new Vec3d(tactile.translation.field_72449_c, tactile.translation.field_72448_b, tactile.translation.field_72450_a);
            } else if (this.facing == EnumFacing.NORTH) {
                tactile.translation = new Vec3d(-tactile.translation.field_72450_a, tactile.translation.field_72448_b, tactile.translation.field_72449_c);
            }
        }
        if (group.rotation != null) {
            tactile.rotation = (Vec3d)group.rotation.getForTime(time);
            switch (this.facing) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    break;
                }
            }
            if (this.facing == EnumFacing.EAST) {
                tactile.rotation = new Vec3d(-tactile.rotation.field_72449_c, tactile.rotation.field_72448_b, tactile.rotation.field_72450_a);
            } else if (this.facing == EnumFacing.WEST) {
                tactile.rotation = new Vec3d(-tactile.rotation.field_72449_c, tactile.rotation.field_72448_b, tactile.rotation.field_72450_a);
            } else if (this.facing == EnumFacing.SOUTH) {
                tactile.rotation = new Vec3d(-tactile.rotation.field_72450_a, tactile.rotation.field_72448_b, -tactile.rotation.field_72449_c);
            }
        }
        if (group.scale != null) {
            tactile.scale = this.mat.apply((Vec3d)group.scale.getForTime(time));
        }
        if (group.visibility != null) {
            tactile.visibility = group.visibility.getForTime(time);
        }
    }
}

