/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import blusunrize.immersiveengineering.client.models.obj.IEOBJModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IILogger;

public class IIAnimationLoader {
    @SideOnly(value=Side.CLIENT)
    public static JsonObject readFileToJSON(@Nonnull ResourceLocation res) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);
            InputStream stream = resource.func_110527_b();
            JsonElement object = new JsonStreamParser((Reader)new InputStreamReader(stream)).next();
            return object.getAsJsonObject();
        }
        catch (Exception exception) {
            IILogger.error("[AMT] Couldn't load animation " + TextFormatting.GOLD + res.toString().replaceFirst("animations/", "").replaceFirst(".json", "") + TextFormatting.RESET + ", " + exception.getClass().getCanonicalName());
            return new JsonObject();
        }
    }

    public static JsonObject readServerFileToJson(@Nonnull ResourceLocation res) {
        try {
            InputStream stream = MinecraftServer.class.getResourceAsStream("/assets/" + res.func_110624_b() + "/" + res.func_110623_a());
            assert (stream != null);
            return (JsonObject)new JsonStreamParser((Reader)new InputStreamReader(stream)).next();
        }
        catch (Exception exception) {
            IILogger.error("[AMT/Server] Couldn't load " + TextFormatting.GOLD + res.toString().replaceFirst(".json", "") + TextFormatting.RESET + ", " + exception.getClass().getCanonicalName());
            return new JsonObject();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static IIAnimation loadAnimation(@Nonnull ResourceLocation res) {
        ResourceLocation fullRes = new ResourceLocation(res.func_110624_b(), "animations/" + res.func_110623_a() + ".json");
        return new IIAnimation(res, IIAnimationLoader.readFileToJSON(fullRes));
    }

    public static IIAnimation loadAnimationServer(@Nonnull ResourceLocation res) {
        ResourceLocation fullRes = new ResourceLocation(res.func_110624_b(), "animations/" + res.func_110623_a() + ".json");
        return new IIAnimation(res, IIAnimationLoader.readServerFileToJson(fullRes));
    }

    @SideOnly(value=Side.CLIENT)
    public static IIModelHeader loadHeader(@Nonnull IBakedModel model) {
        IEOBJModel ieobjModel = (IEOBJModel)((IESmartObjModel)model).getModel();
        ResourceLocation res = ieobjModel.getResourceLocation();
        ResourceLocation fullRes = new ResourceLocation(res.func_110624_b(), res.func_110623_a().replace(".obj.ie", ".obj.amt"));
        return IIAnimationLoader.loadHeader(fullRes);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIModelHeader loadHeader(@Nonnull ResourceLocation res) {
        return new IIModelHeader(IIAnimationLoader.readFileToJSON(res));
    }

    public static IIModelHeader loadHeaderServer(@Nonnull ResourceLocation res) {
        return new IIModelHeader(IIAnimationLoader.readServerFileToJson(res));
    }

    @SideOnly(value=Side.CLIENT)
    public static HashMap<String, ResourceLocation> loadMTL(@Nonnull ResourceLocation res) {
        HashMap<String, ResourceLocation> map = new HashMap<String, ResourceLocation>();
        try {
            String line;
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b()));
            String lastMaterial = null;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split.length < 2) continue;
                switch (split[0]) {
                    case "newmtl": {
                        lastMaterial = split[1];
                        break;
                    }
                    case "map_Kd": {
                        if (lastMaterial == null) {
                            throw new IOException("No material defined before map_Kd");
                        }
                        map.put(lastMaterial, new ResourceLocation(split[1]));
                        lastMaterial = null;
                        break;
                    }
                }
            }
        }
        catch (IOException exception) {
            IILogger.error("[AMT] Couldn't load MTL file " + TextFormatting.GOLD + res.toString().replaceFirst("models/", "") + TextFormatting.RESET + ", " + exception.getClass().getCanonicalName());
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public static void preloadTexturesFromMTL(@Nonnull ResourceLocation mtl, TextureMap map) {
        IIAnimationLoader.loadMTL(mtl).values().forEach(res -> ApiUtils.getRegisterSprite((TextureMap)map, (ResourceLocation)res));
    }
}

