/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTLocator;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCache;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTQuads;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIMachineUpgradeModel;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.lambda.ArraylistJoinCollector;

@SideOnly(value=Side.CLIENT)
public class IIAnimationUtils {
    private static final OBJModel EMPTY = new OBJModel(new OBJModel.MaterialLibrary(), (ResourceLocation)ResLoc.of(IIReference.RES_BLOCK_MODEL, "empty.obj"));

    public static float getDebugProgress(World world, float max, float partialTicks) {
        return ((float)ClientUtils.mc().field_71441_e.func_82737_E() % max + partialTicks) / max;
    }

    public static float getAnimationProgress(float current, float max, boolean invert, float partialTicks) {
        return MathHelper.func_76131_a((float)(invert ? 1.0f - (current - partialTicks) / max : (current + partialTicks) / max), (float)0.0f, (float)1.0f);
    }

    public static float getAnimationProgress(float current, float max, boolean shouldAnimate, boolean reverse, float posStep, float negStep, float partialTicks) {
        return current == 0.0f ? 0.0f : (current == max ? 1.0f : MathHelper.func_76131_a((float)((current + (shouldAnimate ? (reverse ? -negStep : posStep) * partialTicks : 0.0f)) / max), (float)0.0f, (float)1.0f));
    }

    public static float getOffset(float progress, float offset, float duration) {
        return MathHelper.func_76131_a((float)((progress - offset) / duration), (float)0.0f, (float)1.0f);
    }

    public static BlockRendererDispatcher getBRD() {
        return Minecraft.func_71410_x().func_175602_ab();
    }

    @Nonnull
    public static Tuple<IBlockState, IBakedModel> getAnimationBakedModel(TileEntity tile) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
        state = state.func_177226_a((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        return new Tuple((Object)state, (Object)blockRenderer.func_175023_a().func_178125_b(state));
    }

    public static void setModelAnimations(AMT model, IIAnimation.IIAnimationGroup group, float time) {
        if (group.visibility != null) {
            model.visible = group.visibility.getForTime(time);
        }
        if (group.position != null) {
            model.off = (Vec3d)group.position.getForTime(time);
        }
        if (group.rotation != null) {
            model.rot = (Vec3d)group.rotation.getForTime(time);
        }
        if (group.scale != null) {
            model.scale = (Vec3d)group.scale.getForTime(time);
        }
        if (group.shader != null) {
            model.shader = group.shader.getShader();
            model.shaderValue = (Float[])group.shader.getForTime(time);
        }
        if (group.property != null) {
            model.property = ((Float)group.property.getForTime(time)).floatValue();
        }
    }

    public static void setModelVisibility(AMT[] models, boolean visible) {
        for (AMT model : models) {
            model.visible = visible;
        }
    }

    public static void setModelVisibility(AMT model, boolean visible) {
        model.visible = visible;
    }

    public static void setModelRotation(AMT model, double pitch, double yaw, double roll) {
        model.rot = new Vec3d(pitch, yaw, roll);
    }

    public static void addModelRotation(AMT model, double pitch, double yaw, double roll) {
        if (model.rot == null) {
            IIAnimationUtils.setModelRotation(model, pitch, yaw, roll);
        } else {
            model.rot = new Vec3d(model.rot.field_72450_a + pitch, model.rot.field_72448_b + yaw, model.rot.field_72449_c + roll);
        }
    }

    public static void setModelRotation(AMT amt, Vec3d rotation) {
        IIAnimationUtils.setModelRotation(amt, rotation.field_72450_a, rotation.field_72448_b, rotation.field_72449_c);
    }

    public static void setModelTranslation(AMT model, Vec3d vec) {
        model.off = vec;
    }

    public static void addModelTranslation(AMT model, Vec3d vec) {
        if (model.off == null) {
            IIAnimationUtils.setModelTranslation(model, vec);
        } else {
            model.off = model.off.func_178787_e(vec);
        }
    }

    public static AMT[] getAMT(Tuple<IBlockState, IBakedModel> model, @Nullable IIModelHeader header) {
        return IIAnimationUtils.getAMT(model, header, h -> new AMT[0]);
    }

    public static AMT[] getAMT(Tuple<IBlockState, IBakedModel> model, @Nullable IIModelHeader header, @Nonnull Function<IIModelHeader, AMT[]> custom) {
        IESmartObjModel baked = (IESmartObjModel)model.func_76340_b();
        Map groups = baked.getModel().getMatLib().getGroups();
        ArrayList<AMT> models = new ArrayList<AMT>();
        for (String group : groups.keySet()) {
            OBJModel.OBJState objState = new OBJModel.OBJState((List)ImmutableList.of((Object)group), true, (IModelState)ModelRotation.X0_Y0);
            IExtendedBlockState bstate = ((IExtendedBlockState)model.func_76341_a()).withProperty(Properties.AnimationProperty, (Object)objState);
            Vec3d origin = IIAnimationUtils.getHeaderOffset(header, group);
            baked.getTextures().forEach((s, textureAtlasSprite) -> ApiUtils.getRegisterSprite((TextureMap)ClientUtils.mc().func_147117_R(), (String)textureAtlasSprite.func_94215_i()));
            BakedQuad[] quads = baked.getModel().bake((IModelState)objState, DefaultVertexFormats.field_176600_a, ClientUtils::getSprite).func_188616_a((IBlockState)bstate, null, 0L).toArray(new BakedQuad[0]);
            if (quads.length == 0) continue;
            models.add(new AMTQuads(group, origin, quads));
        }
        models.addAll(Arrays.asList((Object[])custom.apply(header)));
        if (header != null) {
            header.applyHierarchy((Collection<AMT>)models);
        }
        return IIAnimationUtils.organise(models.toArray(new AMT[0]));
    }

    public static Vec3d getHeaderOffset(IIModelHeader header, String name) {
        if (header != null) {
            return header.getOffset(name);
        }
        return Vec3d.field_186680_a;
    }

    public static OBJModel modelFromRes(ResourceLocation res) {
        try {
            OBJModel model = (OBJModel)OBJLoader.INSTANCE.loadModel(res);
            return (OBJModel)model.process(ImmutableMap.of((Object)"flip-v", (Object)String.valueOf(true)));
        }
        catch (Exception ignored) {
            IILogger.error("Couldn't load model for {}, either the path used is incorrect or a model file may be missing!", res);
            return EMPTY;
        }
    }

    public static AMT[] getAMTFromRes(ResourceLocation res, @Nullable ResourceLocation headerRes) {
        return IIAnimationUtils.getAMTFromRes(res, headerRes, h -> new AMT[0]);
    }

    public static AMT[] getAMTFromRes(ResourceLocation res, @Nullable ResourceLocation headerRes, @Nonnull Function<IIModelHeader, AMT[]> custom) {
        try {
            OBJModel model = (OBJModel)OBJLoader.INSTANCE.loadModel(res).process(ImmutableMap.of((Object)"flip-v", (Object)String.valueOf(true)));
            IIModelHeader header = headerRes == null ? null : IIAnimationLoader.loadHeader(headerRes);
            return IIAnimationUtils.getAMTInternal(null, model, header, custom);
        }
        catch (Exception exception) {
            return new AMT[0];
        }
    }

    private static AMT[] getAMTInternal(@Nullable IBlockState bState, @Nonnull OBJModel model, @Nullable IIModelHeader header, @Nonnull Function<IIModelHeader, AMT[]> custom) {
        Map groups = model.getMatLib().getGroups();
        ArrayList<AMT> models = new ArrayList<AMT>();
        for (String group : groups.keySet()) {
            OBJModel.OBJState objState = new OBJModel.OBJState((List)ImmutableList.of((Object)group), true, (IModelState)ModelRotation.X0_Y0);
            Vec3d origin = IIAnimationUtils.getHeaderOffset(header, group);
            BakedQuad[] quads = model.bake((IModelState)objState, DefaultVertexFormats.field_176600_a, ClientUtils::getSprite).func_188616_a(bState, null, 0L).toArray(new BakedQuad[0]);
            if (quads.length == 0) continue;
            models.add(new AMTQuads(group, origin, quads));
        }
        models.addAll(Arrays.asList((Object[])custom.apply(header)));
        if (header != null) {
            header.applyHierarchy((Collection<AMT>)models);
        }
        return IIAnimationUtils.organise(models.toArray(new AMT[0]));
    }

    public static AMT[] getAMTItemModel(@Nonnull OBJModel model, @Nullable IIModelHeader header, @Nonnull Function<IIModelHeader, AMT[]> custom) {
        Map groups = model.getMatLib().getGroups();
        ArrayList<AMT> models = new ArrayList<AMT>();
        for (String group : groups.keySet()) {
            OBJModel.OBJState objState = new OBJModel.OBJState((List)ImmutableList.of((Object)group), true, (IModelState)ModelRotation.X0_Y0);
            Vec3d origin = IIAnimationUtils.getHeaderOffset(header, group);
            BakedQuad[] quads = model.bake((IModelState)objState, DefaultVertexFormats.field_176599_b, ClientUtils::getSprite).func_188616_a(null, null, 0L).toArray(new BakedQuad[0]);
            if (quads.length == 0) continue;
            models.add(new AMTQuads(group, origin, quads));
        }
        models.addAll(Arrays.asList((Object[])custom.apply(header)));
        if (header != null) {
            header.applyHierarchy((Collection<AMT>)models);
        }
        return IIAnimationUtils.organise(models.toArray(new AMT[0]));
    }

    public static AMT[] disposeOf(@Nullable AMT[] array) {
        if (array != null) {
            Arrays.stream(array).forEach(AMT::disposeOf);
        }
        return array;
    }

    public static void disposeOf(@Nullable AMTModelCache<?> model) {
        if (model != null) {
            model.clear();
        }
    }

    public static IIMachineUpgradeModel disposeOf(@Nullable IIMachineUpgradeModel model) {
        if (model != null) {
            return model.disposeOf();
        }
        return null;
    }

    public static AMT[] organise(AMT[] array) {
        return (AMT[])Arrays.stream(array).filter(amt -> !amt.isChild()).toArray(AMT[]::new);
    }

    public static AMT[] getChildrenRecursive(AMT[] array) {
        return ((ArrayList)Arrays.stream(array).map(AMT::getChildrenRecursive).collect(new ArraylistJoinCollector())).toArray(new AMT[0]);
    }

    public static AMT getPart(AMT[] array, String name) {
        return Arrays.stream(IIAnimationUtils.getChildrenRecursive(array)).filter(amt -> amt.name.equals(name)).findFirst().orElse(array[0]);
    }

    public static AMT batchMultipleAMTQuads(AMT[] model, String name) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (AMT amt : IIAnimationUtils.getChildrenRecursive(model)) {
            if (!(amt instanceof AMTQuads)) continue;
            quads.addAll(Arrays.asList(((AMTQuads)amt).quads));
        }
        return quads.isEmpty() ? new AMTLocator(name, Vec3d.field_186680_a) : new AMTQuads(name, Vec3d.field_186680_a, quads.toArray(new BakedQuad[0]));
    }

    public static Vec3d jsonToVec3d(JsonArray array) {
        return new Vec3d(array.get(0).getAsNumber().doubleValue(), array.get(1).getAsNumber().doubleValue(), array.get(2).getAsNumber().doubleValue());
    }
}

