/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.client.model.IIModelRegistry;
import pl.pabilo8.immersiveintelligence.client.render.IReloadableModelContainer;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIModelHeader;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;

public abstract class IIItemRendererAMT<I extends Item>
extends TileEntityItemStackRenderer
implements IReloadableModelContainer<IIItemRendererAMT<I>> {
    private boolean unCompiled = true;
    @Nonnull
    private final ImmersiveModelRegistry.ItemModelReplacement_OBJ replacementModel;
    @Nullable
    private IESmartObjModel model;
    @Nonnull
    protected ResLoc headerRes;
    @Nonnull
    protected final I item;

    public IIItemRendererAMT(@Nonnull I item, ResLoc modelRes) {
        this.item = item;
        this.headerRes = modelRes.withExtension(".obj.amt");
        this.replacementModel = new ImmersiveModelRegistry.ItemModelReplacement_OBJ(modelRes.withExtension(".obj").toString(), true);
        IIModelRegistry.instance.registerCustomItemModel((Item)item, modelRes.func_110624_b(), this.setTransforms(this.replacementModel));
    }

    public void setHeaderRes(ResLoc modelRes) {
        this.headerRes = modelRes;
    }

    protected final ImmersiveModelRegistry.ItemModelReplacement parseTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ model, @Nullable IIModelHeader header) {
        if (header != null) {
            header.applyTransforms(model);
        }
        return model;
    }

    public final void func_192838_a(@Nonnull ItemStack stack, float partialTicks) {
        World w = IESmartObjModel.tempEntityStatic != null ? IESmartObjModel.tempEntityStatic.field_70170_p : null;
        IBakedModel model = ClientUtils.mc().func_175599_af().func_184393_a(stack, w, IESmartObjModel.tempEntityStatic);
        if (this.unCompiled) {
            if (model instanceof IESmartObjModel) {
                this.model = (IESmartObjModel)model;
                this.nullifyModels();
                this.compileModels(this.model.getModel(), IIAnimationLoader.loadHeader(this.headerRes));
                this.unCompiled = false;
            }
        } else {
            assert (this.model != null);
            Tessellator tes = Tessellator.func_178181_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            this.draw(stack, (model instanceof IESmartObjModel ? (IESmartObjModel)model : this.model).lastCameraTransform, tes.func_178180_c(), tes, ClientUtils.mc().func_184121_ak());
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public final void reloadModels() {
        this.unCompiled = true;
        this.setTransforms(this.replacementModel);
    }

    @Override
    public void registerSprites(TextureMap map) {
        IIAnimationLoader.preloadTexturesFromMTL(this.headerRes.withExtension(".mtl"), map);
    }

    protected abstract ImmersiveModelRegistry.ItemModelReplacement setTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ var1);

    public abstract void draw(ItemStack var1, ItemCameraTransforms.TransformType var2, BufferBuilder var3, Tessellator var4, float var5);

    public abstract void compileModels(OBJModel var1, IIModelHeader var2);

    protected abstract void nullifyModels();

    protected final boolean is1stPerson(ItemCameraTransforms.TransformType transform) {
        switch (transform) {
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                return true;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                return IIConfigHandler.IIConfig.Graphics.AMTHandDisplayMode == 2;
            }
        }
        return false;
    }

    protected final boolean is3rdPerson(ItemCameraTransforms.TransformType transform) {
        return transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
    }
}

