/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.client.util.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;

public class IIMachineUpgradeModel {
    private final MachineUpgrade upgrade;
    private final IIAnimationCompiledMap animation;
    private final AMT[] model;
    private final AMT assembledModel;
    private final int steps;

    public IIMachineUpgradeModel(MachineUpgrade upgrade, ResourceLocation model, ResourceLocation animation) {
        this(upgrade, IIAnimationUtils.getAMTFromRes(model, new ResourceLocation(model.func_110624_b(), model.func_110623_a().replace(".obj.ie", ".obj.amt"))), animation);
    }

    public IIMachineUpgradeModel(MachineUpgrade upgrade, AMT[] model, ResourceLocation animation) {
        this.upgrade = upgrade;
        IIAnimation loaded = IIAnimationLoader.loadAnimation(animation);
        this.animation = IIAnimationCompiledMap.create(model, new IIAnimation(new ResourceLocation(""), (IIAnimation.IIAnimationGroup[])Arrays.stream(loaded.groups).map(g -> new IIAnimation.IIAnimationGroup(g.groupName, g.position, g.scale, g.rotation, null, this.vecToAlpha(g.position), null)).toArray(IIAnimation.IIAnimationGroup[]::new)));
        this.steps = this.animation.size();
        upgrade.setRequiredSteps(this.steps);
        this.model = (AMT[])Arrays.stream(model).filter(this.animation::containsKey).toArray(AMT[]::new);
        this.assembledModel = IIAnimationUtils.batchMultipleAMTQuads(this.model, "batched");
    }

    @Nullable
    private IIAnimation.IIShaderLine vecToAlpha(IIAnimation.IIVectorLine position) {
        if (position == null || ((Vec3d[])position.values).length < 2) {
            return null;
        }
        return new IIAnimation.IIShaderLine(ShaderUtil.Shaders.ALPHA, new float[]{0.0f, position.timeframes[0], position.timeframes[position.timeframes.length - 1], 1.0f}, new Float[][]{{Float.valueOf(0.0f)}, {Float.valueOf(0.0f)}, {Float.valueOf(1.0f)}, {Float.valueOf(1.0f)}});
    }

    public UpgradeStage renderConstruction(IUpgradableMachine machine, Tessellator tes, BufferBuilder buf, float partialTicks) {
        if (machine.getCurrentlyInstalled() != this.upgrade) {
            return machine.hasUpgrade(this.upgrade) ? UpgradeStage.INSTALLED : UpgradeStage.NOT_INSTALLED;
        }
        int maxProgress = IIContent.UPGRADE_INSERTER.getProgressRequired();
        double maxClientProgress = IIUtils.getMaxClientProgress(machine.getInstallProgress(), maxProgress, this.steps);
        double currentProgress = (int)Math.min((double)((float)machine.getClientInstallProgress() + partialTicks * ((float)IIConfigHandler.IIConfig.Tools.wrenchUpgradeProgress * 0.5f)), maxClientProgress);
        float install = (float)MathHelper.func_151237_a((double)(currentProgress / (double)maxProgress), (double)0.0, (double)1.0);
        ShaderUtil.useBlueprint(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        this.assembledModel.render(tes, buf);
        ShaderUtil.releaseShader();
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        this.animation.apply(install);
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        return UpgradeStage.IN_PROGRESS;
    }

    public IIMachineUpgradeModel disposeOf() {
        IIAnimationUtils.disposeOf(this.model);
        return null;
    }

    public void defaultize() {
        for (AMT mod : this.model) {
            mod.defaultize();
        }
    }

    public void render(Tessellator tes, BufferBuilder buf) {
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }

    @Nonnull
    public AMT getPart(String name) {
        return IIAnimationUtils.getPart(this.model, name);
    }

    public static enum UpgradeStage {
        INSTALLED,
        IN_PROGRESS,
        NOT_INSTALLED;

    }
}

