/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTQuads;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.EntityAMTTactile;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIModelHeader {
    private final HashMap<String, String> hierarchy;
    private final HashMap<String, Vec3d> offsets;
    private final HashMap<String, EasyNBT> properties;
    private final HashMap<ItemCameraTransforms.TransformType, Matrix4> transforms;

    public IIModelHeader(JsonObject json) {
        JsonObject prop;
        this.offsets = new HashMap();
        this.hierarchy = new HashMap();
        this.properties = new HashMap();
        this.transforms = new HashMap();
        if (json.has("origins")) {
            JsonObject origins = json.getAsJsonObject("origins");
            for (Map.Entry entry : origins.entrySet()) {
                this.offsets.put((String)entry.getKey(), IIAnimationUtils.jsonToVec3d(((JsonElement)entry.getValue()).getAsJsonArray()).func_186678_a(0.0625));
            }
        }
        if (json.has("hierarchy")) {
            JsonObject hh = json.getAsJsonObject("hierarchy");
            for (Map.Entry entry : hh.entrySet()) {
                if (((JsonElement)entry.getValue()).getAsString().isEmpty()) continue;
                this.hierarchy.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        if (json.has("properties")) {
            prop = json.getAsJsonObject("properties");
            for (Map.Entry entry : prop.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                this.properties.put((String)entry.getKey(), EasyNBT.parseEasyNBT(((JsonElement)entry.getValue()).toString(), new Object[0]));
            }
        }
        if (json.has("transforms")) {
            prop = json.getAsJsonObject("transforms");
            for (Map.Entry entry : prop.entrySet()) {
                JsonElement translate;
                JsonElement rotate;
                Vec3d vec;
                JsonElement scale;
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject transform = ((JsonElement)entry.getValue()).getAsJsonObject();
                Matrix4 matrix = new Matrix4();
                if (transform.has("scale") && (scale = transform.get("scale")).isJsonArray()) {
                    vec = IIAnimationUtils.jsonToVec3d(scale.getAsJsonArray());
                    matrix.scale(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                if (transform.has("rotate") && (rotate = transform.get("rotate")).isJsonArray()) {
                    vec = IIAnimationUtils.jsonToVec3d(rotate.getAsJsonArray());
                    matrix.rotate(Math.toRadians(vec.field_72450_a), 1.0, 0.0, 0.0);
                    matrix.rotate(Math.toRadians(vec.field_72448_b), 0.0, 1.0, 0.0);
                    matrix.rotate(Math.toRadians(vec.field_72449_c), 0.0, 0.0, 1.0);
                }
                if (transform.has("translate") && (translate = transform.get("translate")).isJsonArray()) {
                    vec = IIAnimationUtils.jsonToVec3d(translate.getAsJsonArray());
                    matrix.translate(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                this.transforms.put(ItemCameraTransforms.TransformType.valueOf((String)((String)entry.getKey()).toUpperCase()), matrix);
            }
        }
    }

    public IIModelHeader(IIModelHeader ... headers) {
        this.hierarchy = new HashMap();
        this.offsets = new HashMap();
        this.properties = new HashMap();
        this.transforms = new HashMap();
        if (headers != null) {
            for (IIModelHeader h : headers) {
                this.hierarchy.putAll(h.hierarchy);
                this.offsets.putAll(h.offsets);
                this.properties.putAll(h.properties);
                this.transforms.putAll(h.transforms);
            }
        }
    }

    public Set<String> getAffectedElements() {
        return this.offsets.keySet();
    }

    @Nonnull
    public Vec3d getOffset(String name) {
        return this.offsets.getOrDefault(name, Vec3d.field_186680_a);
    }

    @SideOnly(value=Side.CLIENT)
    public void applyHierarchy(Collection<AMT> amts) {
        for (AMT amt : amts) {
            EasyNBT nbt;
            AMT[] children = (AMT[])amts.stream().filter(child -> this.hierarchy.getOrDefault(child.name, "").equals(amt.name)).map(AMT::setChild).toArray(AMT[]::new);
            if (children.length > 0) {
                amt.setChildren(children);
            }
            if ((nbt = this.properties.get(amt.name)) == null || !(amt instanceof AMTQuads)) continue;
            nbt.checkSetBoolean("lighting", ((AMTQuads)amt)::setLighting);
        }
    }

    public void applyHierarchy(ArrayList<EntityAMTTactile> amts) {
        for (EntityAMTTactile amt : amts) {
            String parentName = this.hierarchy.get(amt.name);
            if (parentName == null || parentName.isEmpty()) continue;
            amts.stream().filter(a -> a.name.equals(parentName)).findAny().ifPresent(amt::setParent);
        }
    }

    public void applyTransforms(ImmersiveModelRegistry.ItemModelReplacement_OBJ model) {
        for (Map.Entry<ItemCameraTransforms.TransformType, Matrix4> entry : this.transforms.entrySet()) {
            model.setTransformations(entry.getKey(), entry.getValue());
        }
    }
}

