/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.client.util.CameraHandler;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTModelCache;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCachedMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIItemRendererAMT;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIUpgradableTool;

public abstract class IIUpgradableItemRendererAMT<I extends ItemIIUpgradableTool>
extends IIItemRendererAMT<I> {
    protected static final ResLoc RES_MODEL_WEAPON = ResLoc.of(IIReference.RES_ITEM_MODEL, "weapons/%1$s/%1$s");
    protected final ResLoc animationRes;
    protected final ResLoc directoryRes;
    public final HashMap<Predicate<EasyNBT>, String> UPGRADE_PARTS = new HashMap();
    private final HashMap<Predicate<EasyNBT>, IIAnimationCachedMap> UPGRADES = new HashMap();
    protected AMTModelCache<ItemStack> model;
    IIAnimationCachedMap upgradeVisibility;

    public IIUpgradableItemRendererAMT(@Nonnull I item, ResLoc modelRes) {
        super(item, modelRes);
        this.animationRes = ResLoc.of(IIReference.RES_II, ((ItemIIUpgradableTool)((Object)item)).itemName, "/");
        this.directoryRes = modelRes.asDirectory();
    }

    @Override
    protected void nullifyModels() {
        IIAnimationUtils.disposeOf(this.model);
    }

    protected final void showUpgrades(ItemStack stack, EasyNBT nbt) {
        EasyNBT upgrades = nbt.getEasyCompound("upgrades");
        this.upgradeVisibility.apply(0.0f);
        if (!upgrades.isEmpty()) {
            this.UPGRADES.forEach((key, value) -> {
                if (key.test(upgrades)) {
                    value.apply(0.0f);
                }
            });
        }
    }

    protected final OBJModel[] listUpgradeModels() {
        return (OBJModel[])this.UPGRADE_PARTS.values().stream().map(s -> ResLoc.of(this.directoryRes, "upgrades/", s).withExtension(".obj")).map(IIAnimationUtils::modelFromRes).toArray(OBJModel[]::new);
    }

    protected final void loadUpgrades(OBJModel model, ResourceLocation location) {
        this.UPGRADES.clear();
        this.UPGRADE_PARTS.forEach((pred, str) -> this.UPGRADES.put((Predicate<EasyNBT>)pred, IIAnimationCachedMap.create(this.model, new ResourceLocation(location.func_110624_b(), location.func_110623_a() + str))));
        this.upgradeVisibility = IIAnimationCachedMap.createVisibilityAnimation(this.model, model);
    }

    protected final boolean isScopeZooming(ItemCameraTransforms.TransformType transform, ItemStack stack) {
        return this.is1stPerson(transform) && CameraHandler.zoom != null && CameraHandler.zoom.getZoomProgress(stack, null) == 1.0f;
    }

    public void addUpgradePart(Predicate<EasyNBT> predicate, String name) {
        this.UPGRADE_PARTS.put(predicate, name);
    }
}

