/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.util.amt;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJModel;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationLoader;

public class MTLTextureRemapper
implements Function<ResourceLocation, ResourceLocation> {
    private final Map<ResourceLocation, ResourceLocation> map;

    public MTLTextureRemapper(Map<String, ResourceLocation> source, Map<String, ResourceLocation> destination) {
        this.map = source.entrySet().stream().filter(e -> destination.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getValue, e -> (ResourceLocation)destination.get(e.getKey())));
    }

    public MTLTextureRemapper(OBJModel source, ResourceLocation destination) {
        this(MTLTextureRemapper.getSourceMap(source), IIAnimationLoader.loadMTL(destination));
    }

    public MTLTextureRemapper(OBJModel.OBJBakedModel source, ResourceLocation destination) {
        this(source.getModel(), destination);
    }

    private static Map<String, ResourceLocation> getSourceMap(OBJModel source) {
        OBJModel.MaterialLibrary matLib = source.getMatLib();
        ImmutableList materials = matLib.getMaterialNames();
        return materials.stream().collect(Collectors.toMap(m -> m, m -> matLib.getMaterial(m).getTexture().getTextureLocation()));
    }

    @Override
    public ResourceLocation apply(ResourceLocation res) {
        return this.map.getOrDefault(res, res);
    }
}

