/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityChargingStation;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.CorrosionHandler;
import pl.pabilo8.immersiveintelligence.api.LighterFuelHandler;
import pl.pabilo8.immersiveintelligence.api.MachinegunCoolantHandler;
import pl.pabilo8.immersiveintelligence.api.ShrapnelHandler;
import pl.pabilo8.immersiveintelligence.api.VehicleFuelHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.crafting.DustUtils;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.MinecartBlockHelper;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.EventHandler;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IICreativeTab;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.IISaveData;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentFirework;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentFish;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentFlarePowder;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentPropaganda;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentTesla;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentTracerPowder;
import pl.pabilo8.immersiveintelligence.common.ammo.AmmoComponentWhitePhosphorus;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCoreBrass;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCoreLead;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCorePabilium;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCoreSteel;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCoreTungsten;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCoreUranium;
import pl.pabilo8.immersiveintelligence.common.ammo.explosives.AmmoComponentHMX;
import pl.pabilo8.immersiveintelligence.common.ammo.explosives.AmmoComponentNuke;
import pl.pabilo8.immersiveintelligence.common.ammo.explosives.AmmoComponentRDX;
import pl.pabilo8.immersiveintelligence.common.ammo.explosives.AmmoComponentTNT;
import pl.pabilo8.immersiveintelligence.common.ammo.factory.AmmoComponentFluid;
import pl.pabilo8.immersiveintelligence.common.ammo.factory.AmmoComponentShrapnel;
import pl.pabilo8.immersiveintelligence.common.block.data_device.BlockIIDataDevice;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubber;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberCovered;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberCoveredDropper;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberCoveredExtract;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberCoveredVertical;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberDropper;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberExtract;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberSplitter;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberUncontrolled;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberVertical;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIIOre;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIISmallCrate;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;
import pl.pabilo8.immersiveintelligence.common.crafting.IIRecipes;
import pl.pabilo8.immersiveintelligence.common.crafting.RecipePowerpackAdvanced;
import pl.pabilo8.immersiveintelligence.common.crafting.RecipeSkinCraftingHandler;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.EntityGasCloud;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.EntityIIChemthrowerShot;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMortar;
import pl.pabilo8.immersiveintelligence.common.entity.EntityParachute;
import pl.pabilo8.immersiveintelligence.common.entity.EntitySkyCrate;
import pl.pabilo8.immersiveintelligence.common.entity.EntitySkycrateInternal;
import pl.pabilo8.immersiveintelligence.common.entity.EntityTripodPeriscope;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityAtomicBoom;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityFlare;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityNavalMine;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityNavalMineAnchor;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityShrapnel;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityWhitePhosphorus;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansUtils;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.barrel.EntityMinecartBarrelSteel;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.barrel.EntityMinecartBarrelWooden;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.capacitor.EntityMinecartCapacitorCreative;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.capacitor.EntityMinecartCapacitorHV;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.capacitor.EntityMinecartCapacitorLV;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.capacitor.EntityMinecartCapacitorMV;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.crate.EntityMinecartCrateReinforced;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.crate.EntityMinecartCrateSteel;
import pl.pabilo8.immersiveintelligence.common.entity.minecart.crate.EntityMinecartCrateWooden;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.EntityAMTTactile;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityDrone;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityMotorbike;
import pl.pabilo8.immersiveintelligence.common.entity.vehicle.EntityVehicleSeat;
import pl.pabilo8.immersiveintelligence.common.gui.ContainerUpgrade;
import pl.pabilo8.immersiveintelligence.common.item.ItemIIMinecart;
import pl.pabilo8.immersiveintelligence.common.item.crafting.material.ItemIIMaterialDust;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.util.IBatchOredictRegister;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIIFluid;
import pl.pabilo8.immersiveintelligence.common.util.block.IIBlockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.wire.IIDataWireType;
import pl.pabilo8.immersiveintelligence.common.world.IIWorldGen;

@Mod.EventBusSubscriber(modid="immersiveintelligence")
public class CommonProxy
implements IGuiHandler,
ForgeChunkManager.LoadingCallback {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IILogger.info("Registering Blocks");
        for (Block block : IIContent.BLOCKS) {
            event.getRegistry().register(block.setRegistryName(CommonProxy.createRegistryName(block.func_149739_a())));
        }
        WireApi.registerFeedthroughForWiretype((WireType)IIDataWireType.DATA, (ResourceLocation)new ResourceLocation("immersiveintelligence", "block/connector/data_connector.obj.ie"), (ResourceLocation)new ResourceLocation("immersiveintelligence", "blocks/data_connector_feedtrough"), (float[])new float[]{4.0f, 4.0f, 12.0f, 12.0f}, (double)0.75, (IBlockState)IIContent.blockDataConnector.func_176203_a(BlockIIDataDevice.IIBlockTypes_Connector.DATA_CONNECTOR.getMeta()), (float)0.0f, (float)0.0f, f -> f);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IILogger.info("Registering Items");
        for (Item item : IIContent.ITEMS) {
            event.getRegistry().register(item.setRegistryName(CommonProxy.createRegistryName(item.func_77658_a())));
        }
        CommonProxy.registerOreDict();
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        IILogger.info("Registering Potions");
        IIPotions.init();
        for (Block block : IIContent.BLOCKS) {
            if (!(block instanceof BlockIIFluid)) continue;
            BlockIIFluid b = (BlockIIFluid)block;
            if (b.isAcid) {
                b.setPotionEffects(new PotionEffect(IIPotions.corrosion, 40, 1));
            }
            b.addToChemthrower();
        }
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IILogger.info("Registering Biomes");
        event.getRegistry().register((IForgeRegistryEntry)IIContent.biomeWasteland);
    }

    public static void registerOreDict() {
        int meta;
        String[] ores;
        IILogger.info("Registering OreDictionary");
        IIRecipes.addForeignOreDict();
        for (Item item : IIContent.ITEMS) {
            if (item instanceof ItemIISubItemsBase) {
                ores = CommonProxy.getAnnotatedOreDict(item);
                for (Enum subItem : ((ItemIISubItemsBase)item).getSubItems()) {
                    meta = subItem.getMeta();
                    if (((ItemIISubItemsBase)item).isMetaHidden(meta)) continue;
                    if (ores != null) {
                        for (String ore : ores) {
                            OreDictionary.registerOre((String)IIUtils.toCamelCase(ore + "_" + subItem.func_176610_l(), true), (ItemStack)new ItemStack(item, 1, meta));
                        }
                    }
                    for (String ore : subItem.getOreDict()) {
                        OreDictionary.registerOre((String)ore, (ItemStack)new ItemStack(item, 1, meta));
                    }
                }
                continue;
            }
            if (!(item instanceof ItemIIBase) || (ores = CommonProxy.getAnnotatedOreDict(item)) == null) continue;
            for (String ore : ores) {
                OreDictionary.registerOre((String)IIUtils.toCamelCase(ore, true), (ItemStack)new ItemStack(item));
            }
        }
        for (Block block : IIContent.BLOCKS) {
            if (!(block instanceof BlockIIBase)) continue;
            ores = CommonProxy.getAnnotatedOreDict(block);
            for (Object enumValue : ((BlockIIBase)block).enumValues) {
                IIBlockInterfaces.IIBlockProperties properties;
                meta = enumValue.getMeta();
                if (ores != null) {
                    for (String ore : ores) {
                        OreDictionary.registerOre((String)IIUtils.toCamelCase(ore + "_" + enumValue.func_176610_l(), true), (ItemStack)new ItemStack(block, 1, meta));
                    }
                }
                if ((properties = enumValue.getProperties()) == null) continue;
                String[] stringArray = properties.oreDict();
                int n = stringArray.length;
                for (int ore = 0; ore < n; ++ore) {
                    String ore2 = stringArray[ore];
                    OreDictionary.registerOre((String)ore2, (ItemStack)new ItemStack(block, 1, meta));
                }
            }
        }
        for (Field field : IIContent.class.getFields()) {
            if (!field.isAnnotationPresent(IBatchOredictRegister.class)) continue;
            IBatchOredictRegister annotation = field.getAnnotation(IBatchOredictRegister.class);
            String[] ores2 = annotation.oreDict();
            try {
                Object o = field.get(null);
                if (o instanceof BlockIIBase) {
                    BlockIIBase block = (BlockIIBase)((Object)field.get(null));
                    for (String enumValue : block.enumValues) {
                        for (String ore : ores2) {
                            OreDictionary.registerOre((String)IIUtils.toCamelCase(ore + "_" + enumValue.func_176610_l(), true), (ItemStack)new ItemStack((Block)block, 1, enumValue.getMeta()));
                        }
                    }
                    continue;
                }
                if (!(o instanceof ItemIIBase)) continue;
                ItemIIBase item = (ItemIIBase)((Object)field.get(null));
                for (String ore : ores2) {
                    OreDictionary.registerOre((String)IIUtils.toCamelCase(ore, true), (ItemStack)new ItemStack((Item)item, 1, Short.MAX_VALUE));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onSave(WorldEvent.Save event) {
        IISaveData.setDirty(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload event) {
        IISaveData.setDirty(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IILogger.info("Registering Recipes");
        String sulfur = OreDictionary.doesOreNameExist((String)"oreSulfur") ? "oreSulfur" : "dustSulfur";
        ExcavatorHandler.MineralMix mineralFluorite = ExcavatorHandler.addMineral((String)"Fluorite", (int)25, (float)0.65f, (String[])new String[]{"oreFluorite", "oreQuartz"}, (float[])new float[]{0.5f, 0.25f});
        ExcavatorHandler.MineralMix mineralPhosphorite = ExcavatorHandler.addMineral((String)"Phosphorite", (int)30, (float)0.45f, (String[])new String[]{"orePhosphorus", sulfur, "oreIron", "oreAluminum"}, (float[])new float[]{0.65f, 0.125f, 0.0625f, 0.0125f});
        mineralFluorite.dimensionWhitelist = new int[]{-1};
        mineralPhosphorite.dimensionWhitelist = new int[]{-1};
        ExcavatorHandler.addMineral((String)"Wolframite", (int)15, (float)0.15f, (String[])new String[]{"oreTungsten", "oreIron"}, (float[])new float[]{0.25f, 0.75f});
        ExcavatorHandler.addMineral((String)"Ferberite", (int)10, (float)0.2f, (String[])new String[]{"oreTungsten", "oreIron", "oreTin"}, (float[])new float[]{0.2f, 0.4f, 0.3f});
        LighterFuelHandler.addFuel(FluidRegistry.getFluid((String)"creosote"), 100);
        LighterFuelHandler.addFuel(FluidRegistry.getFluid((String)"ethanol"), 20);
        MachinegunCoolantHandler.addCoolant(FluidRegistry.WATER, 1);
        CrusherRecipe.addRecipe((ItemStack)IIContent.itemMaterialDust.getStack(ItemIIMaterialDust.MaterialsDust.SILICON, 1), (Object)new IngredientStack("plateSilicon"), (int)12000);
        IIRecipes.doRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
        IICompatModule.doModulesRecipes();
        event.getRegistry().register(new RecipeSkinCraftingHandler().setRegistryName("immersiveintelligence", "contributor_skin"));
        event.getRegistry().register(new RecipePowerpackAdvanced().setRegistryName("immersiveintelligence", "powerpack_advanced"));
        assert (IIContent.itemAdvancedPowerPack.getRegistryName() != null);
        if (Arrays.stream(Config.IEConfig.Tools.powerpack_blacklist).noneMatch(s -> s.equals(IIContent.itemAdvancedPowerPack.getRegistryName().toString()))) {
            ArrayList<String> collect = new ArrayList<String>(Arrays.asList(Config.IEConfig.Tools.powerpack_blacklist));
            collect.add(IIContent.itemAdvancedPowerPack.getRegistryName().toString());
            Config.IEConfig.Tools.powerpack_blacklist = collect.toArray(new String[0]);
        }
        VehicleFuelHandler.addVehicle(EntityMotorbike.class, FluidRegistry.getFluid((String)"diesel"), FluidRegistry.getFluid((String)"biodiesel"));
    }

    public void preInit() {
        IIDataWireType.init();
        IIPacketHandler.preInit();
        CapabilityRotaryEnergy.register();
        IEApi.prefixToIngotMap.put("spring", new Integer[]{2, 1});
        IIContent.init();
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoArtillery);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoMortar);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoLightArtillery);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoAutocannon);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemGrenade);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemRailgunGrenade);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoMachinegun);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoSubmachinegun);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoAssaultRifle);
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemAmmoRevolver);
        if (IIContent.blockTripmine.itemBlock != null) {
            AmmoRegistry.INSTANCE.registerBulletItem((IAmmo)((Object)IIContent.blockTripmine.itemBlock));
        }
        if (IIContent.blockTellermine.itemBlock != null) {
            AmmoRegistry.INSTANCE.registerBulletItem((IAmmo)((Object)IIContent.blockTellermine.itemBlock));
        }
        if (IIContent.blockRadioExplosives.itemBlock != null) {
            AmmoRegistry.INSTANCE.registerBulletItem((IAmmo)((Object)IIContent.blockRadioExplosives.itemBlock));
        }
        AmmoRegistry.INSTANCE.registerBulletItem(IIContent.itemNavalMine);
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentTNT());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentRDX());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentHMX());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentNuke());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentWhitePhosphorus());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentFirework());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentTracerPowder());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentFlarePowder());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentPropaganda());
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentTesla());
        AmmoRegistry.INSTANCE.registerBulletCore(new AmmoCoreSteel());
        AmmoRegistry.INSTANCE.registerBulletCore(new AmmoCoreTungsten());
        AmmoRegistry.INSTANCE.registerBulletCore(new AmmoCoreBrass());
        AmmoRegistry.INSTANCE.registerBulletCore(new AmmoCoreLead());
        AmmoRegistry.INSTANCE.registerBulletCore(new AmmoCoreUranium());
        DustUtils.registerDust(new IngredientStack("gunpowder", 100), "gunpowder", 0x242424);
        DustUtils.registerDust(new IngredientStack("smallGunpowder", 25), "gunpowder");
        DustUtils.registerDust(new IngredientStack("dustSulfur", 100), "sulfur", 12296989);
        DustUtils.registerDust(new IngredientStack("dustSmallSulfur", 25), "sulfur");
        DustUtils.registerDust(new IngredientStack("dustWood", 100), "sawdust", 9208425);
        DustUtils.registerDust(new IngredientStack("dustSmallWood", 25), "sawdust", 9208425);
        DustUtils.registerDust(new IngredientStack("sand", 100), "sand", 11314043);
        DustUtils.registerDust(new IngredientStack("gravel", 100), "gravel", 3684663);
        ShrapnelHandler.addShrapnel("aluminum", 14281962, "immersiveengineering:textures/blocks/sheetmetal_aluminum", 1, 0.05f, 0.0f);
        ShrapnelHandler.addShrapnel("zinc", 14607324, "immersiveintelligence:textures/blocks/metal/sheetmetal_zinc", 1, 0.15f, 0.0f);
        ShrapnelHandler.addShrapnel("copper", 14908454, "immersiveengineering:textures/blocks/sheetmetal_copper", 2, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("platinum", 14213601, "immersiveintelligence:textures/blocks/metal/sheetmetal_platinum", 2, 0.05f, 0.0f);
        ShrapnelHandler.addShrapnel("gold", 13742137, "minecraft:textures/blocks/gold_block", 2, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("nickel", 0x838877, "immersiveengineering:textures/blocks/sheetmetal_nickel", 2, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("silver", 10996424, "immersiveengineering:textures/blocks/sheetmetal_silver", 2, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("electrum", 16166233, "immersiveengineering:textures/blocks/sheetmetal_electrum", 2, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("constantan", 16348246, "immersiveengineering:textures/blocks/sheetmetal_constantan", 3, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("brass", 9795395, "immersiveintelligence:textures/blocks/metal/sheetmetal_brass", 3, 0.35f, 0.0f);
        ShrapnelHandler.addShrapnel("iron", 0xC7C7C7, "minecraft:textures/blocks/iron_block", 4, 0.25f, 0.0f);
        ShrapnelHandler.addShrapnel("lead", 3817028, "immersiveengineering:textures/blocks/sheetmetal_lead", 4, 0.75f, 0.0f);
        ShrapnelHandler.addShrapnel("steel", 0x4D4D4D, "immersiveengineering:textures/blocks/sheetmetal_steel", 6, 0.35f, 0.0f);
        ShrapnelHandler.addShrapnel("tungsten", 3882563, "immersiveintelligence:textures/blocks/metal/sheetmetal_tungsten", 7, 0.45f, 0.0f);
        ShrapnelHandler.addShrapnel("HOPGraphite", 0x282828, "immersiveengineering:textures/blocks/stone_decoration_coke", 7, 0.45f, 0.0f);
        ShrapnelHandler.addShrapnel("uranium", 6656617, "immersiveengineering:textures/blocks/sheetmetal_uranium", 8, 0.45f, 8.0f);
        AmmoRegistry.INSTANCE.registerComponent(new AmmoComponentFish());
        AmmoRegistry.INSTANCE.registerBulletCore(new AmmoCorePabilium());
        for (Map.Entry<String, ShrapnelHandler.Shrapnel> s : ShrapnelHandler.registry.entrySet()) {
            AmmoComponentShrapnel shrapnel = new AmmoComponentShrapnel(s.getKey());
            AmmoRegistry.INSTANCE.registerComponent(shrapnel);
        }
        BulletHandler.registerBullet((String)"ii_bullet", (BulletHandler.IBullet)IIContent.itemAmmoRevolver);
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_conveyor"), ConveyorRubber.class, tileEntity -> new ConveyorRubber());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_uncontrolled"), ConveyorRubberUncontrolled.class, tileEntity -> new ConveyorRubberUncontrolled());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_dropper"), ConveyorRubberDropper.class, tileEntity -> new ConveyorRubberDropper());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_droppercovered"), ConveyorRubberCoveredDropper.class, tileEntity -> new ConveyorRubberCoveredDropper());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_vertical"), ConveyorRubberVertical.class, tileEntity -> new ConveyorRubberVertical());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_splitter"), ConveyorRubberSplitter.class, tileEntity -> new ConveyorRubberSplitter(tileEntity instanceof ConveyorHandler.IConveyorTile ? ((ConveyorHandler.IConveyorTile)tileEntity).getFacing() : EnumFacing.NORTH));
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_covered"), ConveyorRubberCovered.class, tileEntity -> new ConveyorRubberCovered());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_verticalcovered"), ConveyorRubberCoveredVertical.class, tileEntity -> new ConveyorRubberCoveredVertical());
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_extract"), ConveyorRubberExtract.class, tileEntity -> new ConveyorRubberExtract(tileEntity instanceof ConveyorHandler.IConveyorTile ? ((ConveyorHandler.IConveyorTile)tileEntity).getFacing() : EnumFacing.NORTH));
        ConveyorHandler.registerConveyorHandler((ResourceLocation)new ResourceLocation("immersiveintelligence", "rubber_extractcovered"), ConveyorRubberCoveredExtract.class, tileEntity -> new ConveyorRubberCoveredExtract(tileEntity instanceof ConveyorHandler.IConveyorTile ? ((ConveyorHandler.IConveyorTile)tileEntity).getFacing() : EnumFacing.NORTH));
        IICompatModule.doModulesPreInit();
    }

    public void init() {
        IICompatModule.doModulesInit();
        EventHandler handler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
            AmmoComponentFluid comp = new AmmoComponentFluid(f);
            AmmoRegistry.INSTANCE.registerComponent(comp);
        }
        IIContent.blockFluidInkBlack.setPotionEffects(new PotionEffect(IEPotions.sticky, 60, 0));
        IIContent.blockFluidInkCyan.setPotionEffects(new PotionEffect(IEPotions.sticky, 60, 0));
        IIContent.blockFluidInkMagenta.setPotionEffects(new PotionEffect(IEPotions.sticky, 60, 0));
        IIContent.blockFluidInkYellow.setPotionEffects(new PotionEffect(IEPotions.sticky, 60, 0));
        IIContent.blockFluidLatex.setPotionEffects(new PotionEffect(IEPotions.sticky, 60, 0));
        for (Block block : IIContent.BLOCKS) {
            if (!(block instanceof BlockIIBase)) continue;
            ((BlockIIBase)block).parseSubBlocks();
        }
        IILogger.info("Registering Worldgen");
        IIWorldGen iiWorldGen = new IIWorldGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)iiWorldGen, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)iiWorldGen);
        IILogger.info("Adding oregen");
        CommonProxy.addConfiguredWorldgen(IIContent.blockOre.func_176203_a(BlockIIOre.Ores.PLATINUM.getMeta()), "platinum", IIConfigHandler.IIConfig.Ores.orePlatinum, IIWorldGen.EnumOreType.OVERWORLD);
        CommonProxy.addConfiguredWorldgen(IIContent.blockOre.func_176203_a(BlockIIOre.Ores.ZINC.getMeta()), "zinc", IIConfigHandler.IIConfig.Ores.oreZinc, IIWorldGen.EnumOreType.OVERWORLD);
        CommonProxy.addConfiguredWorldgen(IIContent.blockOre.func_176203_a(BlockIIOre.Ores.TUNGSTEN.getMeta()), "tungsten", IIConfigHandler.IIConfig.Ores.oreTungsten, IIWorldGen.EnumOreType.OVERWORLD);
        CommonProxy.addConfiguredWorldgen(IIContent.blockOre.func_176203_a(BlockIIOre.Ores.SALT.getMeta()), "salt", IIConfigHandler.IIConfig.Ores.oreSalt, IIWorldGen.EnumOreType.OVERWORLD);
        CommonProxy.addConfiguredWorldgen(IIContent.blockOre.func_176203_a(BlockIIOre.Ores.FLUORITE.getMeta()), "fluorite", IIConfigHandler.IIConfig.Ores.oreFluorite, IIWorldGen.EnumOreType.NETHER);
        CommonProxy.addConfiguredWorldgen(IIContent.blockOre.func_176203_a(BlockIIOre.Ores.PHOSPHORUS.getMeta()), "phosphorus", IIConfigHandler.IIConfig.Ores.orePhosphorus, IIWorldGen.EnumOreType.NETHER);
        IEApi.forbiddenInCrates.add(stack -> {
            if (OreDictionary.itemMatches((ItemStack)new ItemStack((Block)IIContent.blockMetalDevice, 1, 0), (ItemStack)stack, (boolean)true)) {
                return true;
            }
            if (stack.func_77973_b() == IIContent.itemMinecart) {
                return true;
            }
            return OreDictionary.itemMatches((ItemStack)new ItemStack((Block)IIContent.blockMetalDevice, 1, 1), (ItemStack)stack, (boolean)true);
        });
        IIContent.tileEntitiesWeDontLike.add(tileEntity -> tileEntity instanceof TileEntityChargingStation);
        IEApi.forbiddenInCrates.add(stack -> stack.func_77973_b() instanceof ItemBlockIEBase && ((ItemBlockIEBase)stack.func_77973_b()).func_179223_d() instanceof BlockIISmallCrate);
        IEApi.forbiddenInCrates.add(stack -> stack.func_77973_b() == IIContent.itemCasingPouch);
        IILogger.info("Adding TileEntities");
        IIContent.TILE_ENTITIES.stream().distinct().forEach(CommonProxy::registerTile);
        IILogger.info("Registering Multiblocks");
        IIContent.MULTIBLOCKS.forEach(MultiblockHandler::registerMultiblock);
        int i = -1;
        CommonProxy.registerEntity(i++, EntityMinecartCrateWooden.class, "minecart_wooden_crate", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartCrateReinforced.class, "minecart_reinforced_crate", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartCrateSteel.class, "minecart_steel_crate", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartBarrelWooden.class, "minecart_wooden_barrel", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartBarrelSteel.class, "minecart_metal_barrel", 64, 1, true);
        CommonProxy.registerEntity(i++, EntitySkyCrate.class, "skycrate", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityBullet.class, "bullet", 32, 1, true);
        CommonProxy.registerEntity(i++, EntityNavalMine.class, "naval_mine", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityNavalMineAnchor.class, "naval_mine_anchor", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityShrapnel.class, "shrapnel", 16, 1, true);
        CommonProxy.registerEntity(i++, EntityWhitePhosphorus.class, "white_phosphorus", 16, 1, true);
        CommonProxy.registerEntity(i++, EntityMachinegun.class, "machinegun", 64, 1, true);
        CommonProxy.registerEntity(i++, EntitySkycrateInternal.class, "skycrate_internal", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMotorbike.class, "motorbike", 64, 20, true);
        CommonProxy.registerEntity(i++, EntityFieldHowitzer.class, "field_howitzer", 64, 20, true);
        CommonProxy.registerEntity(i++, EntityVehicleSeat.class, "seat", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityTripodPeriscope.class, "tripod_periscope", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityAtomicBoom.class, "atomic_boom", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityGasCloud.class, "gas_cloud", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityHans.class, "hans", 64, 4, true);
        CommonProxy.registerEntity(i++, EntityFlare.class, "flare", 64, 4, true);
        CommonProxy.registerEntity(i++, EntityParachute.class, "parachute", 64, 4, true);
        CommonProxy.registerEntity(i++, EntityEmplacementWeapon.class, "emplacement_weapon", 64, 4, false);
        CommonProxy.registerEntity(i++, EntityMortar.class, "mortar", 64, 1, false);
        CommonProxy.registerEntity(i++, EntityMinecartCapacitorLV.class, "minecart_capacitor_lv", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartCapacitorMV.class, "minecart_capacitor_mv", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartCapacitorHV.class, "minecart_capacitor", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityMinecartCapacitorCreative.class, "minecart_capacitor_creative", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityDrone.class, "drone", 64, 1, true);
        CommonProxy.registerEntity(i++, EntityIIChemthrowerShot.class, "chemthrower_shot", 64, 1, true);
        CommonProxy.registerEntity(i, EntityAMTTactile.class, "tactile", 64, 1, true);
    }

    public void postInit() {
        IICompatModule.doModulesPostInit();
        HansUtils.init();
        for (ItemIIMinecart.Minecarts value : ItemIIMinecart.Minecarts.values()) {
            MinecartBlockHelper.blocks.put(stack -> OreDictionary.itemMatches((ItemStack)stack, (ItemStack)value.stack.get(), (boolean)false), world -> value.minecart.apply((World)world, Vec3d.field_186680_a));
        }
        RotaryUtils.ie_rotational_blocks_torque.put(tileEntity -> tileEntity instanceof TileEntityWindmill, aFloat -> Float.valueOf(aFloat.floatValue() * IIConfigHandler.IIConfig.MechanicalDevices.dynamoWindmillTorque));
        RotaryUtils.ie_rotational_blocks_torque.put(tileEntity -> tileEntity instanceof TileEntityWatermill, aFloat -> Float.valueOf(aFloat.floatValue() * IIConfigHandler.IIConfig.MechanicalDevices.dynamoWatermillTorque));
        CorrosionHandler.addItemToBlacklist(new ItemStack((Item)Items.field_151161_ac));
        CorrosionHandler.addItemToBlacklist(new ItemStack((Item)Items.field_151163_ad));
        CorrosionHandler.addItemToBlacklist(new ItemStack((Item)Items.field_151173_ae));
        CorrosionHandler.addItemToBlacklist(new ItemStack((Item)Items.field_151175_af));
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            if (!(mb instanceof MultiblockStuctureBase)) continue;
            ((MultiblockStuctureBase)mb).updateStructure();
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object upgradeMaster;
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        EnumHand hand = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IEItemInterfaces.IGuiItem ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        ItemStack stack = player.func_184586_b(hand);
        if (ID == IIGuiList.GUI_UPGRADE.ordinal() && te instanceof IUpgradableMachine && (upgradeMaster = ((IUpgradableMachine)te).getUpgradeMaster()) != null) {
            return new ContainerUpgrade(player, (TileEntity)((IUpgradableMachine)upgradeMaster));
        }
        if (IIGuiList.values().length > ID) {
            Container opened;
            IIGuiList gui = IIGuiList.values()[ID];
            if (gui.item) {
                return gui.containerFromStack == null ? null : gui.containerFromStack.apply(player, stack, hand);
            }
            if (gui.teClass == null || gui.containerFromTile == null) {
                return null;
            }
            if (te instanceof IEBlockInterfaces.IGuiTile && gui.teClass.isInstance(te) && (opened = gui.containerFromTile.apply(player, te)) != null) {
                ((IEBlockInterfaces.IGuiTile)te).onGuiOpened(player, false);
                return opened;
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return this.getServerGuiElement(ID, player, world, x, y, z);
    }

    public void onServerGuiChangeRequest(TileEntity tile, int gui, EntityPlayer player) {
        if (!(tile instanceof IEBlockInterfaces.IGuiTile) || ((IEBlockInterfaces.IGuiTile)tile).getGuiMaster() == null) {
            return;
        }
        IEBlockInterfaces.IGuiTile te = (IEBlockInterfaces.IGuiTile)((IEBlockInterfaces.IGuiTile)tile).getGuiMaster();
        if (!((TileEntity)te).func_145831_w().field_72995_K && te.canOpenGui(player)) {
            player.openGui((Object)ImmersiveIntelligence.INSTANCE, gui, tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
        }
    }

    public void reloadModels() {
    }

    public void reloadManual() {
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket.getType() != ForgeChunkManager.Type.NORMAL) continue;
            for (ChunkPos chunkPos : ticket.getChunkList()) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
            }
            MinecraftServer minecraftServer = world.func_73046_m();
            if (minecraftServer == null) continue;
            minecraftServer.func_152344_a(() -> ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket));
        }
    }

    private static ResourceLocation createRegistryName(String unlocalized) {
        unlocalized = unlocalized.substring(unlocalized.indexOf("immersiveintelligence"));
        unlocalized = unlocalized.replaceFirst("\\.", ":");
        return new ResourceLocation(unlocalized);
    }

    public static MachineUpgrade createMachineUpgrade(String name) {
        return new MachineUpgrade(name, new ResourceLocation("immersiveintelligence", "textures/gui/upgrade/" + name + ".png"));
    }

    public static void openGuiForItem(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184582_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEItemInterfaces.IGuiItem)) {
            return;
        }
        IEItemInterfaces.IGuiItem gui = (IEItemInterfaces.IGuiItem)stack.func_77973_b();
        player.openGui((Object)ImmersiveIntelligence.INSTANCE, gui.getGuiID(stack), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public static void addConfiguredWorldgen(IBlockState state, String name, int[] config, IIWorldGen.EnumOreType type) {
        if (config != null && config.length >= 5 && config[0] > 0) {
            IIWorldGen.addOreGen(name, state, config[0], config[1], config[2], config[3], config[4], type);
        }
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        String s = tile.getSimpleName();
        s = s.substring(s.indexOf("TileEntity") + "TileEntity".length());
        GameRegistry.registerTileEntity(tile, (ResourceLocation)new ResourceLocation("immersiveintelligence:" + s));
    }

    public static void registerEntity(int id, Class<? extends Entity> entity, String name, int trackingRange, int updateFrequency, boolean sendVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("immersiveintelligence", name), entity, (String)name, (int)id, (Object)ImmersiveIntelligence.INSTANCE, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocityUpdates);
    }

    static String[] getAnnotatedOreDict(Object o) {
        String[] ores = null;
        if (o.getClass().isAnnotationPresent(IBatchOredictRegister.class)) {
            ores = o.getClass().getAnnotation(IBatchOredictRegister.class).oreDict();
        }
        return ores;
    }

    public static Fluid makeFluid(String name, int density, int viscosity) {
        return CommonProxy.makeFluid(name, density, viscosity, "");
    }

    public static Fluid makeFluid(String name, int density, int viscosity, String prefix) {
        Fluid fl = new Fluid(name, new ResourceLocation("immersiveintelligence:blocks/fluid/" + prefix + name + "_still"), new ResourceLocation("immersiveintelligence:blocks/fluid/" + prefix + name + "_flow")).setDensity(density).setViscosity(viscosity);
        FluidRegistry.addBucketForFluid((Fluid)fl);
        if (!FluidRegistry.registerFluid((Fluid)fl)) {
            fl = FluidRegistry.getFluid((String)fl.getName());
        }
        IICreativeTab.fluidBucketMap.add(fl);
        return fl;
    }
}

