/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Iterator;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.api.utils.IAdvancedMultiblock;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.compat.BaublesHelper;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;
import pl.pabilo8.immersiveintelligence.common.crafting.IIRecipes;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.item.armor.ItemIILightEngineerBoots;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBlockDamageSync;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIUpgradeableArmor;

public class EventHandler {
    @SubscribeEvent
    public void onMultiblockForm(MultiblockHandler.MultiblockFormEvent.Post event) {
        if (event.isCancelable() && !event.isCanceled() && event.getMultiblock().getClass().isAnnotationPresent(IAdvancedMultiblock.class) && !IIUtils.isAdvancedHammer(event.getHammer())) {
            if (!event.getEntityPlayer().func_130014_f_().field_72995_K) {
                IIPacketHandler.sendChatTranslation(event.getEntityPlayer(), "info.immersiveintelligence.requires_advanced_hammer", new Object[0]);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().func_184218_aH() && event.getEntity().func_184187_bx() instanceof EntityMachinegun) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockUse(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity().func_184218_aH() && event.getEntity().func_184187_bx() instanceof EntityMachinegun) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEmptyRightclick(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getEntity().func_184218_aH() && event.getEntity().func_184187_bx() instanceof EntityMachinegun) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        DamageBlockPos dpos = null;
        Iterator<DamageBlockPos> iterator = PenetrationRegistry.blockDamage.iterator();
        if (iterator.hasNext()) {
            DamageBlockPos g = iterator.next();
            if (g.dimension != event.getWorld().field_73011_w.getDimension() || event.getPos().equals((Object)g)) {
                // empty if block
            }
            dpos = g;
        }
        if (dpos != null) {
            PenetrationRegistry.blockDamage.remove((Object)dpos);
            dpos.damage = 0.0f;
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBlockDamageSync(dpos), IIPacketHandler.targetPointFromPos((BlockPos)dpos, event.getWorld(), 32));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack powerpack;
        if (!(event.getEntityLiving() instanceof EntityPlayer && ((EntityPlayer)event.getEntityLiving()).func_184812_l_() || event.getEntityLiving().field_70170_p.func_82737_E() % 20L != 0L || event.getEntityLiving().field_70170_p.func_180494_b(event.getEntityLiving().func_180425_c()) != IIContent.biomeWasteland)) {
            event.getEntityLiving().func_70690_d(new PotionEffect(IIPotions.radiation, 2000, 0, false, false));
        }
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && ItemNBTHelper.hasKey((ItemStack)event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST), (String)"II:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack((ItemStack)event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST), (String)"II:Powerpack")).func_190926_b()) {
            powerpack.func_77973_b().onArmorTick(event.getEntityLiving().func_130014_f_(), (EntityPlayer)event.getEntityLiving(), powerpack);
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityMob) {
            EntityMob e = (EntityMob)event.getEntity();
            e.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)e, EntityHans.class, true));
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack boots = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (event.getSource() == DamageSource.field_76367_g || event.getSource() instanceof EntityDamageSourceIndirect && event.getSource().func_76364_f() instanceof EntityArrow) {
            if (ItemIIUpgradeableArmor.isArmorWithUpgrade(boots, "toughness_increase")) {
                event.setCanceled(true);
            }
        } else if (event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_190095_e) {
            if (ItemIIUpgradeableArmor.isArmorWithUpgrade(chest, "heat_coating") && ItemIIUpgradeableArmor.isArmorWithUpgrade(boots, "reinforced")) {
                event.setCanceled(true);
            }
        } else if (event.getSource() == DamageSource.field_76379_h && ItemIIUpgradeableArmor.isArmorWithUpgrade(boots, "springs")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack boots = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (event.getSource() == DamageSource.field_76367_g || event.getSource() instanceof EntityDamageSourceIndirect && event.getSource().func_76364_f() instanceof EntityArrow) {
            if (ItemIIUpgradeableArmor.isArmorWithUpgrade(boots, "toughness_increase")) {
                event.setCanceled(true);
            }
        } else if (event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_190095_e) {
            if (ItemIIUpgradeableArmor.isArmorWithUpgrade(chest, "heat_coating") && ItemIIUpgradeableArmor.isArmorWithUpgrade(boots, "reinforced")) {
                event.setCanceled(true);
            }
        } else if (event.getSource() == DamageSource.field_76379_h && ItemIIUpgradeableArmor.isArmorWithUpgrade(boots, "springs")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Iterable armor = player.func_184193_aE();
            for (ItemStack piece : armor) {
                ItemIILightEngineerBoots boots;
                if (!(piece.func_77973_b() instanceof ItemIILightEngineerBoots) || !(boots = (ItemIILightEngineerBoots)piece.func_77973_b()).hasUpgrade(piece, "internal_springs")) continue;
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        if (!IIRecipes.AMMO_CASINGS.matchesItemStackIgnoringSize(stack) && !(stack.func_77973_b() instanceof ItemIIBulletMagazine)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            ItemStack pouchStack = i == 0 ? (IICompatModule.baubles ? BaublesHelper.getWornPouch(player) : ItemStack.field_190927_a) : player.field_71071_by.func_70301_a(i - 1);
            ItemStack output = this.storeInPouch(pouchStack, stack);
            if (!output.equals(stack)) {
                event.getItem().func_92058_a(output);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), IISounds.casingPickup, SoundCategory.PLAYERS, 1.0f, 0.88f);
                event.setCanceled(true);
                stack = output;
            }
            if (!stack.func_190926_b()) continue;
            return;
        }
    }

    public ItemStack storeInPouch(ItemStack pouchStack, ItemStack stack) {
        if (!pouchStack.func_77973_b().equals(IIContent.itemCasingPouch)) {
            return stack;
        }
        IItemHandler pouchCap = (IItemHandler)pouchStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (pouchCap == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)pouchCap, (ItemStack)stack, (boolean)false);
    }
}

