/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import blusunrize.immersiveengineering.common.Config;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;
import pl.pabilo8.immersiveintelligence.common.world.IIWorldGen;

@Mod.EventBusSubscriber
public class IIConfigHandler {
    public static final String GEARS = "Gears: Copper, Brass, Iron, Steel, Tungsten";
    public static final String BELTS = "Belts: Cloth, Steel, Rubber";

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
        Config.manual_bool.put("petroleumHere", false);
        Config.manual_bool.put("baublesHere", false);
        Config.validateAndMapValues(IIConfig.class);
        Config.manual_int.put("radio_station_range", IIConfig.Machines.RadioStation.radioRange);
        if (ev.getModID().equals("immersiveintelligence")) {
            ConfigManager.sync((String)"immersiveintelligence", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @net.minecraftforge.common.config.Config(modid="immersiveintelligence")
    public static class IIConfig {
        @Config.SubConfig
        @Config.LangKey(value="Graphics")
        public static Graphics graphics;
        @Config.SubConfig
        @Config.LangKey(value="Ores")
        public static Ores ores;
        @Config.SubConfig
        @Config.LangKey(value="Machines")
        public static Machines machines;
        @Config.SubConfig
        @Config.LangKey(value="Mechanical Devices")
        public static MechanicalDevices mechanicalDevices;
        @Config.SubConfig
        @Config.LangKey(value="Tools")
        public static Tools tools;
        @Config.SubConfig
        @Config.LangKey(value="Weapons")
        public static Weapons weapons;
        @Config.SubConfig
        @Config.LangKey(value="Wires")
        public static Wires wires;
        @Config.SubConfig
        @Config.LangKey(value="Vehicles")
        public static Vehicles vehicles;
        @Config.Comment(value={"A list of all mods that II has integrated compatability for", "Setting any of these to false disables the respective compat"})
        public static Map<String, Boolean> compat;
        @Config.Comment(value={"The maximum frequency for basic radios."})
        public static int radioBasicMaxFrequency;
        @Config.Comment(value={"The maximum frequency for advanced radios."})
        @Config.LangKey(value="Wires")
        public static int radioAdvancedMaxFrequency;
        @Config.Comment(value={"Whether basic circuits should be produced in II or IE way"})
        @Config.RequiresMcRestart
        public static boolean changeCircuitProduction;
        @Config.Comment(value={"Whether the IE revolver should be a Early Engineering-tier weapon"})
        public static boolean changeRevolverProduction;
        @Config.Comment(value={"Whether Tungsten should be smeltable in the vanilla furnace"})
        @Config.RequiresMcRestart
        public static boolean smeltableTungsten;
        @Config.Comment(value={"Whether Advanced Electronic Alloy should be smeltable in the vanilla furnace"})
        @Config.RequiresMcRestart
        public static boolean smeltableAEA;
        @Config.Comment(value={"A list of all entities for which a fakeplayer should be used when shooter is not a player"})
        public static String[] bulletFakeplayerWhitelist;

        static {
            compat = Maps.newHashMap((Map)Maps.toMap(IICompatModule.moduleClasses.keySet(), s -> Boolean.TRUE));
            radioBasicMaxFrequency = 32;
            radioAdvancedMaxFrequency = 256;
            changeCircuitProduction = true;
            changeRevolverProduction = true;
            smeltableTungsten = false;
            smeltableAEA = false;
            bulletFakeplayerWhitelist = new String[]{"minecraft:ender_dragon"};
        }

        public static class MechanicalDevices {
            @Config.Comment(value={"The modifier of internal torque of a machine using this gear.", "Gears: Copper, Brass, Iron, Steel, Tungsten"})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float[] gearTorqueModifier = new float[]{0.25f, 0.5f, 1.0f, 1.5f, 2.0f};
            @Config.Comment(value={"Belts will break if Torque is higher than this value.", "Belts: Cloth, Steel, Rubber"})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] beltMaxTorque = new int[]{50, 200, 100};
            @Config.Comment(value={"Torque loss, later multiplied by belt length.", "Belts: Cloth, Steel, Rubber"})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float[] beltTorqueLoss = new float[]{0.05f, 0.1f, 0.01f};
            @Config.Comment(value={"Max length of the belt, works exactly like wires (measured in blocks).", "Belts: Cloth, Steel, Rubber"})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] beltLength = new int[]{8, 16, 16};
            @Config.Comment(value={"Immersive Flux to Rotary Flux conversion ratio (default 4 RoF = 1 IF)."})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float rofConversionRatio = 4.0f;
            @Config.Comment(value={"Default torque, used as a fallback, when IE rotational device is not recognised."})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float dynamoDefaultTorque = 16.0f;
            @Config.Comment(value={"Torque multiplier for the windmill."})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float dynamoWindmillTorque = 20.0f;
            @Config.Comment(value={"Torque multiplier for the windmill."})
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float dynamoWatermillTorque = 24.0f;
        }

        public static class Vehicles {
            @Config.SubConfig
            public static Motorbike motorbike;
            @Config.SubConfig
            public static FieldHowitzer fieldHowitzer;

            public static class FieldHowitzer {
                @Config.Comment(value={"Damage resistance of the wheels."})
                public static int wheelDurability = 40;
                @Config.Comment(value={"Damage resistance of the gun frame."})
                public static int mainDurability = 160;
                @Config.Comment(value={"Damage resistance of the gun barrel."})
                public static int gunDurability = 80;
                @Config.Comment(value={"Damage resistance of the gun shield (both sides have common health)."})
                public static int shieldDurability = 160;
                @Config.Comment(value={"Time required to tow a field howitzer."})
                public static int towingTime = 80;
                @Config.Comment(value={"Time required to set up field howitzer after moving it."})
                public static int setupTime = 15;
                @Config.Comment(value={"Time required to reload a field howitzer."})
                public static int reloadTime = 80;
                @Config.Comment(value={"Time required to fire a single shell using the field howitzer."})
                public static int fireTime = 50;
            }

            public static class Motorbike {
                @Config.Comment(value={"Fuel capacity of the motorbike."})
                public static int fuelCapacity = 12000;
                @Config.Comment(value={"Fuel usage per one meter driven."})
                public static int fuelUsage = 6;
                @Config.Comment(value={"Damage resistance of the wheels."})
                public static int wheelDurability = 40;
                @Config.Comment(value={"Damage resistance of the engine."})
                public static int engineDurability = 100;
                @Config.Comment(value={"Damage resistance of the fuel tank."})
                public static int fuelTankDurability = 80;
                @Config.Comment(value={"Amount of fuel burn per time, dependent on diesel generator fluids (in mB)"})
                public static int fuelBurnAmount = 8;
            }
        }

        public static class Wires {
            @Config.Comment(value={"The RGB color of the data wire."})
            public static int dataWireColouration = 11784662;
            @Config.Comment(value={"The maximum length of a single data wire."})
            public static int dataWireLength = 24;
            @Config.Comment(value={"The RGB color of the small data wire."})
            public static int smallRedstoneWireColouration = 0xFF2F2F;
            @Config.Comment(value={"The maximum length of a single small data wire. Should not be much."})
            public static int smallRedstoneWireLength = 4;
            @Config.Comment(value={"The RGB color of the small data wire."})
            public static int smallDataWireColouration = 11784662;
            @Config.Comment(value={"The maximum length of a single small data wire. Should not be much."})
            public static int smallDataWireLength = 4;
            @Config.Comment(value={"The RGB color of the data wire."})
            public static int tripwireColouration = 9862765;
            @Config.Comment(value={"The maximum length of the tripwire. Should be medium range at best."})
            public static int tripwireLength = 8;
        }

        public static class Ammunition {
            @Config.Comment(value={"Default velocity of a light howitzer shell."})
            public static float mortarVelocity = 8.0f;
            @Config.Comment(value={"Default velocity of a light howitzer shell."})
            public static float lightHowiVelocity = 10.0f;
            @Config.Comment(value={"Default velocity of an artillery howitzer shell."})
            public static float artilleryHowiVelocity = 70.0f;
            @Config.Comment(value={"Default velocity of a railgun grenade."})
            public static float railgunGrenadeVelocity = 5.0f;
            @Config.Comment(value={"Default velocity of a thrown grenade."})
            public static float grenadeVelocity = 2.5f;
            @Config.Comment(value={"Default velocity of a machinegun bullet."})
            public static float autocannonVelocity = 6.0f;
            @Config.Comment(value={"Default velocity of a machinegun bullet."})
            public static float mgVelocity = 6.5f;
            @Config.Comment(value={"Default velocity of a submachinegun bullet."})
            public static float smgVelocity = 5.0f;
            @Config.Comment(value={"Default velocity of an assault rifle bullet."})
            public static float stgVelocity = 6.5f;
            @Config.Comment(value={"Default velocity of a revolver cartridge."})
            public static float revolverVelocity = 6.0f;
        }

        public static class Weapons {
            @Config.Comment(value={"Whether blocks should be damaged when hit by bullets"})
            public static boolean blockDamage = true;
            @Config.Comment(value={"Whether bullets should whistle, when flying close to player (slightly affects performance)"})
            public static boolean bulletsWhistleSound = true;
            @Config.Comment(value={"Whether artillery shells should whistle, when about to impact"})
            public static boolean artilleryImpactSound = true;
            @Config.SubConfig
            @Config.LangKey(value="Ammunition")
            public static Ammunition ammunition;
            @Config.SubConfig
            @Config.LangKey(value="Submachinegun")
            public static Submachinegun submachinegun;
            @Config.SubConfig
            @Config.LangKey(value="Machinegun")
            public static Machinegun machinegun;
            @Config.SubConfig
            @Config.LangKey(value="Rifle")
            public static Rifle rifle;
            @Config.SubConfig
            @Config.LangKey(value="Assault Rifle")
            public static AssaultRifle assaultRifle;
            @Config.SubConfig
            @Config.LangKey(value="Mortar")
            public static Mortar mortar;
            @Config.SubConfig
            @Config.LangKey(value="Emplacement Weapons")
            public static EmplacementWeapons emplacementWeapons;
            @Config.SubConfig
            @Config.LangKey(value="Railgun")
            public static Railgun railgun;
            @Config.SubConfig
            @Config.LangKey(value="Grenade")
            public static Grenade grenade;
            @Config.SubConfig
            @Config.LangKey(value="Mines")
            public static Mines mines;
            @Config.SubConfig
            @Config.LangKey(value="Light Engineer Armor")
            public static LightEngineerArmor lightEngineerArmor;

            public static class Machinegun {
                @Config.Comment(value={"Time required to reload a clip in MG."})
                public static int clipReloadTime = 35;
                @Config.Comment(value={"Time required to fire a single bullet in MG."})
                public static int bulletFireTime = 2;
                @Config.Comment(value={"Time required to set up the MG (in ticks)."})
                public static int setupTime = 50;
                @Config.Comment(value={"Max scatter of heat, higher values will force the player to wait until the gun cools down."})
                public static int maxOverheat = 250;
                @Config.Comment(value={"Amount of horizontal recoil after taking a shot."})
                public static float recoilHorizontal = 2.5f;
                @Config.Comment(value={"Amount of vertical recoil after taking a shot."})
                public static float recoilVertical = 2.5f;
                @Config.Comment(value={"Fire rate multiplier when heavy barrel is mouted on mg."})
                public static float heavyBarrelFireRateMultiplier = 0.25f;
                @Config.Comment(value={"Horizontal recoil after taking a shot with heavy barrel mounted."})
                public static float recoilHBHorizontal = 1.25f;
                @Config.Comment(value={"Vertical recoil after taking a shot with heavy barrel mounted."})
                public static float recoilHBVertical = 1.25f;
                @Config.Comment(value={"Water usage when water cooling upgrade is mounted on mg (in mB)."})
                public static int waterCoolingFluidUsage = 10;
                @Config.RequiresMcRestart
                @Config.Comment(value={"Coolant tank capacity of the water cooling upgrade."})
                public static int waterCoolingTankCapacity = 4000;
                @Config.Comment(value={"Setup time multiplier when the mg is mounted on a tripod."})
                public static float tripodSetupTimeMultiplier = 2.5f;
                @Config.Comment(value={"Recoil multiplier when the mg is mounted on a tripod."})
                public static float tripodRecoilMultiplier = 0.125f;
                @Config.Comment(value={"Setup time multiplier when the precise bipod is mouted on mg."})
                public static float preciseBipodSetupTimeMultiplier = 1.5f;
                @Config.Comment(value={"Recoil multiplier when the precise bipod is mouted on mg."})
                public static float preciseBipodRecoilMultiplier = 0.25f;
                @Config.Comment(value={"Setup time multiplier when the hasty bipod is mouted on mg."})
                public static float hastyBipodSetupTimeMultiplier = 0.5f;
                @Config.Comment(value={"Recoil multiplier when the hasty bipod is mouted on mg."})
                public static float hastyBipodRecoilMultiplier = 1.5f;
                @Config.Comment(value={"Horizontal recoil multiplier when the double magazine upgrade is mouted on mg."})
                public static float recoilSecondMagazine = 1.65f;
                @Config.Comment(value={"Setup time multiplier when the belt fed loader upgrade is mouted on mg."})
                public static float beltFedLoaderSetupTimeMultiplier = 0.5f;
                @Config.Comment(value={"Infrared scope energy usage per tick"})
                public static int infraredScopeEnergyUsage = 15;
                @Config.Comment(value={"Max zoom of a machinegun with a scope mounted (in Blu's Unit of Distance Measurement\u2122)."})
                @Config.RequiresMcRestart
                @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
                public static float[] machinegunScopeMaxZoom = new float[]{0.55f, 0.35f, 0.15f};
                @Config.Comment(value={"Shield's initial strength (resistance vs attacks)."})
                public static float shieldStrengthInitial = 45.0f;
                @Config.Comment(value={"Setup time multiplier when a shield is mouted on mg."})
                public static float shieldSetupTimeMultiplier = 0.5f;
            }

            public static class AssaultRifle {
                @Config.Comment(value={"Time required to reload a magazine in AR. (in ticks)"})
                public static int clipReloadTime = 45;
                @Config.Comment(value={"Time required to load a railgun grenade to an upgraded AR. (in ticks)"})
                public static int grenadeReloadTime = 80;
                @Config.Comment(value={"Time required to aim the AR. (in ticks)"})
                public static int aimTime = 15;
                @Config.Comment(value={"Time required to fire a single bullet in Auto mode."})
                public static int bulletFireTimeAuto = 2;
                @Config.Comment(value={"Time required to fire a single bullet in Semi-Auto mode."})
                public static int bulletFireTimeSemiAuto = 5;
                @Config.Comment(value={"Amount of horizontal recoil after taking a shot."})
                public static float recoilHorizontal = 0.345f;
                @Config.Comment(value={"Amount of vertical recoil after taking a shot."})
                public static float recoilVertical = 0.425f;
                @Config.Comment(value={"Maximum amount of horizontal recoil."})
                public static float maxRecoilHorizontal = 8.5f;
                @Config.Comment(value={"Maximum amount of vertical recoil."})
                public static float maxRecoilVertical = 8.5f;
                @Config.Comment(value={"Range in which enemies will be attracted to the gunshot."})
                public static int enemyAttractRange = 36;
                @Config.Comment(value={"Energy used per tick by the Infrared Scope upgrade."})
                public static int upgradeIRScopeEnergy = 20;
                @Config.Comment(value={"Energy used per shot by the Electric Firing Motor upgrade."})
                public static int upgradeFiringMotorEnergy = 10;
                @Config.Comment(value={"Energy used per shot by the Railgun Chamber upgrade."})
                public static int upgradeRailgunChamberEnergy = 40;
                @Config.Comment(value={"Energy used per tick by the Gyroscopic Stabilizer upgrade."})
                public static int upgradeStabilizerEnergy = 10;
                @Config.Comment(value={"Energy used per tick by the Stereoscopic Rangefinder upgrade."})
                public static int upgradeRangefinderEnergy = 1024;
            }

            public static class Submachinegun {
                @Config.Comment(value={"Time required to reload a stick magazine in SMG. (in ticks)"})
                public static int clipReloadTime = 45;
                @Config.Comment(value={"Time required to reload a drum magazine in SMG. (in ticks)"})
                public static int drumReloadTime = 80;
                @Config.Comment(value={"Time required to aim the SMG. (in ticks)"})
                public static int aimTime = 10;
                @Config.Comment(value={"Time required to aim the SMG with folded stock upgrade."})
                public static int aimTimeFoldedStock = 4;
                @Config.Comment(value={"Time required to fire a single bullet."})
                public static int bulletFireTime = 2;
                @Config.Comment(value={"Maximum amount of horizontal recoil."})
                public static float sturdyBarrelVelocityMod = 1.25f;
                @Config.Comment(value={"Amount of horizontal recoil after taking a shot."})
                public static float newRecoilHorizontal = 0.345f;
                @Config.Comment(value={"Amount of vertical recoil after taking a shot."})
                public static float newRecoilVertical = 0.625f;
                @Config.Comment(value={"Maximum amount of horizontal recoil."})
                public static float newMaxRecoilHorizontal = 14.5f;
                @Config.Comment(value={"Maximum amount of vertical recoil."})
                public static float newMaxRecoilVertical = 9.0f;
                @Config.Comment(value={"Range in which enemies will be attracted to the gunshot."})
                public static int enemyAttractRange = 36;
                @Config.Comment(value={"Range in which enemies will be attracted to the gunshot for a suppressed SMG."})
                public static int enemyAttractRangeSuppressor = 6;
            }

            public static class Rifle {
                @Config.Comment(value={"Time required to reload a stick magazine in SMG. (in ticks)"})
                public static int bulletReloadTime = 20;
                @Config.Comment(value={"Time required to reload a drum magazine in SMG. (in ticks)"})
                public static int magazineReloadTime = 65;
                @Config.Comment(value={"Time required to aim the SMG. (in ticks)"})
                public static int clipSize = 4;
                @Config.Comment(value={"Time required to aim the SMG. (in ticks)"})
                public static int aimTime = 15;
                @Config.Comment(value={"Time required to fire a single bullet."})
                public static int bulletFireTime = 20;
                @Config.Comment(value={"Time required to fire a single bullet."})
                public static int bulletFireTimeSemiAuto = 10;
                @Config.Comment(value={"Maximum amount of horizontal recoil."})
                public static float longBarrelVelocityMod = 1.5f;
                @Config.Comment(value={"Amount of horizontal recoil after taking a shot."})
                public static float recoilHorizontal = 0.5f;
                @Config.Comment(value={"Amount of vertical recoil after taking a shot."})
                public static float recoilVertical = 2.75f;
                @Config.Comment(value={"Maximum amount of horizontal recoil."})
                public static float maxRecoilHorizontal = 3.5f;
                @Config.Comment(value={"Maximum amount of vertical recoil."})
                public static float maxRecoilVertical = 12.0f;
                @Config.Comment(value={"Amount of vertical recoil after taking a shot."})
                public static float recoilSemiAutoVertical = 1.0f;
                @Config.Comment(value={"Range in which enemies will be attracted to the gunshot."})
                public static int enemyAttractRange = 32;
            }

            public static class Mines {
                @Config.Comment(value={"Changes color of the tripmine ", "0 - steel", "1 - green", "2 - dull-yellow (makes your tripmine a true S-Mine straight out of ze [REDACTED])"})
                @Config.RangeInt(min=0, max=2)
                public static int tripmineColor = 0;
                @Config.Comment(value={"Time before colision is being detected for navy mine after placing it (in ticks)"})
                public static int navalMineArmTime = 60;
                @Config.Comment(value={"Energy capacity of radio explosives (in IF)."})
                public static int energyCapacity = 240000;
                @Config.Comment(value={"Energy usage by radio explosives per tick (in IF)."})
                public static int energyUsage = 10;
                @Config.Comment(value={"Radio signal range of the radio explosives (radius)."})
                public static int radioRange = 32;
                @Config.RangeDouble(min=0.0, max=1.0)
                @Config.Comment(value={"How much the range decreases when there is bad weather (rain, snow) ( 1 - full range, 0.5 - half range, 0 - no range, etc.)"})
                public static double weatherHarshness = 0.35;
                @Config.Comment(value={"A list of all entities which will not activate the Tripmine"})
                public static String[] tripmineBlacklist = new String[]{"minecraft:chicken", "minecraft:rabbit", "immersiveintelligence:bullet", "immersiveintelligence:silverfish", "immersiveintelligence:endermite"};
            }

            public static class Grenade {
                @Config.Comment(value={"Changes looks of the grenades", "0 - new look", "1 - old look, but cores are colored", "2 - old look"})
                @Config.RangeInt(min=0, max=2)
                public static int classicGrenades = 0;
                @Config.Comment(value={"Grenade's initial speed modifier."})
                @Config.RangeDouble(min=0.0)
                public static float throwSpeedModifier = 1.65f;
            }

            public static class Railgun {
                @Config.Comment(value={"If disabled, II will not make any changes to IE railgun. This also disables using railgun grenades (as they use a custom entity)."})
                public static boolean enableRailgunOverride = true;
                @Config.Comment(value={"Make standard railgun rods to be able to penetrate mobs (depending on metal)."})
                public static boolean enablePenetration = true;
                @Config.Comment(value={"Whether the railgun has recoil (pushes the shooter to back, depending on projectile mass)."})
                public static boolean railgunRecoil = true;
                @Config.Comment(value={"Whether the railgun can only be used when in mainhand."})
                public static boolean disableRailgunOffhand = true;
            }

            public static class EmplacementWeapons {
                @Config.SubConfig
                public static Autocannon autocannon;
                @Config.SubConfig
                public static Machinegun machinegun;
                @Config.SubConfig
                public static TeslaCoil teslaCoil;
                @Config.SubConfig
                public static InfraredObserver infraredObserver;
                @Config.SubConfig
                public static CPDS cpds;
                @Config.SubConfig
                public static HeavyChemthrower heavyChemthrower;
                @Config.SubConfig
                public static HeavyRailgun heavyRailgun;

                public static class HeavyRailgun {
                    @Config.Comment(value={"Time required to fire a single shot."})
                    public static int shotFireTime = 40;
                    @Config.Comment(value={"Time required for loading a single projectile."})
                    public static int reloadConveyorTime = 20;
                    @Config.Comment(value={"Time required for replacing the ammo box."})
                    public static int reloadAmmoBoxTime = 100;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 350;
                    @Config.Comment(value={"Yaw rotation speed (degrees/tick)"})
                    public static float yawRotateSpeed = 1.75f;
                    @Config.Comment(value={"Pitch rotation speed (degrees/tick)"})
                    public static float pitchRotateSpeed = 0.65f;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 16.0f;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 2048;
                }

                public static class HeavyChemthrower {
                    @Config.Comment(value={"Time required for chemthrower setup (barrel extension animation) (in ticks)."})
                    public static int setupTime = 100;
                    @Config.Comment(value={"Fluid tank capacity of the heavy chemthrower (in mB)."})
                    public static int tankCapacity = 8000;
                    @Config.Comment(value={"Yaw rotation speed (degrees/tick)"})
                    public static float yawRotateSpeed = 2.0f;
                    @Config.Comment(value={"Pitch rotation speed (degrees/tick)"})
                    public static float pitchRotateSpeed = 1.0f;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 120;
                    @Config.Comment(value={"Time required to fire a single chemthrower particle (in ticks)."})
                    public static int sprayTime = 0;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 16.0f;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 2048;
                }

                public static class CPDS {
                    @Config.Comment(value={"Yaw rotation speed (degrees/tick)"})
                    public static float yawRotateSpeed = 8.0f;
                    @Config.Comment(value={"Pitch rotation speed (degrees/tick)"})
                    public static float pitchRotateSpeed = 8.0f;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 350;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 16.0f;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 4096;
                    @Config.Comment(value={"Time required to reload the magazine."})
                    public static int reloadTime = 120;
                }

                public static class InfraredObserver {
                    @Config.Comment(value={"Pitch rotation speed (degrees/tick)"})
                    public static float pitchRotateSpeed = 2.0f;
                    @Config.Comment(value={"Yaw rotation speed (degrees/tick, rotates only if sent a data packet, requires lowering the platform)"})
                    public static int yawRotateTime = 1;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 100;
                    @Config.Comment(value={"Time required for observer setup (lens attachment animation) (in ticks)."})
                    public static int setupTime = 300;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 56.0f;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 1024;
                }

                public static class TeslaCoil {
                    @Config.Comment(value={" \"reload\" time after dealing damage (in ticks)."})
                    public static int damageDelay = 10;
                    @Config.Comment(value={"Damage dealt to enemies (in half-hearts)."})
                    public static int damage = 10;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 3096;
                    @Config.Comment(value={"Energy used per shot (in IF)"})
                    public static int energyUsage = 2048;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 200;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 0.0f;
                    @Config.Comment(value={"Enemy attack range (in blocks)"})
                    public static float attackRadius = 16.0f;
                }

                public static class Machinegun {
                    @Config.Comment(value={"Yaw rotation speed (degrees/tick)"})
                    public static float yawRotateSpeed = 4.0f;
                    @Config.Comment(value={"Pitch rotation speed (degrees/tick)"})
                    public static float pitchRotateSpeed = 4.0f;
                    @Config.Comment(value={"Time required to reload all the magazines."})
                    public static int reloadTime = 200;
                    @Config.Comment(value={"Time required to fire a single bullet."})
                    public static int bulletFireTime = 2;
                    @Config.Comment(value={"Time required for machinegun nest setup (barrel attachment animation) (in ticks)"})
                    public static int setupTime = 150;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 150;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 24.0f;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 1024;
                }

                public static class Autocannon {
                    @Config.Comment(value={"Yaw rotation speed (degrees/tick)"})
                    public static float yawRotateSpeed = 4.0f;
                    @Config.Comment(value={"Pitch rotation speed (degrees/tick)"})
                    public static float pitchRotateSpeed = 4.0f;
                    @Config.Comment(value={"Time required to reload all the magazines."})
                    public static int reloadTime = 280;
                    @Config.Comment(value={"Time required to fire a single bullet."})
                    public static int bulletFireTime = 3;
                    @Config.Comment(value={"Starting/max health of the turret (in half-hearts)"})
                    public static int maxHealth = 200;
                    @Config.Comment(value={"Enemy detection range (in blocks)"})
                    public static float detectionRadius = 24.0f;
                    @Config.Comment(value={"Base energy usage per tick (in IF)."})
                    public static int energyUpkeepCost = 2048;
                }
            }

            public static class Mortar {
                @Config.Comment(value={"Determines how fast the Mortar can be set up (in ticks)."})
                @Config.RangeInt(min=0)
                @Config.RequiresMcRestart
                public static int setupTime = 100;
                @Config.Comment(value={"Determines how fast the Mortar can be fired (in ticks)."})
                @Config.RangeInt(min=0)
                @Config.RequiresMcRestart
                public static int shootTime = 80;
                @Config.Comment(value={"The pitch turn speed of the Mortar (in degrees)."})
                @Config.RequiresMcRestart
                public static float pitchSpeed = 1.0f;
            }

            public static class LightEngineerArmor {
                @Config.Comment(value={"The energy usage of the Infiltrator's Headgear when IR is active (in IF / 20 ticks)."})
                @Config.RangeInt(min=0)
                public static int irHeadgearEnergyUsage = 150;
                @Config.Comment(value={"The energy usage of the Technician's Headgear when it is active (in IF / 20 ticks)."})
                @Config.RangeInt(min=0)
                public static int technicianHeadgearEnergyUsage = 50;
                @Config.Comment(value={"The energy usage of the Engineer's Headgear when it is active (in IF / 20 ticks)."})
                @Config.RangeInt(min=0)
                public static int engineerHeadgearEnergyUsage = 225;
                @Config.Comment(value={"The multiplier of electric damage taken when an anti-static mesh is worn under water (in half-hearts)."})
                @Config.RangeInt(min=0)
                public static float antiStaticMeshWaterDamageMod = 1.5f;
                @Config.Comment(value={"The energy usage of the exoskeleton when running (in IF)."})
                @Config.RangeInt(min=0)
                public static int exoskeletonEnergyUsage = 200;
                @Config.Comment(value={"The oxygen capacity of the scuba tank (in mB)."})
                @Config.RangeInt(min=0)
                @Config.RequiresMcRestart
                public static int scubaTankCapacity = 10000;
                @Config.Comment(value={"The oxygen capacity of the scuba tank (in mB / 20 ticks)."})
                @Config.RangeInt(min=0)
                public static int scubaTankUsage = 20;
            }
        }

        public static class Machines {
            @Config.SubConfig
            public static LatexCollector latexCollector;
            @Config.SubConfig
            public static RadioStation radioStation;
            @Config.SubConfig
            public static DataInputMachine dataInputMachine;
            @Config.SubConfig
            public static ArithmeticLogicMachine arithmeticLogicMachine;
            @Config.SubConfig
            public static PrintingPress printingPress;
            @Config.SubConfig
            public static ChemicalBath chemicalBath;
            @Config.SubConfig
            public static Electrolyzer electrolyzer;
            @Config.SubConfig
            public static PrecisionAssembler precissionAssembler;
            @Config.SubConfig
            public static Coagulator coagulator;
            @Config.SubConfig
            public static Vulcanizer vulcanizer;
            @Config.SubConfig
            public static ArtilleryHowitzer artilleryHowitzer;
            @Config.SubConfig
            public static BallisticComputer ballisticComputer;
            @Config.SubConfig
            public static MissileSilo missileSilo;
            @Config.SubConfig
            public static ScanningConveyor scanningConveyor;
            @Config.SubConfig
            public static Inserter inserter;
            @Config.SubConfig
            public static AdvancedInserter advancedInserter;
            @Config.SubConfig
            public static FluidInserter fluidInserter;
            @Config.SubConfig
            public static AdvancedFluidInserter advancedFluidInserter;
            @Config.SubConfig
            public static ChemicalDispenser chemicalDispenser;
            @Config.SubConfig
            public static SmallDataBuffer smallDataBuffer;
            @Config.SubConfig
            public static SkyCrateStation skycrateStation;
            @Config.SubConfig
            public static SkyCartStation skycartStation;
            @Config.SubConfig
            public static Packer packer;
            @Config.SubConfig
            public static RedstoneInterface redstoneInterface;
            @Config.SubConfig
            public static Sawmill sawmill;
            @Config.SubConfig
            public static AlarmSiren alarmSiren;
            @Config.SubConfig
            public static ProgrammableSpeaker speaker;
            @Config.SubConfig
            public static EffectCrates effectCrates;
            @Config.SubConfig
            public static Emplacement emplacement;
            @Config.SubConfig
            public static Filler filler;
            @Config.SubConfig
            public static VehicleWorkshop vehicleWorkshop;

            public static class ProjectileWorkshop {
                @Config.Comment(value={"Energy capacity of the ammunition workshop (in IF)."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Fluid capacity of a projectile workshop coolant (water) tank (in mB)."})
                public static int coolantTankCapacity = 6000;
                @Config.Comment(value={"Fluid capacity of a projectile workshop fluid bullet component buffer tank (in mB)."})
                public static int componentTankCapacity = 1000;
                @Config.Comment(value={"Maximum amount of bullet component stored in a projectile workshop (16 is default amount per one item / 1000mB of a fluid)."})
                public static int componentCapacity = 512;
                @Config.Comment(value={"How long does it take to produce a projectile from a plate (in ticks, multiplied by caliber)."})
                public static int productionTime = 35;
                @Config.Comment(value={"How long does it take to fill a projectile with components (in ticks, multiplied by caliber)."})
                public static int fillingTime = 35;
            }

            public static class AmmunitionWorkshop {
                @Config.Comment(value={"Energy capacity of the ammunition workshop (in IF)."})
                public static int energyCapacity = 16000;
            }

            public static class Coagulator {
                @Config.Comment(value={"Energy capacity of the coagulator (in IF)."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Fluid capacity of a coagulator tank (in mB)."})
                public static int fluidCapacity = 16000;
                @Config.Comment(value={"Default bucket wait time for a coagulator process, when not specified in recipe (in ticks)."})
                public static int bucketTime = 400;
                @Config.Comment(value={"How long does it take to move a crane 1 block (in ticks)."})
                public static int craneMoveTime = 20;
                @Config.Comment(value={"Duration of crane bucket actions (in ticks)."})
                public static int craneGrabTime = 20;
            }

            public static class Vulcanizer {
                @Config.Comment(value={"Energy capacity of the vulcanizer (in IF)."})
                public static int energyCapacity = 16000;
            }

            public static class CO2Collector {
                @Config.Comment(value={"CO2 collection time (in ticks)."})
                public static int blastFurnaceCollectTime = 20;
                @Config.Comment(value={"CO2 amount collected (in mB)."})
                public static int blastFurnaceCollectAmount = 5;
                @Config.Comment(value={"CO2 collection time (in ticks)."})
                public static int fermenterCollectTime = 20;
                @Config.Comment(value={"CO2 amount collected (in mB)."})
                public static int fermenterCollectAmount = 2;
            }

            public static class LatexCollector {
                @Config.Comment(value={"Collection time of a single bucket (in ticks)."})
                public static int collectTime = 12000;
            }

            public static class FuelStation {
                @Config.Comment(value={"Energy capacity of the fuel station."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Energy amount used per one mB of fluid transfered."})
                public static int energyUsage = 4;
                @Config.Comment(value={"Amount of fluid transfered per tick."})
                public static int fluidTransfer = 120;
                @Config.RequiresWorldRestart
                @Config.Comment(value={"Fluid capacity of the fuel station."})
                public static int fluidCapacity = 64000;
            }

            public static class SmallDataBuffer {
                @Config.Comment(value={"Amount of data packets the machine can store."})
                public static int packetCapacity = 4;
            }

            public static class ChemicalDispenser {
                @Config.Comment(value={"Energy capacity of the chemical dispenser."})
                public static int energyCapacity = 2048;
                @Config.Comment(value={"Energy usage of the chemical dispenser per one shot."})
                public static int energyUsage = 128;
                @Config.Comment(value={"How long does it take for the chemical dispenser to rotate 45 degrees horizontally (in ticks)"})
                public static int rotateHTime = 240;
                @Config.Comment(value={"How long does it take for the chemical dispenser to rotate 45 degrees vertically (in ticks)"})
                public static int rotateVTime = 180;
            }

            public static class AdvancedFluidInserter {
                @Config.Comment(value={"Energy capacity of the inserter."})
                public static int energyCapacity = 4096;
                @Config.Comment(value={"Energy usage of the inserter per item taken."})
                public static int energyUsage = 256;
                @Config.Comment(value={"Max fluid output (in milibuckets per tick)"})
                public static int maxOutput = 240;
            }

            public static class FluidInserter {
                @Config.Comment(value={"Energy capacity of the inserter."})
                public static int energyCapacity = 2048;
                @Config.Comment(value={"Energy usage of the inserter per item taken."})
                public static int energyUsage = 128;
                @Config.Comment(value={"Max fluid output (in milibuckets per tick)"})
                public static int maxOutput = 500;
            }

            public static class AdvancedInserter {
                @Config.Comment(value={"Energy capacity of the inserter (in IF)"})
                public static int energyCapacity = 4096;
                @Config.Comment(value={"Energy usage of the inserter per tick (in IF)"})
                public static int energyUsage = 256;
                @Config.Comment(value={"How long does it take for the inserter to perform a task (in ticks)"})
                public static int taskTime = 10;
                @Config.Comment(value={"How many items can be taken per single operation"})
                public static int maxTake = 64;
            }

            public static class Inserter {
                @Config.Comment(value={"Energy capacity of the inserter (in IF)"})
                public static int energyCapacity = 4096;
                @Config.Comment(value={"Energy usage of the inserter per tick (in IF)"})
                public static int energyUsage = 128;
                @Config.Comment(value={"How long does it take for the inserter to perform a task (in ticks)"})
                public static int taskTime = 20;
                @Config.Comment(value={"How many items can be taken per single operation"})
                public static int maxTake = 32;
            }

            public static class Emplacement {
                @Config.Comment(value={"Energy capacity of the emplacement (in IF)."})
                public static int energyCapacity = 32000;
                @Config.Comment(value={"Time for the multiblock to open/close the lid (in ticks)."})
                public static int lidTime = 240;
                @Config.Comment(value={"Interval for the multiblock weapon to update sighted targets (in ticks)."})
                public static int sightUpdateTime = 10;
                @Config.Comment(value={"Energy required to perform a single repair action (in IF)."})
                public static int repairCost = 1024;
                @Config.Comment(value={"Time for a single repair action (in ticks)."})
                public static int repairDelay = 40;
                @Config.Comment(value={"Amount of turret health restored during single repair action (in half-hearts)."})
                public static int repairAmount = 4;
            }

            public static class Radar {
                @Config.Comment(value={"Energy required to construct the radar (in IF)."})
                public static int constructionEnergy = 200000;
                @Config.Comment(value={"Energy capacity of the radar (in IF)."})
                public static int energyCapacity = 64000;
                @Config.Comment(value={"Energy usage of the radar per tick (in IF)."})
                public static int energyUsage = 2048;
            }

            public static class MissileSilo {
                @Config.Comment(value={"Energy capacity of the missile silo (per one block of height) (in IF)."})
                public static int energyCapacity = 2500000;
            }

            public static class ScanningConveyor {
                @Config.Comment(value={"Energy capacity of the scanning conveyor."})
                public static int energyCapacity = 8000;
                @Config.Comment(value={"Energy usage when scanning an ItemStack."})
                public static int energyUsage = 128;
            }

            public static class BallisticComputer {
                @Config.Comment(value={"Energy capacity of the ballistic computer."})
                public static int energyCapacity = 24000;
                @Config.Comment(value={"Energy capacity of the ballistic computer."})
                public static int energyUsage = 16000;
            }

            public static class ArtilleryHowitzer {
                @Config.Comment(value={"Energy capacity of the artillery howitzer."})
                public static int energyCapacity = 4000000;
                @Config.Comment(value={"Additional energy usage when moving the platform, loading or shooting."})
                public static int energyUsageActive = 1024;
                @Config.Comment(value={"Passive energy usage of the howitzer (in IF)."})
                public static int energyUsagePassive = 2048;
                @Config.Comment(value={"Time needed for the platform to ascend/descend (in ticks)."})
                public static int platformTime = 200;
                @Config.Comment(value={"Time needed for the howitzer to fire (in ticks)."})
                public static int gunFireTime = 240;
                @Config.RangeDouble(min=0.0, max=1.0)
                @Config.Comment(value={"In what moment of animation should the gun fire the bullet (0.0-1.0 fraction of gunFireTime)"})
                public static double gunFireMoment = 0.5989;
                @Config.Comment(value={"Time needed to open the howitzer door (in ticks)."})
                public static int doorTime = 248;
                @Config.Comment(value={"How many degrees per tick can the howitzer rotate (in degrees)"})
                public static int rotateSpeed = 2;
                @Config.Comment(value={"How long does it take for the howitzer to load or unload a shell to the platform shell rack (in ticks)"})
                public static int loadRackTime = 360;
                @Config.Comment(value={"How long does it take for the howitzer to move the shell by one item slot using conveyor (in ticks)"})
                public static int conveyorTime = 40;
            }

            public static class PrecisionAssembler {
                @Config.Comment(value={"Energy capacity of the chemical bath."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Hatch opening (or closing) time (in ticks)"})
                public static int hatchTime = 40;
            }

            public static class Electrolyzer {
                @Config.Comment(value={"Energy capacity of the electrolyzer."})
                public static int energyCapacity = 16000;
                @Config.RequiresWorldRestart
                @Config.Comment(value={"Fluid capacity of the electrolyzer."})
                public static int fluidCapacity = 12000;
            }

            public static class ChemicalPainter {
                @Config.Comment(value={"Energy capacity of the chemical painter."})
                public static int energyCapacity = 16000;
                @Config.RequiresWorldRestart
                @Config.Comment(value={"Fluid capacity of each tank of the chemical painter."})
                public static int fluidCapacity = 8000;
            }

            public static class ChemicalBath {
                @Config.Comment(value={"Energy capacity of the chemical bath."})
                public static int energyCapacity = 16000;
                @Config.RequiresWorldRestart
                @Config.Comment(value={"Fluid capacity of the chemical bath."})
                public static int fluidCapacity = 24000;
            }

            public static class PrintingPress {
                @Config.Comment(value={"Energy capacity of the printing press."})
                public static int energyCapacity = 24000;
                @Config.Comment(value={"Energy usage of the printing press per page printed."})
                public static int energyUsage = 2048;
                @Config.Comment(value={"Page printing duration (in ticks)."})
                public static int printTime = 90;
                @Config.Comment(value={"Ink used per character printed (mB)."})
                public static int printInkUsage = 8;
            }

            public static class ArithmeticLogicMachine {
                @Config.Comment(value={"Energy capacity of the arithmetic-logic machine."})
                public static int energyCapacity = 24000;
                @Config.Comment(value={"Energy usage of the arithmetic-logic machine per circuit."})
                public static int energyUsage = 2048;
            }

            public static class DataInputMachine {
                @Config.Comment(value={"Energy capacity of the data input machine."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Energy usage when sending a signal."})
                public static int energyUsage = 2048;
                @Config.Comment(value={"Energy per step of punching a tape (1/60 of the full energy needed)."})
                public static int energyUsagePunchtape = 128;
                @Config.Comment(value={"Duration of tape punching process in ticks (1 tick = 1/20 Second)."})
                public static int timePunchtapeProduction = 80;
            }

            public static class RadioStation {
                @Config.Comment(value={"Energy required to construct the radio station (in IF)."})
                public static int constructionEnergy = 200000;
                @Config.Comment(value={"Energy capacity of the radio station (in IF)."})
                public static int energyCapacity = 32000;
                @Config.Comment(value={"Energy usage when sending a signal (in IF)."})
                public static int energyUsage = 2048;
                @Config.Comment(value={"Energy usage when a radio station is working."})
                public static int energyUsageIdle = 512;
                @Config.Comment(value={"Range of the radio station (in which the signals can be received) in blocks from center (radius)."})
                @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_int")
                public static int radioRange = 128;
                @Config.RangeDouble(min=0.0, max=1.0)
                @Config.Comment(value={"How much the range decreases when there is bad weather (rain, snow) ( 1 - full range, 0.5 - half range, 0 - no range, etc.)"})
                public static double weatherHarshness = 0.75;
            }

            public static class MechanicalPump {
                @Config.Comment(value={"Rotations per minute required for the Sawmill to Work."})
                public static int rpmMin = 40;
                @Config.Comment(value={"Max rotations per minute (will break if over)."})
                public static int rpmBreakingMax = 160;
                @Config.Comment(value={"Torque required for the Sawmill to Work."})
                public static int torqueMin = 2;
                @Config.Comment(value={"Max Torque (will break if over)."})
                public static int torqueBreakingMax = 40;
            }

            public static class Sawmill {
                @Config.Comment(value={"Rotations per minute required for the Sawmill to Work."})
                public static int rpmMin = 20;
                @Config.Comment(value={"Max rotations per minute (will break if over)."})
                public static int rpmBreakingMax = 160;
                @Config.Comment(value={"Torque required for the Sawmill to Work."})
                public static int torqueMin = 6;
                @Config.Comment(value={"Max Torque (will break if over)."})
                public static int torqueBreakingMax = 140;
            }

            public static class SkyCartStation {
                @Config.Comment(value={"How long does it take for the minecart to drive into the station. (in ticks)"})
                public static int minecartInTime = 40;
                @Config.Comment(value={"How long does it take for the minecart to drive out of the station. (in ticks)"})
                public static int minecartOutTime = 40;
            }

            public static class SkyCrateStation {
                @Config.Comment(value={"Rotations per minute required for the Skycrate Station to Work."})
                public static int rpmMin = 20;
                @Config.Comment(value={"Max rotations per minute (reaching over this level doesn't change effectiveness)."})
                public static int rpmEffectiveMax = 80;
                @Config.Comment(value={"Max rotations per minute (will break if over)."})
                public static int rpmBreakingMax = 240;
                @Config.Comment(value={"Torque required for the Skycrate Station to Work."})
                public static int torqueMin = 4;
                @Config.Comment(value={"Max Torque (reaching over this level doesn't change effectiveness)."})
                public static int torqueEffectiveMax = 8;
                @Config.Comment(value={"Max Torque (will break if over)."})
                public static int torqueBreakingMax = 256;
                @Config.Comment(value={"How long does it take for the station to put a crate onto the line. (in ticks)"})
                public static int outputTime = 240;
                @Config.Comment(value={"How long does it take for the station to put a crate onto a minecart. (in ticks)"})
                public static int inputTime = 240;
                @Config.Comment(value={"How long does it take for the minecart to drive into the station. (in ticks)"})
                public static int crateInTime = 60;
                @Config.Comment(value={"How long does it take for the minecart to drive out of the station. (in ticks)"})
                public static int crateOutTime = 60;
            }

            public static class Packer {
                @Config.Comment(value={"Energy capacity of the glorious boxing device also known as The Packer."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Additional energy capacity of the packer when the charging module upgrade is present."})
                public static int energyCapacityUpgrade = 16000000;
                @Config.Comment(value={"Additional fluid capacity of the packer when the pump module upgrade is present."})
                public static int fluidCapacityUpgrade = 96000;
                @Config.Comment(value={"Energy usage of the packer (if any stack/fluid/energy input/output is performed)."})
                public static int energyUsage = 4096;
                @Config.Comment(value={"Duration of the packing process (in ticks)."})
                public static int actionTime = 260;
            }

            public static class EffectCrates {
                @Config.Comment(value={"The amount of fluid a Medical Crate can store (in mB)"})
                public static int mediCrateTankSize = 4000;
                @Config.Comment(value={"The amount of fluid a Medical Crate uses after applying the effect (in mB)"})
                public static int mediCrateFluidDrain = 250;
                @Config.Comment(value={"The amount of energy an inserter upgraded Medical Crate takes per one heal (in IF/RF/FE)"})
                public static int mediCrateEnergyPerAction = 50;
                @Config.Comment(value={"The amount of energy an inserter upgraded Repair Crate takes per one repair (in IF/RF/FE)"})
                public static int repairCrateEnergyPerAction = 65;
                @Config.Comment(value={"The amount of energy an inserter upgraded Ammunition Crate takes per one 4 second effect (in IF/RF/FE)"})
                public static int ammoCrateEnergyPerAction = 85;
                @Config.Comment(value={"The amount of energy an inserter upgraded crate can store (in IF/RF/FE)"})
                public static int maxEnergyStored = 4000;
                @Config.Comment(value={"The amount of energy an inserter upgraded crate can drain in one tick (in IF/RF/FE)"})
                public static int energyDrain = 40;
            }

            public static class VehicleWorkshop {
                @Config.Comment(value={"Energy capacity of the the Vehicle Workshop (in IF)."})
                public static int energyCapacity = 100000;
                @Config.RequiresWorldRestart
                @Config.Comment(value={"Fluid (diesel) capacity of the the Vehicle Workshop (in mB)."})
                public static int dieselCapacity = 24000;
            }

            public static class Filler {
                @Config.Comment(value={"Energy capacity of the the Filler (in IF)."})
                public static int energyCapacity = 16000;
                @Config.RequiresWorldRestart
                @Config.Comment(value={"Dust capacity of the the Filler (in mB, 1 dustStack is 100mB)."})
                public static int dustCapacity = 32000;
            }

            public static class ProgrammableSpeaker {
                @Config.Comment(value={"The distance the speaker can be heard from."})
                public static int soundRange = 24;
            }

            public static class AlarmSiren {
                @Config.Comment(value={"The distance the siren can be heard from."})
                public static int soundRange = 16;
            }

            public static class RedstoneInterface {
            }
        }

        public static class Tools {
            @Config.SubConfig
            public static SkycrateMounts skycrateMounts;
            @Config.SubConfig
            public static TripodPeriscope tripodPeriscope;
            @Config.Comment(value={"A modifier to apply to the ammunition resupply time of the Ammunition Crate (weapons reload)."})
            public static float ammunitionCrateResupplyTime;
            @Config.Comment(value={"The Lighter fuel capacity in milibuckets (mB)."})
            @Config.RequiresMcRestart
            public static int lighterCapacity;
            @Config.Comment(value={"The capacity of the measuring cup (mB)."})
            @Config.RequiresMcRestart
            public static int measuringCupCapacity;
            @Config.Comment(value={"The energy capacity of the electric hammer in RF... i mean IF... i mean FE... that thing o' powerin'!."})
            @Config.RequiresMcRestart
            public static int electricHammerCapacity;
            @Config.Comment(value={"The energy capacity of the electric wirecutter."})
            @Config.RequiresMcRestart
            public static int electricWirecutterCapacity;
            @Config.Comment(value={"The energy capacity of the electric wrench."})
            @Config.RequiresMcRestart
            public static int electricWrenchCapacity;
            @Config.Comment(value={"The energy capacity of the electric multitool. (when it will be added)"})
            @Config.RequiresMcRestart
            public static int electricMultitoolCapacity;
            @Config.Comment(value={"The energy usage of the electric hammer (when mining, rotating, etc. )."})
            @Config.RequiresMcRestart
            public static int electricHammerEnergyPerUse;
            @Config.Comment(value={"The energy usage of the electric hammer when building advanced multiblocks (per tick)."})
            @Config.RequiresMcRestart
            public static int electricHammerEnergyPerUseConstruction;
            @Config.Comment(value={"The energy usage of the electric wirecutter (when cutting wires)."})
            @Config.RequiresMcRestart
            public static int electricWirecutterEnergyPerUse;
            @Config.Comment(value={"The energy usage of the electric wrench (when destroying blocks / upgrading)."})
            @Config.RequiresMcRestart
            public static int electricWrenchEnergyPerUse;
            @Config.Comment(value={"The upgrade progress added per use of the engineer's wrench (default 1IF=1 Point of Progress\u2122)."})
            @Config.RequiresMcRestart
            public static int electricWrenchUpgradeProgress;
            @Config.Comment(value={"The durability of the engineer's wrench."})
            @Config.RequiresMcRestart
            public static int wrenchDurability;
            @Config.Comment(value={"The upgrade progress added per use of the engineer's wrench."})
            @Config.RequiresMcRestart
            public static int wrenchUpgradeProgress;
            @Config.Comment(value={"Max zoom of the binoculars (in Blu's Unit of Magnification Measurement\u2122)."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float[] binocularsMaxZoom;
            @Config.Comment(value={"Max zoom of the advanced binoculars (in Blu's Unit of Magnification Measurement\u2122)."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
            public static float[] advancedBinocularsMaxZoom;
            @Config.Comment(value={"The energy capacity of advanced binoculars (when using Infrared Sight)."})
            @Config.RequiresMcRestart
            public static int advancedBinocularsEnergyCapacity;
            @Config.Comment(value={"The energy usage of advanced binoculars (when using Infrared Sight)."})
            @Config.RequiresMcRestart
            public static int advancedBinocularsEnergyUsage;
            @Config.Comment(value={"The durability (max number of uses) of the Precision Buzzsaw."})
            @Config.RequiresMcRestart
            public static int precissionToolBuzzsawDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Precision Drill."})
            @Config.RequiresMcRestart
            public static int precissionToolDrillDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Precision Inserter."})
            @Config.RequiresMcRestart
            public static int precissionToolInserterDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Precision Solderer."})
            @Config.RequiresMcRestart
            public static int precissionToolSoldererDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Precision Welder."})
            @Config.RequiresMcRestart
            public static int precissionToolWelderDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Precision Hammer."})
            @Config.RequiresMcRestart
            public static int precissionToolHammerDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Iron Sawblade."})
            @Config.RequiresMcRestart
            public static int sawbladeIronDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Steel Sawblade."})
            @Config.RequiresMcRestart
            public static int sawbladeSteelDurability;
            @Config.Comment(value={"The durability (max number of uses) of the Tungsten Sawblade."})
            @Config.RequiresMcRestart
            public static int sawbladeTungstenDurability;
            @Config.Comment(value={"The usage time of the Precision Buzzsaw."})
            @Config.RequiresMcRestart
            public static int precissionToolBuzzsawUsageTime;
            @Config.Comment(value={"The usage time of the Precision Drill."})
            @Config.RequiresMcRestart
            public static int precissionToolDrillUsageTime;
            @Config.Comment(value={"The usage time of the Precision Inserter."})
            @Config.RequiresMcRestart
            public static int precissionToolInserterUsageTime;
            @Config.Comment(value={"The usage time of the Precision Solderer."})
            @Config.RequiresMcRestart
            public static int precissionToolSoldererUsageTime;
            @Config.Comment(value={"The usage time of the Precision Welder."})
            @Config.RequiresMcRestart
            public static int precissionToolWelderUsageTime;
            @Config.Comment(value={"The usage time of the Precision Hammer."})
            @Config.RequiresMcRestart
            public static int precissionToolHammerUsageTime;
            @Config.Comment(value={"The capacity of the Improved Capacitor Backpack (in IF)."})
            @Config.RequiresMcRestart
            public static int advancedPowerpackCapacity;

            static {
                ammunitionCrateResupplyTime = 1.0f;
                lighterCapacity = 1000;
                measuringCupCapacity = 500;
                electricHammerCapacity = 24000;
                electricWirecutterCapacity = 24000;
                electricWrenchCapacity = 24000;
                electricMultitoolCapacity = 100000;
                electricHammerEnergyPerUse = 100;
                electricHammerEnergyPerUseConstruction = 4096;
                electricWirecutterEnergyPerUse = 100;
                electricWrenchEnergyPerUse = 1000;
                electricWrenchUpgradeProgress = 1000;
                wrenchDurability = 256;
                wrenchUpgradeProgress = 350;
                binocularsMaxZoom = new float[]{0.1f, 0.125f, 0.167f, 0.25f, 0.5f};
                advancedBinocularsMaxZoom = new float[]{0.05f, 0.0625f, 0.0833f, 0.1f, 0.25f, 0.5f};
                advancedBinocularsEnergyCapacity = 4000;
                advancedBinocularsEnergyUsage = 150;
                precissionToolBuzzsawDurability = 150;
                precissionToolDrillDurability = 250;
                precissionToolInserterDurability = 200;
                precissionToolSoldererDurability = 150;
                precissionToolWelderDurability = 250;
                precissionToolHammerDurability = 200;
                sawbladeIronDurability = 150;
                sawbladeSteelDurability = 300;
                sawbladeTungstenDurability = 550;
                precissionToolBuzzsawUsageTime = 140;
                precissionToolDrillUsageTime = 140;
                precissionToolInserterUsageTime = 60;
                precissionToolSoldererUsageTime = 80;
                precissionToolWelderUsageTime = 160;
                precissionToolHammerUsageTime = 40;
                advancedPowerpackCapacity = 1000000;
            }

            public static class TripodPeriscope {
                @Config.Comment(value={"Determines how fast the Tripod Periscope can be set up (in ticks)."})
                @Config.RangeInt(min=0)
                @Config.RequiresMcRestart
                public static int setupTime = 60;
                @Config.Comment(value={"The yaw turn speed of the Tripod Periscope (in degrees)."})
                @Config.RequiresMcRestart
                public static float turnSpeed = 2.5f;
                @Config.Comment(value={"Max zoom of a machinegun with a scope mounted (in Blu's Unit of Distance Measurement\u2122)."})
                @Config.RequiresMcRestart
                @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_floatA")
                public static float[] tripodZoomSteps = new float[]{0.01f, 0.02f, 0.04f, 0.0625f, 0.0833f, 0.125f, 0.25f, 0.5f};
            }

            public static class SkycrateMounts {
                @Config.Comment(value={"The speed of the Mechanical Skycrate Mount."})
                @Config.RequiresMcRestart
                public static float mechSpeed = 0.25f;
                @Config.Comment(value={"The energy (max distance to be traveled) of the Mechanical Skycrate Mount."})
                @Config.RequiresMcRestart
                public static float mechEnergy = 35.0f;
                @Config.Comment(value={"The speed of the Electric Skycrate Mount."})
                @Config.RequiresMcRestart
                public static float electricSpeed = 1.0f;
                @Config.Comment(value={"The energy to distance ratio of the Electric Skycrate Mount. (in Immersive Flux per Meter)"})
                @Config.RequiresMcRestart
                public static int electricEnergyRatio = 128;
                @Config.Comment(value={"The energy capacity of the Electric Skycrate Mount (in Immersive Flux)."})
                @Config.RequiresMcRestart
                public static float electricEnergy = 55.0f;
            }
        }

        public static class Ores {
            @Config.Comment(value={"A blacklist of dimensions in which IE ores won't spawn. By default this is Nether (-1) and End (1)"})
            public static int[] oreDimBlacklistNormal = new int[]{-1, 1};
            @Config.Comment(value={"A blacklist of dimensions in which IE ores won't spawn. By default this is the Overworld (0) and End (1)"})
            public static int[] oreDimBlacklistNether = new int[]{0, 1};
            @Config.Comment(value={"Set this to false to disable the logging of the chunks that were flagged for retrogen."})
            public static boolean retrogenLogFlagChunk = true;
            @Config.Comment(value={"Set this to false to disable the logging of the chunks that are still left to retrogen."})
            public static boolean retrogenLogRemaining = true;
            @Config.Comment(value={"The retrogeneration key. Basically IE checks if this key is saved in the chunks data. If it isn't, it will perform retrogen on all ores marked for retrogen.", "Change this in combination with the retrogen booleans to regen only some of the ores."})
            public static String retrogenKey = "DEFAULT_II";
            @Config.Comment(value={"Generation config for Platinum Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] orePlatinum = new int[]{6, 0, 10, 2, 75};
            @Config.Comment(value={"Generation config for Zinc Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] oreZinc = new int[]{10, 35, 95, 2, 100};
            @Config.Comment(value={"Generation config for Tungsten Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] oreTungsten = new int[]{6, 0, 35, 2, 75};
            @Config.Comment(value={"Generation config for Salt Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] oreSalt = new int[]{12, 55, 95, 1, 75};
            @Config.Comment(value={"Generation config for Fluorite Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] oreFluorite = new int[]{6, 1, 55, 1, 65};
            @Config.Comment(value={"Generation config for Fluorite Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIConfigHandler.class, mapName="manual_intA")
            public static int[] orePhosphorus = new int[]{12, 1, 55, 1, 80};
            @Config.Comment(value={"Set this to true to allow retro-generation of Platinum Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogenPlatinum = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Zinc Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogenZinc = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Tungsten Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogenTungsten = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Salt Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogenSalt = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Salt Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogenFluorite = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Salt Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogenPhosphorus = false;
            @Config.Comment(value={"Whether rubber trees should be generated."})
            @Config.RequiresWorldRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean genRubberTrees = true;
            @Config.RangeInt(min=0, max=100)
            @Config.RequiresWorldRestart
            public static int genRubberTreesChance = 15;
        }

        public static class Graphics {
            @Config.Comment(value={"Enable Tactile AMT - dynamic collision boxes for multiblocks that use animations for positioning them."})
            public static boolean tactileAMT = true;
            @Config.Comment(value={"Whether gun recoil is visible in first-person view."})
            public static boolean cameraRecoil = true;
            @Config.Comment(value={"Roll the camera when turning the motorbike."})
            public static boolean cameraRoll = false;
            @Config.Comment(value={"Determines how hand animations should be displayed on II models", "0 - disabled", "1 - first person only", "2 - 1st and 3rd person (may be incompatible with mods modifying the player model)"})
            @Config.RangeInt(min=0, max=2)
            public static int AMTHandDisplayMode = 1;
            @Config.RequiresMcRestart
            @Config.Comment(value={"Max amount of block penetrations that will be rendered. 0 will disable rendering."})
            public static int maxPenetratedBlocks = 64;
        }
    }
}

