/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.BlockIIMetalDecoration;
import pl.pabilo8.immersiveintelligence.common.block.mines.BlockIIMine;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IICreativeTab
extends CreativeTabs {
    public static List<Fluid> fluidBucketMap = new ArrayList<Fluid>();

    public IICreativeTab(String name) {
        super(name);
    }

    @Nonnull
    public ItemStack func_78016_d() {
        return IIContent.blockMetalDecoration.getStack(BlockIIMetalDecoration.IIBlockTypes_MetalDecoration.COIL_DATA, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(@Nonnull NonNullList<ItemStack> list) {
        super.func_78018_a(list);
        this.addExampleBullets(list);
        for (Fluid fluid : fluidBucketMap) {
            this.addFluidBucket(fluid, list);
        }
    }

    public void addFluidBucket(Fluid fluid, NonNullList<ItemStack> list) {
        UniversalBucket bucket = ForgeModContainer.getInstance().universalBucket;
        ItemStack stack = new ItemStack((Item)bucket);
        FluidBucketWrapper fluidHandler = new FluidBucketWrapper(stack);
        FluidStack fs = new FluidStack(fluid, bucket.getCapacity());
        if (fluidHandler.fill(fs, true) == fs.amount) {
            list.add((Object)fluidHandler.getContainer());
        }
    }

    public void addExampleBullets(NonNullList<ItemStack> list) {
        for (IAmmo bullet : new IAmmo[]{IIContent.itemAmmoArtillery, IIContent.itemAmmoLightArtillery, IIContent.itemAmmoMortar}) {
            for (String[] core : new String[][]{{"core_brass", "canister"}, {"core_tungsten", "piercing"}, {"core_steel", "shaped"}}) {
                String[] stringArray = new String[]{"tnt", "rdx", "hmx"};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String explosive = stringArray[i];
                    list.add((Object)bullet.getBulletWithParams(core[0], core[1], explosive, "tracer_powder"));
                }
            }
        }
        list.add((Object)IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "hmx", "white_phosphorus").func_151001_c("Phosphorgranate mk. 1"));
        list.add((Object)IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "fluid_napalm").func_151001_c("Napalmgranate mk. 1"));
        list.add((Object)IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "nuke").func_151001_c("Geburtstagsgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "tnt").func_151001_c("Stielhandgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "white_phosphorus").func_151001_c("Phosphorhandgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "rdx").func_151001_c("Sprenghandgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "hmx").func_151001_c("Sprenghandgranate mk.2"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "gas_chlorine").func_151001_c("Chemhandgranate mk.1"));
        ItemStack grenade_firework = IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "firework").func_151001_c("Feuerwerkhandgranate mk.1");
        IIContent.itemGrenade.setComponentNBT(grenade_firework, EasyNBT.parseNBT("{Explosion:{Type:0b,Colors:[I;3887386]}}", new Object[0]));
        list.add((Object)IIContent.itemRailgunGrenade.getBulletWithParams("core_brass", "canister", "gas_chlorine").func_151001_c("Schienenkanone Chemgranate mk.1"));
        list.add((Object)IIContent.itemRailgunGrenade.getBulletWithParams("core_brass", "canister", "rdx").func_151001_c("Schienenkanone Sprenggranate mk.1"));
        list.add((Object)grenade_firework);
        list.add((Object)IIContent.itemAmmoRevolver.getBulletWithParams("core_brass", "canister", "white_phosphorus").func_151001_c("Flammpatrone mk.1"));
        list.add((Object)IIContent.itemAmmoRevolver.getBulletWithParams("core_tungsten", "piercing", new String[0]).func_151001_c("Wolframpatrone mk.1"));
        ItemStack bullet_tracer = IIContent.itemAmmoRevolver.getBulletWithParams("core_brass", "canister", "tracer_powder").func_151001_c("Markierungspatrone mk.1");
        IIContent.itemAmmoRevolver.setComponentNBT(bullet_tracer, EasyNBT.parseNBT("{colour:3887386}", new Object[0]));
        list.add((Object)bullet_tracer);
        ItemStack bullet1 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("Sprengpatrone mk.1");
        list.add((Object)bullet1);
        ItemStack bullet2 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_tungsten", "piercing", "shrapnel_tungsten").func_151001_c("Wolframpatrone mk.1");
        list.add((Object)bullet2);
        ItemStack bullet3 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_steel", "piercing", new String[0]).func_151001_c("Stahlpatrone mk.1");
        list.add((Object)bullet3);
        ItemStack bullet4 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_brass", "softpoint", "white_phosphorus").func_151001_c("Phosphorpatrone mk.1");
        list.add((Object)bullet4);
        list.add((Object)IIContent.itemBulletMagazine.getMagazine(ItemIIBulletMagazine.Magazines.MACHINEGUN, bullet1, bullet2, bullet3, bullet4));
        list.add((Object)IIContent.itemBulletMagazine.getMagazine(ItemIIBulletMagazine.Magazines.SUBMACHINEGUN, IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("Sprengpatrone mk.1"), IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_tungsten", "piercing", "shrapnel_tungsten").func_151001_c("Wolframpatrone mk.1"), IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_steel", "piercing", new String[0]).func_151001_c("Stahlpatrone mk.1"), IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_brass", "softpoint", "white_phosphorus").func_151001_c("Phosphorpatrone mk.1")));
        ItemStack bullet5 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_uranium", "piercing", "shrapnel_uranium").func_151001_c("Uraniumpatrone mk.1");
        list.add((Object)bullet5);
        list.add((Object)IIContent.itemBulletMagazine.getMagazine(ItemIIBulletMagazine.Magazines.MACHINEGUN, bullet5));
        for (ItemIIBulletMagazine.Magazines magazine : ItemIIBulletMagazine.Magazines.values()) {
            if (IIContent.itemBulletMagazine.isMetaHidden(magazine.getMeta())) continue;
            list.add((Object)this.getColorMagazine(magazine, 65327, 0xFF0000, 25343, 0xFFEE00));
        }
        assert (IIContent.blockRadioExplosives.itemBlock instanceof BlockIIMine.ItemBlockMineBase);
        assert (IIContent.blockTellermine.itemBlock instanceof BlockIIMine.ItemBlockMineBase);
        assert (IIContent.blockTripmine.itemBlock instanceof BlockIIMine.ItemBlockMineBase);
        list.add((Object)((BlockIIMine.ItemBlockMineBase)IIContent.blockRadioExplosives.itemBlock).getBulletWithParams("core_brass", "canister", "tnt").func_151001_c("Radio-Sprengstoff TNT mk.1"));
        list.add((Object)((BlockIIMine.ItemBlockMineBase)IIContent.blockRadioExplosives.itemBlock).getBulletWithParams("core_brass", "canister", "white_phosphorus").func_151001_c("Radio-Sprengstoff Phosphor mk.1"));
        list.add((Object)((BlockIIMine.ItemBlockMineBase)IIContent.blockTellermine.itemBlock).getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("Tellermine mk.1"));
        list.add((Object)((BlockIIMine.ItemBlockMineBase)IIContent.blockTripmine.itemBlock).getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("SD-Mine mk.1"));
        list.add((Object)IIContent.itemNavalMine.getBulletWithParams("core_brass", "softpoint", "rdx").func_151001_c("Seemine mk.1"));
    }

    ItemStack getColorMagazine(ItemIIBulletMagazine.Magazines magazine, int ... colors) {
        ItemStack[] bullets = new ItemStack[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            ItemStack stack = magazine.ammo.getBulletWithParams("core_steel", "softpoint", "tracer_powder").func_151001_c(this.getGermanColorName(colors[i]) + "markierungspatrone");
            magazine.ammo.setComponentNBT(stack, EasyNBT.parseNBT("{colour: %s}", colors[i]));
            magazine.ammo.setPaintColour(stack, colors[i]);
            bullets[i] = stack;
        }
        return IIContent.itemBulletMagazine.getMagazine(magazine, bullets);
    }

    private String getGermanColorName(int color) {
        switch (IIUtils.getRGBTextFormatting(color)) {
            case WHITE: {
                return "Wei\u00df";
            }
            case ORANGE: {
                return "Orange";
            }
            case MAGENTA: {
                return "Magenta";
            }
            case LIGHT_BLUE: {
                return "Hellblau";
            }
            case YELLOW: {
                return "Gelb";
            }
            case LIME: {
                return "Lime";
            }
            case PINK: {
                return "Rosa";
            }
            case GRAY: {
                return "Grau";
            }
            case SILVER: {
                return "Silber";
            }
            case CYAN: {
                return "Cyan";
            }
            case PURPLE: {
                return "Purpur";
            }
            case BLUE: {
                return "Blau";
            }
            case BROWN: {
                return "Braun";
            }
            case GREEN: {
                return "Gr\u00fcn";
            }
            case RED: {
                return "Rot";
            }
        }
        return "Schwarz";
    }
}

