/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.IntMath;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IWrench;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.compat.BaublesHelper;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;

public class IIUtils {
    public static double getDistanceBetweenPos(BlockPos pos1, BlockPos pos2, boolean center) {
        double deltaX = (double)pos1.func_177958_n() + (center ? 0.0 : 0.5) - ((double)pos2.func_177958_n() + (center ? 0.0 : 0.5));
        double deltaY = (double)pos1.func_177956_o() + (center ? 0.0 : 0.5) - ((double)pos2.func_177956_o() + (center ? 0.0 : 0.5));
        double deltaZ = (double)pos1.func_177952_p() + (center ? 0.0 : 0.5) - ((double)pos2.func_177952_p() + (center ? 0.0 : 0.5));
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static <T extends TileEntity> Set<ImmersiveNetHandler.Connection> genConnectableBlockstate(T te) {
        Set conns = ImmersiveNetHandler.INSTANCE.getConnections(te.func_145831_w(), te.func_174877_v());
        if (conns == null) {
            return ImmutableSet.of();
        }
        HashSet<ImmersiveNetHandler.Connection> ret = new HashSet<ImmersiveNetHandler.Connection>(){

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HashSet)) {
                    return false;
                }
                HashSet other = (HashSet)o;
                if (other.size() != this.size()) {
                    return false;
                }
                for (ImmersiveNetHandler.Connection c : this) {
                    if (other.contains(c)) continue;
                    return false;
                }
                return true;
            }
        };
        for (ImmersiveNetHandler.Connection c : conns) {
            IImmersiveConnectable end = ApiUtils.toIIC((Object)c.end, (World)te.func_145831_w(), (boolean)false);
            if (end == null) continue;
            c.getSubVertices(te.func_145831_w());
            ret.add(c);
        }
        return ret;
    }

    @Nullable
    public static IDataConnector findConnectorFacing(BlockPos pos, World world, EnumFacing facing) {
        IEBlockInterfaces.IDirectionalTile t;
        BlockPos newpos = pos.func_177972_a(facing);
        if (!world.func_175667_e(newpos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(newpos);
        if (te instanceof IDataConnector && te instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)te).getFacing() == facing.func_176734_d()) {
            return (IDataConnector)te;
        }
        return null;
    }

    @Nullable
    public static IDataConnector findConnectorAround(BlockPos pos, World world) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IDataConnector conn = IIUtils.findConnectorFacing(pos, world, facing);
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    public static double root(double num, double root) {
        double d = Math.pow(num, 1.0 / root);
        long rounded = Math.round(d);
        return Math.abs((double)rounded - d) < 1.0E-14 ? (double)rounded : d;
    }

    public static int[] rgbToCmyk(int red, int green, int blue) {
        return new int[]{255 - red, 255 - green, 255 - blue, 255 - Math.min(red, Math.max(green, blue))};
    }

    public static float[] rgbToCmyk(float r, float g, float b) {
        int[] cmyk = IIUtils.rgbToCmyk((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
        return new float[]{(float)cmyk[0] / 255.0f, (float)cmyk[1] / 255.0f, (float)cmyk[2] / 255.0f, (float)cmyk[3] / 255.0f};
    }

    public static float[] rgbToCmyk(float[] rgb) {
        return IIUtils.rgbToCmyk(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] cmykToRgb(int cyan, int magenta, int yellow, int black) {
        return new int[]{Math.min(255 - black, 255 - cyan), Math.min(255 - black, 255 - magenta), Math.min(255 - black, 255 - yellow)};
    }

    public static float[] cmykToRgb(float c, float m, float y, float b) {
        int[] dec = IIUtils.cmykToRgb((int)(c * 255.0f), (int)(m * 255.0f), (int)(y * 255.0f), (int)(b * 255.0f));
        return new float[]{(float)dec[0] / 255.0f, (float)dec[1] / 255.0f, (float)dec[2] / 255.0f};
    }

    public static float[] hsvToRgb(float hue, float saturation, float value) {
        float b;
        float g;
        float r;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        switch (i) {
            case 0: {
                r = value;
                g = f3;
                b = f1;
                break;
            }
            case 1: {
                r = f2;
                g = value;
                b = f1;
                break;
            }
            case 2: {
                r = f1;
                g = value;
                b = f3;
                break;
            }
            case 3: {
                r = f1;
                g = f2;
                b = value;
                break;
            }
            case 4: {
                r = f3;
                g = f1;
                b = value;
                break;
            }
            case 5: {
                r = value;
                g = f1;
                b = f2;
                break;
            }
            default: {
                r = 0.0f;
                g = 0.0f;
                b = 0.0f;
            }
        }
        return new float[]{r, g, b};
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float s;
        float cMax = Math.max(Math.max(r, g), b);
        float cMin = Math.min(Math.min(r, g), b);
        float d = cMax - cMin;
        float f = s = cMax != 0.0f ? d / cMax : 0.0f;
        float h = d == 0.0f ? 0.0f : (cMax == r ? (g - b) / d % 6.0f / 6.0f : (cMax == g ? ((b - r) / d + 2.0f) / 6.0f : (cMax == b ? ((r - g) / d + 4.0f) / 6.0f : 0.0f)));
        if (h < 0.0f) {
            h = 1.0f + h;
        }
        return new float[]{h, s, cMax};
    }

    public static boolean isPointInRectangle(double x, double y, double xx, double yy, double px, double py) {
        return px >= x && px < xx && py >= y && py < yy;
    }

    public static boolean isPointInTriangle(int x, int y, int xx, int yy, int xxx, int yyy, int px, int py) {
        boolean s_ab;
        int as_x;
        int as_y;
        if ((xxx - x) * as_y - (yyy - y) * as_x > 0 == (s_ab = (xx - x) * (as_y = py - y) - (yy - y) * (as_x = px - x) > 0)) {
            return false;
        }
        return (xxx - xx) * (py - yy) - (yyy - yy) * (px - xx) > 0 == s_ab;
    }

    public static <T extends IFluidTank & IFluidHandler> boolean handleBucketTankInteraction(T tank, NonNullList<ItemStack> inventory, int bucketInputSlot, int bucketOutputSlot, boolean fillBucket, Predicate<FluidStack> filter) {
        if (((ItemStack)inventory.get(bucketInputSlot)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            ItemStack emptyContainer;
            IFluidHandlerItem capability = (IFluidHandlerItem)((ItemStack)inventory.get(bucketInputSlot)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (!filter.test(capability.getTankProperties()[0].getContents())) {
                return false;
            }
            int amount_prev = tank.getFluidAmount();
            if (fillBucket) {
                if (((IFluidHandler)tank).getTankProperties()[0].getContents() == null) {
                    return false;
                }
                emptyContainer = Utils.fillFluidContainer((IFluidHandler)tank, (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            } else {
                if (capability.getTankProperties()[0].getContents() == null) {
                    return false;
                }
                emptyContainer = Utils.drainFluidContainer((IFluidHandler)tank, (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            }
            if (amount_prev != tank.getFluidAmount()) {
                if (!((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), (ItemStack)emptyContainer, (boolean)true)) {
                    ((ItemStack)inventory.get(bucketOutputSlot)).func_190917_f(emptyContainer.func_190916_E());
                } else if (((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b()) {
                    inventory.set(bucketOutputSlot, (Object)emptyContainer.func_77946_l());
                }
                ((ItemStack)inventory.get(bucketInputSlot)).func_190918_g(1);
                if (((ItemStack)inventory.get(bucketInputSlot)).func_190916_E() <= 0) {
                    inventory.set(bucketInputSlot, (Object)ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static <T extends IFluidTank & IFluidHandler> boolean handleBucketTankInteraction(T[] tanks, NonNullList<ItemStack> inventory, int bucketInputSlot, int bucketOutputSlot, int tank, boolean fillBucket) {
        return IIUtils.handleBucketTankInteraction(tanks, inventory, (int)bucketInputSlot, (int)bucketOutputSlot, (int)tank, (boolean)fillBucket, (T fluidStack) -> true);
    }

    public static <T extends IFluidTank & IFluidHandler> boolean handleBucketTankInteraction(T[] tanks, NonNullList<ItemStack> inventory, int bucketInputSlot, int bucketOutputSlot, int tank, boolean fillBucket, Predicate<FluidStack> filter) {
        if (((ItemStack)inventory.get(bucketInputSlot)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            ItemStack emptyContainer;
            IFluidHandlerItem capability = (IFluidHandlerItem)((ItemStack)inventory.get(bucketInputSlot)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (!filter.test(capability.getTankProperties()[0].getContents())) {
                return false;
            }
            int amount_prev = tanks[tank].getFluidAmount();
            if (fillBucket) {
                if (((IFluidHandler)tanks[tank]).getTankProperties()[0].getContents() == null) {
                    return false;
                }
                emptyContainer = Utils.fillFluidContainer((IFluidHandler)((IFluidHandler)tanks[tank]), (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            } else {
                if (capability.getTankProperties()[0].getContents() == null) {
                    return false;
                }
                emptyContainer = Utils.drainFluidContainer((IFluidHandler)((IFluidHandler)tanks[tank]), (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            }
            if (amount_prev != tanks[tank].getFluidAmount()) {
                if (!((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), (ItemStack)emptyContainer, (boolean)true)) {
                    ((ItemStack)inventory.get(bucketOutputSlot)).func_190917_f(emptyContainer.func_190916_E());
                } else if (((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b()) {
                    inventory.set(bucketOutputSlot, (Object)emptyContainer.func_77946_l());
                }
                ((ItemStack)inventory.get(bucketInputSlot)).func_190918_g(1);
                if (((ItemStack)inventory.get(bucketInputSlot)).func_190916_E() <= 0) {
                    inventory.set(bucketInputSlot, (Object)ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean outputFluidToTank(FluidTank tank, int amount, BlockPos pos, World world, EnumFacing side) {
        if (tank.getFluidAmount() > 0) {
            int accepted;
            FluidStack out = tank.drain(Math.min(tank.getFluidAmount(), amount), false);
            IFluidHandler output = FluidUtil.getFluidHandler((World)world, (BlockPos)pos.func_177972_a(side), (EnumFacing)side.func_176734_d());
            if (output != null && (accepted = output.fill(out, true)) > 0) {
                int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
                tank.drain(drained, true);
                return true;
            }
        }
        return false;
    }

    public static Vec3d offsetPosDirection(float offset, double yaw, double pitch) {
        if (offset == 0.0f) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        double yy = MathHelper.func_76126_a((float)((float)pitch)) * offset;
        double true_offset = MathHelper.func_76134_b((float)((float)pitch)) * offset;
        double xx = (double)MathHelper.func_76126_a((float)((float)yaw)) * true_offset;
        double zz = (double)MathHelper.func_76134_b((float)((float)yaw)) * true_offset;
        return new Vec3d(xx, yy, zz);
    }

    public static float[] rgbIntToRGB(int rgb) {
        float r = (float)(rgb >> 16 & 0xFF) * 0.003921f;
        float g = (float)(rgb >> 8 & 0xFF) * 0.003921f;
        float b = (float)(rgb & 0xFF) * 0.003921f;
        return new float[]{r, g, b};
    }

    public static char cycleDataPacketChars(char current, boolean forward, boolean hasEmpty) {
        if (hasEmpty) {
            if (current == ' ') {
                current = forward ? DataPacket.varCharacters[0] : DataPacket.varCharacters[DataPacket.varCharacters.length - 1];
            } else {
                int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
                current = (current_char += forward ? 1 : -1) >= DataPacket.varCharacters.length || current_char < 0 ? (char)32 : DataPacket.varCharacters[current_char];
            }
        } else {
            int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
            current = (current_char += forward ? 1 : -1) >= DataPacket.varCharacters.length ? DataPacket.varCharacters[0] : (current_char < 0 ? DataPacket.varCharacters[DataPacket.varCharacters.length - 1] : DataPacket.varCharacters[current_char]);
        }
        return current;
    }

    public static char cyclePacketCharsAvoiding(char current, boolean forward, boolean hasEmpty, DataPacket packet) {
        int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
        int repeats = DataPacket.varCharacters.length + (hasEmpty ? 1 : 0);
        for (int i = 0; i < repeats; ++i) {
            char c;
            if ((current_char += forward ? 1 : -1) >= repeats) {
                current_char = 0;
            }
            if (current_char < 0) {
                current_char = repeats - 1;
            }
            char c2 = c = hasEmpty && current_char == DataPacket.varCharacters.length ? (char)' ' : DataPacket.varCharacters[current_char];
            if (packet.hasVariable(Character.valueOf(c))) continue;
            return c;
        }
        return current;
    }

    public static float clampedLerp3Par(float e1, float e2, float e3, float percent) {
        return (float)MathHelper.func_151238_b((double)MathHelper.func_151238_b((double)e1, (double)e2, (double)(percent * 2.0f)), (double)e3, (double)(Math.max(percent - 0.5f, 0.0f) * 2.0f));
    }

    public static float calculateBallisticAngle(double distance, double height, float force, double gravity, double drag, double anglePrecision) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (gravity == 0.0) {
            return 90.0f - (float)(Math.atan(height / distance) * 180.0 / Math.PI);
        }
        for (double i = Math.PI * anglePrecision; i < 1.5707963267948966; i += anglePrecision) {
            double motionX = MathHelper.func_76134_b((float)((float)i)) * force;
            double motionY = MathHelper.func_76126_a((float)((float)i)) * force;
            double posX = 0.0;
            for (double posY = 0.0; posY > height || motionY > 0.0; posY += (motionY -= gravity)) {
                motionY *= drag;
                posX += (motionX *= drag);
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    public static boolean isAdvancedHammer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_ADVANCED_HAMMER");
    }

    public static boolean isAABBContained(@Nonnull AxisAlignedBB compared, @Nonnull AxisAlignedBB comparedTo) {
        Vec3d c0 = new Vec3d(compared.field_72340_a, compared.field_72338_b, compared.field_72339_c);
        Vec3d c1 = new Vec3d(compared.field_72336_d, compared.field_72338_b, compared.field_72339_c);
        Vec3d c2 = new Vec3d(compared.field_72340_a, compared.field_72337_e, compared.field_72339_c);
        Vec3d c3 = new Vec3d(compared.field_72336_d, compared.field_72337_e, compared.field_72339_c);
        Vec3d c4 = new Vec3d(compared.field_72340_a, compared.field_72338_b, compared.field_72334_f);
        Vec3d c5 = new Vec3d(compared.field_72336_d, compared.field_72338_b, compared.field_72334_f);
        Vec3d c6 = new Vec3d(compared.field_72340_a, compared.field_72337_e, compared.field_72334_f);
        Vec3d c7 = new Vec3d(compared.field_72336_d, compared.field_72337_e, compared.field_72334_f);
        AxisAlignedBB comp2 = comparedTo.func_186662_g((double)0.1f);
        return comp2.func_72318_a(c0) && comp2.func_72318_a(c1) && comp2.func_72318_a(c2) && comp2.func_72318_a(c3) && comp2.func_72318_a(c4) && comp2.func_72318_a(c5) && comp2.func_72318_a(c6) && comp2.func_72318_a(c7);
    }

    public static String toCamelCase(String string, boolean startSmall) {
        String[] all;
        StringBuilder result = new StringBuilder();
        for (String s : all = string.split("_")) {
            result.append(Character.toUpperCase(s.charAt(0)));
            result.append(s.substring(1));
        }
        if (startSmall) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static void unlockIIAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            if (IIUtils.hasUnlockedIIAdvancement(player, name)) {
                return;
            }
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveintelligence", name));
            if (advancement != null) {
                advancements.func_192750_a(advancement, "code_trigger");
            }
        }
    }

    public static boolean hasUnlockedIIAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveintelligence", name));
            if (advancement != null) {
                return advancements.func_192747_a(advancement).func_192105_a();
            }
        }
        return false;
    }

    public static boolean isWrench(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_WRENCH") && stack.func_77973_b() instanceof IWrench;
    }

    public static boolean isTachometer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("TOOL_TACHOMETER");
    }

    public static boolean isCrowbar(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_CROWBAR");
    }

    public static boolean isVoltmeter(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)stack, (boolean)true);
    }

    public static int cycleInt(boolean forward, int current, int min, int max) {
        if ((current += forward ? 1 : -1) > max) {
            return min;
        }
        if (current < min) {
            return max;
        }
        return current;
    }

    public static int cycleIntAvoid(boolean forward, int current, int min, int max, int avoid) {
        int i = IIUtils.cycleInt(forward, current, min, max);
        if (i == avoid) {
            return IIUtils.cycleInt(forward, i, min, max);
        }
        return i;
    }

    public static <E extends Enum<E>> E cycleEnum(boolean forward, Class<E> enumType, E current) {
        return (E)((Enum[])enumType.getEnumConstants())[IIUtils.cycleInt(forward, current.ordinal(), 0, ((Enum[])enumType.getEnumConstants()).length - 1)];
    }

    public static boolean compareBlockstateOredict(IBlockState state, String oreName) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        return Utils.compareToOreName((ItemStack)stack, (String)oreName);
    }

    public static int RGBAToRGB(int color) {
        return color - (color >> 24 & 0xFF);
    }

    static double colorDistance(int a, int b) {
        float[] f1 = IIUtils.rgbIntToRGB(a);
        float[] f2 = IIUtils.rgbIntToRGB(b);
        return IIUtils.colorDistance(f1, f2);
    }

    static double colorDistance(float[] f1, float[] f2) {
        int deltaR = (int)(f1[0] * 255.0f - f2[0] * 255.0f);
        int deltaG = (int)(f1[1] * 255.0f - f2[1] * 255.0f);
        int deltaB = (int)(f1[2] * 255.0f - f2[2] * 255.0f);
        return Math.abs((double)(deltaR * deltaR + deltaG * deltaG + deltaB * deltaB) / 3.0);
    }

    public static EnumDyeColor getRGBTextFormatting(int color) {
        float[] cc = IIUtils.rgbIntToRGB(color);
        Optional<EnumDyeColor> min = Arrays.stream(EnumDyeColor.values()).min(Comparator.comparingDouble(value -> IIUtils.colorDistance(value.func_193349_f(), cc)));
        return min.orElse(EnumDyeColor.BLACK);
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static float getMaxClientProgress(float current, float required, int parts) {
        return current - current % (required / (float)parts);
    }

    public static int rgb(float rIn, float gIn, float bIn) {
        return IIUtils.rgb(MathHelper.func_76141_d((float)(rIn * 255.0f)), MathHelper.func_76141_d((float)(gIn * 255.0f)), MathHelper.func_76141_d((float)(bIn * 255.0f)));
    }

    public static int rgb(int rIn, int gIn, int bIn) {
        int lvt_3_1_ = (rIn << 8) + gIn;
        lvt_3_1_ = (lvt_3_1_ << 8) + bIn;
        return lvt_3_1_;
    }

    public static float[] medColour(float[] colour1, float[] colour2, float proportion) {
        float rev = 1.0f - proportion;
        return new float[]{colour1[0] * rev + colour2[0] * proportion, colour1[1] * rev + colour2[1] * proportion, colour1[2] * rev + colour2[2] * proportion};
    }

    public static boolean inRange(int value, int maxValue, double min, double max) {
        double vv = (double)value / (double)maxValue;
        return vv >= min && vv <= max;
    }

    @Deprecated
    public static String getPowerLevelString(TileEntityMultiblockMetal<?, ?> tile) {
        return IIUtils.getPowerLevelString(tile.getEnergyStored(null), tile.getMaxEnergyStored(null));
    }

    public static String getPowerLevelString(FluxStorage storage) {
        return IIUtils.getPowerLevelString(storage.getEnergyStored(), storage.getMaxEnergyStored());
    }

    public static String getPowerLevelString(int min, int max) {
        return String.format("%s/%s IF", min, max);
    }

    public static String getItalicString(String string) {
        return TextFormatting.ITALIC + string + TextFormatting.RESET;
    }

    public static String getHexCol(int color, String text) {
        return IIUtils.getHexCol(Integer.toHexString(color), text);
    }

    public static String getHexCol(String color, String text) {
        return String.format("<hexcol=%s:%s>", color, text);
    }

    public static float roundFloat(float number, int decimals) {
        int pow = 1;
        for (int i = 0; i < decimals; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)Math.round(tmp) / (float)pow;
    }

    public static String toSnakeCase(String value) {
        return value.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    public static float getDirectFireAngle(float initialForce, float mass, Vec3d toTarget) {
        float force = initialForce;
        double gravityMotionY = 0.0;
        double motionY = 0.0;
        double baseMotionY = toTarget.func_72432_b().field_72448_b;
        for (double dist = toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0)); dist > 0.0; dist -= (double)(EntityBullet.DEV_SLOMO * force)) {
            force -= 0.01f * force * EntityBullet.DEV_SLOMO;
            double baseMotionYC = baseMotionY * (double)(force / initialForce);
            motionY += (baseMotionYC + (gravityMotionY -= (double)(0.15f * mass * EntityBullet.DEV_SLOMO))) * (double)EntityBullet.DEV_SLOMO;
        }
        toTarget = toTarget.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        return (float)Math.toDegrees(Math.atan2(toTarget.field_72448_b, toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0))));
    }

    public static float getIEDirectRailgunAngle(ItemStack ammo, Vec3d toTarget) {
        RailgunHandler.RailgunProjectileProperties p = RailgunHandler.getProjectileProperties((ItemStack)ammo);
        if (p != null) {
            double baseMotionY;
            float force = 20.0f;
            float gravity = (float)p.gravity;
            double gravityMotionY = 0.0;
            double motionY = 0.0;
            double baseMotionYC = baseMotionY = toTarget.func_72432_b().field_72448_b;
            double dist = toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0));
            while (dist > 0.0) {
                dist -= (double)force;
                force = (float)((double)force * 0.99);
                motionY += (baseMotionYC *= (double)0.99f) + (gravityMotionY -= (double)(gravity / force));
            }
            toTarget = toTarget.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        }
        return (float)Math.toDegrees(Math.atan2(toTarget.field_72448_b, toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0))));
    }

    public static Vec3d getEntityCenter(Entity entity) {
        return entity.func_174791_d().func_72441_c((double)(-entity.field_70130_N / 2.0f), (double)(entity.field_70131_O / 2.0f), (double)(-entity.field_70130_N / 2.0f));
    }

    @Nonnull
    public static EnumFacing getFacingBetweenPos(@Nonnull BlockPos fromPos, @Nonnull BlockPos toPos) {
        Vec3d vv = new Vec3d((Vec3i)fromPos.func_177973_b((Vec3i)toPos)).func_72432_b();
        return EnumFacing.func_176737_a((float)((float)vv.field_72450_a), (float)((float)vv.field_72448_b), (float)((float)vv.field_72450_a));
    }

    public static IngredientStack ingredientFromData(IDataType dataType) {
        if (dataType instanceof DataTypeItemStack) {
            return new IngredientStack(((DataTypeItemStack)dataType).value.func_77946_l());
        }
        if (dataType instanceof DataTypeString) {
            return new IngredientStack(dataType.valueToString());
        }
        return new IngredientStack("*");
    }

    public static DataPacket getSimpleCallbackMessage(DataPacket packet, String parameter, IDataType value) {
        packet.setVariable(Character.valueOf('c'), new DataTypeString(parameter));
        packet.setVariable(Character.valueOf('g'), value);
        return packet;
    }

    public static void giveOrDropCasingStack(@Nonnull Entity entity, ItemStack stack) {
        IItemHandler capability;
        if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < 10 && !stack.func_190926_b(); ++i) {
                IItemHandler pouchCap;
                ItemStack pouchStack = i == 0 ? (IICompatModule.baubles && entity instanceof EntityPlayer ? BaublesHelper.getWornPouch((EntityPlayer)entity) : ItemStack.field_190927_a) : capability.getStackInSlot(i - 1);
                if (!pouchStack.func_77973_b().equals(IIContent.itemCasingPouch) || (pouchCap = (IItemHandler)pouchStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
                stack = ItemHandlerHelper.insertItem((IItemHandler)pouchCap, (ItemStack)stack, (boolean)false);
                if (!(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).field_71069_bz.func_75142_b();
            }
        }
        if (!stack.func_190926_b()) {
            IIUtils.giveOrDropStack(entity, stack);
        }
    }

    public static void giveOrDropStack(@Nonnull Entity entity, ItemStack stack) {
        if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            stack = ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)stack, (boolean)false);
        }
        if (!stack.func_190926_b()) {
            Utils.dropStackAtPos((World)entity.field_70170_p, (BlockPos)entity.func_180425_c(), (ItemStack)stack);
        }
    }

    public static void setEntityVelocity(Entity entity, double motionX, double motionY, double motionZ) {
        entity.field_70159_w = motionX;
        entity.field_70181_x = motionY;
        entity.field_70179_y = motionZ;
        entity.field_70133_I = true;
    }

    public static Vec3d getEntityMotion(Entity entity) {
        return new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
    }

    @Nullable
    public static <T extends Annotation> T getEnumAnnotation(Class<T> annotationClass, ISerializableEnum e) {
        try {
            Field field = e.getClass().getDeclaredField(e.func_176610_l().toUpperCase());
            if (field.isAnnotationPresent(annotationClass)) {
                return field.getAnnotation(annotationClass);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static int gcd(int ... numbers) {
        int gcd = numbers[0];
        for (int i = 1; i < numbers.length; ++i) {
            gcd = IntMath.gcd((int)gcd, (int)numbers[i]);
        }
        return gcd;
    }
}

