/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammo;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityWhitePhosphorus;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageParticleEffect;

public class AmmoComponentWhitePhosphorus
implements IAmmoComponent {
    @Override
    public String getName() {
        return "white_phosphorus";
    }

    @Override
    public IngredientStack getMaterial() {
        return new IngredientStack("dustWhitePhosphorus");
    }

    @Override
    public float getDensity() {
        return 1.0f;
    }

    @Override
    public void onEffect(float amount, AmmoRegistry.EnumCoreTypes coreType, NBTTagCompound tag, Vec3d pos, Vec3d dir, World world) {
        if (world.field_72995_K) {
            return;
        }
        Vec3d v = coreType == AmmoRegistry.EnumCoreTypes.SHAPED ? dir : dir.func_186678_a(-1.0);
        IIPacketHandler.playRangedSound(world, pos, IISounds.explosionIncendiary, SoundCategory.NEUTRAL, (int)(40.0f * amount), 1.0f, 1.0f);
        int i = 0;
        while ((float)i < 30.0f * amount) {
            Vec3d vecDir = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / (30.0f * amount) * 360.0f).func_178787_e(v);
            EntityWhitePhosphorus shrap = new EntityWhitePhosphorus(world, pos.field_72450_a + vecDir.field_72450_a, pos.field_72448_b + v.field_72448_b + 1.0, pos.field_72449_c + vecDir.field_72449_c, 0.0, 0.0, 0.0);
            shrap.field_70159_w = vecDir.field_72450_a * (double)0.35f;
            shrap.field_70181_x = (double)0.1f + Utils.RAND.nextDouble() * (double)0.2f;
            shrap.field_70179_y = vecDir.field_72449_c * (double)0.35f;
            world.func_72838_d((Entity)shrap);
            ++i;
        }
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticleEffect(pos.func_72441_c(0.0, 1.0, 0.0), "white_phosphorus"), IIPacketHandler.targetPointFromPos(pos, world, 48));
        EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(world, pos.field_72450_a + v.field_72450_a, pos.field_72448_b + v.field_72448_b + 1.0, pos.field_72449_c + v.field_72449_c);
        cloud.func_184496_a(new PotionEffect(IIPotions.brokenArmor, Math.round(240.0f), 2));
        cloud.func_184496_a(new PotionEffect(IEPotions.flammable, Math.round(240.0f), 4));
        cloud.func_184496_a(new PotionEffect(IEPotions.stunned, Math.round(160.0f), 2));
        cloud.func_184496_a(new PotionEffect(IEPotions.flashed, Math.round(270.0f), 1));
        cloud.func_184483_a(3.0f * amount);
        cloud.func_184486_b(Math.round(20.0f + 10.0f * Utils.RAND.nextFloat()));
        cloud.func_184491_a(EnumParticleTypes.CLOUD);
        world.func_72838_d((Entity)cloud);
    }

    @Override
    public AmmoRegistry.EnumComponentRole getRole() {
        return AmmoRegistry.EnumComponentRole.INCENDIARY;
    }

    @Override
    public int getColour() {
        return 13884332;
    }
}

