/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammo.emplacement_weapons;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.gui.block.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.util.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;

public class EmplacementWeaponMachinegun
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    float shootDelay = IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.bulletFireTime;
    int reloadDelay = 0;
    private Vec3d vv;
    int setupDelay = 0;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> inventoryPlatform = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);
    private boolean requiresPlatformRefill = false;
    private ArrayDeque<ItemStack> magazine = new ArrayDeque();
    private ItemStack s2 = ItemStack.field_190927_a;
    private final IItemHandler inventoryHandler = new ItemStackHandler(this.inventory){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() != IIContent.itemAmmoMachinegun) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack itemStack = super.insertItem(slot, stack, simulate);
            EmplacementWeaponMachinegun.this.inventory.set(slot, this.stacks.get(slot));
            return itemStack;
        }
    };

    @Override
    public String getName() {
        return "machinegun";
    }

    @Override
    public float getYawTurnSpeed() {
        return IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.yawRotateSpeed;
    }

    @Override
    public float getPitchTurnSpeed() {
        return IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.pitchRotateSpeed;
    }

    @Override
    public void shoot(TileEntityEmplacement te) {
        super.shoot(te);
        if (!te.func_145831_w().field_72995_K) {
            ItemStack itemStack = this.s2 = this.magazine.size() > 0 ? this.magazine.removeFirst() : ItemStack.field_190927_a;
            if (!this.s2.func_190926_b()) {
                IIPacketHandler.playRangedSound(te.func_145831_w(), new Vec3d((Vec3i)te.func_174877_v()), IISounds.machinegunShotHeavyBarrel, SoundCategory.PLAYERS, 75, 1.5f, 0.8f + (float)(Utils.RAND.nextGaussian() * 0.02));
                EntityBullet a = AmmoUtils.createBullet(te.func_145831_w(), this.s2, te.getWeaponCenter(), this.vv.func_186678_a(-1.0));
                a.setShootPos(te.getAllBlocks());
                if (this.entity != null) {
                    a.setShooters((Entity)this.entity, (Entity[])this.entity.partArray);
                }
                te.func_145831_w().func_72838_d((Entity)a);
            }
        } else if (this.magazine.size() > 0) {
            Vec3d weaponCenter = te.getWeaponCenter().func_178787_e(this.vv.func_186678_a(-1.85)).func_178787_e(this.vv.func_178785_b(90.0f).func_186678_a(0.25));
            Vec3d vg = this.vv.func_186678_a(3.0);
            ParticleUtils.spawnGunfireFX(weaponCenter, vg, 3.0f);
            weaponCenter = weaponCenter.func_178787_e(this.vv.func_178785_b(90.0f).func_186678_a(-0.5));
            ParticleUtils.spawnGunfireFX(weaponCenter, vg, 3.0f);
            this.magazine.removeFirst();
        }
        this.shootDelay = IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.bulletFireTime;
    }

    @Override
    public boolean isSetUp(boolean door) {
        return this.setupDelay == (door ? IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.setupTime : 0);
    }

    @Override
    public void doSetUp(boolean door) {
        if (door) {
            if (!this.isAimedAt(this.yaw, 0.0f)) {
                this.aimAt(this.yaw, 0.0f);
                return;
            }
            if (this.setupDelay < IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.setupTime) {
                ++this.setupDelay;
            }
        } else {
            if (!this.isAimedAt(this.yaw, 0.0f)) {
                this.aimAt(this.yaw, 0.0f);
                return;
            }
            if (this.setupDelay > 0) {
                --this.setupDelay;
            }
        }
    }

    @Override
    public boolean requiresPlatformRefill() {
        return this.requiresPlatformRefill;
    }

    @Override
    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        float force = IIContent.itemAmmoMachinegun.getDefaultVelocity();
        this.s2 = this.magazine.size() > 0 ? this.magazine.peekFirst() : ItemStack.field_190927_a;
        float mass = this.s2.func_190926_b() ? 0.0f : IIContent.itemAmmoMachinegun.getMass(this.s2);
        this.vv = posTurret.func_178788_d(posTarget.func_178787_e(motion));
        double gravityMotionY = 0.0;
        double motionY = 0.0;
        double baseMotionY = this.vv.func_72432_b().field_72448_b;
        for (double dist = this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0)); dist > 0.0; dist -= (double)(EntityBullet.DEV_SLOMO * force)) {
            force -= 0.01f * force * EntityBullet.DEV_SLOMO;
            double baseMotionYC = baseMotionY * (double)(force / IIContent.itemAmmoMachinegun.getDefaultVelocity());
            motionY += (baseMotionYC + (gravityMotionY -= (double)(0.15f * mass * EntityBullet.DEV_SLOMO))) * (double)EntityBullet.DEV_SLOMO;
        }
        this.vv = this.vv.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        float yy = (float)(Math.atan2(this.vv.field_72450_a, this.vv.field_72449_c) * 180.0 / 3.1415927410125732);
        float pp = (float)Math.toDegrees(Math.atan2(this.vv.field_72448_b, this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0))));
        return new float[]{yy, pp};
    }

    @Override
    public void aimAt(float yaw, float pitch) {
        this.nextPitch = MathHelper.func_76131_a((float)pitch, (float)-15.0f, (float)20.0f);
        super.aimAt(yaw, MathHelper.func_76131_a((float)pitch, (float)-15.0f, (float)20.0f));
    }

    public void aimAtUnrestricted(float yaw, float pitch) {
        super.aimAt(yaw, pitch);
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g((double)IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.detectionRadius);
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
        if (active && this.magazine.isEmpty()) {
            if (this.reloadDelay == 0) {
                if (this.inventoryPlatform.stream().anyMatch(stack -> stack.func_77973_b() == IIContent.itemAmmoMachinegun)) {
                    this.reloadDelay = 1;
                } else {
                    this.requiresPlatformRefill = true;
                }
            } else {
                ++this.reloadDelay;
            }
            if (this.reloadDelay >= IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.reloadTime) {
                for (ItemStack stack2 : this.inventoryPlatform) {
                    if (this.magazine.size() >= 256) break;
                    while (!stack2.func_190926_b() && this.magazine.size() < 256) {
                        ItemStack copy = stack2.func_77946_l();
                        copy.func_190920_e(1);
                        this.magazine.addLast(copy);
                        stack2.func_190918_g(1);
                    }
                }
                this.reloadDelay = 0;
                this.syncWithClient(te);
            }
        }
        if (this.shootDelay > 0.0f) {
            this.shootDelay -= 1.0f;
        }
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        NBTTagCompound nbt = super.saveToNBT(forClient);
        nbt.func_74776_a("shootDelay", this.shootDelay);
        nbt.func_74768_a("reloadDelay", this.reloadDelay);
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        nbt.func_74782_a("inventoryPlatform", (NBTBase)Utils.writeInventory(this.inventoryPlatform));
        if (!forClient) {
            nbt.func_74782_a("magazine", (NBTBase)Utils.writeInventory(this.magazine));
        }
        nbt.func_74768_a("magazine_amount", this.magazine.size());
        nbt.func_74757_a("requiresPlatformRefill", this.requiresPlatformRefill);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.shootDelay = tagCompound.func_74760_g("shootDelay");
        this.reloadDelay = tagCompound.func_74762_e("reloadDelay");
        this.inventory = Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventory", 10), (int)this.inventory.size());
        this.inventoryPlatform = Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventoryPlatform", 10), (int)this.inventoryPlatform.size());
        this.magazine = new ArrayDeque(Utils.readInventory((NBTTagList)tagCompound.func_150295_c("magazine", 10), (int)tagCompound.func_74762_e("magazine_amount")));
        this.requiresPlatformRefill = tagCompound.func_74767_n("requiresPlatformRefill");
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        return this.vv != null && te.isDoorOpened && this.shootDelay == 0.0f && this.magazine.size() > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        GlStateManager.func_179094_E();
        float p = this.nextPitch - this.pitch;
        float y = this.nextYaw - this.yaw;
        boolean power = te.energyStorage.getEnergyStored() >= this.getEnergyUpkeepCost();
        float pp = this.pitch + (power ? Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)1.0f) * partialTicks * this.getPitchTurnSpeed() : 0.0f);
        float yy = this.yaw + (power ? Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)1.0f) * partialTicks * this.getYawTurnSpeed() : 0.0f);
        float setupProgress = MathHelper.func_76131_a((float)((float)this.setupDelay + (this.setupDelay > 0 ? (te.isDoorOpened ? (te.progress == IIConfigHandler.IIConfig.Machines.Emplacement.lidTime ? partialTicks : 0.0f) : -partialTicks) : 0.0f)), (float)0.0f, (float)IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.setupTime) / (float)IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.setupTime;
        float inserterYaw = 0.0f;
        float inserterPitch1 = 95.0f;
        float inserterPitch2 = 265.0f;
        float inserterProgress = 0.0f;
        IIClientUtils.bindTexture(EmplacementRenderer.textureMachinegun);
        for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.baseModel) {
            modelRendererTurbo.render();
        }
        GlStateManager.func_179114_b((float)yy, (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.turretBaseModel) {
            modelRendererTurbo.render();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.9375f, (float)0.125f);
        GlStateManager.func_179114_b((float)pp, (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.isSetUp(te.isDoorOpened) || this != te.currentWeapon) {
            inserterYaw = -75.0f;
            inserterPitch1 = 100.0f;
            inserterPitch2 = 220.0f;
            inserterProgress = -0.5f;
            if (this.reloadDelay > 0) {
                for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.ammoCrateModel) {
                    modelRendererTurbo.render();
                }
                for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.ammoCrateLidModel) {
                    modelRendererTurbo.render();
                }
            } else {
                for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.ammoCrateModel) {
                    modelRendererTurbo.render();
                }
                for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.ammoCrateLidModel) {
                    modelRendererTurbo.render();
                }
            }
            for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.barrelsModel) {
                modelRendererTurbo.render();
            }
        } else {
            float machineBox = MathHelper.func_76131_a((float)(setupProgress / 0.35f), (float)0.0f, (float)1.0f);
            float projector = MathHelper.func_76131_a((float)((setupProgress - 0.35f) / 0.35f), (float)0.0f, (float)1.0f);
            float deskStuff = MathHelper.func_76131_a((float)((setupProgress - 0.7f) / 0.3f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.barrelsModel) {
                modelRendererTurbo.render();
            }
            GlStateManager.func_179121_F();
            for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.ammoCrateModel) {
                modelRendererTurbo.render();
            }
            for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.ammoCrateLidModel) {
                modelRendererTurbo.render();
            }
        }
        for (ModelRendererTurbo modelRendererTurbo : EmplacementRenderer.modelMachinegun.turretModel) {
            modelRendererTurbo.render();
        }
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.0625, (double)0.8125, (double)0.0625);
        EmplacementRenderer.renderInserter(true, inserterYaw, inserterPitch1, inserterPitch2, inserterProgress, () -> {});
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_MACHINEGUN.getProgressRequired();
        int l = EmplacementRenderer.modelMachinegunConstruction.length;
        double maxClientProgress = IIUtils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)IIConfigHandler.IIConfig.Tools.wrenchUpgradeProgress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        IIClientUtils.bindTexture(EmplacementRenderer.textureMachinegun);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelMachinegunConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelMachinegunConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.useBlueprint(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelMachinegunConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public void syncWithEntity(EntityEmplacementWeapon entity) {
        super.syncWithEntity(entity);
        if (entity == this.entity) {
            entity.aabb = new AxisAlignedBB(-2.0, 0.0, -2.0, 2.0, 3.0, 2.0);
        }
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 1.0f, 1.25f, new Vec3d(0.0, 0.75, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(0.75, 0.5, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(0.75, 0.5, 0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(0.75, 0.5, -0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(0.0, 0.5, 0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(0.0, 0.5, -0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(-0.75, 0.5, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(-0.75, 0.5, 0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseSandbags", 0.75f, 0.75f, new Vec3d(-0.75, 0.5, -0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel", 0.45f, 0.45f, new Vec3d(-0.5, 1.0, 0.0), new Vec3d(-0.625, 0.0, 0.0), 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel", 0.45f, 0.45f, new Vec3d(-0.5, 1.0, 0.0), new Vec3d(-1.25, 0.0, 0.0), 12));
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return this.inventory;
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
        for (int i = 0; i < this.inventoryPlatform.size(); ++i) {
            te.doProcessOutput((ItemStack)this.inventoryPlatform.get(i));
            this.inventoryPlatform.set(i, (Object)ItemStack.field_190927_a);
        }
        int moved = 0;
        for (int i = 0; i < this.inventory.size() && moved < this.inventoryPlatform.size(); ++i) {
            ItemStack s = (ItemStack)this.inventory.get(i);
            if (s.func_190926_b()) continue;
            this.inventoryPlatform.set(moved, (Object)s);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            ++moved;
        }
        if (this.inventoryPlatform.stream().anyMatch(stack -> !stack.func_190926_b())) {
            this.requiresPlatformRefill = false;
            this.syncWithClient(te);
        }
    }

    @Override
    public int getEnergyUpkeepCost() {
        return IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.Machinegun.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureMachinegun, Arrays.asList(EmplacementRenderer.modelMachinegunConstruction));
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(boolean in) {
        return in ? this.inventoryHandler : super.getItemHandler(in);
    }
}

