/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammo.emplacement_weapons;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.TileRenderTeslaCoil;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.gui.block.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.util.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.util.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.network.IIMessage;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageIITileSync;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class EmplacementWeaponTeslaCoil
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    private AxisAlignedBB attack;
    private final ArrayList<Integer> targetedEntities = new ArrayList();
    private final ArrayList<TileEntityTeslaCoil.LightningAnimation> effects = new ArrayList();

    @Override
    public String getName() {
        return "tesla";
    }

    @Override
    public float getYawTurnSpeed() {
        return 360.0f;
    }

    @Override
    public float getPitchTurnSpeed() {
        return 360.0f;
    }

    @Override
    public boolean isAimedAt(float yaw, float pitch) {
        return true;
    }

    @Override
    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g(16.0);
        this.attack = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g((double)IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.TeslaCoil.attackRadius);
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
        if (!active) {
            return;
        }
        for (Integer targetedEntity : this.targetedEntities) {
            this.addEntityToAnimation(targetedEntity, te.func_145831_w(), te.getBlockPosForPos(49).func_177984_a());
        }
        this.targetedEntities.clear();
        this.effects.removeIf(TileEntityTeslaCoil.LightningAnimation::tick);
    }

    @Override
    public void shoot(TileEntityEmplacement te) {
        super.shoot(te);
        if (te.func_145831_w().func_82737_E() % 10L == 0L) {
            List targets = te.func_145831_w().func_175647_a(EntityLivingBase.class, this.attack, input -> input != this.entity);
            EntityLivingBase target = null;
            if (!targets.isEmpty()) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage((float)(Config.IEConfig.Machines.teslacoil_damage * 2.5f), (boolean)false);
                int randomTarget = Utils.RAND.nextInt(targets.size());
                target = (EntityLivingBase)targets.get(randomTarget);
                if (target != null) {
                    if (dmgsrc.apply((Entity)target)) {
                        int prevFire = target.field_190534_ay;
                        target.field_190534_ay = 1;
                        target.func_70690_d(new PotionEffect(IEPotions.stunned, 128));
                        target.field_190534_ay = prevFire;
                    }
                    this.syncAttackedEntity(te, (Entity)target);
                }
            }
            for (Entity e : targets) {
                if (e == target || !(e instanceof EntityLivingBase)) continue;
                IElectricEquipment.applyToEntity((EntityLivingBase)((EntityLivingBase)e), null, (IElectricEquipment.ElectricSource)new IElectricEquipment.ElectricSource(3.0f));
            }
        }
    }

    private void addAnimation(TileEntityTeslaCoil.LightningAnimation ani) {
        Minecraft.func_71410_x().func_152343_a(() -> this.effects.add(ani));
    }

    @Override
    public void aimAt(float yaw, float pitch) {
        super.aimAt(yaw, pitch);
    }

    @Override
    public boolean isSetUp(boolean door) {
        return true;
    }

    @Override
    public boolean requiresPlatformRefill() {
        return false;
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        return super.saveToNBT(forClient);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("targetEntity")) {
            this.targetedEntities.add(tagCompound.func_74762_e("targetEntity"));
        } else {
            super.readFromNBT(tagCompound);
        }
    }

    @Override
    public void syncWithEntity(EntityEmplacementWeapon entity) {
        super.syncWithEntity(entity);
        if (entity == this.entity) {
            entity.aabb = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 3.75, 1.0);
        }
    }

    private void addEntityToAnimation(int id, World world, BlockPos pos) {
        Entity target = world.func_73045_a(id);
        if (target instanceof EntityLivingBase) {
            double dx = target.field_70165_t - (double)pos.func_177958_n();
            double dy = target.field_70163_u - (double)pos.func_177956_o();
            double dz = target.field_70161_v - (double)pos.func_177952_p();
            EnumFacing f = Math.abs(dz) > Math.abs(dx) ? (dz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH) : (dx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST);
            double verticalOffset = 1.0 + Utils.RAND.nextDouble() * 0.25;
            Vec3d coilPos = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
            coilPos = coilPos.func_72441_c(0.0, verticalOffset, 0.0);
            coilPos = coilPos.func_72441_c((double)f.func_82601_c() * 0.375, (double)f.func_96559_d() * 0.375, (double)f.func_82599_e() * 0.375);
            f = f.func_176732_a(EnumFacing.Axis.Y);
            double dShift = (Utils.RAND.nextDouble() - 0.5) * 0.75;
            coilPos = coilPos.func_72441_c((double)f.func_82601_c() * dShift, (double)f.func_96559_d() * dShift, (double)f.func_82599_e() * dShift);
            this.addAnimation(new TileEntityTeslaCoil.LightningAnimation(coilPos, (EntityLivingBase)target));
        }
    }

    public void syncAttackedEntity(TileEntityEmplacement te, Entity e) {
        if (!te.func_145831_w().field_72995_K) {
            IIPacketHandler.sendToClient((TileEntity)te, (IIMessage)new MessageIITileSync((TileEntityIEBase)te, EasyNBT.newNBT().withString("weaponName", this.getName()).withTag("currentWeapon", EasyNBT.newNBT().withInt("targetEntity", e.func_145782_y()))));
        }
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        IIClientUtils.bindTexture(EmplacementRenderer.textureTeslaCoil);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelTeslaCoil.baseModel) {
            mod.render();
        }
        Iterator<TileEntityTeslaCoil.LightningAnimation> animationIt = this.effects.iterator();
        ClientUtils.setLightmapDisabled((boolean)true);
        boolean wasLightingEnabled = GL11.glIsEnabled((int)2896);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179112_b((int)770, (int)771);
        while (animationIt.hasNext()) {
            TileEntityTeslaCoil.LightningAnimation animation = animationIt.next();
            if (animation.shoudlRecalculateLightning()) {
                animation.createLightning(Utils.RAND);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            double tx = 0.0;
            double ty = 1.5;
            double tz = 0.0;
            float curWidth = GL11.glGetFloat((int)2849);
            TileRenderTeslaCoil.drawAnimation((TileEntityTeslaCoil.LightningAnimation)animation, (double)tx, (double)ty, (double)tz, (float[])new float[]{0.3019608f, 0.2901961f, 0.59607846f, 0.75f}, (float)10.0f);
            TileRenderTeslaCoil.drawAnimation((TileEntityTeslaCoil.LightningAnimation)animation, (double)tx, (double)ty, (double)tz, (float[])new float[]{1.0f, 1.0f, 1.0f, 1.0f}, (float)6.0f);
            GL11.glLineWidth((float)curWidth);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (wasLightingEnabled) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        ClientUtils.setLightmapDisabled((boolean)false);
        GlStateManager.func_179089_o();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_TESLA.getProgressRequired();
        int l = EmplacementRenderer.modelTeslaCoilConstruction.length;
        double maxClientProgress = IIUtils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)IIConfigHandler.IIConfig.Tools.wrenchUpgradeProgress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        IIClientUtils.bindTexture(EmplacementRenderer.textureTeslaCoil);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelTeslaCoilConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelTeslaCoilConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.useBlueprint(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelTeslaCoilConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 1.0f, 1.0f, new Vec3d(0.0, 0.5, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "rod", 0.375f, 1.5f, new Vec3d(0.0, 2.0, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "rodTop", 0.75f, 0.75f, new Vec3d(0.0, 3.0, 0.0), Vec3d.field_186680_a, 20));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "ring1", 0.75f, 0.1875f, new Vec3d(0.0, (double)2.55f, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "ring2", 1.0f, 0.1875f, new Vec3d(0.0, (double)2.15f, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "ring3", 1.0625f, 0.1875f, new Vec3d(0.0, (double)1.8f, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "ring4", 1.1875f, 0.1875f, new Vec3d(0.0, 1.5, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "sideBox1", 0.5f, 0.5f, new Vec3d(0.75, 0.5, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "sideBox2", 0.5f, 0.5f, new Vec3d(-0.75, 0.5, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "sideBox3", 0.5f, 0.5f, new Vec3d(0.0, 0.5, 0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "sideBox4", 0.5f, 0.5f, new Vec3d(0.0, 0.5, -0.75), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "pipe1", 0.5f, 0.35f, new Vec3d(0.6, (double)0.35f, 0.5), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "pipe2", 0.5f, 0.35f, new Vec3d(0.6, (double)0.35f, -0.5), Vec3d.field_186680_a, 4));
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return NonNullList.func_191196_a();
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
    }

    @Override
    public int getEnergyUpkeepCost() {
        return IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.TeslaCoil.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return IIConfigHandler.IIConfig.Weapons.EmplacementWeapons.TeslaCoil.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureTeslaCoil, Arrays.asList(EmplacementRenderer.modelTeslaCoilConstruction));
    }
}

