/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammo.explosives;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityAtomicBoom;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.util.IIDamageSources;
import pl.pabilo8.immersiveintelligence.common.util.IIExplosion;

public class AmmoComponentNuke
implements IAmmoComponent {
    @Override
    public String getName() {
        return "nuke";
    }

    @Override
    public IngredientStack getMaterial() {
        return new IngredientStack("materialNuke");
    }

    @Override
    public float getDensity() {
        return 2.0f;
    }

    @Override
    public void onEffect(float amount, AmmoRegistry.EnumCoreTypes coreType, NBTTagCompound tag, Vec3d pos, Vec3d dir, World world) {
        EntityLivingBase[] entities;
        BlockPos ppos = new BlockPos(pos);
        new IIExplosion(world, null, pos, 56.0f * amount, 60.0f, false, true, false).doExplosion();
        for (EntityLivingBase e : entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(ppos).func_186662_g((double)(75.0f * amount))).toArray(new EntityLivingBase[0])) {
            e.func_70690_d(new PotionEffect(IEPotions.flashed, 40, 1));
            e.func_70690_d(new PotionEffect(IIPotions.nuclearHeat, 40, 0));
            e.field_70172_ad = 0;
            e.func_184193_aE().forEach(stack -> stack.func_77972_a(stack.func_77958_k(), e));
            e.func_70097_a(IIDamageSources.NUCLEAR_HEAT_DAMAGE, 2000.0f);
        }
        for (EntityLivingBase e : entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(ppos).func_186662_g((double)(50.0f * amount))).toArray(new EntityLivingBase[0])) {
            e.func_70690_d(new PotionEffect(IIPotions.radiation, 4000, 0));
        }
        IIPacketHandler.playRangedSound(world, pos, IISounds.explosionNuke, SoundCategory.NEUTRAL, 72, 1.0f, 0.0f);
        EntityAtomicBoom entityAtomicBoom = new EntityAtomicBoom(world, amount);
        entityAtomicBoom.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        world.func_72838_d((Entity)entityAtomicBoom);
        int endRad = (int)(24.0f * amount);
        int biomeWasteland = Biome.func_185362_a((Biome)IIContent.biomeWasteland);
        int wastelandRadius = (int)(5.0f * amount) * 16;
        ArrayList<Chunk> radiatedChunks = new ArrayList<Chunk>();
        for (int i = -wastelandRadius; i <= wastelandRadius; ++i) {
            for (int j = -wastelandRadius; j <= wastelandRadius; ++j) {
                float dist = MathHelper.func_76129_c((float)(i * i + j * j));
                if (dist > (float)wastelandRadius) continue;
                Chunk chunk = world.func_72964_e(ppos.func_177958_n() + i >> 4, ppos.func_177952_p() + j >> 4);
                if (!radiatedChunks.contains(chunk)) {
                    radiatedChunks.add(chunk);
                }
                byte[] ground = chunk.func_76605_m();
                int posID = (ppos.func_177952_p() + j & 0xF) << 4 | ppos.func_177958_n() + i & 0xF;
                int val = (int)Math.max(dist - (float)(wastelandRadius - endRad), 0.0f);
                boolean result = MathHelper.func_76136_a((Random)Utils.RAND, (int)0, (int)(val / 2)) == 0;
                ground[posID] = result ? (byte)biomeWasteland : ground[posID];
                chunk.func_76616_a(ground);
                chunk.func_177427_f(true);
            }
        }
        for (Chunk radiatedChunk : radiatedChunks) {
            radiatedChunk.func_150804_b(false);
            SPacketChunkData packet = new SPacketChunkData(radiatedChunk, 65535);
            for (EntityPlayer player : world.field_73010_i) {
                if (!(player instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
                MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.Watch(radiatedChunk, (EntityPlayerMP)player));
            }
        }
    }

    @Override
    public AmmoRegistry.EnumComponentRole getRole() {
        return AmmoRegistry.EnumComponentRole.SPECIAL;
    }

    @Override
    public int getColour() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            float add = (float)Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60.0f / 60.0f;
            add = (double)add > 0.5 ? 1.0f - (add - 0.5f) * 2.0f : add * 2.0f;
            return MathHelper.func_181758_c((float)0.43137255f, (float)(0.75f * add), (float)(0.5f + (1.0f - add) * 0.45f));
        }
        return MathHelper.func_181758_c((float)0.4745098f, (float)0.75f, (float)0.88f);
    }

    @Override
    public boolean matchesBullet(IAmmo bullet) {
        return bullet.getCaliber() >= 6.0f;
    }
}

