/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammo.factory;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.ShrapnelHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityShrapnel;

public class AmmoComponentShrapnel
implements IAmmoComponent {
    IngredientStack stack;
    String name;

    public AmmoComponentShrapnel(String material) {
        this.name = material;
        this.stack = new IngredientStack("dust" + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1));
    }

    @Override
    public String getName() {
        return "shrapnel_" + this.name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTranslatedName() {
        return I18n.func_135052_a((String)("ie.manual.entry.bullet_component." + this.getName()), (Object[])new Object[0]);
    }

    @Override
    public IngredientStack getMaterial() {
        return this.stack;
    }

    @Override
    public float getDensity() {
        return 1.0f;
    }

    @Override
    public void onEffect(float amount, AmmoRegistry.EnumCoreTypes coreType, NBTTagCompound tag, Vec3d pos, Vec3d dir, World world) {
        Vec3d v = new Vec3d(0.0, -1.0, 0.0);
        Vec3d throwerPos = pos.func_72441_c(0.0, 3.0, 0.0);
        int i = 0;
        while ((float)i < 50.0f * amount) {
            Vec3d vecDir = v.func_72441_c(Utils.RAND.nextGaussian() * 0.25, Utils.RAND.nextGaussian() * 0.25, Utils.RAND.nextGaussian() * 0.25);
            EntityShrapnel shrap = new EntityShrapnel(world, throwerPos.field_72450_a + v.field_72450_a * 2.0, throwerPos.field_72448_b + v.field_72448_b * 2.0, throwerPos.field_72449_c + v.field_72449_c * 2.0, 0.0, 0.0, 0.0, this.name);
            shrap.field_70159_w = vecDir.field_72450_a * 2.0;
            shrap.field_70181_x = vecDir.field_72448_b * (double)0.05f;
            shrap.field_70179_y = vecDir.field_72449_c * 2.0;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)shrap);
            }
            ++i;
        }
    }

    @Override
    public AmmoRegistry.EnumComponentRole getRole() {
        return AmmoRegistry.EnumComponentRole.SHRAPNEL;
    }

    @Override
    public int getColour() {
        return ShrapnelHandler.registry.get((Object)this.name).color;
    }
}

