/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.data_device.tileentity;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.data_device.tileentity.TileEntityDataConnector;
import pl.pabilo8.immersiveintelligence.common.wire.IIDataWireType;

public class TileEntityDataCallbackConnector
extends TileEntityDataConnector {
    public int colorIn = 0;
    public int colorOut = 1;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public void onPacketReceive(DataPacket packet) {
        this.lastReceived = packet.clone();
        this.compatReceived = false;
        if (packet.matchesConnector(EnumDyeColor.func_176764_b((int)this.colorIn), -1)) {
            BlockPos devicePos = this.field_174879_c.func_177972_a(this.facing);
            TileEntity device = this.field_145850_b.func_175625_s(devicePos);
            if (this.field_145850_b.func_175667_e(devicePos) && device instanceof IDataDevice) {
                IDataDevice d = (IDataDevice)device;
                d.onReceive(packet, this.facing.func_176734_d());
            }
        }
    }

    @Override
    public void sendPacket(DataPacket packet) {
        this.getDataNetwork().sendPacket(packet.setPacketColor(EnumDyeColor.func_176764_b((int)this.colorOut)), this);
    }

    @Override
    public boolean isCallbackCapable() {
        return true;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.colorIn = IIUtils.cycleIntAvoid(true, this.colorIn, 0, 15, this.colorOut);
        } else {
            this.colorOut = IIUtils.cycleIntAvoid(true, this.colorOut, 0, 15, this.colorIn);
        }
        this.onDataChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("colorIn", this.colorIn);
        nbt.func_74768_a("colorOut", this.colorOut);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.colorIn = nbt.func_74762_e("colorIn");
        this.colorOut = nbt.func_74762_e("colorOut");
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (0.25 - conRadius), 0.5 + (double)side.func_96559_d() * (0.25 - conRadius), 0.5 + (double)side.func_82599_e() * (0.25 - conRadius));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - inc), (double)(this.field_174879_c.func_177956_o() - inc), (double)(this.field_174879_c.func_177952_p() - inc), (double)(this.field_174879_c.func_177958_n() + inc + 1), (double)(this.field_174879_c.func_177956_o() + inc + 1), (double)(this.field_174879_c.func_177952_p() + inc + 1));
    }

    @Override
    int getRenderRadiusIncrease() {
        return IIDataWireType.DATA.getMaxLength();
    }

    @Override
    public float[] getBlockBounds() {
        float length = 0.75f;
        float wMin = 0.25f;
        float wMax = 0.75f;
        switch (this.facing.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColour(IBlockState object, String group) {
        if ("Color_In".equals(group)) {
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)this.colorIn).func_193350_e();
        }
        if ("Color_Out".equals(group)) {
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)this.colorOut).func_193350_e();
        }
        return -1;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.colorIn + ";" + this.colorOut;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop) {
        if (Utils.isHammer((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.io.0", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.colorIn).func_176762_d()), (Object[])new Object[0]), I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.io.1", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.colorOut).func_176762_d()), (Object[])new Object[0])};
        }
        return new String[0];
    }
}

