/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.data_device.tileentity;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.IDataStorageItem;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;

public class TileEntityPunchtapeReader
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IRedstoneOutput,
IDataDevice,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IDirectionalTile {
    public boolean hadRedstone = false;
    public int mode = 0;
    public int rsTime = 0;
    EnumFacing facing = EnumFacing.NORTH;
    DataPacket received = null;

    public void func_73660_a() {
        if (this.mode == 1) {
            if (this.hadRedstone ^ this.field_145850_b.func_175640_z(this.field_174879_c)) {
                if (this.received != null && !this.hadRedstone) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, IISounds.punchtapeReader, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    IDataConnector conn = IIUtils.findConnectorFacing(this.field_174879_c, this.field_145850_b, this.facing.func_176734_d());
                    if (conn != null) {
                        conn.sendPacket(this.received.clone());
                    } else {
                        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing.func_176734_d()));
                        if (te instanceof IDataDevice) {
                            ((IDataDevice)te).onReceive(this.received.clone(), this.facing);
                        }
                    }
                }
                this.hadRedstone = this.field_145850_b.func_175640_z(this.field_174879_c);
            }
        } else if (this.mode == 2 && this.rsTime > 0) {
            --this.rsTime;
        }
    }

    public int getWeakRSOutput(IBlockState state, EnumFacing side) {
        return 0;
    }

    public int getStrongRSOutput(IBlockState state, EnumFacing side) {
        return this.mode == 2 ? (side != this.facing && this.rsTime > 0 ? 15 : 0) : 0;
    }

    public boolean canConnectRedstone(IBlockState state, EnumFacing side) {
        return this.mode > 0;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.mode = nbt.func_74762_e("mode");
        this.setFacing(EnumFacing.func_82600_a((int)nbt.func_74762_e("facing")));
        if (nbt.func_74764_b("received")) {
            this.received = new DataPacket().fromNBT(nbt.func_74775_l("received"));
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("facing", this.facing.ordinal());
        if (this.received != null) {
            nbt.func_74782_a("received", (NBTBase)this.received.toNBT());
        }
    }

    @Override
    public void onReceive(DataPacket packet, EnumFacing side) {
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            ++this.mode;
            if (this.mode > 2) {
                this.mode = 0;
            }
            IIPacketHandler.sendChatTranslation(player, "info.immersiveintelligence.punchtape_reader_mode", new TextComponentTranslation("info.immersiveintelligence.punchtape_reader_mode." + this.mode, new Object[0]));
            this.func_70296_d();
            this.markBlockForUpdate(this.func_174877_v(), null);
        }
        return true;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing.func_176740_k().func_176722_c() ? facing : EnumFacing.NORTH;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.func_77973_b() instanceof IDataStorageItem) {
            IDataStorageItem storage = (IDataStorageItem)heldItem.func_77973_b();
            DataPacket packet = storage.getStoredData(heldItem);
            this.received = packet.clone();
            IDataConnector conn = IIUtils.findConnectorFacing(this.field_174879_c, this.field_145850_b, this.facing.func_176734_d());
            if (conn != null) {
                conn.sendPacket(packet);
            } else {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing.func_176734_d()));
                if (te instanceof IDataDevice) {
                    ((IDataDevice)te).onReceive(packet, this.facing);
                }
                if (this.mode == 2) {
                    this.rsTime = 20;
                }
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, IISounds.punchtapeReader, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return false;
    }
}

