/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorCovered;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.util.vector.Vector3f;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubber;
import pl.pabilo8.immersiveintelligence.common.block.metal_device.tileentity.conveyors.ConveyorRubberExtract;

public class ConveyorRubberCoveredExtract
extends ConveyorRubberExtract {
    public static final ItemStack defaultCover = new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
    public ItemStack cover = ItemStack.field_190927_a;
    static final AxisAlignedBB topBox = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);

    public ConveyorRubberCoveredExtract(EnumFacing conveyorDir) {
        super(conveyorDir);
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return ConveyorRubber.texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return ConveyorRubber.texture_off;
    }

    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        super.onEntityCollision(tile, entity, facing);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).func_174867_a(10);
        }
    }

    public void onItemDeployed(TileEntity tile, EntityItem entity, EnumFacing facing) {
        entity.func_174867_a(10);
        ConveyorHandler.applyMagnetSupression((Entity)entity, (ConveyorHandler.IConveyorTile)((ConveyorHandler.IConveyorTile)tile));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        baseModel = super.modifyQuads(baseModel, tile, facing);
        ConveyorRubberCoveredExtract.addCoverToQuads(baseModel, tile, facing, () -> this.cover, ConveyorHandler.ConveyorDirection.HORIZONTAL, new boolean[]{tile == null || this.renderWall(tile, facing, 0), tile == null || this.renderWall(tile, facing, 1)});
        return baseModel;
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = super.getModelCacheKey(tile, facing);
        if (!this.cover.func_190926_b()) {
            key = key + "s" + this.cover.func_77973_b().getRegistryName() + this.cover.func_77960_j();
        }
        return key;
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (super.playerInteraction(tile, player, hand, heldItem, hitX, hitY, hitZ, side)) {
            return true;
        }
        return ConveyorRubberCoveredExtract.handleCoverInteraction(tile, player, hand, heldItem, () -> this.cover, itemStack -> {
            this.cover = itemStack;
        });
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        list.add(topBox);
        return list;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{Block.field_185505_j});
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        if (this.cover != null) {
            nbt.func_74782_a("cover", (NBTBase)this.cover.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.cover = new ItemStack(nbt.func_74775_l("cover"));
    }

    static boolean handleCoverInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, Supplier<ItemStack> coverGet, Consumer<ItemStack> coverSet) {
        ItemStack cover = coverGet.get();
        if (heldItem.func_190926_b() && player.func_70093_af() && !cover.func_190926_b()) {
            EntityItem entityitem;
            if (!tile.func_145831_w().field_72995_K && tile.func_145831_w().func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(cover.func_77946_l(), false)) != null) {
                entityitem.func_174868_q();
            }
            coverSet.accept(ItemStack.field_190927_a);
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_70093_af()) {
            for (Function func : ConveyorCovered.validCoveyorCovers) {
                EntityItem entityitem;
                if (func.apply((Object)heldItem) != Boolean.TRUE || OreDictionary.itemMatches((ItemStack)cover, (ItemStack)heldItem, (boolean)true)) continue;
                if (!tile.func_145831_w().field_72995_K && !cover.func_190926_b() && tile.func_145831_w().func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(cover.func_77946_l(), false)) != null) {
                    entityitem.func_174868_q();
                }
                coverSet.accept(Utils.copyStackWithAmount((ItemStack)heldItem, (int)1));
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    static void addCoverToQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing, Supplier<ItemStack> coverGet, ConveyorHandler.ConveyorDirection conDir, boolean[] walls) {
        ItemStack cover = !coverGet.get().func_190926_b() ? coverGet.get() : defaultCover;
        Block b = Block.func_149634_a((Item)cover.func_77973_b());
        IBlockState state = !cover.func_190926_b() ? b.func_176203_a(cover.func_77960_j()) : Blocks.field_150348_b.func_176223_P();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != null) {
            TextureAtlasSprite sprite = model.func_177554_e();
            HashMap<EnumFacing, TextureAtlasSprite> sprites = new HashMap<EnumFacing, TextureAtlasSprite>();
            for (EnumFacing f2 : EnumFacing.field_82609_l) {
                for (BakedQuad q : model.func_188616_a(state, f2, 0L)) {
                    if (q == null || q.func_187508_a() == null) continue;
                    sprites.put(f2, q.func_187508_a());
                }
            }
            for (BakedQuad q : model.func_188616_a(state, null, 0L)) {
                if (q == null || q.func_187508_a() == null || q.func_178210_d() == null) continue;
                sprites.put(q.func_178210_d(), q.func_187508_a());
            }
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSprite = f -> sprites.getOrDefault(f, sprite);
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSpriteHorizontal = f -> f.func_176740_k() == EnumFacing.Axis.Y ? null : sprites.getOrDefault(f, sprite);
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(facing);
            java.util.function.Function<Vector3f[], Vector3f[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
                Vector3f[] ret = new Vector3f[((Vector3f[])vertices).length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new Vector3f(vertices[i].x, vertices[i].y + (float)(vertices[i].z == (float)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].z);
                }
                return ret;
            };
            baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.0f, 0.75f, 0.0f), (Vector3f)new Vector3f(1.0f, 1.0f, 1.0f), (Matrix4)matrix, (EnumFacing)facing, vertexTransformer, getSprite, (float[])colour));
            if (walls[0]) {
                baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.0f, 0.1875f, 0.0f), (Vector3f)new Vector3f(0.0625f, 0.75f, 1.0f), (Matrix4)matrix, (EnumFacing)facing, vertexTransformer, getSpriteHorizontal, (float[])colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.0f, 0.1875f, 0.0f), (Vector3f)new Vector3f(0.0625f, 0.75f, 0.0625f), (Matrix4)matrix, (EnumFacing)facing, getSpriteHorizontal, (float[])colour));
                baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.0f, 0.1875f, 0.9375f), (Vector3f)new Vector3f(0.0625f, 0.75f, 1.0f), (Matrix4)matrix, (EnumFacing)facing, getSpriteHorizontal, (float[])colour));
            }
            if (walls[1]) {
                baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.9375f, 0.1875f, 0.0f), (Vector3f)new Vector3f(1.0f, 0.75f, 1.0f), (Matrix4)matrix, (EnumFacing)facing, vertexTransformer, getSpriteHorizontal, (float[])colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.9375f, 0.1875f, 0.0f), (Vector3f)new Vector3f(1.0f, 0.75f, 0.0625f), (Matrix4)matrix, (EnumFacing)facing, getSpriteHorizontal, (float[])colour));
                baseModel.addAll(ClientUtils.createBakedBox((Vector3f)new Vector3f(0.9375f, 0.1875f, 0.9375f), (Vector3f)new Vector3f(1.0f, 0.75f, 1.0f), (Matrix4)matrix, (EnumFacing)facing, getSpriteHorizontal, (float[])colour));
            }
        }
    }
}

