/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.mines;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoCore;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.mines.tileentity.TileEntityTripMine;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIIBase;
import pl.pabilo8.immersiveintelligence.common.util.block.BlockIITileProvider;
import pl.pabilo8.immersiveintelligence.common.util.block.IIBlockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.block.ItemBlockIIBase;

public abstract class BlockIIMine
extends BlockIITileProvider<IIBlockTypes_Mine> {
    public BlockIIMine(String name, Class<? extends TileEntity> tileClass, Function<BlockIIMine, ItemBlockMineBase> itemBlock, Object ... additionalProperties) {
        super(name, Material.field_151594_q, PropertyEnum.func_177709_a((String)"dummy", IIBlockTypes_Mine.class), (BlockIIBase<E> i) -> (ItemBlockMineBase)itemBlock.apply((BlockIIMine)((Object)i)), additionalProperties);
        this.func_149711_c(0.25f);
        this.func_149752_b(1.0f);
        this.setLightOpacity(0);
        IIContent.TILE_ENTITIES.add(tileClass);
        this.addToTESRMap(new IIBlockTypes_Mine[]{IIBlockTypes_Mine.MAIN, IIBlockTypes_Mine.CORE});
    }

    @Override
    public boolean useCustomStateMapper() {
        return false;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        return this.name;
    }

    @Override
    public final boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b((IProperty)this.property) == IIBlockTypes_Mine.MAIN;
    }

    @Override
    public final TileEntity createBasicTE(IIBlockTypes_Mine type) {
        return type == IIBlockTypes_Mine.MAIN ? this.getMineTileEntity() : null;
    }

    protected abstract TileEntity getMineTileEntity();

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTripMine) {
            TileEntityTripMine mine = (TileEntityTripMine)te;
            if (world.func_175623_d(pos.func_177977_b())) {
                if (mine.digLevel == 15) {
                    mine.explode();
                }
                this.func_176226_b(mine.func_145831_w(), pos, world.func_180495_p(pos), 0);
                mine.func_145831_w().func_175698_g(pos);
            }
        }
    }

    public static abstract class ItemBlockMineBase
    extends ItemBlockIIBase
    implements IAmmo {
        public ItemBlockMineBase(BlockIIMine b) {
            super(b);
        }

        @Override
        public float getDefaultVelocity() {
            return 1.0f;
        }

        @Override
        public AmmoRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
            return new AmmoRegistry.EnumCoreTypes[]{AmmoRegistry.EnumCoreTypes.CANISTER};
        }

        public void makeDefault(ItemStack stack) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)"core_brass");
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)this.getAllowedCoreTypes()[0].func_176610_l());
            }
            if (stack.func_77960_j() == IIBlockTypes_Mine.MAIN.getMeta() && !ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)this.getAllowedFuseTypes()[0].func_176610_l());
            }
        }

        @Override
        public IAmmoCore getCore(ItemStack stack) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
                this.makeDefault(stack);
            }
            return AmmoRegistry.INSTANCE.getCore(ItemNBTHelper.getString((ItemStack)stack, (String)"core"));
        }

        @Override
        public AmmoRegistry.EnumCoreTypes getCoreType(ItemStack stack) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
                this.makeDefault(stack);
            }
            return AmmoRegistry.EnumCoreTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"core_type"));
        }

        @Override
        public int getPaintColor(ItemStack stack) {
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"paint_color")) {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"paint_color");
            }
            return -1;
        }

        @Override
        public void registerSprites(TextureMap map) {
        }

        @Override
        public ItemStack getBulletWithParams(String core, String coreType, String ... components) {
            ItemStack stack = new ItemStack((Item)this, 1, IIBlockTypes_Mine.MAIN.getMeta());
            ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
            ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
            NBTTagList tagList = new NBTTagList();
            Arrays.stream(components).map(NBTTagString::new).forEachOrdered(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
            if (tagList.func_74745_c() > 0) {
                ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)tagList);
                NBTTagList nbt = new NBTTagList();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    nbt.func_74742_a((NBTBase)new NBTTagCompound());
                }
                ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbt);
            }
            return stack;
        }

        @Override
        public ItemStack getBulletCore(String core, String coreType) {
            ItemStack stack = new ItemStack((Item)this, 1, IIBlockTypes_Mine.CORE.getMeta());
            ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
            ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
            return stack;
        }

        @Override
        public boolean isBulletCore(ItemStack stack) {
            return stack.func_77960_j() == IIBlockTypes_Mine.CORE.getMeta();
        }

        @Override
        public AmmoRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
            return new AmmoRegistry.EnumFuseTypes[]{AmmoRegistry.EnumFuseTypes.CONTACT};
        }

        @Override
        public void setFuseType(ItemStack stack, AmmoRegistry.EnumFuseTypes type) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)type.func_176610_l());
        }

        @Override
        public AmmoRegistry.EnumFuseTypes getFuseType(ItemStack stack) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
                this.makeDefault(stack);
            }
            return AmmoRegistry.EnumFuseTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"fuse"));
        }

        @Override
        public boolean isProjectile() {
            return false;
        }

        @Override
        public IAmmoComponent[] getComponents(ItemStack stack) {
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"components")) {
                ArrayList<IAmmoComponent> arrayList = new ArrayList<IAmmoComponent>();
                NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("components");
                for (int i = 0; i < components.func_74745_c(); ++i) {
                    arrayList.add(AmmoRegistry.INSTANCE.getComponent(components.func_150307_f(i)));
                }
                return arrayList.toArray(new IAmmoComponent[0]);
            }
            return new IAmmoComponent[0];
        }

        @Override
        public NBTTagCompound[] getComponentsNBT(ItemStack stack) {
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"component_nbt")) {
                ArrayList<NBTTagCompound> arrayList = new ArrayList<NBTTagCompound>();
                NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("component_nbt");
                for (int i = 0; i < components.func_74745_c(); ++i) {
                    arrayList.add(components.func_150305_b(i));
                }
                return arrayList.toArray(new NBTTagCompound[0]);
            }
            return new NBTTagCompound[0];
        }

        @Override
        public void addComponents(ItemStack stack, IAmmoComponent component, NBTTagCompound componentNBT) {
            NBTTagList comps = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("components", 8);
            NBTTagList nbts = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("component_nbt", 10);
            comps.func_74742_a((NBTBase)new NBTTagString(component.getName()));
            nbts.func_74742_a((NBTBase)componentNBT.func_74737_b());
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)comps);
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbts);
        }

        @Override
        public ItemStack setPaintColour(ItemStack stack, int color) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"paint_color", (int)color);
            return stack;
        }

        @Override
        public ItemStack setComponentNBT(ItemStack stack, NBTTagCompound ... tagCompounds) {
            NBTTagList component_nbt = new NBTTagList();
            for (NBTTagCompound tagCompound : tagCompounds) {
                component_nbt.func_74742_a((NBTBase)tagCompound);
            }
            assert (stack.func_77978_p() != null);
            stack.func_77978_p().func_74782_a("component_nbt", (NBTBase)component_nbt);
            return stack;
        }
    }

    public static enum IIBlockTypes_Mine implements IIBlockInterfaces.IITileProviderEnum
    {
        MAIN,
        CORE;

    }
}

