/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.gate_multiblock.tileentity;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIConnectable;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockInteractablePart;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockRedstoneNetwork;
import pl.pabilo8.immersiveintelligence.common.util.upgrade_system.UpgradeStorage;

public abstract class TileEntityGateBase<T extends TileEntityGateBase<T>>
extends TileEntityMultiblockIIConnectable<T>
implements IBooleanAnimatedPartsBlock,
IEBlockInterfaces.IPlayerInteraction,
IUpgradableMachine,
IRedstoneConnector {
    public MultiblockInteractablePart gate = new MultiblockInteractablePart(40.0f);
    protected MultiblockRedstoneNetwork<T> redstoneNetwork = new MultiblockRedstoneNetwork<TileEntityGateBase>(this);
    protected UpgradeStorage<TileEntityGateBase<T>> upgradeStorage = new UpgradeStorage<TileEntityGateBase>(this);

    public TileEntityGateBase(MultiblockStuctureBase<T> multiblock) {
        super(multiblock);
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.gate.readFromNBT(nbt.func_74775_l("gate"));
        this.upgradeStorage.getUpgradesFromNBT(nbt.func_74775_l("upgrades"));
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74782_a("gate", (NBTBase)this.gate.writeToNBT());
        nbt.func_74782_a("upgrades", (NBTBase)this.upgradeStorage.saveUpgradesToNBT());
    }

    @Override
    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (!this.isDummy()) {
            this.gate.readFromNBT(message.func_74775_l("gate"));
        }
    }

    @Override
    protected void onUpdate() {
        this.gate.update();
        this.upgradeStorage.update();
    }

    @Override
    public List<AxisAlignedBB> getBounds(boolean collision) {
        if (this.isPOI("gate") && ((TileEntityGateBase)this.master()).gate.getProgress(0.0f) > 0.0f) {
            return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return super.getBounds(collision);
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case MISC_DOOR: {
                return this.getPOI("gate");
            }
            case REDSTONE_CABLE_MOUNT: {
                return this.getPOI("redstone");
            }
        }
        return new int[0];
    }

    public boolean isDoorPart() {
        return this.isPOI("gate");
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        this.gate.setState(state);
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (this.gate.setState(state)) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), state ? this.getOpeningSound() : this.getClosingSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(state, 0, this.func_174877_v()), IIPacketHandler.targetPointFromPos(this.func_174877_v(), this.field_145850_b, 32));
        }
    }

    protected abstract SoundEvent getOpeningSound();

    protected abstract SoundEvent getClosingSound();

    public abstract IBlockState getFenceState(@Nullable EnumFacing var1);

    @Override
    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        return this.upgradeStorage.addUpgrade(upgrade, test);
    }

    @Override
    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.upgradeStorage.hasUpgrade(upgrade);
    }

    @Override
    public boolean upgradeMatches(MachineUpgrade upgrade) {
        return upgrade == IIContent.UPGRADE_REDSTONE_ACTIVATION || upgrade == IIContent.UPGRADE_RAZOR_WIRE;
    }

    @Override
    public <T extends TileEntity> T getUpgradeMaster() {
        return (T)this.master();
    }

    @Override
    public void saveUpgradesToNBT(NBTTagCompound tag) {
        this.upgradeStorage.saveUpgradesToNBT();
    }

    @Override
    public void getUpgradesFromNBT(NBTTagCompound tag) {
        this.upgradeStorage.getUpgradesFromNBT(tag);
    }

    public ArrayList<MachineUpgrade> getUpgrades() {
        return this.upgradeStorage.getUpgrades();
    }

    @Override
    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.upgradeStorage.getCurrentlyInstalled();
    }

    @Override
    public int getInstallProgress() {
        return this.upgradeStorage.getInstallProgress();
    }

    @Override
    public int getClientInstallProgress() {
        return this.upgradeStorage.getClientInstallProgress();
    }

    @Override
    public boolean addUpgradeInstallProgress(int toAdd) {
        return this.upgradeStorage.addUpgradeInstallProgress(toAdd);
    }

    @Override
    public boolean resetInstallProgress() {
        return this.upgradeStorage.resetInstallProgress();
    }

    @Override
    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.upgradeStorage.startUpgrade(upgrade);
    }

    @Override
    public void removeUpgrade(MachineUpgrade upgrade) {
        this.upgradeStorage.removeUpgrade(upgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntityGateBase master = (TileEntityGateBase)this.master();
        if (!IIUtils.isWrench(player.func_184586_b(hand)) && master != null && !master.hasUpgrade(IIContent.UPGRADE_REDSTONE_ACTIVATION)) {
            if (!this.field_145850_b.field_72995_K) {
                ((TileEntityGateBase)this.master()).onAnimationChangeServer(!this.gate.getState(), 0);
            }
            return true;
        }
        return false;
    }

    public void onEntityCollision(World world, Entity entity) {
        if (this.isPOI("razor") && ((TileEntityGateBase)this.master()).hasUpgrade(IIContent.UPGRADE_RAZOR_WIRE) && !entity.field_70128_L) {
            entity.func_70097_a(IEDamageSources.razorWire, 3.0f);
        }
        super.onEntityCollision(world, entity);
    }

    @Override
    protected boolean isMatchingCable(WireType cableType) {
        return Objects.equals(cableType.getCategory(), "REDSTONE");
    }

    public RedstoneWireNetwork getNetwork() {
        return this.redstoneNetwork.getNetwork();
    }

    public void setNetwork(RedstoneWireNetwork net) {
        this.redstoneNetwork.setNetwork(net);
    }

    public void onChange() {
        ((TileEntityGateBase)this.master()).onAnimationChangeServer(this.redstoneNetwork.getNetwork().channelValues[0] > 0, 0);
    }

    public World getConnectorWorld() {
        return this.field_145850_b;
    }

    public void updateInput(byte[] signals) {
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return new Vec3d(0.5, 0.5, 0.5);
    }
}

