/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataHandlingUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.client.util.carversound.ConditionCompoundSound;
import pl.pabilo8.immersiveintelligence.client.util.carversound.TimedCompoundSound;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.multiblock.MultiblockArtilleryHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.entity.tactile.TactileHandler;
import pl.pabilo8.immersiveintelligence.common.item.ammo.ItemIIAmmoArtillery;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.util.AdvancedSounds;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.IISoundAnimation;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.lambda.NBTTagCollector;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIGeneric;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public class TileEntityArtilleryHowitzer
extends TileEntityMultiblockIIGeneric<TileEntityArtilleryHowitzer>
implements IBooleanAnimatedPartsBlock,
ConveyorHandler.IConveyorAttachable,
IIMultiblockInterfaces.ILadderMultiblock,
IIMultiblockInterfaces.IExplosionResistantMultiblock,
TactileHandler.ITactileListener {
    private static final IISoundAnimation loadingSoundAnimation;
    private static final IISoundAnimation unloadingSoundAnimation;
    private static final IISoundAnimation firingSoundAnimation;
    @SideOnly(value=Side.CLIENT)
    private ConditionCompoundSound soundRotationV;
    @SideOnly(value=Side.CLIENT)
    private ConditionCompoundSound soundRotationH;
    @SideOnly(value=Side.CLIENT)
    private ConditionCompoundSound soundDoorOpen;
    @SideOnly(value=Side.CLIENT)
    private ConditionCompoundSound soundDoorClose;
    private static final ResLoc animationPlatform;
    private static final ResLoc animationOpen;
    private static final ResLoc animationFire;
    private static final ResLoc animationLoading;
    private static final ResLoc animationUnloading;
    private static final ResLoc animationPitch;
    private static final ResLoc animationYaw;
    public ArrayList<HowitzerOrder> orderList = new ArrayList();
    public ArtilleryHowitzerAnimation animation = ArtilleryHowitzerAnimation.STOP;
    public int animationTime = 0;
    public int animationTimeMax = 0;
    public int shellConveyorTime = 0;
    public boolean isDoorOpened = false;
    public boolean platformPosition = false;
    public int platformTime = 0;
    public int doorTime = 0;
    public float turretYaw = 0.0f;
    public float turretPitch = 0.0f;
    public float plannedYaw = 0.0f;
    public float plannedPitch = 0.0f;
    public NonNullList<ItemStack> loadedShells;
    public IItemHandler inventoryHandler;
    public IItemHandler insertionHandler;
    @SideOnly(value=Side.CLIENT)
    private List<TimedCompoundSound> soundsList;
    private TactileHandler tactileHandler = null;

    public TileEntityArtilleryHowitzer() {
        super(MultiblockArtilleryHowitzer.INSTANCE);
        this.energyStorage = new FluxStorageAdvanced(IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyCapacity);
        this.inventory = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);
        this.loadedShells = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.inventoryHandler = new IEInventoryHandler(this.inventory.size(), (IIEInventory)this, 0, true, true);
        this.insertionHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, false);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
        }
        if (this.tactileHandler == null) {
            this.tactileHandler = new TactileHandler(this.multiblock, (TactileHandler.ITactileListener)this);
        }
        this.tactileHandler.defaultize();
        boolean rs = this.getRedstoneAtPos(0);
        if (this.isDoorOpened ^ rs) {
            this.isDoorOpened = rs;
            if (!this.field_145850_b.field_72995_K) {
                IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDoorOpened, 0, this.func_174877_v()), IIPacketHandler.targetPointFromTile((TileEntity)this, 48));
            }
        }
        if (this.energyStorage.getEnergyStored() < IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive) {
            return;
        }
        this.energyStorage.extractEnergy(IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive, false);
        this.doorTime = MathHelper.func_76125_a((int)(this.doorTime + (this.isDoorOpened ? 1 : -2)), (int)0, (int)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.doorTime);
        this.tactileHandler.update(animationOpen, (float)this.doorTime / (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.doorTime);
        this.platformTime = MathHelper.func_76125_a((int)(this.platformTime + (this.platformPosition ? 1 : -1)), (int)0, (int)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.platformTime);
        this.tactileHandler.update(animationPlatform, (float)this.platformTime / (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.platformTime);
        if (!this.isDoorOpened) {
            this.animation = ArtilleryHowitzerAnimation.HIDE;
        }
        if (this.shellConveyorTime < IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.conveyorTime) {
            ++this.shellConveyorTime;
        } else {
            int i;
            for (i = 5; i > 0; --i) {
                if (!this.inventoryHandler.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.set(i, (Object)this.inventoryHandler.extractItem(i - 1, 1, false));
            }
            for (i = 11; i > 6; --i) {
                if (!this.inventoryHandler.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.set(i, (Object)this.inventoryHandler.extractItem(i - 1, 1, false));
            }
            if (!this.field_145850_b.field_72995_K && !this.inventoryHandler.getStackInSlot(11).func_190926_b()) {
                BlockPos outPos = this.getBlockPosForPos(this.multiblock.getPointOfInterest("item_output")).func_177972_a(this.facing.func_176734_d()).func_177972_a(EnumFacing.UP);
                ItemStack casing = this.inventoryHandler.extractItem(11, 1, false);
                if (this.field_145850_b.func_175625_s(outPos) != null) {
                    casing = Utils.insertStackIntoInventory((TileEntity)this.field_145850_b.func_175625_s(outPos), (ItemStack)casing, (EnumFacing)this.facing);
                }
                if (!casing.func_190926_b()) {
                    Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)outPos, (ItemStack)casing);
                }
            }
            this.shellConveyorTime = 0;
            if (!this.field_145850_b.field_72995_K) {
                this.forceTileUpdate();
            }
        }
        this.animateGunTactiles();
        if (this.animation == ArtilleryHowitzerAnimation.STOP) {
            if (this.field_145850_b.field_72995_K || this.orderList.isEmpty()) {
                return;
            }
            HowitzerOrder newOrder = this.orderList.get(0);
            if (newOrder.animation.isFulfilled(this)) {
                this.orderList.remove(0);
            } else if (newOrder.animation.matchesRequirements(this)) {
                this.animation = newOrder.animation;
                this.animationTime = 0;
                this.animationTimeMax = this.animation.animationTime;
                this.plannedPitch = newOrder.pitch;
                this.plannedYaw = newOrder.yaw;
                this.forceTileUpdate();
                this.orderList.remove(0);
            }
            return;
        }
        boolean canContinue = true;
        switch (this.animation.gunPosition) {
            case NEUTRAL: {
                break;
            }
            case LOADING: {
                this.platformPosition = false;
                this.plannedYaw = this.facing.func_185119_l();
                this.plannedPitch = 0.0f;
                canContinue = this.platformTime == 0;
                break;
            }
            case ON_TARGET: {
                this.platformPosition = true;
                canContinue = this.platformTime == IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.platformTime && this.isAimed();
            }
        }
        this.turnToTarget();
        if (canContinue) {
            if (this.animationTime < this.animationTimeMax) {
                ++this.animationTime;
            } else {
                this.animation = ArtilleryHowitzerAnimation.STOP;
                this.animationTimeMax = 0;
                this.animationTime = 0;
                this.forceTileUpdate();
            }
            if (this.field_145850_b.field_72995_K) {
                this.handleAnimationSounds();
            }
            switch (this.animation) {
                case AIM: {
                    break;
                }
                case FIRE1: 
                case FIRE2: 
                case FIRE3: 
                case FIRE4: {
                    this.tactileHandler.update(animationFire, (float)this.animationTime / (float)this.animationTimeMax);
                    break;
                }
                case LOAD1: 
                case LOAD2: 
                case LOAD3: 
                case LOAD4: {
                    this.tactileHandler.update(animationLoading, (float)this.animationTime / (float)this.animationTimeMax);
                    break;
                }
                case UNLOAD1: 
                case UNLOAD2: 
                case UNLOAD3: 
                case UNLOAD4: {
                    this.tactileHandler.update(animationUnloading, (float)this.animationTime / (float)this.animationTimeMax);
                }
            }
            if (this.animationTime == (int)((float)this.animationTimeMax * this.animation.executeTime)) {
                switch (this.animation) {
                    case AIM: {
                        break;
                    }
                    case FIRE1: 
                    case FIRE2: 
                    case FIRE3: 
                    case FIRE4: {
                        this.fireGun(this.animation.ordinal() - ArtilleryHowitzerAnimation.FIRE1.ordinal());
                        break;
                    }
                    case LOAD1: 
                    case LOAD2: 
                    case LOAD3: 
                    case LOAD4: {
                        int slot = this.animation.ordinal() - ArtilleryHowitzerAnimation.LOAD1.ordinal();
                        this.loadedShells.set(slot, (Object)this.inventoryHandler.extractItem(5, 1, false));
                        break;
                    }
                    case UNLOAD1: 
                    case UNLOAD2: 
                    case UNLOAD3: 
                    case UNLOAD4: {
                        int slot = this.animation.ordinal() - ArtilleryHowitzerAnimation.UNLOAD1.ordinal();
                        this.inventory.set(6, (Object)((ItemStack)this.loadedShells.get(slot)).func_77946_l());
                        this.loadedShells.set(slot, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        }
        this.animateGunTactiles();
    }

    private void animateGunTactiles() {
        this.tactileHandler.update(animationPitch, this.turretPitch / 105.0f);
        this.tactileHandler.update(animationYaw, (720.0f - this.turretYaw - this.facing.func_185119_l() - 90.0f) % 360.0f / 360.0f);
    }

    private void fireGun(int i) {
        double yawFireAngle = Math.toRadians(-this.turretYaw > 180.0f ? (double)(180.0f + this.turretYaw) : (double)(180.0f - this.turretYaw));
        double yawPitchAngle = Math.toRadians(this.turretPitch + 90.0f);
        Vec3d gunEnd = IIUtils.offsetPosDirection(3.0f, yawFireAngle, yawPitchAngle);
        Vec3d gunVec = gunEnd.func_72432_b();
        if (this.field_145850_b.field_72995_K) {
            Vec3d gun_end_particle = gunVec.func_186678_a(4.5);
            ParticleUtils.spawnGunfireFX(this.getGunPosition().func_178787_e(gun_end_particle), gunVec, 8.0f);
        }
        IIPacketHandler.playRangedSound(this.field_145850_b, gunEnd, IISounds.howitzerShot, SoundCategory.PLAYERS, 155, 1.5f, 1.25f + (float)(Utils.RAND.nextGaussian() * 0.02));
        if (!this.field_145850_b.field_72995_K) {
            ItemStack bullet = (ItemStack)this.loadedShells.get(i);
            EntityBullet a = AmmoUtils.createBullet(this.field_145850_b, bullet, this.getGunPosition().func_178787_e(gunEnd), gunVec);
            if (this.tactileHandler != null) {
                a.setShooters(a.getShooter(), this.tactileHandler.getEntities().toArray(new Entity[0]));
            }
            a.setShootPos(this.getMultiblockBlocks());
            a.field_70170_p.func_72838_d((Entity)a);
        }
        this.loadedShells.set(i, (Object)IIContent.itemAmmoArtillery.getCasingStack(1));
    }

    private boolean isAimed() {
        return this.plannedYaw == this.turretYaw && this.plannedPitch == this.turretPitch;
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            this.loadedShells = Utils.readInventory((NBTTagList)nbt.func_150295_c("loaded_shells", 10), (int)this.loadedShells.size());
            if (nbt.func_74764_b("bullet")) {
                this.loadedShells = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack(nbt.func_74775_l("bullet")), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a});
            }
        }
        this.turretYaw = nbt.func_74760_g("turretYaw");
        this.plannedYaw = nbt.func_74760_g("plannedYaw");
        this.turretPitch = nbt.func_74760_g("turretPitch");
        this.plannedPitch = nbt.func_74760_g("plannedPitch");
        this.isDoorOpened = nbt.func_74767_n("isDoorOpened");
        this.animation = ArtilleryHowitzerAnimation.values()[nbt.func_74762_e("animation")];
        this.animationTime = nbt.func_74762_e("animation_time");
        this.animationTimeMax = nbt.func_74762_e("animation_time_max");
        this.doorTime = nbt.func_74762_e("door_time");
        this.platformTime = nbt.func_74762_e("platform_time");
        this.platformPosition = nbt.func_74767_n("platform_position");
        this.shellConveyorTime = nbt.func_74762_e("shell_conveyor_time");
        this.orderList.clear();
        for (NBTBase order : nbt.func_150295_c("order_queue", 10)) {
            if (!(order instanceof NBTTagCompound)) continue;
            NBTTagCompound compound = (NBTTagCompound)order;
            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.values()[compound.func_74762_e("order")], compound.func_74760_g("pitch"), compound.func_74760_g("yaw")));
        }
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            nbt.func_74782_a("loaded_shells", (NBTBase)Utils.writeInventory(this.loadedShells));
        }
        nbt.func_74776_a("turretYaw", this.turretYaw);
        nbt.func_74776_a("plannedYaw", this.plannedYaw);
        nbt.func_74776_a("turretPitch", this.turretPitch);
        nbt.func_74776_a("plannedPitch", this.plannedPitch);
        nbt.func_74757_a("isDoorOpened", this.isDoorOpened);
        nbt.func_74768_a("animation", this.animation.ordinal());
        nbt.func_74768_a("animation_time", this.animationTime);
        nbt.func_74768_a("animation_time_max", this.animationTimeMax);
        nbt.func_74768_a("door_time", this.doorTime);
        nbt.func_74768_a("platform_time", this.platformTime);
        nbt.func_74757_a("platform_position", this.platformPosition);
        nbt.func_74768_a("shell_conveyor_time", this.shellConveyorTime);
        nbt.func_74782_a("order_queue", (NBTBase)this.orderList.stream().map(order -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("order", order.animation.ordinal());
            tag.func_74776_a("pitch", order.pitch);
            tag.func_74776_a("yaw", order.yaw);
            return tag;
        }).collect(new NBTTagCollector()));
    }

    public void receiveMessageFromClient(@Nonnull NBTTagCompound message) {
    }

    @Override
    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isFullSyncMessage(message) || this.isDummy()) {
            return;
        }
        if (message.func_74764_b("loaded_shells")) {
            this.loadedShells = Utils.readInventory((NBTTagList)message.func_150295_c("loaded_shells", 10), (int)this.loadedShells.size());
        }
        if (message.func_74764_b("turretYaw")) {
            this.turretYaw = message.func_74760_g("turretYaw");
        }
        if (message.func_74764_b("plannedYaw")) {
            this.plannedYaw = message.func_74760_g("plannedYaw");
        }
        if (message.func_74764_b("turretPitch")) {
            this.turretPitch = message.func_74760_g("turretPitch");
        }
        if (message.func_74764_b("plannedPitch")) {
            this.plannedPitch = message.func_74760_g("plannedPitch");
        }
        if (message.func_74764_b("isDoorOpened")) {
            this.isDoorOpened = message.func_74767_n("isDoorOpened");
        }
        if (message.func_74764_b("animation")) {
            this.animation = ArtilleryHowitzerAnimation.values()[message.func_74762_e("animation")];
        }
        if (message.func_74764_b("animation_time")) {
            this.animationTime = message.func_74762_e("animation_time");
        }
        if (message.func_74764_b("animation_time_max")) {
            this.animationTimeMax = message.func_74762_e("animation_time_max");
        }
        if (message.func_74764_b("door_time")) {
            this.doorTime = message.func_74762_e("door_time");
        }
        if (message.func_74764_b("platform_time")) {
            this.platformTime = message.func_74762_e("platform_time");
        }
        if (message.func_74764_b("platform_position")) {
            this.platformPosition = message.func_74767_n("platform_position");
        }
        if (message.func_74764_b("shell_conveyor_time")) {
            this.shellConveyorTime = message.func_74762_e("shell_conveyor_time");
        }
    }

    private void turnToTarget() {
        if (Double.isNaN(this.turretPitch)) {
            this.turretPitch = 0.0f;
        }
        if (Double.isNaN(this.turretYaw)) {
            this.turretYaw = 0.0f;
        }
        if (this.isAimed()) {
            return;
        }
        this.plannedYaw = MathHelper.func_76142_g((float)this.plannedYaw);
        float p = this.plannedPitch - this.turretPitch;
        this.turretPitch += Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed);
        float y = MathHelper.func_76142_g((float)(360.0f + this.plannedYaw - this.turretYaw));
        if (Math.abs(p) < (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed * 0.5f) {
            this.turretPitch = this.plannedPitch;
        }
        this.turretYaw = Math.abs(y) < (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed * 0.5f ? this.plannedYaw : MathHelper.func_76142_g((float)(this.turretYaw + Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed)));
    }

    @SideOnly(value=Side.CLIENT)
    private void handleAnimationSounds() {
        IISoundAnimation current = null;
        switch (this.animation) {
            case FIRE1: 
            case FIRE2: 
            case FIRE3: 
            case FIRE4: {
                current = firingSoundAnimation;
                break;
            }
            case LOAD1: 
            case LOAD2: 
            case LOAD3: 
            case LOAD4: {
                current = loadingSoundAnimation;
                break;
            }
            case UNLOAD1: 
            case UNLOAD2: 
            case UNLOAD3: 
            case UNLOAD4: {
                current = unloadingSoundAnimation;
                break;
            }
        }
        if (current != null) {
            BlockPos soundPos = this.getBlockPosForPos(202);
            if (this.soundsList == null) {
                this.soundsList = new ArrayList<TimedCompoundSound>();
            }
            current.handleSounds(this.soundsList, soundPos, this.animationTime, 0.75f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleSounds() {
        boolean hasActiveEnergy;
        boolean hasEnergy = this.energyStorage.getEnergyStored() >= IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive;
        boolean bl = hasActiveEnergy = this.energyStorage.getEnergyStored() >= IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive + IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.energyUsageActive;
        boolean platformOK = this.animation == ArtilleryHowitzerAnimation.STOP || this.platformTime == (this.platformPosition ? IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.platformTime : 0);
        boolean yawOK = this.turretYaw == MathHelper.func_76142_g((float)this.plannedYaw);
        boolean pitchOK = this.turretPitch == this.plannedPitch;
        Vec3d posDoor = new Vec3d((Vec3i)this.getBlockPosForPos(525));
        this.soundDoorOpen = this.playRepeatedSound(this.soundDoorOpen, IISounds.slidingDoorOpenM, posDoor, 0.5f, 1.0f, hasEnergy && this.isDoorOpened && this.doorTime < IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.doorTime);
        this.soundDoorClose = this.playRepeatedSound(this.soundDoorClose, IISounds.slidingDoorCloseM, posDoor, 0.5f, 1.0f, hasEnergy && !this.isDoorOpened && this.doorTime > 0);
        this.soundRotationH = this.playRepeatedSound(this.soundRotationH, IISounds.turntableHeavyForwardM, posDoor, 0.5f, 1.0f, hasEnergy && platformOK && !yawOK);
        this.soundRotationV = this.playRepeatedSound(this.soundRotationV, IISounds.electricMotorHeavyForwardM, posDoor, 0.5f, 1.0f, hasEnergy && platformOK && !pitchOK);
    }

    @SideOnly(value=Side.CLIENT)
    private ConditionCompoundSound playRepeatedSound(ConditionCompoundSound current, AdvancedSounds.MultiSound sound, Vec3d pos, float volume, float pitch, boolean condition) {
        if (!condition) {
            if (current != null) {
                current.forceStop();
            }
            return null;
        }
        if (current == null) {
            current = new ConditionCompoundSound(sound, SoundCategory.BLOCKS, pos, volume, pitch, () -> true);
            ClientUtils.mc().func_147118_V().func_147682_a((ISound)current);
        }
        return current;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemIIAmmoArtillery;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case ENERGY_INPUT: {
                return this.getPOI("energy");
            }
            case ITEM_INPUT: {
                return this.getPOI("item_input");
            }
            case ITEM_OUTPUT: {
                return this.getPOI("item_output");
            }
            case REDSTONE_INPUT: {
                return this.getPOI("redstone");
            }
            case DATA_INPUT: {
                return this.getPOI("data");
            }
            case MISC_DOOR: {
                return this.getPOI("bunker_door");
            }
            case MISC_WEAPON: {
                return this.getPOI("gun");
            }
        }
        return new int[0];
    }

    @Override
    public void receiveData(DataPacket packet, int pos) {
        DataHandlingUtils.expectingNumericParam('y', packet, f -> {
            this.plannedYaw = f.floatValue();
        });
        DataHandlingUtils.expectingNumericParam('p', packet, f -> {
            this.plannedPitch = Math.abs(Math.min(Math.max(-Math.abs(f.floatValue() % 360.0f), -105.0f), 0.0f));
        });
        if (this.animationTime == 0) {
            DataHandlingUtils.expectingStringParam('c', packet, command -> {
                switch (command) {
                    case "fire_all": {
                        float vOffset = DataHandlingUtils.asFloat('v', packet);
                        float hOffset = DataHandlingUtils.asFloat('h', packet);
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE1, this.plannedPitch - vOffset, this.plannedYaw - hOffset));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE2, this.plannedPitch + vOffset, this.plannedYaw + hOffset));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE3, this.plannedPitch - vOffset, this.plannedYaw - hOffset));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE4, this.plannedPitch + vOffset, this.plannedYaw + hOffset));
                        break;
                    }
                    case "load_all": {
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD1));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD2));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD3));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD4));
                        break;
                    }
                    case "unload_all": {
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD1));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD2));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD3));
                        this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD4));
                        break;
                    }
                    case "callback": {
                        DataPacket callback;
                        IDataConnector conn = IIUtils.findConnectorFacing(this.getBlockPosForPos(441), this.field_145850_b, EnumFacing.UP);
                        if (conn == null || (callback = DataHandlingUtils.handleCallback(packet, var -> {
                            switch (var) {
                                case "get_energy": {
                                    return new DataTypeInteger(this.energyStorage.getEnergyStored());
                                }
                                case "get_state_progress": {
                                    return new DataTypeFloat((float)this.animationTime / (float)this.animationTimeMax);
                                }
                                case "get_yaw": {
                                    return new DataTypeFloat(this.turretYaw);
                                }
                                case "get_pitch": {
                                    return new DataTypeFloat(this.turretPitch);
                                }
                                case "get_planned_yaw": {
                                    return new DataTypeFloat(this.plannedYaw);
                                }
                                case "get_planned_pitch": {
                                    return new DataTypeFloat(this.plannedPitch);
                                }
                                case "get_platform_height": {
                                    return new DataTypeInteger(this.platformTime);
                                }
                                case "get_door_opened": {
                                    return new DataTypeBoolean(this.isDoorOpened && this.doorTime == IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.doorTime);
                                }
                                case "get_door_closed": {
                                    return new DataTypeBoolean(!this.isDoorOpened && this.doorTime == 0);
                                }
                                case "get_door_opening": {
                                    return new DataTypeBoolean(this.doorTime != 0 && this.doorTime != IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.doorTime);
                                }
                                case "get_loaded_shell": {
                                    return new DataTypeItemStack((ItemStack)this.loadedShells.get(DataHandlingUtils.asInt('i', packet)));
                                }
                                case "get_stored_shell": {
                                    return new DataTypeItemStack((ItemStack)this.inventory.get(MathHelper.func_76125_a((int)DataHandlingUtils.asInt('i', packet), (int)0, (int)5)));
                                }
                                case "get_state": {
                                    return new DataTypeString(this.animation.func_176610_l());
                                }
                                case "get_state_num": {
                                    return new DataTypeInteger(this.animation.ordinal());
                                }
                            }
                            return null;
                        })) == null) break;
                        conn.sendPacket(callback);
                        break;
                    }
                    default: {
                        ArtilleryHowitzerAnimation anim = ArtilleryHowitzerAnimation.v(command, this);
                        if (anim == null) break;
                        if (anim == ArtilleryHowitzerAnimation.STOP) {
                            this.orderList.clear();
                        }
                        if (!anim.matchesRequirements(this)) break;
                        this.animation = anim;
                        this.animationTime = 0;
                        this.animationTimeMax = anim.animationTime;
                        this.forceTileUpdate();
                    }
                }
            });
        }
        this.forceTileUpdate();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.multiblock.isPointOfInterest(this.field_174879_c, "item_input");
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.field_174879_c == 410) {
            TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
            if (master == null) {
                return null;
            }
            return (T)master.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        if (part == 0) {
            this.isDoorOpened = state;
        }
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (part == 0) {
            this.isDoorOpened = state;
        }
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDoorOpened, 1, this.func_174877_v()), IIPacketHandler.targetPointFromPos(this.func_174877_v(), this.field_145850_b, 32));
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 2) {
            return new EnumFacing[]{this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }

    public void onEntityCollision(@Nonnull World world, @Nonnull Entity entity) {
        if (!world.field_72995_K && this.field_174879_c == 410 && entity instanceof EntityItem) {
            TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
            if (master == null || !((ItemStack)master.inventory.get(0)).func_190926_b()) {
                return;
            }
            EntityItem entityItem = (EntityItem)entity;
            if (entityItem.func_92059_d().func_77973_b() != IIContent.itemAmmoArtillery) {
                return;
            }
            ItemStack stack = master.inventoryHandler.insertItem(0, entityItem.func_92059_d().func_77946_l(), false);
            if (stack.func_190926_b()) {
                entityItem.func_92058_a(ItemStack.field_190927_a);
            }
        }
    }

    private Vec3d getGunPosition() {
        BlockPos shoot_pos = this.getBlockPosForPos(this.multiblock.getPointOfInterest("gun")).func_177967_a(EnumFacing.UP, 1);
        return new Vec3d((double)shoot_pos.func_177958_n() + 0.5, (double)shoot_pos.func_177956_o() + 1.5, (double)shoot_pos.func_177952_p() + 0.5);
    }

    @Override
    public boolean isLadder() {
        return this.multiblock.isPointOfInterest(this.field_174879_c, "ladder");
    }

    @Override
    public float getExplosionResistance() {
        if (this.multiblock.isPointOfInterest(this.field_174879_c, "bunker_door")) {
            TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
            return master != null && master.doorTime > 1 ? 2000.0f : -1.0f;
        }
        return -1.0f;
    }

    @Override
    @Nullable
    public TactileHandler getTactileHandler() {
        return this.tactileHandler;
    }

    @Override
    public World getTactileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTactilePos() {
        return this.func_174877_v();
    }

    @Override
    public EnumFacing getTactileFacing() {
        return this.facing;
    }

    @Override
    public boolean getIsTactileMirrored() {
        return this.mirrored;
    }

    static {
        animationOpen = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_door");
        animationPlatform = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_platform");
        animationLoading = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_loading1");
        animationUnloading = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_unloading1");
        animationFire = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_fire1");
        animationPitch = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_tactile_pitch");
        animationYaw = ResLoc.of(IIReference.RES_II, "artillery_howitzer/artillery_howitzer_tactile_yaw");
        loadingSoundAnimation = new IISoundAnimation(18.0);
        unloadingSoundAnimation = new IISoundAnimation(18.0);
        firingSoundAnimation = new IISoundAnimation(15.96);
        loadingSoundAnimation.withRepeatedSound(0.64, 3.6, IISounds.slidingDoorOpenM).withSound(4.36, IISounds.metalLockerOpen).withRepeatedSound(5.0, 11.28, IISounds.chainM).withSound(8.4, IISounds.artilleryShellPlace).withSound(9.0, SoundEvents.field_187782_ds).withSound(8.92, IISounds.howitzerPlatformStart).withSound(11.52, IISounds.metalLockerClose).withRepeatedSound(11.96, 13.24, IISounds.inserterYawM).withSound(13.96, IISounds.artilleryShellPick).withSound(14.0, SoundEvents.field_187782_ds).withRepeatedSound(14.24, 14.96, IISounds.inserterPitchM).withRepeatedSound(15.12, 15.9, IISounds.inserterYawM).withSound(16.36, IISounds.artilleryShellPlace).withRepeatedSound(15.12, 16.68, IISounds.inserterPitchM).withRepeatedSound(17.0, 18.0, IISounds.slidingDoorCloseM).compile(IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime);
        firingSoundAnimation.compile(IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireTime);
        unloadingSoundAnimation.withRepeatedSound(0.04, 1.24, IISounds.inserterYawM).withRepeatedSound(0.36, 1.0, IISounds.slidingDoorCloseM).withSound(1.36, IISounds.artilleryShellPick).withSound(2.0, SoundEvents.field_187782_ds).withRepeatedSound(1.44, 3.8, IISounds.inserterYawM).withSound(4.0, IISounds.artilleryShellPlace).withSound(4.5, SoundEvents.field_187782_ds).withRepeatedSound(4.28, 5.8, IISounds.inserterYawM).withSound(5.92, IISounds.metalLockerOpen).withRepeatedSound(6.6, 9.28, IISounds.chainM).withSound(8.0, IISounds.artilleryShellPick).withSound(12.44, IISounds.metalLockerClose).withRepeatedSound(8.08, 10.5, IISounds.slidingDoorCloseM).compile(IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime);
    }

    public static class HowitzerOrder {
        final ArtilleryHowitzerAnimation animation;
        final float pitch;
        final float yaw;

        public HowitzerOrder(ArtilleryHowitzerAnimation animation, float pitch, float yaw) {
            this.animation = animation;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public HowitzerOrder(ArtilleryHowitzerAnimation animation) {
            this(animation, 0.0f, 0.0f);
        }
    }

    public static enum GunPosition {
        ON_TARGET,
        NEUTRAL,
        LOADING;

    }

    public static enum ArtilleryHowitzerAnimation implements ISerializableEnum
    {
        STOP(false, false, GunPosition.NEUTRAL, t -> true, t -> false, 0, null, 1.0f),
        HIDE(false, false, GunPosition.LOADING, t -> true, t -> t.platformTime == 0, 0, null, 1.0f),
        LOAD1(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(0)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(0)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        LOAD2(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(1)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(1)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        LOAD3(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(2)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(2)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        LOAD4(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(3)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(3)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        UNLOAD1(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(0)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(0)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        UNLOAD2(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(1)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(1)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        UNLOAD3(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(2)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(2)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        UNLOAD4(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(3)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(3)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        FIRE1(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(0)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(0)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        FIRE2(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(1)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(1)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        FIRE3(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(2)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(2)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        FIRE4(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(3)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(3)).func_190926_b(), IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)IIConfigHandler.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        AIM(true, true, GunPosition.ON_TARGET, t -> true, t -> false, 0, null, 1.0f);

        final boolean requiresPlatform;
        final boolean platformUp;
        final GunPosition gunPosition;
        @Nullable
        final String alias;
        final Predicate<TileEntityArtilleryHowitzer> requirements;
        final Predicate<TileEntityArtilleryHowitzer> fulfilled;
        final int animationTime;
        final float executeTime;

        private ArtilleryHowitzerAnimation(boolean requiresPlatform, boolean platformUp, GunPosition gunPosition, Predicate<TileEntityArtilleryHowitzer> requirements, @Nullable Predicate<TileEntityArtilleryHowitzer> fulfilled, int animationTime, String alias, float executeTime) {
            this.requiresPlatform = requiresPlatform;
            this.platformUp = platformUp;
            this.gunPosition = gunPosition;
            this.requirements = requirements;
            this.fulfilled = fulfilled;
            this.animationTime = animationTime;
            this.alias = alias;
            this.executeTime = executeTime;
        }

        public boolean matchesRequirements(TileEntityArtilleryHowitzer te) {
            return this.requirements.test(te);
        }

        public boolean isFulfilled(TileEntityArtilleryHowitzer te) {
            return this.fulfilled.test(te);
        }

        @Nullable
        public static ArtilleryHowitzerAnimation v(String s, TileEntityArtilleryHowitzer te) {
            String ss = s.toUpperCase();
            Optional<ArtilleryHowitzerAnimation> found = Arrays.stream(ArtilleryHowitzerAnimation.values()).filter(e -> e.alias != null && e.alias.toLowerCase().equals(s)).filter(a -> a.matchesRequirements(te)).findFirst();
            return found.orElseGet(() -> Arrays.stream(ArtilleryHowitzerAnimation.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(null));
        }
    }
}

