/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.multiblock.MultiblockBallisticComputer;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.TileEntityMultiblockIIGeneric;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public class TileEntityBallisticComputer
extends TileEntityMultiblockIIGeneric<TileEntityBallisticComputer>
implements IEBlockInterfaces.IPlayerInteraction {
    public int progress = 0;

    public TileEntityBallisticComputer() {
        super(MultiblockBallisticComputer.INSTANCE);
        this.energyStorage = new FluxStorageAdvanced(IIConfigHandler.IIConfig.Machines.BallisticComputer.energyCapacity);
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    protected void onUpdate() {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("progress", this.progress);
    }

    @Override
    public void receiveData(DataPacket packet, int pos) {
        if (this.energyStorage.getEnergyStored() < IIConfigHandler.IIConfig.Machines.BallisticComputer.energyUsage) {
            return;
        }
        this.energyStorage.extractEnergy(IIConfigHandler.IIConfig.Machines.BallisticComputer.energyUsage, false);
        DataPacket new_packet = packet.clone();
        if (new_packet.hasAnyVariables(Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'))) {
            float x = packet.getVarInType(IDataTypeNumeric.class, new_packet.getPacketVariable(Character.valueOf('x'))).floatValue();
            float y = packet.getVarInType(IDataTypeNumeric.class, new_packet.getPacketVariable(Character.valueOf('y'))).floatValue();
            float z = packet.getVarInType(IDataTypeNumeric.class, new_packet.getPacketVariable(Character.valueOf('z'))).floatValue();
            new_packet.removeVariables(Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'));
            float mass = 0.0f;
            double force = IIContent.itemAmmoArtillery.getDefaultVelocity();
            if (new_packet.hasVariable(Character.valueOf('s'))) {
                DataTypeItemStack t = packet.getVarInType(DataTypeItemStack.class, new_packet.getPacketVariable(Character.valueOf('s')));
                ItemStack stack = t.value;
                if (stack.func_77973_b() instanceof IAmmo) {
                    IAmmo bullet = (IAmmo)stack.func_77973_b();
                    force = bullet.getDefaultVelocity();
                    mass = bullet.getMass(stack);
                }
                new_packet.removeVariable(Character.valueOf('s'));
            } else {
                String bname;
                IAmmo bullet;
                if (new_packet.hasVariable(Character.valueOf('m'))) {
                    mass = packet.getVarInType(DataTypeInteger.class, (IDataType)new_packet.getPacketVariable((Character)Character.valueOf((char)'m'))).value;
                }
                if (new_packet.hasVariable(Character.valueOf('f'))) {
                    force = packet.getVarInType(DataTypeInteger.class, (IDataType)new_packet.getPacketVariable((Character)Character.valueOf((char)'f'))).value;
                }
                if (new_packet.hasVariable(Character.valueOf('t')) && (bullet = AmmoRegistry.INSTANCE.getBulletItem(bname = new_packet.getPacketVariable(Character.valueOf('t')).valueToString())) != null) {
                    force = bullet.getDefaultVelocity();
                }
                new_packet.removeVariables(Character.valueOf('m'), Character.valueOf('f'), Character.valueOf('t'));
            }
            float distance = (float)new Vec3d(0.0, 0.0, 0.0).func_72438_d(new Vec3d((double)x, 0.0, (double)z));
            double drag = 0.99f;
            double gravity = 0.15f * mass;
            float yaw = x < 0.0f && z >= 0.0f ? (float)(Math.atan(Math.abs((double)x / (double)z)) / Math.PI * 180.0) : (x <= 0.0f && z <= 0.0f ? (float)(Math.atan(Math.abs((double)z / (double)x)) / Math.PI * 180.0) + 90.0f : (z < 0.0f ? (float)(Math.atan(Math.abs((double)x / (double)z)) / Math.PI * 180.0) + 180.0f : (float)(Math.atan(Math.abs((double)z / (double)x)) / Math.PI * 180.0) + 270.0f));
            float pitch = packet.getVarInType(DataTypeBoolean.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'d'))).value ? 90.0f - IIUtils.getDirectFireAngle((float)force, mass, new Vec3d((double)x, (double)y, (double)z)) : IIUtils.calculateBallisticAngle(distance, y, (float)force, gravity, drag, 0.002);
            new_packet.setVariable(Character.valueOf('y'), new DataTypeFloat(yaw));
            new_packet.setVariable(Character.valueOf('p'), new DataTypeFloat(pitch));
            IDataConnector conn = IIUtils.findConnectorFacing(this.getBlockPosForPos(this.multiblock.getPointOfInterest("data_output")), this.field_145850_b, this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e());
            if (conn != null) {
                conn.sendPacket(new_packet);
            }
        }
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case ENERGY_INPUT: {
                return this.getPOI("energy");
            }
            case DATA_INPUT: {
                return this.getPOI("data_input");
            }
            case DATA_OUTPUT: {
                return this.getPOI("data_output");
            }
        }
        return new int[0];
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.multiblock.isPointOfInterest(this.field_174879_c, "cocoa")) {
            TileEntityBallisticComputer master = (TileEntityBallisticComputer)this.master();
            if (master == null) {
                return false;
            }
            if (master.progress < 2 && heldItem.func_77973_b() == Items.field_151117_aB) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151133_ar));
                ++master.progress;
                this.forceTileUpdate();
                return true;
            }
            if (master.progress > 1 && master.progress < 6 && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77960_j() == 3) {
                heldItem.func_190918_g(1);
                ++master.progress;
                this.forceTileUpdate();
                return true;
            }
            if (master.progress > 5 && master.progress < 10 && heldItem.func_77973_b() == Items.field_151102_aT) {
                heldItem.func_190918_g(1);
                ++master.progress;
                this.forceTileUpdate();
                return true;
            }
            if (master.progress > 9 && master.progress < 32 && Utils.compareToOreName((ItemStack)heldItem, (String)"stickSteel")) {
                ++master.progress;
                this.forceTileUpdate();
                return true;
            }
            if (master.progress >= 32 && heldItem.func_190926_b()) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 360, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 360, 1));
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 10, 127));
                player.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 1, 127));
                master.progress = 0;
                if (!IIUtils.hasUnlockedIIAdvancement(player, "main/secret_cocoa")) {
                    IIUtils.unlockIIAdvancement(player, "main/secret_cocoa");
                }
                this.forceTileUpdate();
                return true;
            }
        }
        return false;
    }
}

