/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import pl.pabilo8.immersiveintelligence.api.crafting.ElectrolyzerRecipe;
import pl.pabilo8.immersiveintelligence.common.IIConfigHandler;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.multiblock.MultiblockElectrolyzer;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionBase;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionSingle;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.util.MultiblockPOI;

public class TileEntityElectrolyzer
extends TileEntityMultiblockProductionSingle<TileEntityElectrolyzer, ElectrolyzerRecipe> {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(IIConfigHandler.IIConfig.Machines.Electrolyzer.fluidCapacity), new FluidTank(IIConfigHandler.IIConfig.Machines.Electrolyzer.fluidCapacity), new FluidTank(IIConfigHandler.IIConfig.Machines.Electrolyzer.fluidCapacity)};

    public TileEntityElectrolyzer() {
        super(MultiblockElectrolyzer.INSTANCE);
        this.inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        this.energyStorage = new FluxStorageAdvanced(IIConfigHandler.IIConfig.Machines.Electrolyzer.energyCapacity);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt.func_74775_l("tank" + i));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        for (int i = 0; i < this.tanks.length; ++i) {
            nbt.func_74782_a("tank" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!message.func_74764_b("tank" + i)) continue;
            this.tanks[i].readFromNBT(message.func_74775_l("tank" + i));
        }
    }

    @Override
    protected int[] listAllPOI(MultiblockPOI poi) {
        switch (poi) {
            case ENERGY_INPUT: {
                return this.getPOI("energy_input");
            }
            case REDSTONE_INPUT: {
                return this.getPOI("redstone_input");
            }
            case FLUID_INPUT: {
                return this.getPOI("fluid_input");
            }
            case FLUID_OUTPUT: {
                return this.getPOI("fluid_output");
            }
        }
        return new int[0];
    }

    @Override
    protected IFluidTank[] getFluidTanks(int pos, EnumFacing side) {
        return this.tanks;
    }

    @Override
    protected boolean isTankAvailable(int pos, int tank) {
        switch (tank) {
            case 0: {
                return true;
            }
            case 1: {
                return this.multiblock.isPointOfInterest(pos, "output1");
            }
            case 2: {
                return this.multiblock.isPointOfInterest(pos, "output2");
            }
        }
        return false;
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
            boolean update = IIUtils.handleBucketTankInteraction((IFluidTank[])this.tanks, (NonNullList)this.inventory, (int)0, (int)1, (int)0, (boolean)false);
            if (IIUtils.outputFluidToTank(this.tanks[1], 100, this.getPOIPos("output1"), this.field_145850_b, this.facing.func_176734_d())) {
                update = true;
            }
            if (IIUtils.outputFluidToTank(this.tanks[2], 100, this.getPOIPos("output2"), this.field_145850_b, this.facing.func_176734_d())) {
                update = true;
            }
            if (IIUtils.handleBucketTankInteraction((IFluidTank[])this.tanks, (NonNullList)this.inventory, (int)2, (int)4, (int)1, (boolean)true)) {
                update = true;
            }
            if (IIUtils.handleBucketTankInteraction((IFluidTank[])this.tanks, (NonNullList)this.inventory, (int)3, (int)5, (int)2, (boolean)true)) {
                update = true;
            }
            if (update && this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.forceTileUpdate();
            }
        }
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public IIGuiList getGUI() {
        return IIGuiList.GUI_ELECTROLYZER;
    }

    @Override
    protected TileEntityMultiblockProductionBase.IIMultiblockProcess<ElectrolyzerRecipe> findNewProductionProcess() {
        ElectrolyzerRecipe recipe;
        if (this.tanks[0].getFluidAmount() > 0 && this.energyStorage.getEnergyStored() > 0 && (recipe = ElectrolyzerRecipe.findRecipe(this.tanks[0].getFluid())) != null) {
            return new TileEntityMultiblockProductionBase.IIMultiblockProcess<ElectrolyzerRecipe>(recipe);
        }
        return null;
    }

    @Override
    public float getProductionStep(TileEntityMultiblockProductionBase.IIMultiblockProcess<ElectrolyzerRecipe> process, boolean simulate) {
        return (float)this.energyStorage.extractEnergy(((ElectrolyzerRecipe)process.recipe).energyPerTick, simulate) / (float)((ElectrolyzerRecipe)process.recipe).energyPerTick;
    }

    @Override
    protected boolean attemptProductionOutput(TileEntityMultiblockProductionBase.IIMultiblockProcess<ElectrolyzerRecipe> process) {
        ElectrolyzerRecipe recipe = (ElectrolyzerRecipe)process.recipe;
        for (int i = 1; i < 2; ++i) {
            int added;
            FluidStack output = recipe.fluidOutputs[i - 1];
            int n = added = output == null ? 0 : output.amount;
            if (this.tanks[i].getFluidAmount() + added <= this.tanks[i].getCapacity()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onProductionFinish(TileEntityMultiblockProductionBase.IIMultiblockProcess<ElectrolyzerRecipe> process) {
        ElectrolyzerRecipe recipe = (ElectrolyzerRecipe)process.recipe;
        this.tanks[0].drain(recipe.fluidInput, true);
        this.tanks[1].fill(recipe.fluidOutputs[0], true);
        this.tanks[2].fill(recipe.fluidOutputs[1], true);
    }
}

